/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger.util;

import com.google.common.flogger.util.Checks;
import java.lang.reflect.Method;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class StaticMethodCaller {
    public static <T> T getInstanceFromSystemProperty(String propertyName, Class<T> type) {
        return StaticMethodCaller.getInstanceFromSystemProperty(propertyName, null, type);
    }

    @NullableDecl
    public static <T> T getInstanceFromSystemProperty(String propertyName, @NullableDecl String defaultValue, Class<T> type) {
        String property = StaticMethodCaller.readProperty(propertyName, defaultValue);
        if (property == null) {
            return null;
        }
        int hashIndex = property.indexOf(35);
        String className = hashIndex == -1 ? property : property.substring(0, hashIndex);
        String methodName = hashIndex == -1 ? "getInstance" : property.substring(hashIndex + 1);
        String attemptedMethod = className + '#' + methodName + "()";
        try {
            Class<?> clazz = Class.forName(className);
            try {
                Method method = clazz.getMethod(methodName, new Class[0]);
                return type.cast(method.invoke(null, new Object[0]));
            }
            catch (NoSuchMethodException e) {
                if (hashIndex == -1 || !methodName.equals("getInstance")) {
                    StaticMethodCaller.error("method '%s' does not exist: %s\n", property, e);
                    return null;
                }
                attemptedMethod = "new " + className + "()";
                return type.cast(clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
        catch (ClassNotFoundException clazz) {
        }
        catch (ClassCastException e) {
            StaticMethodCaller.error("cannot cast result of calling '%s' to '%s': %s\n", attemptedMethod, type.getName(), e);
        }
        catch (Exception e) {
            StaticMethodCaller.error("cannot call expected no-argument constructor or static method '%s': %s\n", attemptedMethod, e);
        }
        return null;
    }

    private static String readProperty(String propertyName, @NullableDecl String defaultValue) {
        Checks.checkNotNull(propertyName, "property name");
        try {
            return System.getProperty(propertyName, defaultValue);
        }
        catch (SecurityException e) {
            StaticMethodCaller.error("cannot read property name %s: %s", propertyName, e);
            return null;
        }
    }

    private static void error(String msg, Object ... args2) {
        System.err.println(StaticMethodCaller.class + ": " + String.format(msg, args2));
    }

    private StaticMethodCaller() {
    }
}

