/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.targetprep;

import com.android.compatibility.common.tradefed.targetprep.ApkInstrumentationPreparer;
import com.android.compatibility.common.util.DevicePropertyInfo;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.ITestLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.ITestLoggerReceiver;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.Map;

@OptionClass(alias="device-info-collector")
public class DeviceInfoCollector
extends ApkInstrumentationPreparer
implements ITestLoggerReceiver {
    public static final String DEVICE_INFO_DIR = "device_info_dir";
    public static final String SKIP_DEVICE_INFO_OPTION = "skip-device-info";
    private static final String ABI = "ro.product.cpu.abi";
    private static final String ABI2 = "ro.product.cpu.abi2";
    private static final String ABIS = "ro.product.cpu.abilist";
    private static final String ABIS_32 = "ro.product.cpu.abilist32";
    private static final String ABIS_64 = "ro.product.cpu.abilist64";
    private static final String BOARD = "ro.product.board";
    private static final String BRAND = "ro.product.brand";
    private static final String DEVICE = "ro.product.device";
    private static final String FINGERPRINT = "ro.build.fingerprint";
    private static final String VENDOR_FINGERPRINT = "ro.vendor.build.fingerprint";
    private static final String BOOTIMAGE_FINGERPRINT = "ro.bootimage.build.fingerprint";
    private static final String ID = "ro.build.id";
    private static final String MANUFACTURER = "ro.product.manufacturer";
    private static final String MODEL = "ro.product.model";
    private static final String PRODUCT = "ro.product.name";
    private static final String REFERENCE_FINGERPRINT = "ro.build.reference.fingerprint";
    private static final String SERIAL = "ro.serialno";
    private static final String TAGS = "ro.build.tags";
    private static final String TYPE = "ro.build.type";
    private static final String VERSION_BASE_OS = "ro.build.version.base_os";
    private static final String VERSION_RELEASE = "ro.build.version.release";
    private static final String VERSION_SDK = "ro.build.version.sdk";
    private static final String VERSION_SECURITY_PATCH = "ro.build.version.security_patch";
    private static final String VERSION_INCREMENTAL = "ro.build.version.incremental";
    private static final String VERSION_SDK_FULL = "ro.build.version.sdk_full";
    private static final String PREFIX_TAG = "cts:build_";
    @Option(name="skip-device-info", shortName=100, description="Whether device info collection should be skipped")
    private boolean mSkipDeviceInfo = false;
    @Option(name="force-collect-device-info", description="Force device info collection. If set to true, skip-device-info is ignored.")
    private boolean mForceCollectDeviceInfo = false;
    @Option(name="src-dir", description="The directory to copy to the results dir")
    private String mSrcDir;
    @Option(name="dest-dir", description="The directory under the result to store the files")
    private String mDestDir = "device-info-files";
    @Deprecated
    @Option(name="temp-dir", description="The directory containing host-side device info files")
    private String mTempDir;
    private ITestLogger mLogger;
    private File deviceInfoDir = null;

    public DeviceInfoCollector() {
        this.mWhen = ApkInstrumentationPreparer.When.BEFORE;
    }

    @Override
    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        if (testInfo.getBuildInfo().getFile(DEVICE_INFO_DIR) != null) {
            LogUtil.CLog.i((String)"Device info already collected, skipping DeviceInfoCollector.");
            return;
        }
        if (this.mSkipDeviceInfo && !this.mForceCollectDeviceInfo) {
            return;
        }
        ITestDevice device = testInfo.getDevice();
        IBuildInfo buildInfo = testInfo.getBuildInfo();
        DevicePropertyInfo devicePropertyInfo = DevicePropertyInfo.newBuilder().abi(ABI).abi2(ABI2).abis(ABIS).abis32(ABIS_32).abis64(ABIS_64).board(BOARD).brand(BRAND).device(DEVICE).fingerprint(FINGERPRINT).vendorFingerprint(VENDOR_FINGERPRINT).bootimageFingerprint(BOOTIMAGE_FINGERPRINT).id(ID).manufacturer(MANUFACTURER).model(MODEL).product(PRODUCT).referenceFingerprint(REFERENCE_FINGERPRINT).serial(SERIAL).tags(TAGS).type(TYPE).versionBaseOs(VERSION_BASE_OS).versionRelease(VERSION_RELEASE).versionSdk(VERSION_SDK).versionSecurityPatch(VERSION_SECURITY_PATCH).versionIncremental(VERSION_INCREMENTAL).versionSdkFull(device.getApiLevel() >= 36 ? VERSION_SDK_FULL : VERSION_SDK).build();
        for (Map.Entry entry : devicePropertyInfo.getPropertytMapWithPrefix(PREFIX_TAG).entrySet()) {
            String property = DeviceInfoCollector.nullToEmpty(device.getProperty((String)entry.getValue()));
            buildInfo.addBuildAttribute((String)entry.getKey(), property);
        }
        this.run(testInfo);
        try {
            this.deviceInfoDir = FileUtil.createTempDir((String)"device-info-files");
            if (device.pullDir(this.mSrcDir, this.deviceInfoDir)) {
                if (!this.deviceInfoDir.exists() || this.deviceInfoDir.listFiles() == null) {
                    LogUtil.CLog.e((String)"Pulled device-info, but local dir '%s' is not valid. [exists=%s, isDir=%s].", (Object[])new Object[]{this.deviceInfoDir, this.deviceInfoDir.exists(), this.deviceInfoDir.isDirectory()});
                } else {
                    for (File deviceInfoFile : this.deviceInfoDir.listFiles()) {
                        try (FileInputStreamSource source = new FileInputStreamSource(deviceInfoFile);){
                            this.mLogger.testLog(deviceInfoFile.getName(), LogDataType.TEXT, (InputStreamSource)source);
                        }
                    }
                    buildInfo.setFile(DEVICE_INFO_DIR, this.deviceInfoDir, "v1");
                }
            } else {
                LogUtil.CLog.e((String)"Failed to pull device-info files from device %s", (Object[])new Object[]{device.getSerialNumber()});
            }
        }
        catch (IOException e) {
            LogUtil.CLog.e((String)"Failed to pull device-info files from device %s", (Object[])new Object[]{device.getSerialNumber()});
            LogUtil.CLog.e((Throwable)e);
        }
    }

    @Override
    public void tearDown(TestInformation testInfo, Throwable e) throws DeviceNotAvailableException {
        FileUtil.recursiveDelete((File)this.deviceInfoDir);
        super.tearDown(testInfo, e);
    }

    public void setTestLogger(ITestLogger testLogger) {
        this.mLogger = testLogger;
    }

    private static String nullToEmpty(String value) {
        return value == null ? "" : value;
    }
}

