/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.result.suite;

import com.android.compatibility.common.tradefed.build.CompatibilityBuildHelper;
import com.android.compatibility.common.tradefed.result.suite.CompatibilityProtoResultReporter;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.InvocationContext;
import com.android.tradefed.invoker.tracing.CloseableTraceScope;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.ITestSummaryListener;
import com.android.tradefed.result.proto.FileProtoResultReporter;
import com.android.tradefed.result.proto.ProtoResultParser;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IDisableable;
import java.io.File;
import java.io.IOException;

@OptionClass(alias="result-reporter")
public class CompactProtoReporter
implements ITestInvocationListener,
ITestSummaryListener,
IDisableable {
    @Option(name="skip-proto-compacting", description="Option to disable compacting the protos at the end")
    private boolean mSkipProtoCompacting = false;
    @Option(name="disable", description="Whether or not to disable this reporter.")
    private boolean mDisable = false;
    private CompatibilityBuildHelper mBuildHelper;
    private File mResultDir = null;
    private File mBaseProtoFile = null;

    public void invocationStarted(IInvocationContext context) {
        if (this.mBuildHelper == null) {
            this.mBuildHelper = new CompatibilityBuildHelper((IBuildInfo)context.getBuildInfos().get(0));
            this.mResultDir = CompatibilityProtoResultReporter.getProtoResultDirectory(this.mBuildHelper);
            this.mBaseProtoFile = new File(this.mResultDir, "test-record.pb");
        }
    }

    public void invocationEnded(long elapsedTime) {
        if (this.mSkipProtoCompacting) {
            return;
        }
        if (this.mBuildHelper == null) {
            LogUtil.CLog.w((String)"Something went wrong and no build helper are configured.");
            return;
        }
        try (CloseableTraceScope ignored = new CloseableTraceScope("compact_protos");){
            LogUtil.CLog.d((String)"Compacting protos to reduce disk size");
            this.compactAllProtos();
            LogUtil.CLog.d((String)"Done compacting protos");
        }
        catch (RuntimeException e) {
            LogUtil.CLog.e((String)"Failed to compact the protos");
            LogUtil.CLog.e((Throwable)e);
            FileUtil.deleteFile((File)this.mBaseProtoFile);
            return;
        }
        int index = 0;
        while (new File(this.mBaseProtoFile.getAbsolutePath() + index).exists()) {
            FileUtil.deleteFile((File)new File(this.mBaseProtoFile.getAbsolutePath() + index));
            ++index;
        }
    }

    private void compactAllProtos() {
        FileProtoResultReporter fprr = new FileProtoResultReporter();
        fprr.setOutputFile(this.mBaseProtoFile);
        ProtoResultParser parser = new ProtoResultParser((ITestInvocationListener)fprr, (IInvocationContext)new InvocationContext(), true);
        int index = 0;
        while (new File(this.mBaseProtoFile.getAbsolutePath() + index).exists()) {
            try {
                parser.processFileProto(new File(this.mBaseProtoFile.getAbsolutePath() + index));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ++index;
        }
    }

    public boolean isDisabled() {
        return this.mDisable;
    }
}

