/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import com.android.compatibility.common.util.StreamUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    public static void createZip(File dir, File zipFile) throws IOException {
        ZipUtil.createZip(Collections.singletonList(dir), zipFile);
    }

    public static void createZip(List<File> files, File zipFile) throws IOException {
        try (ZipOutputStream out = null;){
            FileOutputStream fileStream = new FileOutputStream(zipFile);
            out = new ZipOutputStream(new BufferedOutputStream(fileStream));
            for (File file : files) {
                ZipUtil.addToZip(out, file, new ArrayList<String>());
            }
        }
    }

    public static void addToZip(ZipOutputStream out, File file, List<String> relativePathSegs) throws IOException {
        relativePathSegs.add(file.getName());
        if (file.isDirectory()) {
            relativePathSegs.add("/");
        }
        ZipEntry zipEntry = new ZipEntry(ZipUtil.buildPath(relativePathSegs));
        out.putNextEntry(zipEntry);
        if (file.isFile()) {
            ZipUtil.writeToStream(file, out);
        }
        out.closeEntry();
        if (file.isDirectory()) {
            File[] subFiles = file.listFiles();
            if (subFiles == null) {
                throw new IOException(String.format("Could not read directory %s", file.getAbsolutePath()));
            }
            for (File subFile : subFiles) {
                ZipUtil.addToZip(out, subFile, relativePathSegs);
            }
            relativePathSegs.remove(relativePathSegs.size() - 1);
        }
        relativePathSegs.remove(relativePathSegs.size() - 1);
    }

    private static String buildPath(List<String> relativePathSegs) {
        StringBuilder pathBuilder = new StringBuilder();
        for (String segment : relativePathSegs) {
            pathBuilder.append(segment);
        }
        return pathBuilder.toString();
    }

    private static void writeToStream(File file, OutputStream out) throws IOException {
        try (InputStream inputStream = null;){
            inputStream = new BufferedInputStream(new FileInputStream(file));
            StreamUtil.copyStreams(inputStream, out);
        }
    }
}

