/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import java.util.Arrays;

public class Stat {
    private Stat() {
    }

    public static StatResult getStat(double[] data) {
        double average = data[0];
        double min = data[0];
        double max = data[0];
        for (int i = 1; i < data.length; ++i) {
            average += data[i];
            if (data[i] > max) {
                max = data[i];
            }
            if (!(data[i] < min)) continue;
            min = data[i];
        }
        average /= (double)data.length;
        double sumOfSquares = 0.0;
        for (int i = 0; i < data.length; ++i) {
            double diff = average - data[i];
            sumOfSquares += diff * diff;
        }
        double variance = sumOfSquares / (double)(data.length - 1);
        double stddev = Math.sqrt(variance);
        double median = Stat.getMedian(data);
        return new StatResult(average, min, max, stddev, median, data.length);
    }

    public static StatResult getStatWithOutlierRejection(double[] data, double rejectionThreshold) {
        double median = Stat.getMedian(data);
        double thresholdMin = median * (1.0 - rejectionThreshold);
        double thresholdMax = median * (1.0 + rejectionThreshold);
        double[] validData = new double[data.length];
        int index = 0;
        for (int i = 0; i < data.length; ++i) {
            if (!(data[i] > thresholdMin) || !(data[i] < thresholdMax)) continue;
            validData[index] = data[i];
            ++index;
        }
        return Stat.getStat(Arrays.copyOf(validData, index));
    }

    private static double getMedian(double[] data) {
        double[] dataCopied = Arrays.copyOf(data, data.length);
        Arrays.sort(dataCopied);
        int medianIndex = dataCopied.length / 2;
        double median = dataCopied.length % 2 == 1 ? dataCopied[medianIndex] : (dataCopied[medianIndex - 1] + dataCopied[medianIndex]) / 2.0;
        return median;
    }

    public static double getAverage(double[] data) {
        double sum = data[0];
        for (int i = 1; i < data.length; ++i) {
            sum += data[i];
        }
        return sum / (double)data.length;
    }

    public static double getMin(double[] data) {
        double min = data[0];
        for (int i = 1; i < data.length; ++i) {
            if (!(data[i] < min)) continue;
            min = data[i];
        }
        return min;
    }

    public static double getMax(double[] data) {
        double max = data[0];
        for (int i = 1; i < data.length; ++i) {
            if (!(data[i] > max)) continue;
            max = data[i];
        }
        return max;
    }

    public static double calcRatePerSec(double change, double timeInMSec) {
        if (timeInMSec == 0.0) {
            return change * 1000.0 / 0.001;
        }
        return change * 1000.0 / timeInMSec;
    }

    public static double[] calcRatePerSecArray(double change, double[] timeInMSec) {
        double[] result = new double[timeInMSec.length];
        change *= 1000.0;
        for (int i = 0; i < timeInMSec.length; ++i) {
            result[i] = timeInMSec[i] == 0.0 ? change / 0.001 : change / timeInMSec[i];
        }
        return result;
    }

    public static double get95PercentileValue(double[] values) {
        Arrays.sort(values);
        int index = (int)Math.round((double)values.length * 0.95 + 0.5) - 1;
        return values[index];
    }

    public static class StatResult {
        public double mAverage;
        public double mMin;
        public double mMax;
        public double mStddev;
        public double mMedian;
        public int mDataCount;

        public StatResult(double average, double min, double max, double stddev, double median, int dataCount) {
            this.mAverage = average;
            this.mMin = min;
            this.mMax = max;
            this.mStddev = stddev;
            this.mMedian = median;
            this.mDataCount = dataCount;
        }
    }
}

