/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import com.android.compatibility.common.util.ICaseResult;
import com.android.compatibility.common.util.IInvocationResult;
import com.android.compatibility.common.util.IModuleResult;
import com.android.compatibility.common.util.ITestResult;
import com.android.compatibility.common.util.TestScreenshotsMetadata;
import com.android.compatibility.common.util.TestStatus;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;

public class ScreenshotsMetadataHandler {
    private static final String ENCODING = "UTF-8";
    private static final String TYPE = "org.kxml2.io.KXmlParser,org.kxml2.io.KXmlSerializer";
    private static final String NS = null;
    public static final String SCREENSHOTS_METADATA_FILE_NAME = "screenshots_metadata.xml";
    private static final String CASE_TAG = "TestCase";
    private static final String MODULE_TAG = "Module";
    private static final String NAME_ATTR = "name";
    private static final String ABI_ATTR = "abi";
    private static final String RESULT_TAG = "Result";
    private static final String TEST_TAG = "Test";

    public static File writeResults(IInvocationResult result, File resultDir) throws IOException, XmlPullParserException {
        File screenshotsMetadataFile = new File(resultDir, SCREENSHOTS_METADATA_FILE_NAME);
        FileOutputStream stream = new FileOutputStream(screenshotsMetadataFile);
        XmlSerializer serializer = XmlPullParserFactory.newInstance((String)TYPE, null).newSerializer();
        serializer.setOutput((OutputStream)stream, ENCODING);
        serializer.startDocument(ENCODING, Boolean.valueOf(false));
        serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
        serializer.processingInstruction("xml-stylesheet type=\"text/xsl\" href=\"compatibility_result.xsl\"");
        serializer.startTag(NS, RESULT_TAG);
        for (IModuleResult module : result.getModules()) {
            serializer.startTag(NS, MODULE_TAG);
            serializer.attribute(NS, NAME_ATTR, module.getName());
            serializer.attribute(NS, ABI_ATTR, module.getAbi());
            for (ICaseResult cr : module.getResults()) {
                serializer.startTag(NS, CASE_TAG);
                serializer.attribute(NS, NAME_ATTR, cr.getName());
                for (ITestResult r : cr.getResults()) {
                    TestStatus status = r.getResultStatus();
                    if (status == null) continue;
                    serializer.startTag(NS, TEST_TAG);
                    serializer.attribute(NS, NAME_ATTR, r.getName());
                    TestScreenshotsMetadata screenshotsMetadata = r.getTestScreenshotsMetadata();
                    if (screenshotsMetadata != null) {
                        TestScreenshotsMetadata.serialize(serializer, screenshotsMetadata);
                    }
                    serializer.endTag(NS, TEST_TAG);
                }
                serializer.endTag(NS, CASE_TAG);
            }
            serializer.endTag(NS, MODULE_TAG);
        }
        serializer.endDocument();
        return screenshotsMetadataFile;
    }
}

