/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import com.android.compatibility.common.util.HostInfoStore;
import com.android.json.stream.JsonWriter;
import com.android.tradefed.util.FileUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class ReportLogHostInfoStore
extends HostInfoStore {
    private final String mStreamName;
    private File tempJsonFile;

    public ReportLogHostInfoStore(File jsonFile, String streamName) throws Exception {
        this.mJsonFile = jsonFile;
        this.mStreamName = streamName;
    }

    @Override
    public void open() throws IOException {
        this.tempJsonFile = File.createTempFile(this.mStreamName, "-temp-report-log");
        BufferedWriter formatWriter = new BufferedWriter(new FileWriter(this.tempJsonFile));
        if (this.mJsonFile.exists()) {
            String currentLine;
            BufferedReader jsonReader = new BufferedReader(new FileReader(this.mJsonFile));
            String nextLine = jsonReader.readLine();
            while ((currentLine = nextLine) != null) {
                nextLine = jsonReader.readLine();
                if (nextLine == null && currentLine.charAt(currentLine.length() - 1) == '}') {
                    currentLine = currentLine.substring(0, currentLine.length() - 1) + ",";
                }
                formatWriter.write(currentLine, 0, currentLine.length());
            }
            jsonReader.close();
        } else {
            formatWriter.write("{", 0, 1);
        }
        formatWriter.write("\"" + this.mStreamName + "\":", 0, this.mStreamName.length() + 3);
        formatWriter.flush();
        formatWriter.close();
        this.mJsonWriter = new JsonWriter(new FileWriter(this.tempJsonFile, true));
        this.mJsonWriter.beginObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.mJsonWriter.endObject();
        this.mJsonWriter.close();
        try (BufferedWriter formatWriter = new BufferedWriter(new FileWriter(this.tempJsonFile, true));){
            formatWriter.write("}", 0, 1);
        }
        this.mJsonFile.createNewFile();
        try (BufferedReader jsonReader = new BufferedReader(new FileReader(this.tempJsonFile));
             BufferedWriter metricsWriter = new BufferedWriter(new FileWriter(this.mJsonFile));){
            String line;
            while ((line = jsonReader.readLine()) != null) {
                metricsWriter.write(line, 0, line.length());
            }
        }
        finally {
            FileUtil.deleteFile((File)this.tempJsonFile);
        }
    }
}

