/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import com.android.compatibility.common.util.ResultType;
import com.android.compatibility.common.util.ResultUnit;
import com.android.compatibility.common.util.Stacktrace;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;

public class ReportLog
implements Serializable {
    private static final String ENCODING = "UTF-8";
    private static final String TYPE = "org.kxml2.io.KXmlParser,org.kxml2.io.KXmlSerializer";
    private static final String METRIC_TAG = "Metric";
    private static final String MESSAGE_ATTR = "message";
    private static final String SCORETYPE_ATTR = "score_type";
    private static final String SCOREUNIT_ATTR = "score_unit";
    private static final String SOURCE_ATTR = "source";
    private static final String SUMMARY_TAG = "Summary";
    private static final String VALUE_TAG = "Value";
    private static final String DEFAULT_NAME = "default";
    protected Metric mSummary;
    protected String mReportLogName;
    protected String mStreamName;

    public ReportLog() {
        this.mReportLogName = DEFAULT_NAME;
    }

    public ReportLog(String reportLogName, String streamName) {
        this.mReportLogName = reportLogName;
        this.mStreamName = streamName;
    }

    public void addValues(String message, double[] values, ResultType type, ResultUnit unit) {
    }

    public void addValues(String source, String message, double[] values, ResultType type, ResultUnit unit) {
    }

    public void addValue(String message, double value, ResultType type, ResultUnit unit) {
    }

    public void addValue(String source, String message, double value, ResultType type, ResultUnit unit) {
    }

    public void addValue(String message, int value, ResultType type, ResultUnit unit) {
    }

    public void addValue(String message, long value, ResultType type, ResultUnit unit) {
    }

    public void addValue(String message, float value, ResultType type, ResultUnit unit) {
    }

    public void addValue(String message, boolean value, ResultType type, ResultUnit unit) {
    }

    public void addValue(String message, String value, ResultType type, ResultUnit unit) {
    }

    public void addValues(String message, int[] values, ResultType type, ResultUnit unit) {
    }

    public void addValues(String message, long[] values, ResultType type, ResultUnit unit) {
    }

    public void addValues(String message, float[] values, ResultType type, ResultUnit unit) {
    }

    public void addValues(String message, boolean[] values, ResultType type, ResultUnit unit) {
    }

    public void addValues(String message, List<String> values, ResultType type, ResultUnit unit) {
    }

    void setSummary(Metric elem) {
        this.mSummary = elem;
    }

    public void setSummary(String message, double value, ResultType type, ResultUnit unit) {
        this.setSummary(new Metric(Stacktrace.getTestCallerClassMethodNameLineNumber(), message, value, type, unit));
    }

    public Metric getSummary() {
        return this.mSummary;
    }

    public static String serialize(ReportLog reportlog) throws XmlPullParserException, IllegalArgumentException, IllegalStateException, IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XmlSerializer serializer = XmlPullParserFactory.newInstance((String)TYPE, null).newSerializer();
        serializer.setOutput((OutputStream)byteArrayOutputStream, ENCODING);
        serializer.startDocument(ENCODING, Boolean.valueOf(true));
        serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
        ReportLog.serialize(serializer, reportlog);
        serializer.endDocument();
        return byteArrayOutputStream.toString(ENCODING);
    }

    public static void serialize(XmlSerializer serializer, ReportLog reportLog) throws IOException {
        if (reportLog == null) {
            throw new IllegalArgumentException("Metrics reports was null");
        }
        Metric summary = reportLog.getSummary();
        if (summary != null) {
            serializer.startTag(null, SUMMARY_TAG);
            summary.serialize(serializer);
            serializer.endTag(null, SUMMARY_TAG);
        }
    }

    public static ReportLog parse(String result) throws XmlPullParserException, IOException {
        if (result == null) {
            throw new IllegalArgumentException("Metrics string was null");
        }
        if (result.trim().isEmpty()) {
            return new ReportLog();
        }
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
        XmlPullParser parser = factory.newPullParser();
        parser.setInput((InputStream)new ByteArrayInputStream(result.getBytes(ENCODING)), ENCODING);
        try {
            parser.nextTag();
        }
        catch (XmlPullParserException e) {
            return new ReportLog();
        }
        return ReportLog.parse(parser);
    }

    public static ReportLog parse(XmlPullParser parser) throws XmlPullParserException, IOException {
        parser.require(2, null, SUMMARY_TAG);
        parser.nextTag();
        ReportLog report = new ReportLog();
        report.setSummary(Metric.parse(parser));
        parser.nextTag();
        parser.require(3, null, SUMMARY_TAG);
        return report;
    }

    public static class Metric
    implements Serializable {
        private static final int MAX_SOURCE_LENGTH = 200;
        private static final int MAX_MESSAGE_LENGTH = 200;
        private static final int MAX_NUM_VALUES = 1000;
        String mSource;
        String mMessage;
        double[] mValues;
        ResultType mType;
        ResultUnit mUnit;

        Metric(String source, String message, double value, ResultType type, ResultUnit unit) {
            this(source, message, new double[]{value}, type, unit);
        }

        Metric(String source, String message, double[] values, ResultType type, ResultUnit unit) {
            int sourceLength = source.length();
            this.mSource = sourceLength > 200 ? source.substring(sourceLength - 200) : source;
            int messageLength = message.length();
            this.mMessage = messageLength > 200 ? message.substring(0, 200) : message;
            int valuesLength = values.length;
            this.mValues = valuesLength > 1000 ? Arrays.copyOf(values, 1000) : values;
            this.mType = type;
            this.mUnit = unit;
        }

        public String getSource() {
            return this.mSource;
        }

        public String getMessage() {
            return this.mMessage;
        }

        public double[] getValues() {
            return this.mValues;
        }

        public ResultType getType() {
            return this.mType;
        }

        public ResultUnit getUnit() {
            return this.mUnit;
        }

        void serialize(XmlSerializer serializer) throws IllegalArgumentException, IllegalStateException, IOException {
            serializer.startTag(null, ReportLog.METRIC_TAG);
            serializer.attribute(null, ReportLog.SOURCE_ATTR, this.getSource());
            serializer.attribute(null, ReportLog.MESSAGE_ATTR, this.getMessage());
            serializer.attribute(null, ReportLog.SCORETYPE_ATTR, this.getType().toReportString());
            serializer.attribute(null, ReportLog.SCOREUNIT_ATTR, this.getUnit().toReportString());
            for (double d : this.getValues()) {
                serializer.startTag(null, ReportLog.VALUE_TAG);
                serializer.text(Double.toString(d));
                serializer.endTag(null, ReportLog.VALUE_TAG);
            }
            serializer.endTag(null, ReportLog.METRIC_TAG);
        }

        static Metric parse(XmlPullParser parser) throws XmlPullParserException, IOException {
            parser.require(2, null, ReportLog.METRIC_TAG);
            String source = parser.getAttributeValue(null, ReportLog.SOURCE_ATTR);
            String message = parser.getAttributeValue(null, ReportLog.MESSAGE_ATTR);
            ResultType type = ResultType.parseReportString(parser.getAttributeValue(null, ReportLog.SCORETYPE_ATTR));
            ResultUnit unit = ResultUnit.parseReportString(parser.getAttributeValue(null, ReportLog.SCOREUNIT_ATTR));
            ArrayList<String> valuesList = new ArrayList<String>();
            while (parser.nextTag() == 2) {
                parser.require(2, null, ReportLog.VALUE_TAG);
                valuesList.add(parser.nextText());
                parser.require(3, null, ReportLog.VALUE_TAG);
            }
            int length = valuesList.size();
            double[] values = new double[length];
            for (int i = 0; i < length; ++i) {
                values[i] = Double.parseDouble((String)valuesList.get(i));
            }
            parser.require(3, null, ReportLog.METRIC_TAG);
            return new Metric(source, message, values, type, unit);
        }
    }
}

