/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import com.android.compatibility.common.util.AbiUtils;
import com.android.compatibility.common.util.CaseResult;
import com.android.compatibility.common.util.ICaseResult;
import com.android.compatibility.common.util.IModuleResult;
import com.android.compatibility.common.util.TestStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModuleResult
implements IModuleResult {
    private String mId;
    private long mRuntime = 0L;
    private boolean mDone = false;
    private boolean mHaveSetDone = false;
    private boolean mInProgress = false;
    private int mExpectedTestRuns = 0;
    private int mActualTestRuns = 0;
    private int mNotExecuted = 0;
    private boolean mIsFailed = false;
    private Map<String, ICaseResult> mResults = new HashMap<String, ICaseResult>();

    public ModuleResult(String id) {
        this.mId = id;
    }

    @Override
    public boolean isDone() {
        if (this.isFailed()) {
            return false;
        }
        return this.mDone && !this.mInProgress && this.mActualTestRuns >= this.mExpectedTestRuns;
    }

    @Override
    public boolean isDoneSoFar() {
        return this.mDone && !this.mInProgress;
    }

    @Override
    public void initializeDone(boolean done) {
        this.mDone = done;
        this.mHaveSetDone = false;
        if (this.mDone) {
            this.mNotExecuted = 0;
        }
    }

    @Override
    public void setDone(boolean done) {
        this.mDone = this.mHaveSetDone ? (this.mDone &= done) : done;
        this.mHaveSetDone = true;
        if (this.mDone) {
            this.mNotExecuted = 0;
        }
    }

    @Override
    public void inProgress(boolean inProgress) {
        this.mInProgress = inProgress;
    }

    @Override
    public int getExpectedTestRuns() {
        return this.mExpectedTestRuns;
    }

    @Override
    public void setExpectedTestRuns(int numRuns) {
        this.mExpectedTestRuns = numRuns;
    }

    @Override
    public int getTestRuns() {
        return this.mActualTestRuns;
    }

    @Override
    public void addTestRun() {
        ++this.mActualTestRuns;
    }

    @Override
    public void resetTestRuns() {
        this.mActualTestRuns = 0;
    }

    @Override
    public int getNotExecuted() {
        return this.mNotExecuted;
    }

    @Override
    public void setNotExecuted(int numTests) {
        this.mNotExecuted = numTests;
    }

    @Override
    public String getId() {
        return this.mId;
    }

    @Override
    public String getName() {
        return AbiUtils.parseTestName(this.mId);
    }

    @Override
    public String getAbi() {
        return AbiUtils.parseAbi(this.mId);
    }

    @Override
    public void addRuntime(long elapsedTime) {
        this.mRuntime += elapsedTime;
    }

    @Override
    public void resetRuntime() {
        this.mRuntime = 0L;
    }

    @Override
    public long getRuntime() {
        return this.mRuntime;
    }

    @Override
    public ICaseResult getOrCreateResult(String caseName) {
        ICaseResult result = this.mResults.get(caseName);
        if (result == null) {
            result = new CaseResult(caseName);
            this.mResults.put(caseName, result);
        }
        return result;
    }

    @Override
    public ICaseResult getResult(String caseName) {
        return this.mResults.get(caseName);
    }

    @Override
    public List<ICaseResult> getResults() {
        ArrayList<ICaseResult> results = new ArrayList<ICaseResult>(this.mResults.values());
        Collections.sort(results);
        return results;
    }

    @Override
    public int countResults(TestStatus status) {
        int total = 0;
        for (ICaseResult result : this.mResults.values()) {
            total += result.countResults(status);
        }
        return total;
    }

    @Override
    public int compareTo(IModuleResult another) {
        return this.getId().compareTo(another.getId());
    }

    @Override
    public void setFailed() {
        this.mIsFailed = true;
    }

    @Override
    public boolean isFailed() {
        return this.mIsFailed;
    }

    @Override
    public void mergeFrom(IModuleResult otherModuleResult) {
        if (!otherModuleResult.getId().equals(this.getId())) {
            throw new IllegalArgumentException(String.format("Cannot merge module result with mismatched id. Expected %s, Found %s", otherModuleResult.getId(), this.getId()));
        }
        this.mRuntime += otherModuleResult.getRuntime();
        this.mNotExecuted += otherModuleResult.getNotExecuted();
        if (!this.isDone()) {
            this.setDone(otherModuleResult.isDoneSoFar());
            this.mActualTestRuns += otherModuleResult.getTestRuns();
            this.mExpectedTestRuns += otherModuleResult.getExpectedTestRuns();
        }
        if (!this.isFailed()) {
            this.mIsFailed = otherModuleResult.isFailed();
        }
        for (ICaseResult otherCaseResult : otherModuleResult.getResults()) {
            ICaseResult caseResult = this.getOrCreateResult(otherCaseResult.getName());
            caseResult.mergeFrom(otherCaseResult);
        }
    }
}

