/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.loading;

import com.android.compatibility.common.tradefed.targetprep.ApkInstaller;
import com.android.compatibility.common.tradefed.targetprep.PreconditionPreparer;
import com.android.compatibility.common.tradefed.testtype.JarHostTest;
import com.android.tradefed.build.FolderBuildInfo;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.ConfigurationDescriptor;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.ConfigurationFactory;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IDeviceConfiguration;
import com.android.tradefed.invoker.ExecutionFiles;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.InvocationContext;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.invoker.shard.token.TokenProperty;
import com.android.tradefed.targetprep.DeviceSetup;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.targetprep.PythonVirtualenvPreparer;
import com.android.tradefed.testtype.AndroidJUnitTest;
import com.android.tradefed.testtype.GTest;
import com.android.tradefed.testtype.HostTest;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.ITestFilterReceiver;
import com.android.tradefed.testtype.suite.TestSuiteInfo;
import com.android.tradefed.testtype.suite.ValidateSuiteConfigHelper;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.ModuleTestTypeUtil;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CommonConfigLoadingTest {
    private static final Pattern TODO_BUG_PATTERN = Pattern.compile(".*TODO\\(b/[0-9]+\\).*", 32);
    private static final Set<String> SUPPORTED_SUITE_TEST_TYPE = new HashSet<String>(Arrays.asList("com.android.compatibility.common.tradefed.testtype.JarHostTest", "com.android.compatibility.testtype.DalvikTest", "com.android.compatibility.testtype.LibcoreTest", "com.drawelements.deqp.runner.DeqpTestRunner", "com.android.tradefed.testtype.AndroidJUnitTest", "com.android.tradefed.testtype.ArtRunTest", "com.android.tradefed.testtype.HostTest", "com.android.tradefed.testtype.GTest", "com.android.tradefed.testtype.mobly.MoblyBinaryHostTest", "com.android.tradefed.testtype.pandora.PtsBotTest", "com.android.tradefed.testtype.binary.KernelTargetTest", "com.android.tradefed.testtype.python.PythonBinaryHostTest", "com.android.tradefed.testtype.binary.ExecutableTargetTest", "com.android.tradefed.testtype.binary.ExecutableHostTest", "com.android.tradefed.testtype.rust.RustBinaryTest"));
    private static final Set<String> ALLOWED_INSTRUMENTATION_RUNNER_NAME = new HashSet<String>();
    private static final Set<String> RUNNER_EXCEPTION;
    private static final Set<String> ALLOWED_PERFORMANCE_TEST;

    @Test
    public void testConfigurationLoad() throws Exception {
        File testcases;
        String rootVar = String.format("%s_ROOT", this.getSuiteName().toUpperCase());
        String suiteRoot = System.getProperty(rootVar);
        if (Strings.isNullOrEmpty((String)suiteRoot)) {
            Assert.fail((String)String.format("Should run within a suite context: %s doesn't exist", rootVar));
        }
        if (!(testcases = new File(suiteRoot, String.format("/android-%s/testcases/", this.getSuiteName().toLowerCase()))).exists()) {
            Assert.fail((String)String.format("%s does not exist", testcases));
            return;
        }
        Set listConfigs = FileUtil.findFilesObject((File)testcases, (String)".*\\.config");
        Assert.assertTrue((listConfigs.size() > 0 ? 1 : 0) != 0);
        FolderBuildInfo stubFolder = new FolderBuildInfo("-1", "-1");
        stubFolder.setRootDir(new File(suiteRoot));
        stubFolder.addBuildAttribute("SUITE_NAME", this.getSuiteName().toUpperCase());
        stubFolder.addBuildAttribute("ROOT_DIR", suiteRoot);
        TestInformation stubTestInfo = TestInformation.newBuilder().setInvocationContext((IInvocationContext)new InvocationContext()).build();
        stubTestInfo.executionFiles().put(ExecutionFiles.FilesKey.TESTS_DIRECTORY, new File(suiteRoot));
        for (File config : listConfigs) {
            IConfiguration c = ConfigurationFactory.getInstance().createConfigurationFromArgs(new String[]{config.getAbsolutePath()});
            if (c.getDeviceConfig().size() > 2) {
                throw new ConfigurationException(String.format("%s declares more than 2 devices.", config));
            }
            int deviceCount = 0;
            for (IDeviceConfiguration dConfig : c.getDeviceConfig()) {
                for (ITargetPreparer prep : dConfig.getTargetPreparers()) {
                    DeviceSetup deviceSetup;
                    if (prep.getClass().isAssignableFrom(ApkInstaller.class)) {
                        throw new ConfigurationException(String.format("%s: Use com.android.tradefed.targetprep.suite.SuiteApkInstaller instead of com.android.compatibility.common.tradefed.targetprep.ApkInstaller, options will be the same.", config));
                    }
                    if (prep.getClass().isAssignableFrom(PreconditionPreparer.class)) {
                        throw new ConfigurationException(String.format("%s: includes a PreconditionPreparer (%s) which is not allowed in modules.", config.getName(), prep.getClass()));
                    }
                    if (prep.getClass().isAssignableFrom(DeviceSetup.class) && !(deviceSetup = (DeviceSetup)prep).isForceSkipSystemProps()) {
                        throw new ConfigurationException(String.format("%s: %s needs to be configured with <option name=\"force-skip-system-props\" value=\"true\" /> in *TS.", config.getName(), prep.getClass()));
                    }
                    if (!prep.getClass().isAssignableFrom(PythonVirtualenvPreparer.class)) continue;
                    this.checkPythonModules(config, deviceCount);
                }
                ++deviceCount;
            }
            for (Object test : c.getTests()) {
                AndroidJUnitTest instru;
                if (!SUPPORTED_SUITE_TEST_TYPE.contains(test.getClass().getCanonicalName())) {
                    throw new ConfigurationException(String.format("testtype %s is not officially supported by *TS. The supported ones are: %s", test.getClass().getCanonicalName(), SUPPORTED_SUITE_TEST_TYPE));
                }
                if (test instanceof HostTest) {
                    HostTest hostTest = (HostTest)test;
                    hostTest.setBuild((IBuildInfo)stubFolder);
                    hostTest.setTestInformation(stubTestInfo);
                    int testCount = hostTest.countTestCases();
                    if (testCount == 0) {
                        throw new ConfigurationException(String.format("%s: %s reports 0 test cases.", config.getName(), test));
                    }
                }
                if (test instanceof GTest && ((GTest)test).isRebootBeforeTestEnabled()) {
                    throw new ConfigurationException(String.format("%s: instead of reboot-before-test use a RebootTargetPreparer which is more optimized during sharding.", config.getName()));
                }
                if (!(test instanceof ITestFilterReceiver)) {
                    throw new IllegalArgumentException(String.format("Test in module %s must implement ITestFilterReceiver.", config.getName()));
                }
                if (!(test instanceof AndroidJUnitTest) || (instru = (AndroidJUnitTest)test).getRunnerName() == null || ALLOWED_INSTRUMENTATION_RUNNER_NAME.contains(instru.getRunnerName()) || RUNNER_EXCEPTION.contains(instru.getRunnerName())) continue;
                throw new ConfigurationException(String.format("%s: uses '%s' instead of on of '%s' that are expected", config.getName(), instru.getRunnerName(), ALLOWED_INSTRUMENTATION_RUNNER_NAME));
            }
            ConfigurationDescriptor cd = c.getConfigurationDescription();
            Assert.assertNotNull((String)(config + ": configuration descriptor is null"), (Object)cd);
            this.checkTokens(config.getName(), cd.getMetaData("token"));
            if (cd.isNotShardable()) {
                Object test;
                test = c.getTests().iterator();
                while (test.hasNext()) {
                    IRemoteTest test2 = (IRemoteTest)test.next();
                    if (!test2.getClass().isAssignableFrom(JarHostTest.class)) continue;
                    throw new ConfigurationException(String.format("config: %s. JarHostTest does not need the not-shardable option.", config.getName()));
                }
            }
            c.validateOptions();
            String configModuleName = config.getName().substring(0, config.getName().length() - 7);
            if (!ALLOWED_PERFORMANCE_TEST.contains(configModuleName) && ModuleTestTypeUtil.isPerformanceModule((IConfiguration)c)) {
                throw new ConfigurationException(String.format("config: %s. Performance test modules are not allowed in xTS", config.getName()));
            }
            ValidateSuiteConfigHelper.validateConfigFile((File)config);
        }
    }

    private void checkTokens(String configName, List<String> tokens) throws ConfigurationException {
        if (tokens == null) {
            return;
        }
        for (String token : tokens) {
            try {
                TokenProperty.valueOf((String)token.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new ConfigurationException(String.format("Config: %s includes an unknown token '%s'.", configName, token));
            }
        }
    }

    private void checkPythonModules(File config, int deviceCount) throws IOException, ConfigurationException {
        if (deviceCount != 0) {
            throw new ConfigurationException(String.format("%s: PythonVirtualenvPreparer should only be declared for the first <device> tag in the config", config.getName()));
        }
        if (!TODO_BUG_PATTERN.matcher(FileUtil.readStringFromFile((File)config)).matches()) {
            throw new ConfigurationException(String.format("%s: Contains some virtualenv python lib usage but no tracking bug to import them as source.", config.getName()));
        }
    }

    private String getSuiteName() {
        return TestSuiteInfo.getInstance().getName();
    }

    static {
        ALLOWED_INSTRUMENTATION_RUNNER_NAME.add("android.support.test.runner.AndroidJUnitRunner");
        ALLOWED_INSTRUMENTATION_RUNNER_NAME.add("androidx.test.runner.AndroidJUnitRunner");
        RUNNER_EXCEPTION = new HashSet<String>();
        RUNNER_EXCEPTION.add("repackaged.android.test.InstrumentationTestRunner");
        RUNNER_EXCEPTION.add("android.uirendering.cts.runner.UiRenderingRunner");
        RUNNER_EXCEPTION.add("android.widget.cts.runner.WidgetRunner");
        RUNNER_EXCEPTION.add("android.text.cts.runner.CtsTextRunner");
        RUNNER_EXCEPTION.add("com.android.server.uwb.CustomTestRunner");
        RUNNER_EXCEPTION.add("com.android.server.wifi.CustomTestRunner");
        RUNNER_EXCEPTION.add("com.android.healthconnect.controller.tests.HiltTestRunner");
        RUNNER_EXCEPTION.add("com.android.photopicker.tests.HiltTestRunner");
        ALLOWED_PERFORMANCE_TEST = new HashSet<String>();
        ALLOWED_PERFORMANCE_TEST.add("AptsHostSideTestCases");
    }
}

