/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.parser;

import com.android.loganalysis.item.TopItem;
import com.android.loganalysis.parser.IParser;
import com.android.loganalysis.util.ArrayUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TopParser
implements IParser {
    private static final Pattern TICKS_PAT = Pattern.compile("User (\\d+) \\+ Nice (\\d+) \\+ Sys (\\d+) \\+ Idle (\\d+) \\+ IOW (\\d+) \\+ IRQ (\\d+) \\+ SIRQ (\\d+) = (\\d+)");

    @Override
    public TopItem parse(List<String> lines) {
        String text = ArrayUtil.join("\n", lines).trim();
        if ("".equals(text)) {
            return null;
        }
        TopItem item = new TopItem();
        item.setText(text);
        for (String line : lines) {
            Matcher m = TICKS_PAT.matcher(line);
            if (!m.matches()) continue;
            item.setUser(Integer.parseInt(m.group(1)));
            item.setNice(Integer.parseInt(m.group(2)));
            item.setSystem(Integer.parseInt(m.group(3)));
            item.setIdle(Integer.parseInt(m.group(4)));
            item.setIow(Integer.parseInt(m.group(5)));
            item.setIrq(Integer.parseInt(m.group(6)));
            item.setSirq(Integer.parseInt(m.group(7)));
            item.setTotal(Integer.parseInt(m.group(8)));
        }
        return item;
    }
}

