/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.parser;

import com.android.loganalysis.item.DumpsysWifiStatsItem;
import com.android.loganalysis.parser.IParser;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DumpsysWifiStatsParser
implements IParser {
    private static final Pattern WIFI_SCAN = Pattern.compile("^\\d+-\\d+ \\d+:\\d+:\\d+\\.\\d+ - Event \\[IFNAME=wlan0 CTRL-EVENT-SCAN-STARTED \\]");
    private static final Pattern WIFI_DISCONNECT = Pattern.compile("^\\d+-\\d+ \\d+:\\d+:\\d+\\.\\d+ - Event \\[IFNAME=wlan0 CTRL-EVENT-DISCONNECTED bssid=\\w+:\\w+:\\w+:\\w+:\\w+:\\w+ reason=\\d+(\\s*locally_generated=\\d+)?\\]");
    private static final Pattern WIFI_ASSOCIATION = Pattern.compile("^\\d+-\\d+ \\d+:\\d+:\\d+\\.\\d+ - Event \\[IFNAME=wlan0 Trying to associate with SSID \\'.*\\'\\]");

    @Override
    public DumpsysWifiStatsItem parse(List<String> lines) {
        DumpsysWifiStatsItem item = new DumpsysWifiStatsItem();
        int numWifiScans = 0;
        int numWifiDisconnects = 0;
        int numWifiAssociations = 0;
        for (String line : lines) {
            Matcher m = WIFI_SCAN.matcher(line);
            if (m.matches()) {
                ++numWifiScans;
                continue;
            }
            m = WIFI_DISCONNECT.matcher(line);
            if (m.matches()) {
                ++numWifiDisconnects;
                continue;
            }
            m = WIFI_ASSOCIATION.matcher(line);
            if (!m.matches()) continue;
            ++numWifiAssociations;
        }
        item.setNumWifiScan(numWifiScans);
        item.setNumWifiDisconnect(numWifiDisconnects);
        item.setNumWifiAssociation(numWifiAssociations);
        return item;
    }
}

