/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.parser;

import com.android.loganalysis.item.CompactMemInfoItem;
import com.android.loganalysis.parser.IParser;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CompactMemInfoParser
implements IParser {
    private static final Pattern PROC_PATTERN = Pattern.compile("proc,(\\w+),([a-zA-Z_0-9\\.]+),(\\d+),(\\d+),((\\S+),)?(.*)");
    private static final Pattern LOST_RAM_PATTERN = Pattern.compile("lostram,(\\d+)");
    private static final Pattern RAM_PATTERN = Pattern.compile("ram,(\\d+),(\\d+),(\\d+)");
    private static final Pattern ZRAM_PATTERN = Pattern.compile("zram,(\\d+),(\\d+),(\\d+)");
    private static final Pattern TUNING_PATTERN = Pattern.compile("tuning,(\\d+),(\\d+),(\\d+).*");

    @Override
    public CompactMemInfoItem parse(List<String> lines) {
        CompactMemInfoItem item = new CompactMemInfoItem();
        for (String line : lines) {
            Matcher m = PROC_PATTERN.matcher(line);
            if (m.matches()) {
                String type = m.group(1);
                String name = m.group(2);
                try {
                    int pid = Integer.parseInt(m.group(3));
                    long pss = Long.parseLong(m.group(4));
                    long swap = 0L;
                    if (m.group(6) != null && !"N/A".equals(m.group(6))) {
                        swap = Long.parseLong(m.group(6));
                    }
                    boolean activities = "a".equals(m.group(7));
                    item.addPid(pid, name, type, pss, swap, activities);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((m = LOST_RAM_PATTERN.matcher(line)).matches()) {
                try {
                    long lostRam = Long.parseLong(m.group(1));
                    item.setLostRam(lostRam);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((m = RAM_PATTERN.matcher(line)).matches()) {
                try {
                    item.setFreeRam(Long.parseLong(m.group(2)));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((m = ZRAM_PATTERN.matcher(line)).matches()) {
                try {
                    item.setTotalZram(Long.parseLong(m.group(1)));
                    item.setFreeSwapZram(Long.parseLong(m.group(3)));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (!(m = TUNING_PATTERN.matcher(line)).matches()) continue;
            try {
                item.setTuningLevel(Long.parseLong(m.group(3)));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return item;
    }
}

