/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.parser;

import com.android.loganalysis.item.BatteryDischargeStatsInfoItem;
import com.android.loganalysis.parser.AbstractSectionParser;
import com.android.loganalysis.util.NumberFormattingUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BatteryDischargeStatsInfoParser
extends AbstractSectionParser {
    private static final Pattern DISCHARGE_STEP_PATTERN = Pattern.compile("^.*: \\+((\\d+)h)?((\\d+)m)?((\\d+)s)?(\\d+)ms.* to (\\d+).*");

    @Override
    public BatteryDischargeStatsInfoItem parse(List<String> lines) {
        long totalDuration = 0L;
        long projectionDuration = 0L;
        Integer minPercent = null;
        Integer maxPercent = null;
        Integer minProjectionPercent = null;
        Integer maxProjectionPercent = null;
        for (String line : lines) {
            Matcher m = DISCHARGE_STEP_PATTERN.matcher(line);
            if (!m.matches()) continue;
            int percent = Integer.parseInt(m.group(8));
            if (minPercent == null || percent < minPercent) {
                minPercent = percent;
            }
            if (maxPercent == null || maxPercent < percent) {
                maxPercent = percent;
            }
            long duration = NumberFormattingUtil.getMs(NumberFormattingUtil.parseIntOrZero(m.group(2)), NumberFormattingUtil.parseIntOrZero(m.group(4)), NumberFormattingUtil.parseIntOrZero(m.group(6)), NumberFormattingUtil.parseIntOrZero(m.group(7)));
            totalDuration += duration;
            if (percent > 94) continue;
            if (minProjectionPercent == null || percent < minProjectionPercent) {
                minProjectionPercent = percent;
            }
            if (maxProjectionPercent == null || maxProjectionPercent < percent) {
                maxProjectionPercent = percent;
            }
            projectionDuration += duration;
        }
        if (minPercent == null) {
            return null;
        }
        int dischargePercent = maxPercent - minPercent + 1;
        BatteryDischargeStatsInfoItem item = new BatteryDischargeStatsInfoItem();
        item.setDischargeDuration(totalDuration);
        item.setDischargePercentage(dischargePercent);
        item.setMaxPercentage(maxPercent);
        item.setMinPercentage(minPercent);
        if (minProjectionPercent == null) {
            return item;
        }
        int projectionDischargePercent = maxProjectionPercent - minProjectionPercent + 1;
        item.setProjectedBatteryLife(projectionDuration * 100L / (long)projectionDischargePercent);
        return item;
    }
}

