/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.item;

import com.android.loganalysis.item.GenericItem;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class GenericTimingItem
extends GenericItem {
    public static final String NAME = "NAME";
    public static final String START_TIME = "START_TIME";
    public static final String END_TIME = "END_TIME";
    private static final Set<String> ATTRIBUTES = new HashSet<String>(Arrays.asList("NAME", "END_TIME", "START_TIME"));

    public GenericTimingItem() {
        super(ATTRIBUTES);
    }

    protected GenericTimingItem(Set<String> attributes) {
        super(GenericTimingItem.getAllAttributes(attributes));
    }

    public String getName() {
        return (String)this.getAttribute(NAME);
    }

    public void setName(String name) {
        this.setAttribute(NAME, name);
    }

    public Double getDuration() {
        return (Double)this.getAttribute(END_TIME) - (Double)this.getAttribute(START_TIME);
    }

    public Double getStartTime() {
        return (Double)this.getAttribute(START_TIME);
    }

    public Double getEndTime() {
        return (Double)this.getAttribute(END_TIME);
    }

    public void setStartAndEnd(double startTime, double endTime) {
        this.setAttribute(START_TIME, startTime);
        this.setAttribute(END_TIME, endTime);
    }

    private static Set<String> getAllAttributes(Set<String> attributes) {
        HashSet<String> allAttributes = new HashSet<String>(ATTRIBUTES);
        allAttributes.addAll(attributes);
        return allAttributes;
    }
}

