/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.item;

import com.android.loganalysis.item.DumpsysBatteryStatsItem;
import com.android.loganalysis.item.DumpsysPackageStatsItem;
import com.android.loganalysis.item.DumpsysProcStatsItem;
import com.android.loganalysis.item.DumpsysWifiStatsItem;
import com.android.loganalysis.item.GenericItem;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class DumpsysItem
extends GenericItem {
    private static final String BATTERY_STATS = "BATTERY_STATS";
    private static final String PACKAGE_STATS = "PACKAGE_STATS";
    private static final String PROC_STATS = "PROC_STATS";
    private static final String WIFI_STATS = "WIFI_STATS";
    private static final Set<String> ATTRIBUTES = new HashSet<String>(Arrays.asList("BATTERY_STATS", "PACKAGE_STATS", "PROC_STATS", "WIFI_STATS"));

    public DumpsysItem() {
        super(ATTRIBUTES);
    }

    public void setBatteryInfo(DumpsysBatteryStatsItem batteryStats) {
        this.setAttribute(BATTERY_STATS, batteryStats);
    }

    public void setPackageStats(DumpsysPackageStatsItem packageStats) {
        this.setAttribute(PACKAGE_STATS, packageStats);
    }

    public void setProcStats(DumpsysProcStatsItem procStats) {
        this.setAttribute(PROC_STATS, procStats);
    }

    public void setWifiStats(DumpsysWifiStatsItem wifiStats) {
        this.setAttribute(WIFI_STATS, wifiStats);
    }

    public DumpsysBatteryStatsItem getBatteryStats() {
        return (DumpsysBatteryStatsItem)this.getAttribute(BATTERY_STATS);
    }

    public DumpsysPackageStatsItem getPackageStats() {
        return (DumpsysPackageStatsItem)this.getAttribute(PACKAGE_STATS);
    }

    public DumpsysProcStatsItem getProcStats() {
        return (DumpsysProcStatsItem)this.getAttribute(PROC_STATS);
    }

    public DumpsysWifiStatsItem getWifiStats() {
        return (DumpsysWifiStatsItem)this.getAttribute(WIFI_STATS);
    }
}

