/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.item;

import com.android.loganalysis.item.ConflictingItemException;
import com.android.loganalysis.item.IItem;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CpuInfoItem
implements IItem {
    public static final String PROCESSES_KEY = "processes";
    public static final String PID_KEY = "pid";
    public static final String PERCENT_KEY = "percent";
    public static final String NAME_KEY = "name";
    private Map<Integer, Row> mRows = new HashMap<Integer, Row>();

    @Override
    public IItem merge(IItem other) throws ConflictingItemException {
        throw new ConflictingItemException("CpuInfo items cannot be merged");
    }

    @Override
    public boolean isConsistent(IItem other) {
        return false;
    }

    @Override
    public JSONObject toJson() {
        JSONObject object = new JSONObject();
        JSONArray processes = new JSONArray();
        for (int pid : this.getPids()) {
            JSONObject proc = new JSONObject();
            try {
                proc.put(PID_KEY, pid);
                proc.put(PERCENT_KEY, this.getPercent(pid));
                proc.put(NAME_KEY, (Object)this.getName(pid));
                processes.put((Object)proc);
            }
            catch (JSONException jSONException) {}
        }
        try {
            object.put(PROCESSES_KEY, (Object)processes);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return object;
    }

    public Set<Integer> getPids() {
        return this.mRows.keySet();
    }

    public void addRow(int pid, double percent, String name) {
        Row row = new Row();
        row.percent = percent;
        row.name = name;
        this.mRows.put(pid, row);
    }

    public double getPercent(int pid) {
        return this.mRows.get((Object)Integer.valueOf((int)pid)).percent;
    }

    public String getName(int pid) {
        return this.mRows.get((Object)Integer.valueOf((int)pid)).name;
    }

    private static class Row {
        public double percent;
        public String name;

        private Row() {
        }
    }
}

