/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.android.utils.TokenizedCommandLine;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a8\u0006\n"}, d2={"Lcom/android/utils/StringHelperPOSIX;", "", "<init>", "()V", "splitCommandLine", "", "", "commandLine", "tokenizeCommandLineToEscaped", "tokenizeCommandLineToRaw", "common"})
public final class StringHelperPOSIX {
    @NotNull
    public static final StringHelperPOSIX INSTANCE = new StringHelperPOSIX();

    private StringHelperPOSIX() {
    }

    @JvmStatic
    @NotNull
    public static final List<String> splitCommandLine(@NotNull String commandLine) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        ArrayList arrayList = Lists.newArrayList();
        Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"newArrayList(...)");
        List commands = arrayList;
        boolean quoting = false;
        char quote = '\u0000';
        boolean escaping = false;
        int commandStart = 0;
        int i = 0;
        while (i < commandLine.length()) {
            char c = commandLine.charAt(i);
            if (escaping) {
                escaping = false;
                ++i;
                continue;
            }
            if (!(c != '\\' || quoting && quote != '\"')) {
                escaping = true;
                ++i;
                continue;
            }
            if (!(quoting || c != '\"' && c != '\'')) {
                quoting = true;
                quote = c;
                ++i;
                continue;
            }
            if (quoting && c == quote) {
                quoting = false;
                quote = '\u0000';
                ++i;
                continue;
            }
            if (!quoting) {
                int matched = 0;
                if (commandLine.length() > i + 1 && commandLine.charAt(i) == '&' && commandLine.charAt(i + 1) == '&') {
                    matched = 2;
                } else if (commandLine.charAt(i) == ';') {
                    matched = 1;
                }
                if (matched > 0) {
                    String string = commandLine.substring(commandStart, i);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    commands.add(string);
                    commandStart = i += matched;
                }
            }
            ++i;
        }
        if (commandStart < commandLine.length()) {
            String string = commandLine.substring(commandStart);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            commands.add(string);
        }
        return commands;
    }

    @JvmStatic
    @NotNull
    public static final List<String> tokenizeCommandLineToEscaped(@NotNull String commandLine) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        return new TokenizedCommandLine(commandLine, false, 1, null, 8, null).toTokenList();
    }

    @JvmStatic
    @NotNull
    public static final List<String> tokenizeCommandLineToRaw(@NotNull String commandLine) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        return new TokenizedCommandLine(commandLine, true, 1, null, 8, null).toTokenList();
    }
}

