/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import one.util.streamex.Internals;
import one.util.streamex.TailConcatSpliterator;
import one.util.streamex.UnknownSizeSpliterator;

class ZipSpliterator<U, V, R>
implements Spliterator<R> {
    private Spliterator<U> left;
    private Spliterator<V> right;
    private final BiFunction<? super U, ? super V, ? extends R> mapper;
    private boolean trySplit;
    private int batch = 0;
    private final Internals.Box<U> l = new Internals.Box();
    private final Internals.Box<V> r = new Internals.Box();

    ZipSpliterator(Spliterator<U> left, Spliterator<V> right, BiFunction<? super U, ? super V, ? extends R> mapper, boolean trySplit) {
        this.left = left;
        this.right = right;
        this.mapper = mapper;
        this.trySplit = trySplit;
    }

    @Override
    public boolean tryAdvance(Consumer<? super R> action2) {
        if (this.left.tryAdvance(this.l) && this.right.tryAdvance(this.r)) {
            action2.accept(this.mapper.apply(this.l.a, this.r.a));
            return true;
        }
        return false;
    }

    @Override
    public void forEachRemaining(Consumer<? super R> action2) {
        long rightSize;
        if (!this.hasCharacteristics(64)) {
            Spliterator.super.forEachRemaining(action2);
            return;
        }
        long leftSize = this.left.getExactSizeIfKnown();
        if (leftSize <= (rightSize = this.right.getExactSizeIfKnown())) {
            this.left.forEachRemaining((? super T u) -> {
                if (this.right.tryAdvance(this.r)) {
                    action2.accept((R)this.mapper.apply(u, this.r.a));
                }
            });
        } else {
            this.right.forEachRemaining((? super T v) -> {
                if (this.left.tryAdvance(this.l)) {
                    action2.accept((R)this.mapper.apply(this.l.a, v));
                }
            });
        }
    }

    @Override
    public Spliterator<R> trySplit() {
        if (this.trySplit && this.hasCharacteristics(16448)) {
            Spliterator<U> leftPrefix = this.left.trySplit();
            if (leftPrefix == null) {
                return this.arraySplit();
            }
            Spliterator<V> rightPrefix = this.right.trySplit();
            if (rightPrefix == null) {
                this.left = new TailConcatSpliterator<U>(leftPrefix, this.left);
                return this.arraySplit();
            }
            long leftSize = leftPrefix.getExactSizeIfKnown();
            long rightSize = rightPrefix.getExactSizeIfKnown();
            if (leftSize >= 0L && rightSize >= 0L) {
                if (leftSize == rightSize) {
                    return new ZipSpliterator<U, V, R>(leftPrefix, rightPrefix, this.mapper, true);
                }
                if (Math.abs(leftSize - rightSize) < Math.min(1024L, Math.max(leftSize, rightSize) / 8L)) {
                    if (leftSize < rightSize) {
                        Object[] array = new Object[(int)(rightSize - leftSize)];
                        Internals.drainTo(array, this.left);
                        leftPrefix = new TailConcatSpliterator<U>(leftPrefix, Spliterators.spliterator(array, this.characteristics()));
                    } else {
                        Object[] array = new Object[(int)(leftSize - rightSize)];
                        Internals.drainTo(array, this.right);
                        rightPrefix = new TailConcatSpliterator<V>(rightPrefix, Spliterators.spliterator(array, this.characteristics()));
                    }
                    this.trySplit = false;
                    return new ZipSpliterator<U, V, R>(leftPrefix, rightPrefix, this.mapper, false);
                }
            }
            this.left = new TailConcatSpliterator<U>(leftPrefix, this.left);
            this.right = new TailConcatSpliterator<V>(rightPrefix, this.right);
        }
        return this.arraySplit();
    }

    private Spliterator<R> arraySplit() {
        Object[] array;
        int index;
        long s = this.estimateSize();
        if (s <= 1L) {
            return null;
        }
        int n = this.batch + 1024;
        if ((long)n > s) {
            n = (int)s;
        }
        if (n > 0x2000000) {
            n = 0x2000000;
        }
        if ((this.batch = (index = Internals.drainTo(array = new Object[n], this))) == 0) {
            return null;
        }
        long s2 = this.estimateSize();
        UnknownSizeSpliterator.USOfRef prefix = new UnknownSizeSpliterator.USOfRef(array, 0, index);
        prefix.est = this.hasCharacteristics(16384) ? (long)index : (s == s2 ? Math.max((long)index, s / 2L) : Math.max((long)index, s2 - s));
        return prefix;
    }

    @Override
    public long estimateSize() {
        return Math.min(this.left.estimateSize(), this.right.estimateSize());
    }

    @Override
    public int characteristics() {
        return this.left.characteristics() & this.right.characteristics() & 0x5450;
    }
}

