/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.diff;

import com.intellij.util.diff.BitSet;
import com.intellij.util.diff.FilesTooBigForDiffException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\r\u0010\u000fJ\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0013J\u0006\u0010\u0015\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J8\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J \u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0006H\u0002J \u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u0006H\u0002J \u0010$\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000b0&8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u0006)"}, d2={"Lcom/intellij/util/diff/MyersLCS;", "", "first", "", "second", "start1", "", "count1", "start2", "count2", "changes1", "Lcom/intellij/util/diff/BitSet;", "changes2", "<init>", "([I[IIIIILcom/intellij/util/diff/BitSet;Lcom/intellij/util/diff/BitSet;)V", "([I[I)V", "VForward", "VBackward", "executeLinear", "", "execute", "executeWithThreshold", "threshold", "throwException", "", "oldStart", "oldEnd", "newStart", "newEnd", "differenceEstimate", "addUnchanged", "count", "commonSubsequenceLengthForward", "oldIndex", "newIndex", "maxLength", "commonSubsequenceLengthBackward", "changes", "", "getChanges", "()[Lcom/intellij/util/diff/BitSet;", "intellij.platform.util.diff"})
@ApiStatus.Internal
public final class MyersLCS {
    @NotNull
    private final int[] first;
    @NotNull
    private final int[] second;
    private final int start1;
    private final int count1;
    private final int start2;
    private final int count2;
    @NotNull
    private final BitSet changes1;
    @NotNull
    private final BitSet changes2;
    @NotNull
    private final int[] VForward;
    @NotNull
    private final int[] VBackward;

    public MyersLCS(@NotNull int[] first2, @NotNull int[] second2, int start1, int count1, int start2, int count2, @NotNull BitSet changes1, @NotNull BitSet changes2) {
        Intrinsics.checkNotNullParameter((Object)first2, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second2, (String)"second");
        Intrinsics.checkNotNullParameter((Object)changes1, (String)"changes1");
        Intrinsics.checkNotNullParameter((Object)changes2, (String)"changes2");
        this.first = first2;
        this.second = second2;
        this.start1 = start1;
        this.count1 = count1;
        this.start2 = start2;
        this.count2 = count2;
        this.changes1 = changes1;
        this.changes2 = changes2;
        BitSet.set$default(this.changes1, this.start1, this.start1 + this.count1, false, 4, null);
        BitSet.set$default(this.changes2, this.start2, this.start2 + this.count2, false, 4, null);
        int totalSequenceLength = this.count1 + this.count2;
        this.VForward = new int[totalSequenceLength + 1];
        this.VBackward = new int[totalSequenceLength + 1];
    }

    public MyersLCS(@NotNull int[] first2, @NotNull int[] second2) {
        Intrinsics.checkNotNullParameter((Object)first2, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second2, (String)"second");
        this(first2, second2, 0, first2.length, 0, second2.length, new BitSet(first2.length), new BitSet(second2.length));
    }

    public final void executeLinear() {
        try {
            int threshold = 20000 + 10 * (int)Math.sqrt(this.count1 + this.count2);
            this.execute(threshold, false);
        }
        catch (FilesTooBigForDiffException e) {
            throw new IllegalStateException(e);
        }
    }

    public final void execute() {
        try {
            this.execute(this.count1 + this.count2, false);
        }
        catch (FilesTooBigForDiffException e) {
            throw new IllegalStateException(e);
        }
    }

    public final void executeWithThreshold() throws FilesTooBigForDiffException {
        int threshold = Math.max(20000 + 10 * (int)Math.sqrt(this.count1 + this.count2), 20000);
        this.execute(threshold, true);
    }

    private final void execute(int threshold, boolean throwException) throws FilesTooBigForDiffException {
        if (this.count1 == 0 || this.count2 == 0) {
            return;
        }
        this.execute(0, this.count1, 0, this.count2, Math.min(threshold, this.count1 + this.count2), throwException);
    }

    private final void execute(int oldStart, int oldEnd, int newStart, int newEnd, int differenceEstimate, boolean throwException) throws FilesTooBigForDiffException {
        if (!(oldStart <= oldEnd && newStart <= newEnd)) {
            throw new IllegalStateException("Check failed.");
        }
        if (oldStart < oldEnd && newStart < newEnd) {
            int oldLength = oldEnd - oldStart;
            int newLength = newEnd - newStart;
            this.VForward[newLength + 1] = 0;
            this.VBackward[newLength + 1] = 0;
            int halfD = (differenceEstimate + 1) / 2;
            int xx = 0;
            int kk = 0;
            int td = 0;
            xx = kk = (td = -1);
            int d = 0;
            if (d <= halfD) {
                block0: while (true) {
                    int k;
                    int L = newLength + Math.max(-d, -newLength + ((d ^ newLength) & 1));
                    int R = newLength + Math.min(d, oldLength - ((d ^ oldLength) & 1));
                    MyersLCS $this$execute_u24lambda_u240 = this;
                    boolean bl = false;
                    for (int k2 = L; k2 <= R; k2 += 2) {
                        int x = k2 == L || k2 != R && $this$execute_u24lambda_u240.VForward[k2 - 1] < $this$execute_u24lambda_u240.VForward[k2 + 1] ? $this$execute_u24lambda_u240.VForward[k2 + 1] : $this$execute_u24lambda_u240.VForward[k2 - 1] + 1;
                        int y = x - k2 + newLength;
                        x += $this$execute_u24lambda_u240.commonSubsequenceLengthForward(oldStart + x, newStart + y, Math.min(oldEnd - oldStart - x, newEnd - newStart - y));
                        $this$execute_u24lambda_u240.VForward[k2] = x;
                    }
                    if ((oldLength - newLength) % 2 != 0) {
                        for (k = L; k <= R; k += 2) {
                            if (oldLength - (d - 1) > k || k > oldLength + (d - 1) || this.VForward[k] + this.VBackward[newLength + oldLength - k] < oldLength) continue;
                            xx = this.VForward[k];
                            kk = k;
                            td = 2 * d - 1;
                            break block0;
                        }
                    }
                    for (k = L; k <= R; k += 2) {
                        int x = k == L || k != R && this.VBackward[k - 1] < this.VBackward[k + 1] ? this.VBackward[k + 1] : this.VBackward[k - 1] + 1;
                        int y = x - k + newLength;
                        x += this.commonSubsequenceLengthBackward(oldEnd - 1 - x, newEnd - 1 - y, Math.min(oldEnd - oldStart - x, newEnd - newStart - y));
                        this.VBackward[k] = x;
                    }
                    if ((oldLength - newLength) % 2 == 0) {
                        for (int k3 = L; k3 <= R; k3 += 2) {
                            if (oldLength - d > k3 || k3 > oldLength + d || this.VForward[oldLength + newLength - k3] + this.VBackward[k3] < oldLength) continue;
                            xx = oldLength - this.VBackward[k3];
                            kk = oldLength + newLength - k3;
                            td = 2 * d;
                            break block0;
                        }
                    }
                    if (d == halfD) break;
                    ++d;
                }
            }
            if (td > 1) {
                int yy = xx - kk + newLength;
                int oldDiff = (td + 1) / 2;
                if (0 < xx && 0 < yy) {
                    this.execute(oldStart, oldStart + xx, newStart, newStart + yy, oldDiff, throwException);
                }
                if (oldStart + xx < oldEnd && newStart + yy < newEnd) {
                    this.execute(oldStart + xx, oldEnd, newStart + yy, newEnd, td - oldDiff, throwException);
                }
            } else if (td >= 0) {
                int x = oldStart;
                int y = newStart;
                while (x < oldEnd && y < newEnd) {
                    int commonLength = this.commonSubsequenceLengthForward(x, y, Math.min(oldEnd - x, newEnd - y));
                    if (commonLength > 0) {
                        this.addUnchanged(x, y, commonLength);
                        x += commonLength;
                        y += commonLength;
                        continue;
                    }
                    if (oldEnd - oldStart > newEnd - newStart) {
                        ++x;
                        continue;
                    }
                    ++y;
                }
            } else if (throwException) {
                throw new FilesTooBigForDiffException();
            }
        }
    }

    private final void addUnchanged(int start1, int start2, int count2) {
        this.changes1.set(this.start1 + start1, this.start1 + start1 + count2, false);
        this.changes2.set(this.start2 + start2, this.start2 + start2 + count2, false);
    }

    private final int commonSubsequenceLengthForward(int oldIndex, int newIndex, int maxLength) {
        int maxLength2 = maxLength;
        int x = oldIndex;
        int y = newIndex;
        maxLength2 = Math.min(maxLength2, Math.min(this.count1 - oldIndex, this.count2 - newIndex));
        while (x - oldIndex < maxLength2 && this.first[this.start1 + x] == this.second[this.start2 + y]) {
            ++x;
            ++y;
        }
        return x - oldIndex;
    }

    private final int commonSubsequenceLengthBackward(int oldIndex, int newIndex, int maxLength) {
        int maxLength2 = maxLength;
        int x = oldIndex;
        int y = newIndex;
        maxLength2 = Math.min(maxLength2, Math.min(oldIndex, newIndex) + 1);
        while (oldIndex - x < maxLength2 && this.first[this.start1 + x] == this.second[this.start2 + y]) {
            --x;
            --y;
        }
        return oldIndex - x;
    }

    @NotNull
    public final BitSet[] getChanges() {
        BitSet[] bitSetArray = new BitSet[]{this.changes1, this.changes2};
        return bitSetArray;
    }
}

