/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.java.indexing.JavaIndexingBundle;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.search.HighlightingCaches;
import com.intellij.psi.impl.search.JavaOverridingMethodsSearcher;
import com.intellij.psi.impl.search.LazyConcurrentCollection;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllClassesSearch;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Processor;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public final class JavaClassInheritorsSearcher
extends QueryExecutorBase<PsiClass, ClassInheritorsSearch.SearchParameters> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processQuery(@NotNull ClassInheritorsSearch.SearchParameters parameters, @NotNull Processor<? super PsiClass> consumer) {
        if (parameters == null) {
            JavaClassInheritorsSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            JavaClassInheritorsSearcher.$$$reportNull$$$0(1);
        }
        PsiClass baseClass = parameters.getClassToProcess();
        assert (parameters.isCheckDeep());
        assert (parameters.isCheckInheritance());
        ProgressIndicator progress = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (progress != null) {
            progress.pushState();
            String className = ReadAction.compute(baseClass::getName);
            progress.setText(className != null ? JavaIndexingBundle.message((String)"psi.search.inheritors.of.class.progress", (Object[])new Object[]{className}) : JavaIndexingBundle.message((String)"psi.search.inheritors.progress", (Object[])new Object[0]));
        }
        try {
            JavaClassInheritorsSearcher.processInheritors(parameters, consumer);
        }
        finally {
            if (progress != null) {
                progress.popState();
            }
        }
    }

    private static void processInheritors(@NotNull ClassInheritorsSearch.SearchParameters parameters, @NotNull Processor<? super PsiClass> consumer) {
        PsiClass baseClass;
        if (parameters == null) {
            JavaClassInheritorsSearcher.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            JavaClassInheritorsSearcher.$$$reportNull$$$0(3);
        }
        if ((baseClass = parameters.getClassToProcess()) instanceof PsiAnonymousClass || JavaClassInheritorsSearcher.isFinal(baseClass)) {
            return;
        }
        SearchScope searchScope = parameters.getScope();
        Project project = PsiUtilCore.getProjectInReadAction(baseClass);
        if (JavaClassInheritorsSearcher.isJavaLangObject(baseClass)) {
            AllClassesSearch.search((SearchScope)searchScope, (Project)project, (Condition)parameters.getNameCondition()).allowParallelProcessing().forEach(aClass -> {
                ProgressManager.checkCanceled();
                return JavaClassInheritorsSearcher.isJavaLangObject(aClass) || consumer.process((PsiClass)aClass);
            });
            return;
        }
        if (searchScope instanceof LocalSearchScope && JavaOverridingMethodsSearcher.isJavaOnlyScope(((LocalSearchScope)searchScope).getVirtualFiles())) {
            JavaClassInheritorsSearcher.processLocalScope(project, parameters, (LocalSearchScope)searchScope, baseClass, consumer);
            return;
        }
        if (!parameters.isCheckDeep() && ApplicationManager.getApplication().isDispatchThread()) {
            DirectClassInheritorsSearch.search((PsiClass)baseClass, (SearchScope)searchScope).forEach(consumer);
            return;
        }
        Iterable<PsiClass> cached = JavaClassInheritorsSearcher.getOrComputeSubClasses(project, baseClass, searchScope, parameters);
        for (PsiClass subClass : cached) {
            ProgressManager.checkCanceled();
            if (subClass == null || !ReadAction.compute(() -> JavaClassInheritorsSearcher.checkCandidate(subClass, parameters) && !consumer.process(subClass)).booleanValue()) continue;
            return;
        }
    }

    @NotNull
    private static @NotNull Iterable<@NotNull PsiClass> getOrComputeSubClasses(@NotNull Project project, @NotNull PsiClass baseClass, @NotNull SearchScope searchScopeForNonPhysical, final @NotNull ClassInheritorsSearch.SearchParameters parameters) {
        if (project == null) {
            JavaClassInheritorsSearcher.$$$reportNull$$$0(4);
        }
        if (baseClass == null) {
            JavaClassInheritorsSearcher.$$$reportNull$$$0(5);
        }
        if (searchScopeForNonPhysical == null) {
            JavaClassInheritorsSearcher.$$$reportNull$$$0(6);
        }
        if (parameters == null) {
            JavaClassInheritorsSearcher.$$$reportNull$$$0(7);
        }
        HighlightingCaches caches = HighlightingCaches.getInstance(project);
        ConcurrentMap<PsiClass, Iterable<PsiClass>> map2 = parameters.isIncludeAnonymous() ? caches.ALL_SUB_CLASSES : caches.ALL_SUB_CLASSES_NO_ANONYMOUS;
        LazyConcurrentCollection<PsiAnchor, PsiClass> cached = (LazyConcurrentCollection<PsiAnchor, PsiClass>)map2.get(baseClass);
        if (cached == null) {
            Function<@NotNull PsiAnchor, @NotNull PsiClass> converter = anchor -> ReadAction.compute(() -> (PsiClass)anchor.retrieve());
            Predicate<PsiClass> applicableFilter = candidate -> !(candidate instanceof PsiAnonymousClass) && candidate != null && !candidate.hasModifierProperty("final");
            boolean isPhysical = ReadAction.compute(baseClass::isPhysical);
            SearchScope scopeToUse = isPhysical ? GlobalSearchScope.allScope(project) : searchScopeForNonPhysical;
            LazyConcurrentCollection.MoreElementsGenerator generator = (candidate, processor) -> DirectClassInheritorsSearch.search((DirectClassInheritorsSearch.SearchParameters)new DirectClassInheritorsSearch.SearchParameters((PsiClass)candidate, scopeToUse, parameters.isIncludeAnonymous(), true){

                public boolean shouldSearchInLanguage(@NotNull Language language) {
                    if (language == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return parameters.shouldSearchInLanguage(language);
                }

                public ClassInheritorsSearch.SearchParameters getOriginalParameters() {
                    return parameters;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher$1", "shouldSearchInLanguage"));
                }
            }).allowParallelProcessing().forEach(subClass -> {
                ProgressManager.checkCanceled();
                @NotNull PsiAnchor pointer = ReadAction.compute(() -> PsiAnchor.create(subClass));
                processor.accept(pointer);
                return true;
            });
            PsiAnchor seed = ReadAction.compute(() -> PsiAnchor.create(baseClass));
            LazyConcurrentCollection<PsiAnchor, PsiClass> computed = new LazyConcurrentCollection<PsiAnchor, PsiClass>(seed, converter, applicableFilter, generator);
            cached = isPhysical ? (Iterable)ConcurrencyUtil.cacheOrGet(map2, baseClass, computed) : computed;
        }
        LazyConcurrentCollection<PsiAnchor, PsiClass> lazyConcurrentCollection = cached;
        if (lazyConcurrentCollection == null) {
            JavaClassInheritorsSearcher.$$$reportNull$$$0(8);
        }
        return lazyConcurrentCollection;
    }

    private static void processLocalScope(@NotNull Project project, @NotNull ClassInheritorsSearch.SearchParameters parameters, @NotNull LocalSearchScope searchScope, @NotNull PsiClass baseClass, @NotNull Processor<? super PsiClass> consumer) {
        if (project == null) {
            JavaClassInheritorsSearcher.$$$reportNull$$$0(9);
        }
        if (parameters == null) {
            JavaClassInheritorsSearcher.$$$reportNull$$$0(10);
        }
        if (searchScope == null) {
            JavaClassInheritorsSearcher.$$$reportNull$$$0(11);
        }
        if (baseClass == null) {
            JavaClassInheritorsSearcher.$$$reportNull$$$0(12);
        }
        if (consumer == null) {
            JavaClassInheritorsSearcher.$$$reportNull$$$0(13);
        }
        VirtualFile[] virtualFiles = searchScope.getVirtualFiles();
        boolean[] success = new boolean[]{true};
        if (virtualFiles.length == 0) {
            for (UserDataHolder userDataHolder : searchScope.getScope()) {
                JavaClassInheritorsSearcher.processFile(userDataHolder.getContainingFile(), consumer, parameters, baseClass, success);
            }
        }
        for (UserDataHolder userDataHolder : virtualFiles) {
            ProgressManager.checkCanceled();
            ApplicationManager.getApplication().runReadAction(() -> JavaClassInheritorsSearcher.lambda$processLocalScope$9(project, (VirtualFile)userDataHolder, consumer, parameters, baseClass, success));
        }
    }

    private static void processFile(PsiFile psiFile, final Processor<? super PsiClass> consumer, final // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ClassInheritorsSearch.SearchParameters parameters, final @NotNull PsiClass baseClass, final boolean[] success) {
        if (baseClass == null) {
            JavaClassInheritorsSearcher.$$$reportNull$$$0(14);
        }
        if (parameters == null) {
            JavaClassInheritorsSearcher.$$$reportNull$$$0(15);
        }
        psiFile.accept(new JavaRecursiveElementVisitor(){

            @Override
            public void visitClass(@NotNull PsiClass candidate) {
                if (candidate == null) {
                    2.$$$reportNull$$$0(0);
                }
                ProgressManager.checkCanceled();
                if (!success[0]) {
                    return;
                }
                if (candidate.isInheritor(baseClass, true) && JavaClassInheritorsSearcher.checkCandidate(candidate, parameters) && !consumer.process(candidate)) {
                    success[0] = false;
                    return;
                }
                super.visitClass(candidate);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/psi/impl/search/JavaClassInheritorsSearcher$2", "visitClass"));
            }
        });
    }

    private static boolean checkCandidate(@NotNull PsiClass candidate, @NotNull ClassInheritorsSearch.SearchParameters parameters) {
        if (candidate == null) {
            JavaClassInheritorsSearcher.$$$reportNull$$$0(16);
        }
        if (parameters == null) {
            JavaClassInheritorsSearcher.$$$reportNull$$$0(17);
        }
        SearchScope searchScope = parameters.getScope();
        ProgressManager.checkCanceled();
        if (!PsiSearchScopeUtil.isInScope(searchScope, (PsiElement)candidate)) {
            return false;
        }
        if (candidate instanceof PsiAnonymousClass) {
            return true;
        }
        String name = candidate.getName();
        return name != null && parameters.getNameCondition().value(name);
    }

    static boolean isJavaLangObject(@NotNull PsiClass baseClass) {
        if (baseClass == null) {
            JavaClassInheritorsSearcher.$$$reportNull$$$0(18);
        }
        return ReadAction.compute(() -> baseClass.isValid() && "java.lang.Object".equals(baseClass.getQualifiedName()));
    }

    private static boolean isFinal(@NotNull PsiClass baseClass) {
        if (baseClass == null) {
            JavaClassInheritorsSearcher.$$$reportNull$$$0(19);
        }
        return ReadAction.compute(() -> baseClass.hasModifierProperty("final"));
    }

    private static /* synthetic */ void lambda$processLocalScope$9(Project project, VirtualFile virtualFile, Processor consumer, ClassInheritorsSearch.SearchParameters parameters, PsiClass baseClass, boolean[] success) {
        PsiFile psiFile = PsiManager.getInstance(project).findFile(virtualFile);
        if (psiFile != null) {
            JavaClassInheritorsSearcher.processFile(psiFile, consumer, parameters, baseClass, success);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 12: 
            case 14: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScopeForNonPhysical";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/search/JavaClassInheritorsSearcher";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/search/JavaClassInheritorsSearcher";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrComputeSubClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processQuery";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processInheritors";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getOrComputeSubClasses";
                break;
            }
            case 8: {
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processLocalScope";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processFile";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "checkCandidate";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isJavaLangObject";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isFinal";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }
}

