/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.compiled.SignatureParsing;
import com.intellij.psi.impl.compiled.StubBuildingVisitor;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.Type;

final class AnnotationTextCollector
extends AnnotationVisitor {
    @NotNull
    private final StringBuilder myBuilder;
    @NotNull
    private final SignatureParsing.TypeInfoProvider myMapping;
    private final Consumer<? super String> myCallback;
    private boolean hasPrefix;
    private boolean hasParams;

    AnnotationTextCollector(@Nullable String desc, @NotNull SignatureParsing.TypeInfoProvider mapping, Consumer<? super String> callback) {
        if (mapping == null) {
            AnnotationTextCollector.$$$reportNull$$$0(0);
        }
        super(589824);
        this.myBuilder = new StringBuilder();
        this.myMapping = mapping;
        this.myCallback = callback;
        if (desc != null) {
            this.hasPrefix = true;
            this.myBuilder.append('@');
            StubBuildingVisitor.toJavaType(this.myBuilder, Type.getType(desc), this.myMapping);
        }
    }

    @Override
    public void visit(String name, Object value) {
        this.valuePairPrefix(name);
        StubBuildingVisitor.constToString(this.myBuilder, value, TypeInfo.SimpleTypeInfo.NULL, true, this.myMapping);
    }

    @Override
    public void visitEnum(String name, String desc, String value) {
        this.valuePairPrefix(name);
        StubBuildingVisitor.toJavaType(this.myBuilder, Type.getType(desc), this.myMapping);
        this.myBuilder.append('.').append(value);
    }

    private void valuePairPrefix(String name) {
        if (!this.hasParams) {
            this.hasParams = true;
            if (this.hasPrefix) {
                this.myBuilder.append('(');
            }
        } else {
            this.myBuilder.append(',');
        }
        if (name != null) {
            this.myBuilder.append(name).append('=');
        }
    }

    @Override
    public AnnotationVisitor visitAnnotation(String name, String desc) {
        this.valuePairPrefix(name);
        return new AnnotationTextCollector(desc, this.myMapping, text -> this.myBuilder.append((String)text));
    }

    @Override
    public AnnotationVisitor visitArray(String name) {
        this.valuePairPrefix(name);
        this.myBuilder.append('{');
        return new AnnotationTextCollector(null, this.myMapping, text -> this.myBuilder.append((String)text).append('}'));
    }

    @Override
    public void visitEnd() {
        if (this.hasPrefix && this.hasParams) {
            this.myBuilder.append(')');
        }
        this.myCallback.consume(this.myBuilder.toString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "com/intellij/psi/impl/compiled/AnnotationTextCollector", "<init>"));
    }
}

