/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.codeInsight.TypeNullability;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PsiDisjunctionType
extends PsiType.Stub {
    private final PsiManager myManager;
    private final List<PsiType> myTypes;
    private final CachedValue<PsiType> myLubCache;

    public PsiDisjunctionType(@NotNull List<PsiType> types, @NotNull PsiManager psiManager) {
        if (types == null) {
            PsiDisjunctionType.$$$reportNull$$$0(0);
        }
        if (psiManager == null) {
            PsiDisjunctionType.$$$reportNull$$$0(1);
        }
        super(TypeAnnotationProvider.EMPTY);
        this.myManager = psiManager;
        this.myTypes = Collections.unmodifiableList(types);
        this.myLubCache = CachedValuesManager.getManager(this.myManager.getProject()).createCachedValue(() -> {
            PsiType lub = this.myTypes.get(0);
            for (int i = 1; i < this.myTypes.size(); ++i) {
                if ((lub = GenericsUtil.getLeastUpperBound(lub, this.myTypes.get(i), this.myManager)) != null) continue;
                lub = PsiType.getJavaLangObject(this.myManager, GlobalSearchScope.allScope(this.myManager.getProject()));
                break;
            }
            return CachedValueProvider.Result.create(lub, PsiModificationTracker.MODIFICATION_COUNT);
        }, false);
    }

    @NotNull
    public static PsiType createDisjunction(@NotNull List<PsiType> types, @NotNull PsiManager psiManager) {
        if (types == null) {
            PsiDisjunctionType.$$$reportNull$$$0(2);
        }
        if (psiManager == null) {
            PsiDisjunctionType.$$$reportNull$$$0(3);
        }
        assert (!types.isEmpty());
        return types.size() == 1 ? types.get(0) : new PsiDisjunctionType(types, psiManager);
    }

    @NotNull
    public PsiType getLeastUpperBound() {
        PsiType psiType = this.myLubCache.getValue();
        if (psiType == null) {
            PsiDisjunctionType.$$$reportNull$$$0(4);
        }
        return psiType;
    }

    @NotNull
    public List<PsiType> getDisjunctions() {
        List<PsiType> list = this.myTypes;
        if (list == null) {
            PsiDisjunctionType.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public PsiDisjunctionType newDisjunctionType(List<PsiType> types) {
        return new PsiDisjunctionType(types, this.myManager);
    }

    @Override
    @NotNull
    public String getPresentableText(boolean annotated) {
        String string = StringUtil.join(this.myTypes, psiType -> psiType.getPresentableText(annotated), " | ");
        if (string == null) {
            PsiDisjunctionType.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    public String getCanonicalText(boolean annotated) {
        String string = StringUtil.join(this.myTypes, psiType -> psiType.getCanonicalText(annotated), " | ");
        if (string == null) {
            PsiDisjunctionType.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @NotNull
    public String getInternalCanonicalText() {
        String string = StringUtil.join(this.myTypes, psiType -> psiType.getInternalCanonicalText(), " | ");
        if (string == null) {
            PsiDisjunctionType.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    public boolean isValid() {
        for (PsiType type : this.myTypes) {
            if (type.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public TypeNullability getNullability() {
        TypeNullability typeNullability = TypeNullability.NOT_NULL_MANDATED;
        if (typeNullability == null) {
            PsiDisjunctionType.$$$reportNull$$$0(9);
        }
        return typeNullability;
    }

    @Override
    public boolean equalsToText(@NotNull @NonNls String text) {
        if (text == null) {
            PsiDisjunctionType.$$$reportNull$$$0(10);
        }
        return Objects.equals(text, this.getCanonicalText());
    }

    @Override
    public <A> A accept(@NotNull PsiTypeVisitor<A> visitor) {
        if (visitor == null) {
            PsiDisjunctionType.$$$reportNull$$$0(11);
        }
        return visitor.visitDisjunctionType(this);
    }

    @Override
    public GlobalSearchScope getResolveScope() {
        return this.getLeastUpperBound().getResolveScope();
    }

    @Override
    public PsiType @NotNull [] getSuperTypes() {
        PsiType lub = this.getLeastUpperBound();
        if (lub instanceof PsiIntersectionType) {
            PsiType[] psiTypeArray = ((PsiIntersectionType)lub).getConjuncts();
            if (psiTypeArray == null) {
                PsiDisjunctionType.$$$reportNull$$$0(12);
            }
            return psiTypeArray;
        }
        PsiType[] psiTypeArray = new PsiType[]{lub};
        if (psiTypeArray == null) {
            PsiDisjunctionType.$$$reportNull$$$0(13);
        }
        return psiTypeArray;
    }

    public int hashCode() {
        return this.myTypes.get(0).hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PsiDisjunctionType that = (PsiDisjunctionType)o;
        if (that.myTypes.size() != this.myTypes.size()) {
            return false;
        }
        for (int i = 0; i < this.myTypes.size(); ++i) {
            if (this.myTypes.get(i).equals(that.myTypes.get(i))) continue;
            return false;
        }
        return true;
    }

    public static List<PsiType> flattenAndRemoveDuplicates(@NotNull List<? extends PsiType> types) {
        if (types == null) {
            PsiDisjunctionType.$$$reportNull$$$0(14);
        }
        LinkedHashSet disjunctionSet = new LinkedHashSet();
        for (PsiType psiType : types) {
            PsiDisjunctionType.flatten(disjunctionSet, psiType);
        }
        ArrayList<PsiType> disjunctions = new ArrayList<PsiType>(disjunctionSet);
        Iterator iterator2 = disjunctions.iterator();
        block1: while (iterator2.hasNext()) {
            PsiType d1 = (PsiType)iterator2.next();
            for (PsiType d2 : disjunctions) {
                if (d1 == d2 || !d2.isAssignableFrom(d1)) continue;
                iterator2.remove();
                continue block1;
            }
        }
        return disjunctions;
    }

    private static void flatten(Set<? super PsiType> disjunctions, PsiType type) {
        if (type instanceof PsiDisjunctionType) {
            for (PsiType child : ((PsiDisjunctionType)type).getDisjunctions()) {
                PsiDisjunctionType.flatten(disjunctions, child);
            }
        } else {
            disjunctions.add(type);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/PsiDisjunctionType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/PsiDisjunctionType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeastUpperBound";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisjunctions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalCanonicalText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNullability";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createDisjunction";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "equalsToText";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "flattenAndRemoveDuplicates";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

