/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.syntax.impl.builder;

import com.intellij.platform.syntax.Logger;
import com.intellij.platform.syntax.impl.builder.CompositeMarker;
import com.intellij.platform.syntax.impl.builder.ErrorMarker;
import com.intellij.platform.syntax.impl.builder.MarkerOptionalData;
import com.intellij.platform.syntax.impl.builder.MarkerPool;
import com.intellij.platform.syntax.impl.builder.MarkerProductionKt;
import com.intellij.platform.syntax.impl.builder.ProductionMarker;
import com.intellij.util.fastutil.ints.IntArrayList;
import com.intellij.util.fastutil.ints.IntList;
import com.intellij.util.fastutil.ints.IntListExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0015\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012H\u0002J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0012H\u0002J\u0018\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0012H\u0002J\u000e\u0010\u0019\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u001a\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u001dJ\u0010\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u001f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u001dJ\u0018\u0010 \u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u001d2\b\u0010!\u001a\u0004\u0018\u00010\u000fJ\u000e\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u0012J\u0010\u0010$\u001a\u0004\u0018\u00010\u000f2\u0006\u0010#\u001a\u00020\u0012J\u0010\u0010%\u001a\u0004\u0018\u00010\u001d2\u0006\u0010#\u001a\u00020\u0012J\u000e\u0010&\u001a\u00020\u00122\u0006\u0010'\u001a\u00020\u0012J\u0016\u0010(\u001a\u00020\r2\u0006\u0010)\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0012J\u0018\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020\u001d2\b\u0010!\u001a\u0004\u0018\u00010\u001dJ\u000e\u0010,\u001a\u00020\r2\u0006\u0010-\u001a\u00020\u000fJ\u0011\u0010.\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u0012H\u0096\u0003J)\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u00122\u0006\u00102\u001a\u0002002\u0006\u00103\u001a\u00020\u00122\u0006\u00104\u001a\u00020\u0012H\u0096\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u00105\u001a\u00020\u0012X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b6\u00107\u00a8\u00068"}, d2={"Lcom/intellij/platform/syntax/impl/builder/MarkerProduction;", "Lcom/intellij/util/fastutil/ints/IntList;", "myPool", "Lcom/intellij/platform/syntax/impl/builder/MarkerPool;", "myOptionalData", "Lcom/intellij/platform/syntax/impl/builder/MarkerOptionalData;", "logger", "Lcom/intellij/platform/syntax/Logger;", "production", "Lcom/intellij/util/fastutil/ints/IntArrayList;", "<init>", "(Lcom/intellij/platform/syntax/impl/builder/MarkerPool;Lcom/intellij/platform/syntax/impl/builder/MarkerOptionalData;Lcom/intellij/platform/syntax/Logger;Lcom/intellij/util/fastutil/ints/IntArrayList;)V", "addBefore", "", "marker", "Lcom/intellij/platform/syntax/impl/builder/ProductionMarker;", "anchor", "indexOf", "", "findLinearly", "markerId", "findMarkerAtLexeme", "lexemeIndex", "findSameLexemeGroupStart", "prodIndex", "addMarker", "rollbackTo", "hasErrorsAfter", "", "Lcom/intellij/platform/syntax/impl/builder/CompositeMarker;", "hasError", "dropMarker", "addDone", "anchorBefore", "getMarkerAt", "index", "getStartMarkerAt", "getDoneMarkerAt", "getLexemeIndexAt", "productionIndex", "confineMarkersToMaxLexeme", "markersBefore", "doHeavyChecksOnMarkerDone", "doneMarker", "assertNoDoneMarkerAround", "pivot", "get", "toArray", "", "from", "a", "offset", "length", "size", "getSize", "()I", "intellij.platform.syntax"})
@SourceDebugExtension(value={"SMAP\nMarkerProduction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkerProduction.kt\ncom/intellij/platform/syntax/impl/builder/MarkerProduction\n+ 2 MarkerProduction.kt\ncom/intellij/platform/syntax/impl/builder/MarkerProductionKt\n*L\n1#1,206:1\n194#2,10:207\n*S KotlinDebug\n*F\n+ 1 MarkerProduction.kt\ncom/intellij/platform/syntax/impl/builder/MarkerProduction\n*L\n49#1:207,10\n*E\n"})
public final class MarkerProduction
implements IntList {
    @NotNull
    private final MarkerPool myPool;
    @NotNull
    private final MarkerOptionalData myOptionalData;
    @NotNull
    private final Logger logger;
    @NotNull
    private final IntArrayList production;

    public MarkerProduction(@NotNull MarkerPool myPool, @NotNull MarkerOptionalData myOptionalData, @NotNull Logger logger, @NotNull IntArrayList production) {
        this.myPool = myPool;
        this.myOptionalData = myOptionalData;
        this.logger = logger;
        this.production = production;
    }

    public /* synthetic */ MarkerProduction(MarkerPool markerPool, MarkerOptionalData markerOptionalData, Logger logger, IntArrayList intArrayList, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            intArrayList = new IntArrayList(256);
        }
        this(markerPool, markerOptionalData, logger, intArrayList);
    }

    public final void addBefore(@NotNull ProductionMarker marker, @NotNull ProductionMarker anchor) {
        this.production.add(this.indexOf(anchor), marker.getMarkerId());
    }

    private final int indexOf(ProductionMarker marker) {
        int idx = this.findLinearly(marker.getMarkerId());
        if (idx < 0) {
            int n = this.production.getSize();
            for (int i = this.findMarkerAtLexeme(marker.getStartTokenIndex()); i < n; ++i) {
                if (this.production.get(i) != marker.getMarkerId()) continue;
                idx = i;
                break;
            }
        }
        if (idx < 0) {
            this.logger.error("Dropped or rolled-back marker");
        }
        return idx;
    }

    private final int findLinearly(int markerId) {
        int i;
        int low = Math.max(0, this.production.getSize() - 20);
        if (low <= (i = this.production.getSize() - 1)) {
            while (true) {
                if (this.production.get(i) == markerId) {
                    return i;
                }
                if (i == low) break;
                --i;
            }
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private final int findMarkerAtLexeme(int lexemeIndex) {
        void v0;
        block3: {
            void fromIndex$iv;
            boolean bl = false;
            int toIndex$iv = this.production.getSize() - 20;
            boolean $i$f$binSearch = false;
            void low$iv = fromIndex$iv;
            int high$iv = toIndex$iv - 1;
            while (low$iv <= high$iv) {
                void mid$iv;
                void mid = mid$iv = low$iv + high$iv >>> 1;
                boolean bl2 = false;
                int cmp$iv = Intrinsics.compare((int)this.getLexemeIndexAt((int)mid), (int)lexemeIndex);
                if (cmp$iv < 0) {
                    low$iv = mid$iv + true;
                    continue;
                }
                if (cmp$iv > 0) {
                    high$iv = mid$iv - true;
                    continue;
                }
                v0 = mid$iv;
                break block3;
            }
            v0 = -(low$iv + true);
        }
        void i = v0;
        return i < 0 ? -1 : this.findSameLexemeGroupStart(lexemeIndex, (int)i);
    }

    private final int findSameLexemeGroupStart(int lexemeIndex, int prodIndex) {
        int prodIndex2;
        for (prodIndex2 = prodIndex; prodIndex2 > 0 && this.getLexemeIndexAt(prodIndex2 - 1) == lexemeIndex; --prodIndex2) {
        }
        return prodIndex2;
    }

    public final void addMarker(@NotNull ProductionMarker marker) {
        this.production.add(marker.getMarkerId());
    }

    public final void rollbackTo(@NotNull ProductionMarker marker) {
        int i;
        int idx = this.indexOf(marker);
        if (idx <= (i = this.production.getSize() - 1)) {
            while (true) {
                int markerId;
                if ((markerId = this.production.get(i)) > 0) {
                    ProductionMarker marker2 = this.myPool.get(markerId);
                    this.myPool.freeMarker(marker2);
                }
                if (i == idx) break;
                --i;
            }
        }
        this.production.removeElements(idx, this.production.getSize());
    }

    public final boolean hasErrorsAfter(@NotNull CompositeMarker marker) {
        int n = this.production.getSize();
        for (int i = this.indexOf(marker) + 1; i < n; ++i) {
            ProductionMarker m = this.getStartMarkerAt(i);
            if (m == null || !this.hasError(m)) continue;
            return true;
        }
        return false;
    }

    private final boolean hasError(ProductionMarker marker) {
        return marker instanceof ErrorMarker || this.myOptionalData.getDoneError(marker.getMarkerId()) != null;
    }

    public final void dropMarker(@NotNull CompositeMarker marker) {
        if (marker.isDone()) {
            this.production.removeAt(IntListExtensionsKt.lastIndexOf(this.production, -marker.getMarkerId()));
        }
        this.production.removeAt(this.indexOf(marker));
        this.myPool.freeMarker(marker);
    }

    public final void addDone(@NotNull CompositeMarker marker, @Nullable ProductionMarker anchorBefore) {
        ProductionMarker productionMarker = anchorBefore;
        this.production.add(productionMarker == null ? this.production.getSize() : this.indexOf(productionMarker), -marker.getMarkerId());
    }

    @NotNull
    public final ProductionMarker getMarkerAt(int index) {
        int id = this.production.get(index);
        return this.myPool.get(id > 0 ? id : -id);
    }

    @Nullable
    public final ProductionMarker getStartMarkerAt(int index) {
        int id = this.production.get(index);
        return id > 0 ? this.myPool.get(id) : null;
    }

    @Nullable
    public final CompositeMarker getDoneMarkerAt(int index) {
        int id = this.production.get(index);
        return id < 0 ? (CompositeMarker)this.myPool.get(-id) : null;
    }

    public final int getLexemeIndexAt(int productionIndex) {
        int id = this.production.get(productionIndex);
        ProductionMarker node = this.myPool.get(Math.abs(id));
        return node.getLexemeIndex(id < 0);
    }

    public final void confineMarkersToMaxLexeme(int markersBefore, int lexemeIndex) {
        for (int k = markersBefore - 1; 1 < k; --k) {
            boolean done2;
            int id = this.production.get(k);
            ProductionMarker marker = this.myPool.get(Math.abs(id));
            boolean bl = done2 = id < 0;
            if (marker.getLexemeIndex(done2) < lexemeIndex) break;
            marker.setLexemeIndex(lexemeIndex, done2);
        }
    }

    public final void doHeavyChecksOnMarkerDone(@NotNull CompositeMarker doneMarker, @Nullable CompositeMarker anchorBefore) {
        int i;
        int n;
        int idx = this.indexOf(doneMarker);
        int endIdx = this.production.getSize();
        if (anchorBefore != null && idx > (endIdx = this.indexOf(anchorBefore))) {
            this.logger.error("'Before' marker precedes this one.");
        }
        if ((n = idx + 1) <= (i = endIdx - 1)) {
            while (true) {
                ProductionMarker otherMarker;
                ProductionMarker item;
                if ((item = this.getStartMarkerAt(i)) instanceof CompositeMarker && !((CompositeMarker)(otherMarker = item)).isDone()) {
                    Throwable debugAllocOther;
                    Throwable debugAllocThis = this.myOptionalData.getAllocationTrace(doneMarker);
                    Throwable currentTrace = new Throwable();
                    if (debugAllocThis != null) {
                        MarkerProductionKt.makeStackTraceRelative(debugAllocThis, currentTrace).printStackTrace();
                    }
                    if ((debugAllocOther = this.myOptionalData.getAllocationTrace(otherMarker)) != null) {
                        MarkerProductionKt.makeStackTraceRelative(debugAllocOther, currentTrace).printStackTrace();
                    }
                    this.logger.error("Another not done marker added after this one. Must be done before this.");
                }
                if (i == n) break;
                --i;
            }
        }
    }

    public final void assertNoDoneMarkerAround(@NotNull ProductionMarker pivot) {
        int pivotIndex = this.indexOf(pivot);
        int n = this.production.getSize();
        for (int i = pivotIndex + 1; i < n; ++i) {
            CompositeMarker m = this.getDoneMarkerAt(i);
            if (m != null && m.getStartTokenIndex() <= pivot.getStartTokenIndex() && this.indexOf(m) < pivotIndex) {
                throw new AssertionError("There's a marker of type '" + m.getNodeType() + "' that starts before and finishes after the current marker. See cause for its allocation trace.", this.myOptionalData.getAllocationTrace(m));
            }
        }
    }

    @Override
    public int get(int index) {
        return this.production.get(index);
    }

    @Override
    @NotNull
    public int[] toArray(int from, @NotNull int[] a, int offset, int length) {
        return this.production.toArray(from, a, offset, length);
    }

    @Override
    public int getSize() {
        return this.production.getSize();
    }
}

