/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.limits;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.PersistentFSConstants;
import com.intellij.openapi.vfs.limits.ExtensionSizeLimitInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.Grouping;
import kotlin.collections.GroupingKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\bg\u0018\u0000 \t2\u00020\u0001:\u0001\tJ\b\u0010\u0007\u001a\u00020\bH&R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lcom/intellij/openapi/vfs/limits/FileSizeLimit;", "", "acceptableExtensions", "", "", "getAcceptableExtensions", "()Ljava/util/List;", "getLimits", "Lcom/intellij/openapi/vfs/limits/ExtensionSizeLimitInfo;", "Companion", "intellij.platform.core"})
@ApiStatus.Internal
public interface FileSizeLimit {
    @NotNull
    public static final Companion Companion = com.intellij.openapi.vfs.limits.FileSizeLimit$Companion.$$INSTANCE;

    @NotNull
    public List<String> getAcceptableExtensions();

    @NotNull
    public ExtensionSizeLimitInfo getLimits();

    @JvmStatic
    public static boolean isTooLarge(long fileSize, @Nullable String extension) {
        return Companion.isTooLarge(fileSize, extension);
    }

    @JvmStatic
    public static int getContentLoadLimit(@Nullable String extension) {
        return Companion.getContentLoadLimit(extension);
    }

    @JvmStatic
    public static int getDefaultContentLoadLimit() {
        return Companion.getDefaultContentLoadLimit();
    }

    @JvmStatic
    public static int getIntellisenseLimit() {
        return Companion.getIntellisenseLimit();
    }

    @JvmStatic
    public static int getIntellisenseLimit(@Nullable String extension) {
        return Companion.getIntellisenseLimit(extension);
    }

    @JvmStatic
    public static int getPreviewLimit(@Nullable String extension) {
        return Companion.getPreviewLimit(extension);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0002J\u0006\u0010\r\u001a\u00020\u000eJ\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\nH\u0007J\u0012\u0010\u0014\u001a\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\nH\u0007J\b\u0010\u0015\u001a\u00020\u000eH\u0007J\b\u0010\u0016\u001a\u00020\u000eH\u0007J\u0012\u0010\u0016\u001a\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\nH\u0007J\u0012\u0010\u0017\u001a\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\nH\u0007J\u0014\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0013\u001a\u00020\nH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0007\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/openapi/vfs/limits/FileSizeLimit$Companion;", "", "<init>", "()V", "EP", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/openapi/vfs/limits/FileSizeLimit;", "limitsByExtension", "Ljava/util/concurrent/atomic/AtomicReference;", "", "", "Lcom/intellij/openapi/vfs/limits/ExtensionSizeLimitInfo;", "getLimitsByExtension", "getFingerprint", "", "isTooLarge", "", "fileSize", "", "extension", "getContentLoadLimit", "getDefaultContentLoadLimit", "getIntellisenseLimit", "getPreviewLimit", "getLimits", "findApplicable", "intellij.platform.core"})
    @SourceDebugExtension(value={"SMAP\nFileSizeLimit.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileSizeLimit.kt\ncom/intellij/openapi/vfs/limits/FileSizeLimit$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,98:1\n1056#2:99\n1563#2:100\n1634#2,3:101\n1374#2:104\n1460#2,5:105\n1550#2:110\n774#2:120\n865#2,2:121\n1374#2:124\n1460#2,2:125\n1563#2:127\n1634#2,3:128\n1462#2,3:131\n536#3:111\n521#3,6:112\n216#4:118\n217#4:123\n24#5:119\n*S KotlinDebug\n*F\n+ 1 FileSizeLimit.kt\ncom/intellij/openapi/vfs/limits/FileSizeLimit$Companion\n*L\n38#1:99\n39#1:100\n39#1:101,3\n81#1:104\n81#1:105,5\n81#1:110\n85#1:120\n85#1:121,2\n92#1:124\n92#1:125,2\n92#1:127\n92#1:128,3\n92#1:131,3\n81#1:111\n81#1:112,6\n82#1:118\n82#1:123\n83#1:119\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final ExtensionPointName<FileSizeLimit> EP;
        @NotNull
        private static final AtomicReference<Map<String, ExtensionSizeLimitInfo>> limitsByExtension;

        private Companion() {
        }

        private final Map<String, ExtensionSizeLimitInfo> getLimitsByExtension() {
            Map<String, ExtensionSizeLimitInfo> map2 = limitsByExtension.get();
            if (map2 == null) {
                Map<String, ExtensionSizeLimitInfo> map3 = limitsByExtension.updateAndGet(Companion::getLimitsByExtension$lambda$0);
                Intrinsics.checkNotNull(map3);
                map2 = map3;
            }
            return map2;
        }

        /*
         * WARNING - void declaration
         */
        public final int getFingerprint() {
            void $this$mapTo$iv$iv;
            Iterable $this$sortedBy$iv = this.getLimitsByExtension().entrySet();
            boolean $i$f$sortedBy = false;
            Iterable $this$map$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Map.Entry it = (Map.Entry)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                    it = (Map.Entry)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getKey()))));
                }
            });
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Map.Entry entry = (Map.Entry)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(TuplesKt.to(it.getKey(), it.getValue()));
            }
            List limitsByExtensions = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            return ((Object)limitsByExtensions).hashCode();
        }

        @JvmStatic
        public final boolean isTooLarge(long fileSize, @Nullable String extension) {
            int fileContentLoadLimit = this.getContentLoadLimit(extension);
            return fileSize > (long)fileContentLoadLimit;
        }

        @JvmStatic
        public final int getContentLoadLimit(@Nullable String extension) {
            Object object;
            String string = extension;
            if (string == null) {
                string = "";
            }
            int limit = (object = this.findApplicable(string)) != null && (object = ((ExtensionSizeLimitInfo)object).getContent()) != null ? ((Integer)object).intValue() : this.getDefaultContentLoadLimit();
            return limit;
        }

        @JvmStatic
        public final int getDefaultContentLoadLimit() {
            return FileUtilRt.LARGE_FOR_CONTENT_LOADING;
        }

        @JvmStatic
        public final int getIntellisenseLimit() {
            return this.getIntellisenseLimit(null);
        }

        @JvmStatic
        public final int getIntellisenseLimit(@Nullable String extension) {
            Object object;
            String string = extension;
            if (string == null) {
                string = "";
            }
            int limit = (object = this.findApplicable(string)) != null && (object = ((ExtensionSizeLimitInfo)object).getIntellijSense()) != null ? (Integer)object : PersistentFSConstants.getMaxIntellisenseFileSize();
            return limit;
        }

        @JvmStatic
        public final int getPreviewLimit(@Nullable String extension) {
            Object object;
            String string = extension;
            if (string == null) {
                string = "";
            }
            int limit = (object = this.findApplicable(string)) != null && (object = ((ExtensionSizeLimitInfo)object).getPreview()) != null ? (Integer)object : FileUtilRt.LARGE_FILE_PREVIEW_SIZE;
            return limit;
        }

        /*
         * WARNING - void declaration
         */
        private final Map<String, ExtensionSizeLimitInfo> getLimits() {
            Object it;
            Iterable $this$filterTo$iv$iv;
            Collection destination$iv$iv;
            Map duplicates;
            Iterator $this$filterTo$iv$iv2;
            boolean bl;
            Object element$iv$iv;
            Map $this$flatMapTo$iv$iv2;
            List<FileSizeLimit> extensions = EP.getExtensionsIfPointIsRegistered();
            Iterable $this$flatMap$iv = extensions;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection collection = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator<Object> iterator2 = $this$flatMapTo$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                element$iv$iv = iterator2.next();
                FileSizeLimit it2 = (FileSizeLimit)element$iv$iv;
                bl = false;
                Iterable list$iv$iv = it2.getAcceptableExtensions();
                CollectionsKt.addAll((Collection)collection, (Iterable)list$iv$iv);
            }
            Iterable $this$groupingBy$iv = (List)collection;
            boolean $i$f$groupingBy = false;
            Map $this$filter$iv = GroupingKt.eachCount((Grouping)((Grouping)new Grouping<String, String>($this$groupingBy$iv){
                final /* synthetic */ Iterable $this_groupingBy;
                {
                    this.$this_groupingBy = $receiver;
                }

                public Iterator<String> sourceIterator() {
                    return this.$this_groupingBy.iterator();
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 * WARNING - void declaration
                 */
                public Object keyOf(Object element) {
                    void var2_2;
                    String it = (String)element;
                    boolean bl = false;
                    return var2_2;
                }
            }));
            boolean $i$f$filter = false;
            $this$flatMapTo$iv$iv2 = $this$filter$iv;
            Map map2 = new LinkedHashMap();
            boolean $i$f$filterTo22 = false;
            iterator2 = $this$filterTo$iv$iv2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Object it2 = element$iv$iv = (Map.Entry)iterator2.next();
                bl = false;
                if (!(((Number)it2.getValue()).intValue() > 1)) continue;
                map2.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Map $this$forEach$iv = duplicates = map2;
            boolean $i$f$forEach = false;
            $this$filterTo$iv$iv2 = $this$forEach$iv.entrySet().iterator();
            while ($this$filterTo$iv$iv2.hasNext()) {
                Logger logger;
                void $this$filter$iv2;
                Map.Entry entry;
                Map.Entry $i$f$filterTo22 = entry = $this$filterTo$iv$iv2.next();
                boolean bl2 = false;
                String element = (String)$i$f$filterTo22.getKey();
                int count2 = ((Number)$i$f$filterTo22.getValue()).intValue();
                Object $this$thisLogger$iv = $$INSTANCE;
                boolean $i$f$thisLogger = false;
                Intrinsics.checkNotNullExpressionValue((Object)Logger.getInstance(Companion.class), (String)"getInstance(...)");
                $this$thisLogger$iv = extensions;
                StringBuilder stringBuilder = new StringBuilder().append("For file type ").append(element).append(' ').append(count2).append(" limits are registered. Extensions: ");
                boolean $i$f$filter2 = false;
                void var15_31 = $this$filter$iv2;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo3 = false;
                for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                    it = (FileSizeLimit)element$iv$iv2;
                    boolean bl22 = false;
                    if (!it.getAcceptableExtensions().contains(element)) continue;
                    destination$iv$iv.add(element$iv$iv2);
                }
                List list = (List)destination$iv$iv;
                logger.warn(stringBuilder.append(CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, Companion::getLimits$lambda$9$lambda$8, (int)31, null)).toString());
            }
            Iterable $this$flatMap$iv2 = extensions;
            boolean $i$f$flatMap2 = false;
            Iterable iterable2 = $this$flatMap$iv2;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv3 : iterable2) {
                void $this$mapTo$iv$iv;
                FileSizeLimit extension = (FileSizeLimit)element$iv$iv3;
                boolean bl3 = false;
                Iterable $this$map$iv = extension.getAcceptableExtensions();
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (String)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl32 = false;
                    collection2.add(TuplesKt.to((Object)it, (Object)extension.getLimits()));
                }
                Iterable list$iv$iv = (List)destination$iv$iv;
                CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
            }
            Map newLimits = MapsKt.toMap((Iterable)((List)destination$iv$iv3));
            return newLimits;
        }

        private final ExtensionSizeLimitInfo findApplicable(String extension) {
            return this.getLimitsByExtension().get(extension);
        }

        private static final Map getLimitsByExtension$lambda$0(Map it) {
            return $$INSTANCE.getLimits();
        }

        private static final void _init_$lambda$1() {
            limitsByExtension.set(null);
        }

        private static final CharSequence getLimits$lambda$9$lambda$8(FileSizeLimit extension) {
            Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
            return extension.getClass().getName() + ": " + CollectionsKt.joinToString$default((Iterable)extension.getAcceptableExtensions(), null, null, null, (int)0, null, null, (int)63, null);
        }

        static {
            block0: {
                ExtensionPoint extensionPoint;
                $$INSTANCE = new Companion();
                EP = new ExtensionPointName("com.intellij.fileEditor.fileSizeChecker");
                limitsByExtension = new AtomicReference<Object>(null);
                ExtensionPoint extensionPoint2 = extensionPoint = ApplicationManager.getApplication().getExtensionArea().getExtensionPointIfRegistered(EP.getName());
                if (extensionPoint2 == null) break block0;
                extensionPoint2.addChangeListener(Companion::_init_$lambda$1, null);
            }
        }
    }
}

