/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.vfs.LocalFileOperationsHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public abstract class LocalFileSystem
extends NewVirtualFileSystem {
    public static final String PROTOCOL = "file";
    public static final String PROTOCOL_PREFIX = "file://";
    private static LocalFileSystem ourInstance;

    @NotNull
    public static LocalFileSystem getInstance() {
        LocalFileSystem instance2 = ourInstance;
        if (instance2 == null) {
            ourInstance = instance2 = (LocalFileSystem)VirtualFileManager.getInstance().getFileSystem(PROTOCOL);
        }
        LocalFileSystem localFileSystem = instance2;
        if (localFileSystem == null) {
            LocalFileSystem.$$$reportNull$$$0(0);
        }
        return localFileSystem;
    }

    @Nullable
    public VirtualFile findFileByIoFile(@NotNull File file) {
        if (file == null) {
            LocalFileSystem.$$$reportNull$$$0(1);
        }
        return this.findFileByPath(file.getAbsolutePath());
    }

    @Nullable
    public VirtualFile refreshAndFindFileByIoFile(@NotNull File file) {
        if (file == null) {
            LocalFileSystem.$$$reportNull$$$0(2);
        }
        return this.refreshAndFindFileByPath(file.getAbsolutePath());
    }

    @Nullable
    public VirtualFile findFileByNioFile(@NotNull Path file) {
        if (file == null) {
            LocalFileSystem.$$$reportNull$$$0(3);
        }
        return this.findFileByPath(file.toAbsolutePath().toString());
    }

    @Nullable
    public VirtualFile refreshAndFindFileByNioFile(@NotNull Path file) {
        if (file == null) {
            LocalFileSystem.$$$reportNull$$$0(4);
        }
        return this.refreshAndFindFileByPath(file.toAbsolutePath().toString());
    }

    public void refreshIoFiles(@NotNull Iterable<? extends File> files) {
        if (files == null) {
            LocalFileSystem.$$$reportNull$$$0(5);
        }
        this.refreshIoFiles(files, false, false, null);
    }

    public final void refreshNioFiles(@NotNull Iterable<? extends Path> files) {
        if (files == null) {
            LocalFileSystem.$$$reportNull$$$0(6);
        }
        this.refreshNioFiles(files, false, false, null);
    }

    public abstract void refreshIoFiles(@NotNull Iterable<? extends File> var1, boolean var2, boolean var3, @Nullable Runnable var4);

    public abstract void refreshNioFiles(@NotNull Iterable<? extends Path> var1, boolean var2, boolean var3, @Nullable Runnable var4);

    public void refreshFiles(@NotNull Iterable<? extends VirtualFile> files) {
        if (files == null) {
            LocalFileSystem.$$$reportNull$$$0(7);
        }
        this.refreshFiles(files, false, false, null);
    }

    public abstract void refreshFiles(@NotNull Iterable<? extends VirtualFile> var1, boolean var2, boolean var3, @Nullable Runnable var4);

    @Nullable
    public WatchRequest addRootToWatch(@NotNull String rootPath, boolean watchRecursively) {
        Set<WatchRequest> result;
        if (rootPath == null) {
            LocalFileSystem.$$$reportNull$$$0(8);
        }
        return (result = this.addRootsToWatch(Collections.singleton(rootPath), watchRecursively)).size() == 1 ? result.iterator().next() : null;
    }

    @NotNull
    public Set<WatchRequest> addRootsToWatch(@NotNull Collection<String> rootPaths, boolean watchRecursively) {
        if (rootPaths == null) {
            LocalFileSystem.$$$reportNull$$$0(9);
        }
        if (rootPaths.isEmpty()) {
            Set<WatchRequest> set = Collections.emptySet();
            if (set == null) {
                LocalFileSystem.$$$reportNull$$$0(10);
            }
            return set;
        }
        if (watchRecursively) {
            Set<WatchRequest> set = this.replaceWatchedRoots(Collections.emptySet(), rootPaths, null);
            if (set == null) {
                LocalFileSystem.$$$reportNull$$$0(11);
            }
            return set;
        }
        Set<WatchRequest> set = this.replaceWatchedRoots(Collections.emptySet(), null, rootPaths);
        if (set == null) {
            LocalFileSystem.$$$reportNull$$$0(12);
        }
        return set;
    }

    public void removeWatchedRoot(@NotNull WatchRequest watchRequest) {
        if (watchRequest == null) {
            LocalFileSystem.$$$reportNull$$$0(13);
        }
        this.removeWatchedRoots(Collections.singleton(watchRequest));
    }

    public void removeWatchedRoots(@NotNull Collection<WatchRequest> watchRequests) {
        if (watchRequests == null) {
            LocalFileSystem.$$$reportNull$$$0(14);
        }
        if (!watchRequests.isEmpty()) {
            this.replaceWatchedRoots(watchRequests, null, null);
        }
    }

    @Nullable
    public WatchRequest replaceWatchedRoot(@Nullable WatchRequest watchRequest, @NotNull String rootPath, boolean watchRecursively) {
        if (rootPath == null) {
            LocalFileSystem.$$$reportNull$$$0(15);
        }
        Set<WatchRequest> requests = watchRequest != null ? Collections.singleton(watchRequest) : Collections.emptySet();
        Set<String> roots = Collections.singleton(rootPath);
        Set<WatchRequest> result = watchRecursively ? this.replaceWatchedRoots(requests, roots, null) : this.replaceWatchedRoots(requests, null, roots);
        return result.size() == 1 ? result.iterator().next() : null;
    }

    @NotNull
    public abstract Set<WatchRequest> replaceWatchedRoots(@NotNull Collection<WatchRequest> var1, @Nullable Collection<String> var2, @Nullable Collection<String> var3);

    public abstract void registerAuxiliaryFileOperationsHandler(@NotNull LocalFileOperationsHandler var1);

    public abstract void unregisterAuxiliaryFileOperationsHandler(@NotNull LocalFileOperationsHandler var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 13, 14, 15 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/LocalFileSystem";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = PROTOCOL;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPaths";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "watchRequest";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "watchRequests";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/LocalFileSystem";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "addRootsToWatch";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findFileByIoFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFileByIoFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findFileByNioFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFileByNioFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "refreshIoFiles";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "refreshNioFiles";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "refreshFiles";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addRootToWatch";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addRootsToWatch";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "removeWatchedRoot";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeWatchedRoots";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "replaceWatchedRoot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 13, 14, 15 -> new IllegalArgumentException(string);
        };
    }

    public static interface WatchRequest {
        @NotNull
        public @SystemIndependent String getRootPath();

        public boolean isToWatchRecursively();
    }
}

