/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorComposite;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileEditorNavigatable;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.border.Border;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class FileEditorManager {
    public static final Key<Boolean> USE_CURRENT_WINDOW = Key.create("OpenFile.searchForOpen");
    public static final Key<Boolean> SEPARATOR_DISABLED = Key.create("FileEditorSeparatorDisabled");
    public static final Key<Border> SEPARATOR_BORDER = Key.create("FileEditorSeparatorBorder");
    public static final Key<Color> SEPARATOR_COLOR = Key.create("FileEditorSeparatorColor");

    public static FileEditorManager getInstance(@NotNull Project project) {
        if (project == null) {
            FileEditorManager.$$$reportNull$$$0(0);
        }
        return project.getService(FileEditorManager.class);
    }

    @Nullable
    public abstract FileEditorComposite getComposite(@NotNull VirtualFile var1);

    @ApiStatus.Experimental
    public abstract boolean canOpenFile(@NotNull VirtualFile var1);

    public abstract FileEditor @NotNull [] openFile(@NotNull VirtualFile var1, boolean var2);

    @ApiStatus.Experimental
    public void requestOpenFile(@NotNull VirtualFile file) {
        if (file == null) {
            FileEditorManager.$$$reportNull$$$0(1);
        }
        this.openFile(file, true);
    }

    @NotNull
    public abstract @NotNull @Unmodifiable List<@NotNull FileEditor> openFile(@NotNull VirtualFile var1);

    public FileEditor @NotNull [] openFile(@NotNull VirtualFile file, boolean focusEditor, boolean searchForOpen) {
        if (file == null) {
            FileEditorManager.$$$reportNull$$$0(2);
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public abstract void closeFile(@NotNull VirtualFile var1);

    @Nullable
    public abstract Editor openTextEditor(@NotNull OpenFileDescriptor var1, boolean var2);

    @Deprecated(forRemoval=true)
    public void navigateToTextEditor(@NotNull OpenFileDescriptor descriptor, boolean focusEditor) {
        if (descriptor == null) {
            FileEditorManager.$$$reportNull$$$0(3);
        }
        this.openTextEditor(descriptor, focusEditor);
    }

    @RequiresEdt
    @Nullable
    public abstract Editor getSelectedTextEditor();

    @ApiStatus.Experimental
    @Nullable
    public Editor getSelectedTextEditor(boolean lockFree) {
        return this.getSelectedTextEditor();
    }

    @ApiStatus.Experimental
    @RequiresEdt
    public Editor @NotNull [] getSelectedTextEditorWithRemotes() {
        Editor[] editorArray;
        ThreadingAssertions.assertEventDispatchThread();
        Editor editor = this.getSelectedTextEditor();
        if (editor != null) {
            Editor[] editorArray2 = new Editor[1];
            editorArray = editorArray2;
            editorArray2[0] = editor;
        } else {
            editorArray = Editor.EMPTY_ARRAY;
        }
        if (editorArray == null) {
            FileEditorManager.$$$reportNull$$$0(4);
        }
        return editorArray;
    }

    public abstract boolean isFileOpen(@NotNull VirtualFile var1);

    @ApiStatus.Experimental
    public boolean isFileOpenWithRemotes(@NotNull VirtualFile file) {
        if (file == null) {
            FileEditorManager.$$$reportNull$$$0(5);
        }
        return this.isFileOpen(file);
    }

    public abstract VirtualFile @NotNull [] getOpenFiles();

    @ApiStatus.Experimental
    @NotNull
    public abstract @Unmodifiable List<VirtualFile> getOpenFilesWithRemotes();

    public boolean hasOpenFiles() {
        return this.getOpenFiles().length > 0;
    }

    @ApiStatus.Experimental
    @Nullable
    public abstract VirtualFile getCurrentFile();

    public abstract VirtualFile @NotNull [] getSelectedFiles();

    public abstract FileEditor @NotNull [] getSelectedEditors();

    @ApiStatus.Experimental
    @NotNull
    public @Unmodifiable Collection<FileEditor> getSelectedEditorWithRemotes() {
        List<FileEditor> list = List.of(this.getSelectedEditors());
        if (list == null) {
            FileEditorManager.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Nullable
    public FileEditor getSelectedEditor() {
        VirtualFile[] files = this.getSelectedFiles();
        return files.length == 0 ? null : this.getSelectedEditor(files[0]);
    }

    @ApiStatus.Experimental
    public abstract @NotNull StateFlow<@Nullable FileEditor> getSelectedEditorFlow();

    @Nullable
    public abstract FileEditor getSelectedEditor(@NotNull VirtualFile var1);

    public abstract FileEditor @NotNull [] getEditors(@NotNull VirtualFile var1);

    @NotNull
    public @Unmodifiable List<FileEditor> getEditorList(@NotNull VirtualFile file) {
        if (file == null) {
            FileEditorManager.$$$reportNull$$$0(7);
        }
        List<FileEditor> list = Arrays.asList(this.getEditors(file));
        if (list == null) {
            FileEditorManager.$$$reportNull$$$0(8);
        }
        return list;
    }

    public abstract FileEditor @NotNull [] getAllEditors(@NotNull VirtualFile var1);

    @NotNull
    public abstract @NotNull @Unmodifiable List<@NotNull FileEditor> getAllEditorList(@NotNull VirtualFile var1);

    public abstract FileEditor @NotNull [] getAllEditors();

    @RequiresEdt
    public abstract void addTopComponent(@NotNull FileEditor var1, @NotNull JComponent var2);

    @RequiresEdt
    public abstract void removeTopComponent(@NotNull FileEditor var1, @NotNull JComponent var2);

    @RequiresEdt
    public abstract void addBottomComponent(@NotNull FileEditor var1, @NotNull JComponent var2);

    @RequiresEdt
    public abstract void removeBottomComponent(@NotNull FileEditor var1, @NotNull JComponent var2);

    @Deprecated
    public void addFileEditorManagerListener(@NotNull FileEditorManagerListener listener2) {
        if (listener2 == null) {
            FileEditorManager.$$$reportNull$$$0(9);
        }
    }

    @Deprecated
    public void removeFileEditorManagerListener(@NotNull FileEditorManagerListener listener2) {
        if (listener2 == null) {
            FileEditorManager.$$$reportNull$$$0(10);
        }
    }

    @RequiresEdt
    @NotNull
    public final List<FileEditor> openEditor(@NotNull OpenFileDescriptor descriptor, boolean focusEditor) {
        if (descriptor == null) {
            FileEditorManager.$$$reportNull$$$0(11);
        }
        ThreadingAssertions.assertEventDispatchThread();
        List<FileEditor> list = this.openFileEditor(descriptor, focusEditor);
        if (list == null) {
            FileEditorManager.$$$reportNull$$$0(12);
        }
        return list;
    }

    @RequiresEdt
    @NotNull
    public abstract @Unmodifiable List<FileEditor> openFileEditor(@NotNull FileEditorNavigatable var1, boolean var2);

    @NotNull
    public abstract Project getProject();

    public abstract void setSelectedEditor(@NotNull VirtualFile var1, @NotNull String var2);

    public abstract void runWhenLoaded(@NotNull Editor var1, @NotNull Runnable var2);

    public void updateFilePresentation(@NotNull VirtualFile file) {
        if (file == null) {
            FileEditorManager.$$$reportNull$$$0(13);
        }
    }

    public void updateFileColor(@NotNull VirtualFile file) {
        if (file == null) {
            FileEditorManager.$$$reportNull$$$0(14);
        }
    }

    @Nullable
    public FileEditor getFocusedEditor() {
        FileEditor editor = this.getSelectedEditor();
        return editor != null && UIUtil.isFocusAncestor((Component)editor.getComponent()) ? editor : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 8, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/FileEditorManager";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/FileEditorManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedTextEditorWithRemotes";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedEditorWithRemotes";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorList";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "openEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "requestOpenFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "openFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "navigateToTextEditor";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 12: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isFileOpenWithRemotes";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getEditorList";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addFileEditorManagerListener";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeFileEditorManagerListener";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "openEditor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateFilePresentation";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateFileColor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 8, 12 -> new IllegalStateException(string);
        };
    }
}

