/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0001$B5\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001aH\u0002J\u0010\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u0007H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/openapi/diagnostic/RollingFileHandler;", "Ljava/util/logging/StreamHandler;", "logPath", "Ljava/nio/file/Path;", "limit", "", "count", "", "append", "", "onRotate", "Ljava/lang/Runnable;", "<init>", "(Ljava/nio/file/Path;JIZLjava/lang/Runnable;)V", "getLogPath", "()Ljava/nio/file/Path;", "getLimit", "()J", "getCount", "()I", "getAppend", "()Z", "meter", "Lcom/intellij/openapi/diagnostic/RollingFileHandler$MeteredOutputStream;", "rotateFailed", "open", "", "publish", "record", "Ljava/util/logging/LogRecord;", "rotate", "logRotateFailed", "e", "Ljava/io/IOException;", "logPathWithIndex", "index", "MeteredOutputStream", "intellij.platform.util"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nRollingFileHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RollingFileHandler.kt\ncom/intellij/openapi/diagnostic/RollingFileHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,122:1\n1#2:123\n*E\n"})
public final class RollingFileHandler
extends StreamHandler {
    @NotNull
    private final Path logPath;
    private final long limit;
    private final int count;
    private final boolean append;
    @Nullable
    private final Runnable onRotate;
    private volatile MeteredOutputStream meter;
    private boolean rotateFailed;

    @JvmOverloads
    public RollingFileHandler(@NotNull Path logPath, long limit, int count2, boolean append, @Nullable Runnable onRotate) {
        Intrinsics.checkNotNullParameter((Object)logPath, (String)"logPath");
        this.logPath = logPath;
        this.limit = limit;
        this.count = count2;
        this.append = append;
        this.onRotate = onRotate;
        this.setEncoding(StandardCharsets.UTF_8.name());
        this.open(this.append);
    }

    public /* synthetic */ RollingFileHandler(Path path, long l, int n, boolean bl, Runnable runnable, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            runnable = null;
        }
        this(path, l, n, bl, runnable);
    }

    @NotNull
    public final Path getLogPath() {
        return this.logPath;
    }

    public final long getLimit() {
        return this.limit;
    }

    public final int getCount() {
        return this.count;
    }

    public final boolean getAppend() {
        return this.append;
    }

    private final void open(boolean append) {
        Files.createDirectories(this.logPath.getParent(), new FileAttribute[0]);
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.APPEND};
        BufferedOutputStream delegate = new BufferedOutputStream(Files.newOutputStream(this.logPath, openOptionArray));
        this.meter = new MeteredOutputStream(delegate, append ? Files.size(this.logPath) : 0L);
        MeteredOutputStream meteredOutputStream = this.meter;
        if (meteredOutputStream == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"meter");
            meteredOutputStream = null;
        }
        this.setOutputStream(meteredOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(@NotNull LogRecord record) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        if (!this.isLoggable(record)) {
            return;
        }
        super.publish(record);
        this.flush();
        if (this.limit > 0L) {
            MeteredOutputStream meteredOutputStream = this.meter;
            if (meteredOutputStream == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"meter");
                meteredOutputStream = null;
            }
            if (meteredOutputStream.getWritten() >= this.limit) {
                RollingFileHandler rollingFileHandler = this;
                synchronized (rollingFileHandler) {
                    boolean bl = false;
                    MeteredOutputStream meteredOutputStream2 = this.meter;
                    if (meteredOutputStream2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"meter");
                        meteredOutputStream2 = null;
                    }
                    if (meteredOutputStream2.getWritten() >= this.limit) {
                        this.rotate();
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
        }
    }

    private final void rotate() {
        CopyOption[] copyOptionArray;
        Runnable runnable = this.onRotate;
        if (runnable != null) {
            runnable.run();
        }
        try {
            Files.deleteIfExists(this.logPathWithIndex(this.count));
            for (int i = this.count - 1; 0 < i; --i) {
                Path path = this.logPathWithIndex(i);
                if (!Files.exists(path, new LinkOption[0])) continue;
                CopyOption[] copyOptionArray2 = new CopyOption[]{StandardCopyOption.ATOMIC_MOVE};
                Files.move(path, this.logPathWithIndex(i + 1), copyOptionArray2);
            }
        }
        catch (IOException e) {
            this.logRotateFailed(e);
            return;
        }
        this.close();
        try {
            copyOptionArray = new CopyOption[]{StandardCopyOption.ATOMIC_MOVE};
            Files.move(this.logPath, this.logPathWithIndex(1), copyOptionArray);
            copyOptionArray = null;
        }
        catch (IOException e) {
            copyOptionArray = e;
        }
        CopyOption[] e = copyOptionArray;
        this.open(false);
        if (e == null) {
            this.rotateFailed = false;
        } else {
            this.logRotateFailed((IOException)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void logRotateFailed(IOException e) {
        if (!this.rotateFailed) {
            void it;
            LogRecord logRecord;
            this.rotateFailed = true;
            LogRecord logRecord2 = logRecord = new LogRecord(Level.SEVERE, "Log rotate failed: " + e.getMessage());
            RollingFileHandler rollingFileHandler = this;
            boolean bl = false;
            it.setThrown(e);
            super.publish(logRecord);
        }
    }

    private final Path logPathWithIndex(int index) {
        String pathString = ((Object)this.logPath).toString();
        int extIndex = StringsKt.lastIndexOf$default((CharSequence)pathString, (char)'.', (int)0, (boolean)false, (int)6, null);
        StringBuilder stringBuilder = new StringBuilder();
        String string = pathString.substring(0, extIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        StringBuilder stringBuilder2 = stringBuilder.append(string).append('.').append(index);
        String string2 = pathString.substring(extIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        Path path = Paths.get(stringBuilder2.append(string2).toString(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    @JvmOverloads
    public RollingFileHandler(@NotNull Path logPath, long limit, int count2, boolean append) {
        Intrinsics.checkNotNullParameter((Object)logPath, (String)"logPath");
        this(logPath, limit, count2, append, null, 16, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000fH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\fH\u0016J\b\u0010\u0013\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/intellij/openapi/diagnostic/RollingFileHandler$MeteredOutputStream;", "Ljava/io/OutputStream;", "delegate", "written", "", "<init>", "(Ljava/io/OutputStream;J)V", "getWritten", "()J", "setWritten", "(J)V", "write", "", "b", "", "", "off", "len", "close", "flush", "intellij.platform.util"})
    private static final class MeteredOutputStream
    extends OutputStream {
        @NotNull
        private final OutputStream delegate;
        private volatile long written;

        public MeteredOutputStream(@NotNull OutputStream delegate, long written) {
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            this.delegate = delegate;
            this.written = written;
        }

        public final long getWritten() {
            return this.written;
        }

        public final void setWritten(long l) {
            this.written = l;
        }

        @Override
        public void write(int b) {
            this.delegate.write(b);
            long l = this.written;
            this.written = l + 1L;
        }

        @Override
        public void write(@NotNull byte[] b) {
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            this.delegate.write(b);
            this.written += (long)b.length;
        }

        @Override
        public void write(@NotNull byte[] b, int off, int len) {
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            this.delegate.write(b, off, len);
            this.written += (long)len;
        }

        @Override
        public void close() {
            this.delegate.close();
        }

        @Override
        public void flush() {
            this.delegate.flush();
        }
    }
}

