/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.diagnostic.ActivityCategory;
import com.intellij.mock.MockComponentManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;
import org.picocontainer.PicoContainer;

public class MockProject
extends MockComponentManager
implements Project {
    private static final Logger LOG = Logger.getInstance(MockProject.class);
    private VirtualFile myBaseDir;
    private final CoroutineScope myCoroutineScope;

    @ApiStatus.Internal
    public MockProject(@Nullable PicoContainer parent, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            MockProject.$$$reportNull$$$0(0);
        }
        super(parent, parentDisposable);
        this.myCoroutineScope = CoroutineScopeKt.childScope(GlobalScope.INSTANCE, "MockProject: " + this, (CoroutineContext)EmptyCoroutineContext.INSTANCE, true);
    }

    @Override
    public void dispose() {
        kotlinx.coroutines.CoroutineScopeKt.cancel(this.myCoroutineScope, new CancellationException());
        super.dispose();
    }

    @Override
    @NotNull
    public Condition<?> getDisposed() {
        Condition<Object> condition = o -> this.isDisposed();
        if (condition == null) {
            MockProject.$$$reportNull$$$0(1);
        }
        return condition;
    }

    @Override
    public boolean isOpen() {
        return false;
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    @Override
    @NotNull
    public CoroutineScope getCoroutineScope() {
        CoroutineScope coroutineScope = this.myCoroutineScope;
        if (coroutineScope == null) {
            MockProject.$$$reportNull$$$0(2);
        }
        return coroutineScope;
    }

    @Override
    public VirtualFile getProjectFile() {
        return null;
    }

    @Override
    @NotNull
    public String getName() {
        return "";
    }

    @Override
    @NotNull
    @NonNls
    public String getLocationHash() {
        return "mock";
    }

    @Override
    @Nullable
    public @SystemIndependent String getProjectFilePath() {
        return null;
    }

    @Override
    public VirtualFile getWorkspaceFile() {
        return null;
    }

    public void setBaseDir(VirtualFile baseDir) {
        this.myBaseDir = baseDir;
    }

    @Override
    @Nullable
    public VirtualFile getBaseDir() {
        return this.myBaseDir;
    }

    @Override
    @Nullable
    public @SystemIndependent String getBasePath() {
        return null;
    }

    @Override
    public void save() {
    }

    @NotNull
    public <T> List<T> getComponentInstancesOfType(@NotNull Class<T> componentType) {
        if (componentType == null) {
            MockProject.$$$reportNull$$$0(3);
        }
        ArrayList result = new ArrayList();
        this.getPicoContainer().getComponentAdapters().forEach(componentAdapter -> {
            Object instance2;
            Class<?> descendant = componentAdapter.getComponentImplementation();
            if ((componentType == descendant || componentType.isAssignableFrom(descendant)) && (instance2 = componentAdapter.getComponentInstance()) != null) {
                result.add(instance2);
            }
        });
        ArrayList arrayList = result;
        if (arrayList == null) {
            MockProject.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    public void projectOpened() {
        for (ProjectComponent component : this.getComponentInstancesOfType(ProjectComponent.class)) {
            try {
                component.projectOpened();
            }
            catch (Throwable e) {
                LOG.error(component.toString(), e);
            }
        }
    }

    @Override
    @NotNull
    public final ActivityCategory getActivityCategory(boolean isExtension) {
        ActivityCategory activityCategory = isExtension ? ActivityCategory.PROJECT_EXTENSION : ActivityCategory.PROJECT_SERVICE;
        if (activityCategory == null) {
            MockProject.$$$reportNull$$$0(5);
        }
        return activityCategory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/mock/MockProject";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/mock/MockProject";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisposed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoroutineScope";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentInstancesOfType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getActivityCategory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getComponentInstancesOfType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

