/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.jvm.source;

import com.intellij.lang.jvm.JvmElement;
import com.intellij.lang.jvm.source.JvmDeclarationSearcher;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.util.containers.FlatteningIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JvmDeclarationSearch {
    private JvmDeclarationSearch() {
    }

    @NotNull
    public static Iterable<JvmElement> getElementsByIdentifier(@NotNull PsiElement identifierElement) {
        PsiElement declaringElement;
        if (identifierElement == null) {
            JvmDeclarationSearch.$$$reportNull$$$0(0);
        }
        if ((declaringElement = JvmDeclarationSearch.findDeclaringElement(identifierElement)) == null) {
            List<JvmElement> list = Collections.emptyList();
            if (list == null) {
                JvmDeclarationSearch.$$$reportNull$$$0(1);
            }
            return list;
        }
        Iterable<JvmElement> iterable = () -> JvmDeclarationSearch.iterateDeclarations(declaringElement);
        if (iterable == null) {
            JvmDeclarationSearch.$$$reportNull$$$0(2);
        }
        return iterable;
    }

    @Nullable
    private static PsiElement findDeclaringElement(@NotNull PsiElement potentiallyIdentifyingElement) {
        PsiElement parent;
        if (potentiallyIdentifyingElement == null) {
            JvmDeclarationSearch.$$$reportNull$$$0(3);
        }
        if ((parent = potentiallyIdentifyingElement.getParent()) instanceof PsiNameIdentifierOwner && ((PsiNameIdentifierOwner)parent).getIdentifyingElement() == potentiallyIdentifyingElement) {
            return parent;
        }
        for (JvmDeclarationSearcher searcher : JvmDeclarationSearcher.EP.allForLanguage(potentiallyIdentifyingElement.getLanguage())) {
            PsiElement declaringElement = searcher.adjustIdentifierElement(potentiallyIdentifyingElement);
            if (declaringElement == null) continue;
            return declaringElement;
        }
        return null;
    }

    @NotNull
    private static Iterator<JvmElement> iterateDeclarations(@NotNull PsiElement declaringElement) {
        List<JvmDeclarationSearcher> searchers;
        if (declaringElement == null) {
            JvmDeclarationSearch.$$$reportNull$$$0(4);
        }
        return (searchers = JvmDeclarationSearcher.EP.allForLanguage(declaringElement.getLanguage())).isEmpty() ? Collections.emptyIterator() : JvmDeclarationSearch.iterateDeclarations(declaringElement, searchers);
    }

    @NotNull
    private static Iterator<JvmElement> iterateDeclarations(final @NotNull PsiElement declaringElement, @NotNull Collection<? extends JvmDeclarationSearcher> searchers) {
        if (declaringElement == null) {
            JvmDeclarationSearch.$$$reportNull$$$0(5);
        }
        if (searchers == null) {
            JvmDeclarationSearch.$$$reportNull$$$0(6);
        }
        return new FlatteningIterator<JvmDeclarationSearcher, JvmElement>(searchers.iterator()){

            @Override
            public boolean hasNext() {
                ProgressManager.checkCanceled();
                return super.hasNext();
            }

            @Override
            protected Iterator<JvmElement> createValueIterator(JvmDeclarationSearcher searcher) {
                return searcher.findDeclarations(declaringElement).iterator();
            }
        };
    }

    @NotNull
    public static Iterable<JvmElement> getImmediatelyContainingElements(@NotNull PsiElement place) {
        List<JvmDeclarationSearcher> extensions;
        if (place == null) {
            JvmDeclarationSearch.$$$reportNull$$$0(7);
        }
        if ((extensions = JvmDeclarationSearcher.EP.allForLanguage(place.getLanguage())).isEmpty()) {
            List<JvmElement> list = Collections.emptyList();
            if (list == null) {
                JvmDeclarationSearch.$$$reportNull$$$0(8);
            }
            return list;
        }
        for (PsiElement current = place; current != null; current = current.getParent()) {
            Iterator<JvmElement> iterator2 = JvmDeclarationSearch.iterateDeclarations(current, extensions);
            if (!iterator2.hasNext()) continue;
            Iterable<JvmElement> iterable = () -> iterator2;
            if (iterable == null) {
                JvmDeclarationSearch.$$$reportNull$$$0(9);
            }
            return iterable;
        }
        List<JvmElement> list = Collections.emptyList();
        if (list == null) {
            JvmDeclarationSearch.$$$reportNull$$$0(10);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifierElement";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/jvm/source/JvmDeclarationSearch";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "potentiallyIdentifyingElement";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaringElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchers";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/jvm/source/JvmDeclarationSearch";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsByIdentifier";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getImmediatelyContainingElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getElementsByIdentifier";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findDeclaringElement";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "iterateDeclarations";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getImmediatelyContainingElements";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

