/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.core.CoreBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginNonLoadReason;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0019\u0010\r\u001a\u00070\t\u00a2\u0006\u0002\b\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\fR\u0019\u0010\u0010\u001a\u00070\t\u00a2\u0006\u0002\b\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\fR\u0014\u0010\u0013\u001a\u00020\u0014X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ide/plugins/PluginIsMarkedBroken;", "Lcom/intellij/ide/plugins/PluginNonLoadReason;", "plugin", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "<init>", "(Lcom/intellij/ide/plugins/IdeaPluginDescriptor;)V", "getPlugin", "()Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "detailedMessage", "", "Lcom/intellij/openapi/util/NlsContexts$DetailedDescription;", "getDetailedMessage", "()Ljava/lang/String;", "shortMessage", "Lcom/intellij/openapi/util/NlsContexts$Label;", "getShortMessage", "logMessage", "Lorg/jetbrains/annotations/NonNls;", "getLogMessage", "shouldNotifyUser", "", "getShouldNotifyUser", "()Z", "intellij.platform.core.impl"})
@ApiStatus.Internal
public final class PluginIsMarkedBroken
implements PluginNonLoadReason {
    @NotNull
    private final IdeaPluginDescriptor plugin;
    private final boolean shouldNotifyUser;

    public PluginIsMarkedBroken(@NotNull IdeaPluginDescriptor plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        this.plugin = plugin;
        this.shouldNotifyUser = true;
    }

    @Override
    @NotNull
    public IdeaPluginDescriptor getPlugin() {
        return this.plugin;
    }

    @Override
    @NotNull
    public String getDetailedMessage() {
        Object[] objectArray = new Object[]{this.getPlugin().getName(), this.getPlugin().getVersion()};
        String string = CoreBundle.message("plugin.loading.error.long.marked.as.broken", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    @NotNull
    public String getShortMessage() {
        String string = CoreBundle.message("plugin.loading.error.short.marked.as.broken", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    @NotNull
    public String getLogMessage() {
        return "Plugin '" + this.getPlugin().getName() + "' (" + this.getPlugin().getPluginId() + ", version=" + this.getPlugin().getVersion() + ") is marked incompatible with the current version of the IDE";
    }

    @Override
    public boolean getShouldNotifyUser() {
        return this.shouldNotifyUser;
    }
}

