/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.intellij.find.FindModel;
import com.intellij.find.FindSettings;
import com.intellij.find.impl.FindInProjectSettingsBase;
import com.intellij.find.impl.FindSettingsImpl;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class FindSettingsBase
extends FindSettings
implements PersistentStateComponent<FindSettingsBase> {
    @NonNls
    private static final String FIND_DIRECTION_FORWARD = "forward";
    @NonNls
    private static final String FIND_DIRECTION_BACKWARD = "backward";
    @NonNls
    private static final String FIND_ORIGIN_FROM_CURSOR = "from_cursor";
    @NonNls
    private static final String FIND_ORIGIN_ENTIRE_SCOPE = "entire_scope";
    @NonNls
    private static final String FIND_SCOPE_GLOBAL = "global";
    @NonNls
    private static final String FIND_SCOPE_SELECTED = "selected";
    public boolean SEARCH_OVERLOADED_METHODS;
    public boolean SKIP_RESULTS_WHEN_ONE_USAGE;
    public String FIND_DIRECTION = "forward";
    public String FIND_ORIGIN = "from_cursor";
    public String FIND_SCOPE = "global";
    public boolean CASE_SENSITIVE_SEARCH;
    public boolean LOCAL_CASE_SENSITIVE_SEARCH;
    public boolean PRESERVE_CASE_REPLACE;
    public boolean WHOLE_WORDS_ONLY;
    public boolean COMMENTS_ONLY;
    public boolean STRING_LITERALS_ONLY;
    public boolean EXCEPT_COMMENTS;
    public boolean EXCEPT_COMMENTS_AND_STRING_LITERALS;
    public boolean EXCEPT_STRING_LITERALS;
    public boolean LOCAL_WHOLE_WORDS_ONLY;
    public boolean REGULAR_EXPRESSIONS;
    public boolean LOCAL_REGULAR_EXPRESSIONS;
    public boolean WITH_SUBDIRECTORIES = true;
    public boolean SHOW_RESULTS_IN_SEPARATE_VIEW;
    public boolean SCROLL_TO_RESULTS_DURING_TYPING = true;
    @Nls
    public String SEARCH_SCOPE = FindSettingsImpl.getDefaultSearchScope();
    public String FILE_MASK;
    @Property(surroundWithTag=false)
    @XCollection(propertyElementName="recentFileMasks", elementName="mask", valueAttributeName="")
    protected final List<String> recentFileMasks = new ArrayList<String>();

    @Override
    public boolean isSearchOverloadedMethods() {
        return this.SEARCH_OVERLOADED_METHODS;
    }

    @Override
    public void setSearchOverloadedMethods(boolean search) {
        this.SEARCH_OVERLOADED_METHODS = search;
    }

    @Override
    public final void loadState(@NotNull FindSettingsBase state2) {
        if (state2 == null) {
            FindSettingsBase.$$$reportNull$$$0(0);
        }
        XmlSerializerUtil.copyBean(state2, this);
    }

    @Override
    public FindSettingsBase getState() {
        return this;
    }

    @Override
    public boolean isSkipResultsWithOneUsage() {
        return this.SKIP_RESULTS_WHEN_ONE_USAGE;
    }

    @Override
    public void setSkipResultsWithOneUsage(boolean skip) {
        this.SKIP_RESULTS_WHEN_ONE_USAGE = skip;
    }

    @Override
    @Nls
    public String getDefaultScopeName() {
        return this.SEARCH_SCOPE;
    }

    @Override
    public void setDefaultScopeName(String scope) {
        this.SEARCH_SCOPE = scope;
    }

    @Override
    public boolean isForward() {
        return FIND_DIRECTION_FORWARD.equals(this.FIND_DIRECTION);
    }

    @Override
    public void setForward(boolean findDirectionForward) {
        this.FIND_DIRECTION = findDirectionForward ? FIND_DIRECTION_FORWARD : FIND_DIRECTION_BACKWARD;
    }

    @Override
    public boolean isFromCursor() {
        return FIND_ORIGIN_FROM_CURSOR.equals(this.FIND_ORIGIN);
    }

    @Override
    public void setFromCursor(boolean findFromCursor) {
        this.FIND_ORIGIN = findFromCursor ? FIND_ORIGIN_FROM_CURSOR : FIND_ORIGIN_ENTIRE_SCOPE;
    }

    @Override
    public boolean isGlobal() {
        return FIND_SCOPE_GLOBAL.equals(this.FIND_SCOPE);
    }

    @Override
    public void setGlobal(boolean findGlobalScope) {
        this.FIND_SCOPE = findGlobalScope ? FIND_SCOPE_GLOBAL : FIND_SCOPE_SELECTED;
    }

    @Override
    public boolean isCaseSensitive() {
        return this.CASE_SENSITIVE_SEARCH;
    }

    @Override
    public void setCaseSensitive(boolean caseSensitiveSearch) {
        this.CASE_SENSITIVE_SEARCH = caseSensitiveSearch;
    }

    @Override
    public boolean isLocalCaseSensitive() {
        return this.LOCAL_CASE_SENSITIVE_SEARCH;
    }

    @Override
    public boolean isLocalWholeWordsOnly() {
        return this.LOCAL_WHOLE_WORDS_ONLY;
    }

    @Override
    public void setLocalCaseSensitive(boolean caseSensitiveSearch) {
        this.LOCAL_CASE_SENSITIVE_SEARCH = caseSensitiveSearch;
    }

    @Override
    public void setLocalWholeWordsOnly(boolean wholeWordsOnly) {
        this.LOCAL_WHOLE_WORDS_ONLY = wholeWordsOnly;
    }

    @Override
    public boolean isPreserveCase() {
        return this.PRESERVE_CASE_REPLACE;
    }

    @Override
    public void setPreserveCase(boolean preserveCase) {
        this.PRESERVE_CASE_REPLACE = preserveCase;
    }

    @Override
    public boolean isWholeWordsOnly() {
        return this.WHOLE_WORDS_ONLY;
    }

    @Override
    public void setWholeWordsOnly(boolean wholeWordsOnly) {
        this.WHOLE_WORDS_ONLY = wholeWordsOnly;
    }

    @Override
    public boolean isRegularExpressions() {
        return this.REGULAR_EXPRESSIONS;
    }

    @Override
    public void setRegularExpressions(boolean regularExpressions) {
        this.REGULAR_EXPRESSIONS = regularExpressions;
    }

    @Override
    public boolean isLocalRegularExpressions() {
        return this.LOCAL_REGULAR_EXPRESSIONS;
    }

    @Override
    public void setLocalRegularExpressions(boolean regularExpressions) {
        this.LOCAL_REGULAR_EXPRESSIONS = regularExpressions;
    }

    @Override
    public void setWithSubdirectories(boolean b) {
        this.WITH_SUBDIRECTORIES = b;
    }

    private boolean isWithSubdirectories() {
        return this.WITH_SUBDIRECTORIES;
    }

    @Override
    public void initModelBySetings(@NotNull FindModel model) {
        if (model == null) {
            FindSettingsBase.$$$reportNull$$$0(1);
        }
        model.setCaseSensitive(this.isCaseSensitive());
        model.setForward(this.isForward());
        model.setFromCursor(this.isFromCursor());
        model.setGlobal(this.isGlobal());
        model.setRegularExpressions(this.isRegularExpressions());
        model.setWholeWordsOnly(this.isWholeWordsOnly());
        FindModel.SearchContext searchContext = this.isInCommentsOnly() ? FindModel.SearchContext.IN_COMMENTS : (this.isInStringLiteralsOnly() ? FindModel.SearchContext.IN_STRING_LITERALS : (this.isExceptComments() ? FindModel.SearchContext.EXCEPT_COMMENTS : (this.isExceptStringLiterals() ? FindModel.SearchContext.EXCEPT_STRING_LITERALS : (this.isExceptCommentsAndLiterals() ? FindModel.SearchContext.EXCEPT_COMMENTS_AND_STRING_LITERALS : FindModel.SearchContext.ANY))));
        model.setSearchContext(searchContext);
        model.setWithSubdirectories(this.isWithSubdirectories());
        model.setFileFilter(this.FILE_MASK);
    }

    @Override
    public final @NlsSafe String @NotNull [] getRecentFileMasks() {
        String[] stringArray = ArrayUtilRt.toStringArray(this.recentFileMasks);
        if (stringArray == null) {
            FindSettingsBase.$$$reportNull$$$0(2);
        }
        return stringArray;
    }

    @Override
    @Transient
    @Nullable
    @NlsSafe
    public final String getFileMask() {
        return this.FILE_MASK;
    }

    @Override
    public final void setFileMask(@Nullable @NlsSafe String fileMask) {
        this.FILE_MASK = fileMask;
        FindInProjectSettingsBase.addRecentStringToList(fileMask, this.recentFileMasks);
    }

    @Override
    public String getCustomScope() {
        return this.SEARCH_SCOPE;
    }

    @Override
    public boolean isInStringLiteralsOnly() {
        return this.STRING_LITERALS_ONLY;
    }

    @Override
    public boolean isInCommentsOnly() {
        return this.COMMENTS_ONLY;
    }

    @Override
    public void setInCommentsOnly(boolean selected) {
        this.COMMENTS_ONLY = selected;
    }

    @Override
    public void setInStringLiteralsOnly(boolean selected) {
        this.STRING_LITERALS_ONLY = selected;
    }

    @Override
    public void setCustomScope(String SEARCH_SCOPE) {
        this.SEARCH_SCOPE = SEARCH_SCOPE;
    }

    @Override
    public boolean isExceptComments() {
        return this.EXCEPT_COMMENTS;
    }

    @Override
    public void setExceptCommentsAndLiterals(boolean selected) {
        this.EXCEPT_COMMENTS_AND_STRING_LITERALS = selected;
    }

    @Override
    public boolean isShowResultsInSeparateView() {
        return this.SHOW_RESULTS_IN_SEPARATE_VIEW;
    }

    @Override
    public void setShowResultsInSeparateView(boolean optionValue) {
        this.SHOW_RESULTS_IN_SEPARATE_VIEW = optionValue;
    }

    @Override
    public boolean isExceptCommentsAndLiterals() {
        return this.EXCEPT_COMMENTS_AND_STRING_LITERALS;
    }

    @Override
    public void setExceptComments(boolean selected) {
        this.EXCEPT_COMMENTS = selected;
    }

    @Override
    public boolean isExceptStringLiterals() {
        return this.EXCEPT_STRING_LITERALS;
    }

    @Override
    public void setExceptStringLiterals(boolean selected) {
        this.EXCEPT_STRING_LITERALS = selected;
    }

    @Override
    public boolean isScrollToResultsDuringTyping() {
        return this.SCROLL_TO_RESULTS_DURING_TYPING;
    }

    @Override
    public void setScrollToResultsDuringTyping(boolean selected) {
        this.SCROLL_TO_RESULTS_DURING_TYPING = selected;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/impl/FindSettingsBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/impl/FindSettingsBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecentFileMasks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "initModelBySetings";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

