/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.ByWordRt;
import com.intellij.diff.comparison.CancellationChecker;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.ComparisonUtil;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.util.Side;
import com.intellij.util.text.MergingCharSequence;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0010H\u0002J.\u0010\u0019\u001a\u00020\u00032\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0012\u0010\f\u001a\u00060\rj\u0002`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/diff/comparison/GreedyHelper;", "", "leftText", "", "baseText", "rightText", "<init>", "(Ljava/lang/CharSequence;Ljava/lang/CharSequence;Ljava/lang/CharSequence;)V", "getLeftText", "()Ljava/lang/CharSequence;", "getBaseText", "getRightText", "newContent", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "lastBaseOffset", "", "index1", "index2", "execute", "policy", "Lcom/intellij/diff/comparison/ComparisonPolicy;", "appendBase", "", "endOffset", "getInsertedContent", "fragments", "", "Lcom/intellij/diff/fragments/DiffFragment;", "start", "end", "side", "Lcom/intellij/diff/util/Side;", "intellij.platform.util.diff"})
@SourceDebugExtension(value={"SMAP\nMergeResolveUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MergeResolveUtil.kt\ncom/intellij/diff/comparison/GreedyHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,265:1\n1803#2,3:266\n*S KotlinDebug\n*F\n+ 1 MergeResolveUtil.kt\ncom/intellij/diff/comparison/GreedyHelper\n*L\n260#1:266,3\n*E\n"})
final class GreedyHelper {
    @NotNull
    private final CharSequence leftText;
    @NotNull
    private final CharSequence baseText;
    @NotNull
    private final CharSequence rightText;
    @NotNull
    private final StringBuilder newContent;
    private int lastBaseOffset;
    private int index1;
    private int index2;

    public GreedyHelper(@NotNull CharSequence leftText, @NotNull CharSequence baseText, @NotNull CharSequence rightText) {
        Intrinsics.checkNotNullParameter((Object)leftText, (String)"leftText");
        Intrinsics.checkNotNullParameter((Object)baseText, (String)"baseText");
        Intrinsics.checkNotNullParameter((Object)rightText, (String)"rightText");
        this.leftText = leftText;
        this.baseText = baseText;
        this.rightText = rightText;
        this.newContent = new StringBuilder();
    }

    @NotNull
    public final CharSequence getLeftText() {
        return this.leftText;
    }

    @NotNull
    public final CharSequence getBaseText() {
        return this.baseText;
    }

    @NotNull
    public final CharSequence getRightText() {
        return this.rightText;
    }

    @Nullable
    public final CharSequence execute(@NotNull ComparisonPolicy policy) {
        block10: {
            Intrinsics.checkNotNullParameter((Object)((Object)policy), (String)"policy");
            List<DiffFragment> fragments1 = ByWordRt.compare(this.baseText, this.leftText, policy, CancellationChecker.EMPTY);
            List<DiffFragment> fragments2 = ByWordRt.compare(this.baseText, this.rightText, policy, CancellationChecker.EMPTY);
            while (true) {
                int changeStart2;
                DiffFragment diffFragment = (DiffFragment)CollectionsKt.getOrNull(fragments1, (int)this.index1);
                int changeStart1 = diffFragment != null ? diffFragment.getStartOffset1() : -1;
                DiffFragment diffFragment2 = (DiffFragment)CollectionsKt.getOrNull(fragments2, (int)this.index2);
                int n = changeStart2 = diffFragment2 != null ? diffFragment2.getStartOffset1() : -1;
                if (changeStart1 == -1 && changeStart2 == -1) break block10;
                if (changeStart1 != -1 && changeStart2 != -1) {
                    this.appendBase(Math.min(changeStart1, changeStart2));
                } else if (changeStart1 != -1) {
                    this.appendBase(changeStart1);
                } else {
                    this.appendBase(changeStart2);
                }
                int baseOffsetEnd = this.lastBaseOffset;
                int end1 = this.index1;
                int end2 = this.index2;
                while (true) {
                    DiffFragment next1 = (DiffFragment)CollectionsKt.getOrNull(fragments1, (int)end1);
                    DiffFragment next2 = (DiffFragment)CollectionsKt.getOrNull(fragments2, (int)end2);
                    if (next1 != null && next1.getStartOffset1() <= baseOffsetEnd) {
                        baseOffsetEnd = Math.max(baseOffsetEnd, next1.getEndOffset1());
                        ++end1;
                        continue;
                    }
                    if (next2 == null || next2.getStartOffset1() > baseOffsetEnd) break;
                    baseOffsetEnd = Math.max(baseOffsetEnd, next2.getEndOffset1());
                    ++end2;
                }
                if (!(this.index1 != end1 || this.index2 != end2)) {
                    throw new IllegalStateException("Check failed.");
                }
                CharSequence inserted1 = this.getInsertedContent(fragments1, this.index1, end1, Side.LEFT);
                CharSequence inserted2 = this.getInsertedContent(fragments2, this.index2, end2, Side.RIGHT);
                this.index1 = end1;
                this.index2 = end2;
                this.lastBaseOffset = baseOffsetEnd;
                if (inserted1.length() == 0 && inserted2.length() == 0) continue;
                if (inserted2.length() == 0) {
                    this.newContent.append(inserted1);
                    continue;
                }
                if (inserted1.length() == 0) {
                    this.newContent.append(inserted2);
                    continue;
                }
                if (!ComparisonUtil.isEqualTexts(inserted1, inserted2, policy)) break;
                CharSequence inserted = inserted1.length() <= inserted2.length() ? inserted1 : inserted2;
                this.newContent.append(inserted);
            }
            return null;
        }
        this.appendBase(this.baseText.length());
        return this.newContent;
    }

    private final void appendBase(int endOffset) {
        if (this.lastBaseOffset == endOffset) {
            return;
        }
        this.newContent.append(this.baseText.subSequence(this.lastBaseOffset, endOffset));
        this.lastBaseOffset = endOffset;
    }

    /*
     * WARNING - void declaration
     */
    private final CharSequence getInsertedContent(List<? extends DiffFragment> fragments, int start, int end, Side side) {
        void $this$fold$iv;
        CharSequence charSequence = side.select(this.leftText, this.rightText);
        Intrinsics.checkNotNull((Object)charSequence);
        CharSequence text = charSequence;
        CharSequence empty = "";
        Iterable iterable = fragments.subList(start, end);
        CharSequence initial$iv = empty;
        boolean $i$f$fold = false;
        CharSequence accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void fragment;
            DiffFragment diffFragment = (DiffFragment)element$iv;
            CharSequence prefix = accumulator$iv;
            boolean bl = false;
            accumulator$iv = new MergingCharSequence(prefix, text.subSequence(fragment.getStartOffset2(), fragment.getEndOffset2()));
        }
        return accumulator$iv;
    }
}

