/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.ByWordRt;
import com.intellij.diff.comparison.CancellationChecker;
import com.intellij.diff.comparison.ChangeCorrector;
import com.intellij.diff.comparison.CharacterUtilsKt;
import com.intellij.diff.comparison.TrimUtil;
import com.intellij.diff.comparison.iterables.DiffIterable;
import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.util.Range;
import com.intellij.util.fastutil.ints.IntArrayList;
import com.intellij.util.fastutil.ints.IntListExtensionsKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001(B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0007J \u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0007J \u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0007J \u0010\u000e\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0007J \u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0007J8\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J8\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J0\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0005H\u0002J8\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0007H\u0002J\u0010\u0010\"\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u0007H\u0002J\u0010\u0010#\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u0007H\u0002J \u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u001aH\u0002\u00a8\u0006)"}, d2={"Lcom/intellij/diff/comparison/ByCharRt;", "", "<init>", "()V", "compare", "Lcom/intellij/diff/comparison/iterables/FairDiffIterable;", "text1", "", "text2", "indicator", "Lcom/intellij/diff/comparison/CancellationChecker;", "compareTwoStep", "compareTrimWhitespaces", "Lcom/intellij/diff/comparison/iterables/DiffIterable;", "compareIgnoreWhitespaces", "comparePunctuation", "transferPunctuation", "chars1", "Lcom/intellij/diff/comparison/ByCharRt$CodePointsOffsets;", "chars2", "changes", "matchAdjustmentSpaces", "codePoints1", "codePoints2", "matchAdjustmentSpacesIW", "expandForwardW", "", "ch", "Lcom/intellij/diff/util/Range;", "left", "", "getAllCodePoints", "", "text", "getNonSpaceCodePoints", "getPunctuationChars", "countChars", "codePoints", "start", "end", "CodePointsOffsets", "intellij.platform.util.diff"})
public final class ByCharRt {
    @NotNull
    public static final ByCharRt INSTANCE = new ByCharRt();

    private ByCharRt() {
    }

    @JvmStatic
    @NotNull
    public static final FairDiffIterable compare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CancellationChecker indicator) {
        Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        indicator.checkCanceled();
        int[] codePoints1 = INSTANCE.getAllCodePoints(text1);
        int[] codePoints2 = INSTANCE.getAllCodePoints(text2);
        FairDiffIterable iterable = DiffIterableUtil.diff(codePoints1, codePoints2, indicator);
        int offset1 = 0;
        int offset2 = 0;
        DiffIterableUtil.ChangeBuilder builder = new DiffIterableUtil.ChangeBuilder(text1.length(), text2.length());
        for (Pair<Range, Boolean> pair : DiffIterableUtil.iterateAll(iterable)) {
            Range range = (Range)pair.getFirst();
            boolean equals2 = (Boolean)pair.getSecond();
            int end1 = offset1 + INSTANCE.countChars(codePoints1, range.start1, range.end1);
            int end2 = offset2 + INSTANCE.countChars(codePoints2, range.start2, range.end2);
            if (equals2) {
                builder.markEqual(offset1, offset2, end1, end2);
            }
            offset1 = end1;
            offset2 = end2;
        }
        if (!(offset1 == text1.length())) {
            throw new IllegalStateException("Check failed.");
        }
        if (!(offset2 == text2.length())) {
            throw new IllegalStateException("Check failed.");
        }
        return DiffIterableUtil.fair(builder.finish());
    }

    @JvmStatic
    @NotNull
    public static final FairDiffIterable compareTwoStep(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CancellationChecker indicator) {
        Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        indicator.checkCanceled();
        CodePointsOffsets codePoints1 = INSTANCE.getNonSpaceCodePoints(text1);
        CodePointsOffsets codePoints2 = INSTANCE.getNonSpaceCodePoints(text2);
        FairDiffIterable nonSpaceChanges = DiffIterableUtil.diff(codePoints1.getCodePoints(), codePoints2.getCodePoints(), indicator);
        return INSTANCE.matchAdjustmentSpaces(codePoints1, codePoints2, text1, text2, nonSpaceChanges, indicator);
    }

    @JvmStatic
    @NotNull
    public static final DiffIterable compareTrimWhitespaces(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CancellationChecker indicator) {
        Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        FairDiffIterable iterable = ByCharRt.compareTwoStep(text1, text2, indicator);
        return new ByWordRt.TrimSpacesCorrector(iterable, text1, text2, indicator).build();
    }

    @JvmStatic
    @NotNull
    public static final DiffIterable compareIgnoreWhitespaces(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CancellationChecker indicator) {
        Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        indicator.checkCanceled();
        CodePointsOffsets codePoints1 = INSTANCE.getNonSpaceCodePoints(text1);
        CodePointsOffsets codePoints2 = INSTANCE.getNonSpaceCodePoints(text2);
        FairDiffIterable changes = DiffIterableUtil.diff(codePoints1.getCodePoints(), codePoints2.getCodePoints(), indicator);
        return INSTANCE.matchAdjustmentSpacesIW(codePoints1, codePoints2, text1, text2, changes);
    }

    @JvmStatic
    @NotNull
    public static final FairDiffIterable comparePunctuation(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CancellationChecker indicator) {
        Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        indicator.checkCanceled();
        CodePointsOffsets chars1 = INSTANCE.getPunctuationChars(text1);
        CodePointsOffsets chars2 = INSTANCE.getPunctuationChars(text2);
        FairDiffIterable nonSpaceChanges = DiffIterableUtil.diff(chars1.getCodePoints(), chars2.getCodePoints(), indicator);
        return INSTANCE.transferPunctuation(chars1, chars2, text1, text2, nonSpaceChanges, indicator);
    }

    private final FairDiffIterable transferPunctuation(CodePointsOffsets chars1, CodePointsOffsets chars2, CharSequence text1, CharSequence text2, FairDiffIterable changes, CancellationChecker indicator) {
        DiffIterableUtil.ChangeBuilder builder = new DiffIterableUtil.ChangeBuilder(text1.length(), text2.length());
        for (Range range : changes.iterateUnchanged()) {
            int count2 = range.end1 - range.start1;
            for (int i = 0; i < count2; ++i) {
                int offset1 = chars1.getOffsets()[range.start1 + i];
                int offset2 = chars2.getOffsets()[range.start2 + i];
                builder.markEqual(offset1, offset2);
            }
        }
        return DiffIterableUtil.fair(builder.finish());
    }

    private final FairDiffIterable matchAdjustmentSpaces(CodePointsOffsets codePoints1, CodePointsOffsets codePoints2, CharSequence text1, CharSequence text2, FairDiffIterable changes, CancellationChecker indicator) {
        return new ChangeCorrector.DefaultCharChangeCorrector(codePoints1, codePoints2, text1, text2, changes, indicator).build();
    }

    private final DiffIterable matchAdjustmentSpacesIW(CodePointsOffsets codePoints1, CodePointsOffsets codePoints2, CharSequence text1, CharSequence text2, FairDiffIterable changes) {
        List ranges = new ArrayList();
        for (Range ch : changes.iterateChanges()) {
            int startOffset1 = 0;
            int endOffset1 = 0;
            if (ch.start1 == ch.end1) {
                startOffset1 = endOffset1 = this.expandForwardW(codePoints1, codePoints2, text1, text2, ch, true);
            } else {
                startOffset1 = codePoints1.charOffset(ch.start1);
                endOffset1 = codePoints1.charOffsetAfter(ch.end1 - 1);
            }
            int startOffset2 = 0;
            int endOffset2 = 0;
            if (ch.start2 == ch.end2) {
                startOffset2 = endOffset2 = this.expandForwardW(codePoints1, codePoints2, text1, text2, ch, false);
            } else {
                startOffset2 = codePoints2.charOffset(ch.start2);
                endOffset2 = codePoints2.charOffsetAfter(ch.end2 - 1);
            }
            ranges.add(new Range(startOffset1, endOffset1, startOffset2, endOffset2));
        }
        return DiffIterableUtil.create(ranges, text1.length(), text2.length());
    }

    private final int expandForwardW(CodePointsOffsets codePoints1, CodePointsOffsets codePoints2, CharSequence text1, CharSequence text2, Range ch, boolean left) {
        int offset1 = ch.start1 == 0 ? 0 : codePoints1.charOffsetAfter(ch.start1 - 1);
        int offset2 = ch.start2 == 0 ? 0 : codePoints2.charOffsetAfter(ch.start2 - 1);
        int start = left ? offset1 : offset2;
        return start + TrimUtil.expandWhitespacesForward(text1, text2, offset1, offset2, text1.length(), text2.length());
    }

    private final int[] getAllCodePoints(CharSequence text) {
        int charCount;
        IntArrayList list = new IntArrayList(text.length());
        int len = text.length();
        for (int offset = 0; offset < len; offset += charCount) {
            int ch = CharacterUtilsKt.codePointAt(text, offset);
            charCount = CharacterUtilsKt.charCount(ch);
            list.add(ch);
        }
        return IntListExtensionsKt.toArray(list);
    }

    private final CodePointsOffsets getNonSpaceCodePoints(CharSequence text) {
        int charCount;
        IntArrayList codePoints = new IntArrayList(text.length());
        IntArrayList offsets = new IntArrayList(text.length());
        int len = text.length();
        for (int offset = 0; offset < len; offset += charCount) {
            int ch = CharacterUtilsKt.codePointAt(text, offset);
            charCount = CharacterUtilsKt.charCount(ch);
            if (TrimUtil.isWhiteSpaceCodePoint(ch)) continue;
            codePoints.add(ch);
            offsets.add(offset);
        }
        return new CodePointsOffsets(IntListExtensionsKt.toArray(codePoints), IntListExtensionsKt.toArray(offsets));
    }

    private final CodePointsOffsets getPunctuationChars(CharSequence text) {
        IntArrayList codePoints = new IntArrayList(text.length());
        IntArrayList offsets = new IntArrayList(text.length());
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            char c = text.charAt(i);
            if (!TrimUtil.isPunctuation(c)) continue;
            codePoints.add(c);
            offsets.add(i);
        }
        return new CodePointsOffsets(IntListExtensionsKt.toArray(codePoints), IntListExtensionsKt.toArray(offsets));
    }

    private final int countChars(int[] codePoints, int start, int end) {
        int count2 = 0;
        for (int i = start; i < end; ++i) {
            count2 += CharacterUtilsKt.charCount(codePoints[i]);
        }
        return count2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/diff/comparison/ByCharRt$CodePointsOffsets;", "", "codePoints", "", "offsets", "<init>", "([I[I)V", "getCodePoints", "()[I", "getOffsets", "charOffset", "", "index", "charOffsetAfter", "intellij.platform.util.diff"})
    public static final class CodePointsOffsets {
        @NotNull
        private final int[] codePoints;
        @NotNull
        private final int[] offsets;

        public CodePointsOffsets(@NotNull int[] codePoints, @NotNull int[] offsets) {
            Intrinsics.checkNotNullParameter((Object)codePoints, (String)"codePoints");
            Intrinsics.checkNotNullParameter((Object)offsets, (String)"offsets");
            this.codePoints = codePoints;
            this.offsets = offsets;
        }

        @NotNull
        public final int[] getCodePoints() {
            return this.codePoints;
        }

        @NotNull
        public final int[] getOffsets() {
            return this.offsets;
        }

        public final int charOffset(int index) {
            return this.offsets[index];
        }

        public final int charOffsetAfter(int index) {
            return this.offsets[index] + CharacterUtilsKt.charCount(this.codePoints[index]);
        }
    }
}

