/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.CoroutineDumperKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B;\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001c\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J$\u0010\u001a\u001a\u00020\u00142\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0003H\u0002J\u001c\u0010\u001c\u001a\u00020\u00142\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\"\u0010\u001d\u001a\u00020\u00142\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010!\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003JG\u0010#\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0001J\u0013\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010'\u001a\u00020\u0019H\u00d6\u0001J\t\u0010(\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006)"}, d2={"Lcom/intellij/diagnostic/JobRepresentation;", "", "coroutineName", "", "job", "state", "context", "trace", "", "Ljava/lang/StackTraceElement;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getCoroutineName", "()Ljava/lang/String;", "getJob", "getState", "getContext", "getTrace", "()Ljava/util/List;", "indent", "", "out", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "level", "", "writeHeader", "additionalInfo", "writeTrace", "write", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "intellij.platform.util.base"})
final class JobRepresentation {
    @Nullable
    private final String coroutineName;
    @NotNull
    private final String job;
    @Nullable
    private final String state;
    @Nullable
    private final String context;
    @NotNull
    private final List<StackTraceElement> trace;

    public JobRepresentation(@Nullable String coroutineName, @NotNull String job2, @Nullable String state2, @Nullable String context, @NotNull List<StackTraceElement> trace) {
        Intrinsics.checkNotNullParameter((Object)job2, (String)"job");
        Intrinsics.checkNotNullParameter(trace, (String)"trace");
        this.coroutineName = coroutineName;
        this.job = job2;
        this.state = state2;
        this.context = context;
        this.trace = trace;
    }

    @Nullable
    public final String getCoroutineName() {
        return this.coroutineName;
    }

    @NotNull
    public final String getJob() {
        return this.job;
    }

    @Nullable
    public final String getState() {
        return this.state;
    }

    @Nullable
    public final String getContext() {
        return this.context;
    }

    @NotNull
    public final List<StackTraceElement> getTrace() {
        return this.trace;
    }

    private final void indent(Appendable out, int level) {
        out.append(StringsKt.repeat((CharSequence)"\t", (int)level));
    }

    private final void writeHeader(Appendable out, int level, String additionalInfo) {
        String it;
        this.indent(out, level);
        out.append('-' + additionalInfo + ' ');
        String string = this.coroutineName;
        if (string != null) {
            it = string;
            boolean bl = false;
            out.append('\"' + it + "\":");
        }
        out.append(this.job);
        String string2 = this.state;
        if (string2 != null) {
            it = string2;
            boolean bl = false;
            out.append(", state: " + it);
        }
        String string3 = this.context;
        if (string3 != null) {
            it = string3;
            boolean bl = false;
            out.append(" [" + it + ']');
        }
        CoroutineDumperKt.access$appendOsLine(out);
    }

    private final void writeTrace(Appendable out, int level) {
        for (StackTraceElement stackFrame : this.trace) {
            this.indent(out, level);
            CoroutineDumperKt.access$appendOsLine(out, "\tat " + stackFrame);
        }
    }

    public final void write(@NotNull Appendable out, int level, @NotNull String additionalInfo) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)additionalInfo, (String)"additionalInfo");
        this.writeHeader(out, level, additionalInfo);
        this.writeTrace(out, level);
    }

    @Nullable
    public final String component1() {
        return this.coroutineName;
    }

    @NotNull
    public final String component2() {
        return this.job;
    }

    @Nullable
    public final String component3() {
        return this.state;
    }

    @Nullable
    public final String component4() {
        return this.context;
    }

    @NotNull
    public final List<StackTraceElement> component5() {
        return this.trace;
    }

    @NotNull
    public final JobRepresentation copy(@Nullable String coroutineName, @NotNull String job2, @Nullable String state2, @Nullable String context, @NotNull List<StackTraceElement> trace) {
        Intrinsics.checkNotNullParameter((Object)job2, (String)"job");
        Intrinsics.checkNotNullParameter(trace, (String)"trace");
        return new JobRepresentation(coroutineName, job2, state2, context, trace);
    }

    public static /* synthetic */ JobRepresentation copy$default(JobRepresentation jobRepresentation, String string, String string2, String string3, String string4, List list, int n, Object object) {
        if ((n & 1) != 0) {
            string = jobRepresentation.coroutineName;
        }
        if ((n & 2) != 0) {
            string2 = jobRepresentation.job;
        }
        if ((n & 4) != 0) {
            string3 = jobRepresentation.state;
        }
        if ((n & 8) != 0) {
            string4 = jobRepresentation.context;
        }
        if ((n & 0x10) != 0) {
            list = jobRepresentation.trace;
        }
        return jobRepresentation.copy(string, string2, string3, string4, list);
    }

    @NotNull
    public String toString() {
        return "JobRepresentation(coroutineName=" + this.coroutineName + ", job=" + this.job + ", state=" + this.state + ", context=" + this.context + ", trace=" + this.trace + ')';
    }

    public int hashCode() {
        int result = this.coroutineName == null ? 0 : this.coroutineName.hashCode();
        result = result * 31 + this.job.hashCode();
        result = result * 31 + (this.state == null ? 0 : this.state.hashCode());
        result = result * 31 + (this.context == null ? 0 : this.context.hashCode());
        result = result * 31 + ((Object)this.trace).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JobRepresentation)) {
            return false;
        }
        JobRepresentation jobRepresentation = (JobRepresentation)other;
        if (!Intrinsics.areEqual((Object)this.coroutineName, (Object)jobRepresentation.coroutineName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.job, (Object)jobRepresentation.job)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.state, (Object)jobRepresentation.state)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.context, (Object)jobRepresentation.context)) {
            return false;
        }
        return Intrinsics.areEqual(this.trace, jobRepresentation.trace);
    }
}

