/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.reference.RefDirectory;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.reference.WritableRefElement;
import com.intellij.codeInspection.reference.WritableRefEntity;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class RefDirectoryImpl
extends RefElementImpl
implements RefDirectory {
    private volatile RefModule myRefModule;

    RefDirectoryImpl(PsiDirectory psiElement, RefManager refManager) {
        super(psiElement.getName(), psiElement, refManager);
    }

    @Override
    protected synchronized void initialize() {
        WritableRefElement refElement;
        PsiDirectory parentDirectory;
        PsiDirectory d;
        PsiElement psiElement = this.getPsiElement();
        PsiDirectory psiElement2 = psiElement instanceof PsiDirectory ? (d = (PsiDirectory)psiElement) : null;
        LOG.assertTrue(psiElement2 != null);
        if (!ProjectRootsUtil.isSourceRoot((PsiDirectory)psiElement2) && (parentDirectory = psiElement2.getParentDirectory()) != null && ProjectFileIndex.getInstance(psiElement2.getProject()).isInSourceContent(parentDirectory.getVirtualFile()) && (refElement = (WritableRefElement)this.getRefManager().getReference(parentDirectory)) != null) {
            refElement.add(this);
            return;
        }
        this.myRefModule = this.getRefManager().getRefModule(ModuleUtilCore.findModuleForPsiElement(psiElement2));
        if (this.myRefModule != null) {
            ((WritableRefEntity)((Object)this.myRefModule)).add(this);
            return;
        }
        ((WritableRefEntity)((Object)this.myManager.getRefProject())).add(this);
    }

    @Override
    public void accept(@NotNull RefVisitor visitor) {
        if (visitor == null) {
            RefDirectoryImpl.$$$reportNull$$$0(0);
        }
        ReadAction.run(() -> visitor.visitDirectory(this));
    }

    @Override
    public boolean isValid() {
        if (this.isDeleted()) {
            return false;
        }
        return ReadAction.compute(() -> {
            if (this.getRefManager().getProject().isDisposed()) {
                return false;
            }
            VirtualFile directory = this.getVirtualFile();
            return directory != null && directory.isValid();
        });
    }

    @Override
    @Nullable
    public RefModule getModule() {
        return this.myRefModule != null ? this.myRefModule : super.getModule();
    }

    @Override
    @NotNull
    public String getQualifiedName() {
        String string = this.getName();
        if (string == null) {
            RefDirectoryImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public String getExternalName() {
        PsiElement element = this.getPsiElement();
        assert (element != null);
        return ((PsiDirectory)element).getVirtualFile().getPath();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/reference/RefDirectoryImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/reference/RefDirectoryImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

