/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.SmartList;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LookupElementPresentation {
    private Icon myIcon;
    private Icon myTypeIcon;
    private boolean myTypeIconRightAligned;
    private String myItemText;
    private String myTypeText;
    private boolean myStrikeout;
    private Color myItemTextForeground = JBColor.namedColor((String)"CompletionPopup.foreground", (Color)JBColor.foreground());
    private boolean myItemTextBold;
    private boolean myItemTextUnderlined;
    private boolean myItemTextItalic;
    @Nullable
    private List<DecoratedTextRange> myItemNameDecorations;
    @Nullable
    private List<DecoratedTextRange> myItemTailDecorations;
    private boolean myTypeGrayed;
    @Nullable
    private List<TextFragment> myTail;
    private volatile boolean myFrozen;

    public void setIcon(@Nullable Icon icon) {
        this.ensureMutable();
        this.myIcon = icon;
    }

    public void setItemText(@Nullable String text) {
        this.ensureMutable();
        this.myItemText = text;
    }

    public void setStrikeout(boolean strikeout) {
        this.ensureMutable();
        this.myStrikeout = strikeout;
    }

    public void setItemTextBold(boolean bold) {
        this.ensureMutable();
        this.myItemTextBold = bold;
    }

    public void setItemTextItalic(boolean itemTextItalic) {
        this.ensureMutable();
        this.myItemTextItalic = itemTextItalic;
    }

    @ApiStatus.Internal
    public void decorateItemTextRange(@NotNull TextRange textRange, @NotNull LookupItemDecoration decoration) {
        if (textRange == null) {
            LookupElementPresentation.$$$reportNull$$$0(0);
        }
        if (decoration == null) {
            LookupElementPresentation.$$$reportNull$$$0(1);
        }
        this.ensureMutable();
        if (this.myItemNameDecorations == null) {
            this.myItemNameDecorations = new SmartList<DecoratedTextRange>();
        }
        this.myItemNameDecorations.add(new DecoratedTextRange(textRange, decoration));
    }

    @ApiStatus.Internal
    public void decorateTailItemTextRange(@NotNull TextRange textRange, @NotNull LookupItemDecoration decoration) {
        if (textRange == null) {
            LookupElementPresentation.$$$reportNull$$$0(2);
        }
        if (decoration == null) {
            LookupElementPresentation.$$$reportNull$$$0(3);
        }
        this.ensureMutable();
        if (this.myItemTailDecorations == null) {
            this.myItemTailDecorations = new SmartList<DecoratedTextRange>();
        }
        this.myItemTailDecorations.add(new DecoratedTextRange(textRange, decoration));
    }

    public void setTailText(@Nullable String text) {
        this.setTailText(text, false);
    }

    public void clearTail() {
        this.ensureMutable();
        this.myTail = null;
    }

    public void appendTailText(@NotNull String text, boolean grayed) {
        if (text == null) {
            LookupElementPresentation.$$$reportNull$$$0(4);
        }
        this.appendTailText(new TextFragment(text, grayed, false, null));
    }

    public void appendTailTextItalic(@NotNull String text, boolean grayed) {
        if (text == null) {
            LookupElementPresentation.$$$reportNull$$$0(5);
        }
        this.appendTailText(new TextFragment(text, grayed, true, null));
    }

    private void appendTailText(@NotNull TextFragment fragment) {
        if (fragment == null) {
            LookupElementPresentation.$$$reportNull$$$0(6);
        }
        this.ensureMutable();
        if (fragment.text.isEmpty()) {
            return;
        }
        if (this.myTail == null) {
            this.myTail = new SmartList<TextFragment>();
        }
        this.myTail.add(fragment);
    }

    public void setTailText(@Nullable String text, boolean grayed) {
        this.clearTail();
        if (text != null) {
            this.appendTailText(new TextFragment(text, grayed, false, null));
        }
    }

    public void setTailText(@Nullable String text, @Nullable Color foreground) {
        this.clearTail();
        if (text != null) {
            this.appendTailText(new TextFragment(text, false, false, foreground));
        }
    }

    public void setTypeText(@Nullable String text) {
        this.setTypeText(text, null);
    }

    public void setTypeText(@Nullable String text, @Nullable Icon icon) {
        this.ensureMutable();
        this.myTypeText = text;
        this.myTypeIcon = icon;
    }

    @Deprecated(forRemoval=true)
    public boolean isReal() {
        return true;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    @Nullable
    public Icon getTypeIcon() {
        return this.myTypeIcon;
    }

    @Nullable
    public String getItemText() {
        return this.myItemText;
    }

    @ApiStatus.Internal
    @NotNull
    public List<DecoratedTextRange> getItemNameDecorations() {
        List<DecoratedTextRange> list = this.myItemNameDecorations == null ? Collections.emptyList() : Collections.unmodifiableList(this.myItemNameDecorations);
        if (list == null) {
            LookupElementPresentation.$$$reportNull$$$0(7);
        }
        return list;
    }

    @ApiStatus.Internal
    @NotNull
    public List<DecoratedTextRange> getItemTailDecorations() {
        List<DecoratedTextRange> list = this.myItemTailDecorations == null ? Collections.emptyList() : Collections.unmodifiableList(this.myItemTailDecorations);
        if (list == null) {
            LookupElementPresentation.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    public List<TextFragment> getTailFragments() {
        List<TextFragment> list = this.myTail == null ? Collections.emptyList() : Collections.unmodifiableList(this.myTail);
        if (list == null) {
            LookupElementPresentation.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Nullable
    public String getTailText() {
        if (this.myTail == null) {
            return null;
        }
        return StringUtil.join(this.myTail, fragment -> fragment.text, "");
    }

    @Nullable
    public String getTypeText() {
        return this.myTypeText;
    }

    public boolean isStrikeout() {
        return this.myStrikeout;
    }

    public boolean isItemTextBold() {
        return this.myItemTextBold;
    }

    public boolean isItemTextItalic() {
        return this.myItemTextItalic;
    }

    public boolean isItemTextUnderlined() {
        return this.myItemTextUnderlined;
    }

    public void setItemTextUnderlined(boolean itemTextUnderlined) {
        this.ensureMutable();
        this.myItemTextUnderlined = itemTextUnderlined;
    }

    @NotNull
    public Color getItemTextForeground() {
        Color color = this.myItemTextForeground;
        if (color == null) {
            LookupElementPresentation.$$$reportNull$$$0(10);
        }
        return color;
    }

    public void setItemTextForeground(@NotNull Color itemTextForeground) {
        if (itemTextForeground == null) {
            LookupElementPresentation.$$$reportNull$$$0(11);
        }
        this.ensureMutable();
        this.myItemTextForeground = itemTextForeground;
    }

    public void copyFrom(@NotNull LookupElementPresentation presentation) {
        if (presentation == null) {
            LookupElementPresentation.$$$reportNull$$$0(12);
        }
        this.myIcon = presentation.myIcon;
        this.myTypeIcon = presentation.myTypeIcon;
        this.myItemText = presentation.myItemText;
        List<DecoratedTextRange> thatNameDecoration = presentation.myItemNameDecorations;
        this.myItemNameDecorations = thatNameDecoration == null ? null : new SmartList<DecoratedTextRange>((Collection<DecoratedTextRange>)thatNameDecoration);
        List<DecoratedTextRange> thatTailDecoration = presentation.myItemTailDecorations;
        this.myItemTailDecorations = thatTailDecoration == null ? null : new SmartList<DecoratedTextRange>((Collection<DecoratedTextRange>)thatTailDecoration);
        List<TextFragment> thatTail = presentation.myTail;
        this.myTail = thatTail == null ? null : new SmartList<TextFragment>((Collection<TextFragment>)thatTail);
        this.myTypeText = presentation.myTypeText;
        this.myStrikeout = presentation.myStrikeout;
        this.myItemTextBold = presentation.myItemTextBold;
        this.myItemTextItalic = presentation.myItemTextItalic;
        this.myTypeGrayed = presentation.myTypeGrayed;
        this.myTypeIconRightAligned = presentation.myTypeIconRightAligned;
        this.myItemTextUnderlined = presentation.myItemTextUnderlined;
        this.myItemTextForeground = presentation.myItemTextForeground;
    }

    public boolean isTypeGrayed() {
        return this.myTypeGrayed;
    }

    public void setTypeGrayed(boolean typeGrayed) {
        this.ensureMutable();
        this.myTypeGrayed = typeGrayed;
    }

    private void ensureMutable() {
        if (this.myFrozen) {
            throw new IllegalStateException("This lookup element presentation can't be changed");
        }
    }

    public boolean isTypeIconRightAligned() {
        return this.myTypeIconRightAligned;
    }

    public void setTypeIconRightAligned(boolean typeIconRightAligned) {
        this.ensureMutable();
        this.myTypeIconRightAligned = typeIconRightAligned;
    }

    public static LookupElementPresentation renderElement(LookupElement element) {
        LookupElementPresentation presentation = new LookupElementPresentation();
        element.renderElement(presentation);
        return presentation;
    }

    @ApiStatus.Internal
    public void freeze() {
        this.myFrozen = true;
    }

    public String toString() {
        return "LookupElementPresentation{itemText='" + this.myItemText + "', tail=" + String.valueOf(this.myTail) + ", typeText='" + this.myTypeText + "'}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decoration";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/lookup/LookupElementPresentation";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemTextForeground";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/lookup/LookupElementPresentation";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemNameDecorations";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemTailDecorations";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTailFragments";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemTextForeground";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "decorateItemTextRange";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "decorateTailItemTextRange";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "appendTailText";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendTailTextItalic";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setItemTextForeground";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9, 10 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Internal
    public record DecoratedTextRange(TextRange textRange, LookupItemDecoration decoration) {
    }

    @ApiStatus.Internal
    public static enum LookupItemDecoration {
        ERROR,
        HIGHLIGHT_MATCHED,
        GRAY;

    }

    public static final class TextFragment {
        public final String text;
        private final boolean myGrayed;
        private final boolean myItalic;
        @Nullable
        private final Color myFgColor;

        private TextFragment(String text, boolean grayed, boolean italic, @Nullable Color fgColor) {
            this.text = text;
            this.myGrayed = grayed;
            this.myItalic = italic;
            this.myFgColor = fgColor;
        }

        public String toString() {
            return "TextFragment{text='" + this.text + "'" + (this.myGrayed ? ", grayed" : "") + (this.myItalic ? ", italic" : "") + (String)(this.myFgColor != null ? ", fgColor=" + String.valueOf(this.myFgColor) : "") + "}";
        }

        public boolean isGrayed() {
            return this.myGrayed;
        }

        public boolean isItalic() {
            return this.myItalic;
        }

        @Nullable
        public Color getForegroundColor() {
            return this.myFgColor;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TextFragment)) {
                return false;
            }
            TextFragment fragment = (TextFragment)o;
            return this.myGrayed == fragment.myGrayed && this.myItalic == fragment.myItalic && Objects.equals(this.text, fragment.text) && Objects.equals(this.myFgColor, fragment.myFgColor);
        }

        public int hashCode() {
            return Objects.hash(this.text, this.myGrayed, this.myItalic, this.myFgColor);
        }
    }
}

