/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public interface CustomizableIntentionAction
extends IntentionAction {
    default public boolean isShowSubmenu() {
        return true;
    }

    default public boolean isSelectable() {
        return true;
    }

    default public boolean isShowIcon() {
        return true;
    }

    default public boolean isShowLightBulb() {
        return true;
    }

    default public boolean isOverrideIntentionBulb() {
        return false;
    }

    @NlsContexts.Tooltip
    default public String getTooltipText() {
        return this.getText();
    }

    default public @Unmodifiable @NotNull List<RangeToHighlight> getRangesToHighlight(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            CustomizableIntentionAction.$$$reportNull$$$0(0);
        }
        if (file == null) {
            CustomizableIntentionAction.$$$reportNull$$$0(1);
        }
        List<RangeToHighlight> list = List.of();
        if (list == null) {
            CustomizableIntentionAction.$$$reportNull$$$0(2);
        }
        return list;
    }

    default public boolean hasSeparatorAbove() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/CustomizableIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/CustomizableIntentionAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangesToHighlight";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRangesToHighlight";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public static final class RangeToHighlight {
        private final PsiElement psi;
        private final TextRange rangeInPsi;
        private final TextAttributesKey highlightKey;

        public RangeToHighlight(@NotNull PsiElement psi, @NotNull TextRange rangeInPsi, @NotNull TextAttributesKey highlightKey) {
            if (psi == null) {
                RangeToHighlight.$$$reportNull$$$0(0);
            }
            if (rangeInPsi == null) {
                RangeToHighlight.$$$reportNull$$$0(1);
            }
            if (highlightKey == null) {
                RangeToHighlight.$$$reportNull$$$0(2);
            }
            this.psi = psi;
            this.rangeInPsi = rangeInPsi;
            this.highlightKey = highlightKey;
        }

        public TextRange getRangeInFile() {
            return this.rangeInPsi.shiftRight(this.psi.getTextRange().getStartOffset());
        }

        public PsiFile getContainingFile() {
            return this.psi.getContainingFile();
        }

        public TextAttributesKey getHighlightKey() {
            return this.highlightKey;
        }

        @Contract(value="null, _ -> null; !null, _ -> !null")
        public static RangeToHighlight from(@Nullable PsiElement psi, @NotNull TextAttributesKey highlightKey) {
            if (highlightKey == null) {
                RangeToHighlight.$$$reportNull$$$0(3);
            }
            return psi == null ? null : new RangeToHighlight(psi, TextRange.create(0, psi.getTextLength()), highlightKey);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psi";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rangeInPsi";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "highlightKey";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/intention/CustomizableIntentionAction$RangeToHighlight";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "from";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

