/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInsight.intention.CommonIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAsIntentionAdapter;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.diagnostic.PluginException;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.objectTree.ThrowableInterner;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import com.intellij.xml.util.XmlStringUtil;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
final class B
implements AnnotationBuilder {
    @NotNull
    private final AnnotationHolderImpl myHolder;
    @Nls
    private final String message;
    @NotNull
    private final PsiElement myCurrentElement;
    @NotNull
    private final Object myCurrentAnnotator;
    @NotNull
    private final HighlightSeverity severity;
    private TextRange range;
    private Boolean afterEndOfLine;
    private Boolean fileLevel;
    private GutterIconRenderer gutterIconRenderer;
    private ProblemGroup problemGroup;
    private TextAttributes enforcedAttributes;
    private TextAttributesKey textAttributesKey;
    private ProblemHighlightType highlightType;
    private Boolean needsUpdateOnTyping;
    private @NlsContexts.Tooltip String tooltip;
    private List<FixB> fixes;
    private boolean created;
    private final Throwable myDebugCreationPlace;
    private List<@NotNull Consumer<? super QuickFixActionRegistrar>> myLazyQuickFixes;

    B(@NotNull AnnotationHolderImpl holder, @NotNull HighlightSeverity severity, @Nls @Nullable String message, @NotNull PsiElement currentElement, @NotNull Object currentAnnotator) {
        if (holder == null) {
            B.$$$reportNull$$$0(0);
        }
        if (severity == null) {
            B.$$$reportNull$$$0(1);
        }
        if (currentElement == null) {
            B.$$$reportNull$$$0(2);
        }
        if (currentAnnotator == null) {
            B.$$$reportNull$$$0(3);
        }
        this.myHolder = holder;
        this.severity = severity;
        this.message = message;
        this.myCurrentElement = currentElement;
        this.myCurrentAnnotator = currentAnnotator;
        holder.annotationBuilderCreated(this);
        Application app = ApplicationManager.getApplication();
        this.myDebugCreationPlace = app.isUnitTestMode() && !ApplicationManagerEx.isInStressTest() || app.isInternal() ? ThrowableInterner.intern(new Throwable()) : null;
    }

    private void assertNotSet(Object o, String description) {
        if (o != null) {
            this.markNotAbandoned();
            throw new IllegalStateException(description + " was set already");
        }
    }

    private void markNotAbandoned() {
        this.created = true;
    }

    @Override
    @NotNull
    public AnnotationBuilder withFix(@NotNull IntentionAction fix) {
        if (fix == null) {
            B.$$$reportNull$$$0(4);
        }
        AnnotationBuilder annotationBuilder = this.newFix(fix).registerFix();
        if (annotationBuilder == null) {
            B.$$$reportNull$$$0(5);
        }
        return annotationBuilder;
    }

    @Override
    @NotNull
    public AnnotationBuilder withFix(@NotNull CommonIntentionAction fix) {
        if (fix == null) {
            B.$$$reportNull$$$0(6);
        }
        AnnotationBuilder annotationBuilder = this.newFix(fix).registerFix();
        if (annotationBuilder == null) {
            B.$$$reportNull$$$0(7);
        }
        return annotationBuilder;
    }

    @Override
    @NotNull
    public AnnotationBuilder.FixBuilder newFix(@NotNull IntentionAction fix) {
        if (fix == null) {
            B.$$$reportNull$$$0(8);
        }
        return new FixB(fix);
    }

    @Override
    @NotNull
    public AnnotationBuilder.FixBuilder newFix(@NotNull CommonIntentionAction fix) {
        if (fix == null) {
            B.$$$reportNull$$$0(9);
        }
        return new FixB(fix);
    }

    @Override
    @NotNull
    public AnnotationBuilder.FixBuilder newLocalQuickFix(@NotNull LocalQuickFix fix, @NotNull ProblemDescriptor problemDescriptor) {
        if (fix == null) {
            B.$$$reportNull$$$0(10);
        }
        if (problemDescriptor == null) {
            B.$$$reportNull$$$0(11);
        }
        return new FixB(QuickFixWrapper.wrap(problemDescriptor, fix));
    }

    @Override
    @NotNull
    public AnnotationBuilder withLazyQuickFix(@NotNull Consumer<? super QuickFixActionRegistrar> quickFixComputer) {
        if (quickFixComputer == null) {
            B.$$$reportNull$$$0(12);
        }
        if (this.myLazyQuickFixes == null) {
            this.myLazyQuickFixes = new SmartList<Consumer<? super QuickFixActionRegistrar>>();
        }
        this.myLazyQuickFixes.add(quickFixComputer);
        B b = this;
        if (b == null) {
            B.$$$reportNull$$$0(13);
        }
        return b;
    }

    @Override
    @NotNull
    public AnnotationBuilder range(@NotNull TextRange range) {
        if (range == null) {
            B.$$$reportNull$$$0(14);
        }
        this.assertNotSet(this.range, "range");
        TextRange currentElementRange = this.myCurrentElement.getTextRange();
        if (!currentElementRange.contains(range)) {
            this.markNotAbandoned();
            String message = "Range must be inside element being annotated: " + String.valueOf(currentElementRange) + "; but got: " + String.valueOf(range);
            throw PluginException.createByClass(message, null, this.myCurrentAnnotator.getClass());
        }
        this.range = range;
        B b = this;
        if (b == null) {
            B.$$$reportNull$$$0(15);
        }
        return b;
    }

    @Override
    @NotNull
    public AnnotationBuilder range(@NotNull ASTNode element) {
        if (element == null) {
            B.$$$reportNull$$$0(16);
        }
        AnnotationBuilder annotationBuilder = this.range(element.getTextRange());
        if (annotationBuilder == null) {
            B.$$$reportNull$$$0(17);
        }
        return annotationBuilder;
    }

    @Override
    @NotNull
    public AnnotationBuilder range(@NotNull PsiElement element) {
        if (element == null) {
            B.$$$reportNull$$$0(18);
        }
        AnnotationBuilder annotationBuilder = this.range(element.getTextRange());
        if (annotationBuilder == null) {
            B.$$$reportNull$$$0(19);
        }
        return annotationBuilder;
    }

    @Override
    @NotNull
    public AnnotationBuilder afterEndOfLine() {
        this.assertNotSet(this.afterEndOfLine, "afterEndOfLine");
        this.afterEndOfLine = true;
        B b = this;
        if (b == null) {
            B.$$$reportNull$$$0(20);
        }
        return b;
    }

    @Override
    @NotNull
    public AnnotationBuilder fileLevel() {
        this.assertNotSet(this.fileLevel, "fileLevel");
        this.fileLevel = true;
        B b = this;
        if (b == null) {
            B.$$$reportNull$$$0(21);
        }
        return b;
    }

    @Override
    @NotNull
    public AnnotationBuilder gutterIconRenderer(@NotNull GutterIconRenderer gutterIconRenderer) {
        if (gutterIconRenderer == null) {
            B.$$$reportNull$$$0(22);
        }
        this.assertNotSet(this.gutterIconRenderer, "gutterIconRenderer");
        this.gutterIconRenderer = gutterIconRenderer;
        B b = this;
        if (b == null) {
            B.$$$reportNull$$$0(23);
        }
        return b;
    }

    @Override
    @NotNull
    public AnnotationBuilder problemGroup(@NotNull ProblemGroup problemGroup) {
        if (problemGroup == null) {
            B.$$$reportNull$$$0(24);
        }
        this.assertNotSet(this.problemGroup, "problemGroup");
        this.problemGroup = problemGroup;
        B b = this;
        if (b == null) {
            B.$$$reportNull$$$0(25);
        }
        return b;
    }

    @Override
    @NotNull
    public AnnotationBuilder enforcedTextAttributes(@NotNull TextAttributes enforcedAttributes) {
        if (enforcedAttributes == null) {
            B.$$$reportNull$$$0(26);
        }
        this.assertNotSet(this.enforcedAttributes, "enforcedAttributes");
        this.enforcedAttributes = enforcedAttributes;
        B b = this;
        if (b == null) {
            B.$$$reportNull$$$0(27);
        }
        return b;
    }

    @Override
    @NotNull
    public AnnotationBuilder textAttributes(@NotNull TextAttributesKey textAttributes) {
        if (textAttributes == null) {
            B.$$$reportNull$$$0(28);
        }
        this.assertNotSet(this.textAttributesKey, "textAttributes");
        this.textAttributesKey = textAttributes;
        B b = this;
        if (b == null) {
            B.$$$reportNull$$$0(29);
        }
        return b;
    }

    @Override
    @NotNull
    public AnnotationBuilder highlightType(@NotNull ProblemHighlightType highlightType) {
        if (highlightType == null) {
            B.$$$reportNull$$$0(30);
        }
        this.assertNotSet((Object)this.highlightType, "highlightType");
        this.highlightType = highlightType;
        B b = this;
        if (b == null) {
            B.$$$reportNull$$$0(31);
        }
        return b;
    }

    @Override
    @NotNull
    public AnnotationBuilder needsUpdateOnTyping() {
        AnnotationBuilder annotationBuilder = this.needsUpdateOnTyping(true);
        if (annotationBuilder == null) {
            B.$$$reportNull$$$0(32);
        }
        return annotationBuilder;
    }

    @Override
    @NotNull
    public AnnotationBuilder needsUpdateOnTyping(boolean value) {
        this.assertNotSet(this.needsUpdateOnTyping, "needsUpdateOnTyping");
        this.needsUpdateOnTyping = value;
        B b = this;
        if (b == null) {
            B.$$$reportNull$$$0(33);
        }
        return b;
    }

    @Override
    @NotNull
    public AnnotationBuilder tooltip(@NotNull String tooltip) {
        if (tooltip == null) {
            B.$$$reportNull$$$0(34);
        }
        this.assertNotSet(this.tooltip, "tooltip");
        this.tooltip = tooltip;
        B b = this;
        if (b == null) {
            B.$$$reportNull$$$0(35);
        }
        return b;
    }

    @Override
    public void create() {
        this.doCreate();
    }

    private Annotation doCreate() {
        if (this.created) {
            throw new IllegalStateException("Must not call .create() twice");
        }
        this.created = true;
        if (this.range == null) {
            this.range = this.myCurrentElement.getTextRange();
        }
        if (this.tooltip == null && this.message != null) {
            this.tooltip = XmlStringUtil.wrapInHtml(XmlStringUtil.escapeString(this.message));
        }
        Annotation annotation = new Annotation(this.range.getStartOffset(), this.range.getEndOffset(), this.severity, this.message, this.tooltip);
        if (this.needsUpdateOnTyping != null) {
            annotation.setNeedsUpdateOnTyping(this.needsUpdateOnTyping);
        }
        if (this.highlightType != null) {
            annotation.setHighlightType(this.highlightType);
        }
        if (this.textAttributesKey != null) {
            annotation.setTextAttributes(this.textAttributesKey);
        }
        if (this.enforcedAttributes != null) {
            annotation.setEnforcedTextAttributes(this.enforcedAttributes);
        }
        if (this.problemGroup != null) {
            annotation.setProblemGroup(this.problemGroup);
        }
        if (this.gutterIconRenderer != null) {
            annotation.setGutterIconRenderer(this.gutterIconRenderer);
        }
        if (this.fileLevel != null) {
            annotation.setFileLevelAnnotation(this.fileLevel);
        }
        if (this.afterEndOfLine != null) {
            annotation.setAfterEndOfLine(this.afterEndOfLine);
        }
        if (this.fixes != null) {
            for (FixB fb : this.fixes) {
                TextRange finalRange;
                CommonIntentionAction fix = fb.fix;
                IntentionAction intention = fix.asIntention();
                TextRange textRange = finalRange = fb.range == null ? this.range : fb.range;
                if (fb.batch != null && fb.batch.booleanValue()) {
                    annotation.registerBatchFix(intention, B.getLocalQuickFix(fix), finalRange, fb.key);
                    continue;
                }
                if (fb.universal != null && fb.universal.booleanValue()) {
                    annotation.registerBatchFix(intention, B.getLocalQuickFix(fix), finalRange, fb.key);
                    annotation.registerFix(intention, finalRange, fb.key);
                    continue;
                }
                annotation.registerFix(intention, finalRange, fb.key);
            }
        }
        if (this.myLazyQuickFixes != null) {
            annotation.registerLazyQuickFixes(this.myLazyQuickFixes);
        }
        this.myHolder.add(annotation);
        this.myHolder.annotationCreatedFrom(this);
        return annotation;
    }

    @NotNull
    private static LocalQuickFix getLocalQuickFix(@NotNull CommonIntentionAction fix) {
        if (fix == null) {
            B.$$$reportNull$$$0(36);
        }
        if (fix instanceof ModCommandAction) {
            ModCommandAction modCommandAction = (ModCommandAction)fix;
            LocalQuickFix localQuickFix = LocalQuickFix.from(modCommandAction);
            if (localQuickFix == null) {
                B.$$$reportNull$$$0(37);
            }
            return localQuickFix;
        }
        LocalQuickFix unwrapped = QuickFixWrapper.unwrap(fix);
        if (unwrapped != null) {
            LocalQuickFix localQuickFix = unwrapped;
            if (localQuickFix == null) {
                B.$$$reportNull$$$0(38);
            }
            return localQuickFix;
        }
        LocalQuickFix localQuickFix = (LocalQuickFix)((Object)fix);
        if (localQuickFix == null) {
            B.$$$reportNull$$$0(39);
        }
        return localQuickFix;
    }

    void assertAnnotationCreated() {
        if (!this.created) {
            IllegalStateException exception = new IllegalStateException("Abandoned AnnotationBuilder - its 'create()' method was never called: " + String.valueOf(this) + (this.myDebugCreationPlace == null ? "" : "\nSee cause for the AnnotationBuilder creation stacktrace"), this.myDebugCreationPlace);
            throw PluginException.createByClass(exception, this.myCurrentAnnotator.getClass());
        }
    }

    @NotNull
    private static String omitIfEmpty(Object o, String name) {
        Object object = o == null ? "" : ", " + name + "=" + String.valueOf(o);
        if (object == null) {
            B.$$$reportNull$$$0(40);
        }
        return object;
    }

    public String toString() {
        return "Builder{message='" + this.message + "', myCurrentElement=" + String.valueOf(this.myCurrentElement) + " (" + String.valueOf(this.myCurrentElement.getClass()) + "), myCurrentAnnotator=" + String.valueOf(this.myCurrentAnnotator) + ", severity=" + String.valueOf(this.severity) + ", range=" + String.valueOf(this.range == null ? "(implicit)" + String.valueOf(this.myCurrentElement.getTextRange()) : this.range) + B.omitIfEmpty(this.afterEndOfLine, "afterEndOfLine") + B.omitIfEmpty(this.fileLevel, "fileLevel") + B.omitIfEmpty(this.gutterIconRenderer, "gutterIconRenderer") + B.omitIfEmpty(this.problemGroup, "problemGroup") + B.omitIfEmpty(this.enforcedAttributes, "enforcedAttributes") + B.omitIfEmpty(this.textAttributesKey, "textAttributesKey") + B.omitIfEmpty((Object)this.highlightType, "highlightType") + B.omitIfEmpty(this.needsUpdateOnTyping, "needsUpdateOnTyping") + B.omitIfEmpty(this.tooltip, "tooltip") + B.omitIfEmpty(this.fixes, "fixes") + "}";
    }

    @Override
    public Annotation createAnnotation() {
        PluginException.reportDeprecatedUsage("AnnotationBuilder#createAnnotation", "Use `#create()` instead");
        return this.doCreate();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7, 13, 15, 17, 19, 20, 21, 23, 25, 27, 29, 31, 32, 33, 35, 37, 38, 39, 40 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentAnnotator";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fix";
                break;
            }
            case 5: 
            case 7: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/B";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFixComputer";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gutterIconRenderer";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemGroup";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enforcedAttributes";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textAttributes";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightType";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltip";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/B";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "withFix";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "withLazyQuickFix";
                break;
            }
            case 15: 
            case 17: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "range";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "afterEndOfLine";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "fileLevel";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "gutterIconRenderer";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "problemGroup";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "enforcedTextAttributes";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "textAttributes";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "highlightType";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "needsUpdateOnTyping";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "tooltip";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalQuickFix";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "omitIfEmpty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "withFix";
                break;
            }
            case 5: 
            case 7: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "newFix";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "newLocalQuickFix";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "withLazyQuickFix";
                break;
            }
            case 14: 
            case 16: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "range";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "gutterIconRenderer";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "problemGroup";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "enforcedTextAttributes";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "textAttributes";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "highlightType";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "tooltip";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getLocalQuickFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7, 13, 15, 17, 19, 20, 21, 23, 25, 27, 29, 31, 32, 33, 35, 37, 38, 39, 40 -> new IllegalStateException(string);
        };
    }

    private class FixB
    implements AnnotationBuilder.FixBuilder {
        @NotNull
        final CommonIntentionAction fix;
        TextRange range;
        HighlightDisplayKey key;
        Boolean batch;
        Boolean universal;

        FixB(CommonIntentionAction fix) {
            if (fix == null) {
                FixB.$$$reportNull$$$0(0);
            }
            this.fix = fix;
        }

        @Override
        @NotNull
        public AnnotationBuilder.FixBuilder range(@NotNull TextRange range) {
            if (range == null) {
                FixB.$$$reportNull$$$0(1);
            }
            B.this.assertNotSet(this.range, "range");
            this.range = range;
            FixB fixB = this;
            if (fixB == null) {
                FixB.$$$reportNull$$$0(2);
            }
            return fixB;
        }

        @Override
        @NotNull
        public AnnotationBuilder.FixBuilder key(@NotNull HighlightDisplayKey key) {
            if (key == null) {
                FixB.$$$reportNull$$$0(3);
            }
            B.this.assertNotSet(this.key, "key");
            this.key = key;
            FixB fixB = this;
            if (fixB == null) {
                FixB.$$$reportNull$$$0(4);
            }
            return fixB;
        }

        @Override
        @NotNull
        public AnnotationBuilder.FixBuilder batch() {
            B.this.assertNotSet(this.universal, "universal");
            B.this.assertNotSet(this.batch, "batch");
            this.assertLQF();
            this.batch = true;
            FixB fixB = this;
            if (fixB == null) {
                FixB.$$$reportNull$$$0(5);
            }
            return fixB;
        }

        private void assertLQF() {
            if (!(this.fix instanceof LocalQuickFix || this.fix instanceof ModCommandAction || this.fix instanceof QuickFixWrapper || this.fix instanceof LocalQuickFixAsIntentionAdapter)) {
                B.this.markNotAbandoned();
                throw new IllegalArgumentException("Fix " + String.valueOf(this.fix) + " must be instance of LocalQuickFix or ModCommandAction to be registered as batch");
            }
        }

        @Override
        @NotNull
        public AnnotationBuilder.FixBuilder universal() {
            B.this.assertNotSet(this.universal, "universal");
            B.this.assertNotSet(this.batch, "batch");
            this.assertLQF();
            this.universal = true;
            FixB fixB = this;
            if (fixB == null) {
                FixB.$$$reportNull$$$0(6);
            }
            return fixB;
        }

        @Override
        @NotNull
        public AnnotationBuilder registerFix() {
            if (B.this.fixes == null) {
                B.this.fixes = new SmartList<FixB>();
            }
            B.this.fixes.add(this);
            B b = B.this;
            if (b == null) {
                FixB.$$$reportNull$$$0(7);
            }
            return b;
        }

        public String toString() {
            return String.valueOf(this.fix) + (String)(this.range == null ? "" : " at " + String.valueOf(this.range)) + (this.batch == null ? "" : " batch") + (this.universal == null ? "" : " universal");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 4, 5, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/B$FixB";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/B$FixB";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "range";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "key";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "batch";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "universal";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "registerFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "range";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "key";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 4, 5, 6, 7 -> new IllegalStateException(string);
            };
        }
    }
}

