/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HighlightDisplayKey {
    private static final Logger LOG = Logger.getInstance(HighlightDisplayKey.class);
    private static final Map<String, HighlightDisplayKey> ourShortNameToKeyMap = new ConcurrentHashMap<String, HighlightDisplayKey>();
    private static final Map<String, HighlightDisplayKey> ourIdToKeyMap = new ConcurrentHashMap<String, HighlightDisplayKey>();
    private static final Map<HighlightDisplayKey, Computable<@Nls(capitalization=Nls.Capitalization.Sentence) String>> ourKeyToDisplayNameMap = new ConcurrentHashMap<HighlightDisplayKey, Computable<String>>();
    private static final Map<HighlightDisplayKey, String> ourKeyToAlternativeIDMap = new ConcurrentHashMap<HighlightDisplayKey, String>();
    private final String myShortName;
    private final String myID;

    @Nullable
    public static HighlightDisplayKey find(@NonNls @NotNull String shortName) {
        if (shortName == null) {
            HighlightDisplayKey.$$$reportNull$$$0(0);
        }
        return ourShortNameToKeyMap.get(shortName);
    }

    @Nullable
    public static HighlightDisplayKey findById(@NonNls @NotNull String id) {
        HighlightDisplayKey key;
        if (id == null) {
            HighlightDisplayKey.$$$reportNull$$$0(1);
        }
        if ((key = ourIdToKeyMap.get(id)) != null) {
            return key;
        }
        key = HighlightDisplayKey.find(id);
        if (key != null && key.getID().equals(id)) {
            return key;
        }
        return null;
    }

    @Deprecated
    @Nullable
    public static HighlightDisplayKey register(@NonNls @NotNull String shortName, @NotNull String displayName, @NotNull @NonNls String id) {
        if (shortName == null) {
            HighlightDisplayKey.$$$reportNull$$$0(2);
        }
        if (displayName == null) {
            HighlightDisplayKey.$$$reportNull$$$0(3);
        }
        if (id == null) {
            HighlightDisplayKey.$$$reportNull$$$0(4);
        }
        return HighlightDisplayKey.register(shortName, new Computable.PredefinedValueComputable<String>(displayName), id);
    }

    @Nullable
    public static HighlightDisplayKey register(@NonNls @NotNull String shortName, @NotNull Computable<@Nls(capitalization=Nls.Capitalization.Sentence) String> displayName, @NotNull @NonNls String id) {
        HighlightDisplayKey key;
        if (shortName == null) {
            HighlightDisplayKey.$$$reportNull$$$0(5);
        }
        if (displayName == null) {
            HighlightDisplayKey.$$$reportNull$$$0(6);
        }
        if (id == null) {
            HighlightDisplayKey.$$$reportNull$$$0(7);
        }
        if ((key = HighlightDisplayKey.find(shortName)) != null) {
            LOG.error("Key with shortName '" + shortName + "' already registered with display name: '" + HighlightDisplayKey.getDisplayNameByKey(key) + "' while calling register(Display name='" + displayName.compute() + "', ID='" + id + "')");
            return null;
        }
        HighlightDisplayKey highlightDisplayKey = new HighlightDisplayKey(shortName, id);
        ourKeyToDisplayNameMap.put(highlightDisplayKey, displayName);
        return highlightDisplayKey;
    }

    @Nullable
    public static HighlightDisplayKey register(@NonNls @NotNull String shortName, @NotNull Computable<@Nls(capitalization=Nls.Capitalization.Sentence) String> displayName, @NonNls @NotNull String id, @NonNls @Nullable String alternativeID) {
        if (shortName == null) {
            HighlightDisplayKey.$$$reportNull$$$0(8);
        }
        if (displayName == null) {
            HighlightDisplayKey.$$$reportNull$$$0(9);
        }
        if (id == null) {
            HighlightDisplayKey.$$$reportNull$$$0(10);
        }
        HighlightDisplayKey key = HighlightDisplayKey.register(shortName, displayName, id);
        if (alternativeID != null) {
            ourKeyToAlternativeIDMap.put(key, alternativeID);
        }
        return key;
    }

    public static void unregister(@NotNull String shortName) {
        HighlightDisplayKey key;
        if (shortName == null) {
            HighlightDisplayKey.$$$reportNull$$$0(11);
        }
        if ((key = ourShortNameToKeyMap.remove(shortName)) != null) {
            ourIdToKeyMap.remove(key.myID);
            ourKeyToAlternativeIDMap.remove(key);
            ourKeyToDisplayNameMap.remove(key);
        }
    }

    @NotNull
    public static HighlightDisplayKey findOrRegister(@NonNls @NotNull String shortName, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String displayName) {
        if (shortName == null) {
            HighlightDisplayKey.$$$reportNull$$$0(12);
        }
        if (displayName == null) {
            HighlightDisplayKey.$$$reportNull$$$0(13);
        }
        return HighlightDisplayKey.findOrRegister(shortName, displayName, null);
    }

    @NotNull
    public static HighlightDisplayKey findOrRegister(@NonNls @NotNull String shortName, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String displayName, @NonNls @Nullable String id) {
        HighlightDisplayKey key;
        if (shortName == null) {
            HighlightDisplayKey.$$$reportNull$$$0(14);
        }
        if (displayName == null) {
            HighlightDisplayKey.$$$reportNull$$$0(15);
        }
        if ((key = HighlightDisplayKey.find(shortName)) == null) {
            id = id != null ? id : shortName;
            key = new HighlightDisplayKey(shortName, id);
            ourKeyToDisplayNameMap.put(key, new Computable.PredefinedValueComputable<String>(displayName));
        }
        HighlightDisplayKey highlightDisplayKey = key;
        if (highlightDisplayKey == null) {
            HighlightDisplayKey.$$$reportNull$$$0(16);
        }
        return highlightDisplayKey;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @Nullable
    public static String getDisplayNameByKey(@Nullable HighlightDisplayKey key) {
        if (key == null) {
            return null;
        }
        Computable<@Nls(capitalization=Nls.Capitalization.Sentence) String> computable = ourKeyToDisplayNameMap.get(key);
        return computable == null ? null : computable.compute();
    }

    public static String getAlternativeID(@NotNull HighlightDisplayKey key) {
        if (key == null) {
            HighlightDisplayKey.$$$reportNull$$$0(17);
        }
        return ourKeyToAlternativeIDMap.get(key);
    }

    @Deprecated
    @ApiStatus.Internal
    public HighlightDisplayKey(@NonNls @NotNull String shortName, @NonNls @NotNull String ID2) {
        if (shortName == null) {
            HighlightDisplayKey.$$$reportNull$$$0(18);
        }
        if (ID2 == null) {
            HighlightDisplayKey.$$$reportNull$$$0(19);
        }
        this.myShortName = shortName;
        this.myID = ID2;
        ourShortNameToKeyMap.put(this.myShortName, this);
        if (!Objects.equals(ID2, shortName)) {
            ourIdToKeyMap.put(ID2, this);
        }
    }

    public String toString() {
        return this.myShortName;
    }

    public String getShortName() {
        return this.myShortName;
    }

    @NotNull
    public String getID() {
        String string = this.myID;
        if (string == null) {
            HighlightDisplayKey.$$$reportNull$$$0(20);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 16, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/HighlightDisplayKey";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ID";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/HighlightDisplayKey";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrRegister";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findById";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "unregister";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findOrRegister";
                break;
            }
            case 16: 
            case 20: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getAlternativeID";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 16, 20 -> new IllegalStateException(string);
        };
    }
}

