/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.TailTypes;
import com.intellij.codeInsight.completion.CompletionAssertions;
import com.intellij.codeInsight.completion.CompletionData;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProcessEx;
import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.codeInsight.completion.CompletionVariant;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupValueWithPsiElement;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.CharPattern;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.filters.TrueFilter;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.UnmodifiableIterator;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompletionUtil {
    private static final CompletionData ourGenericCompletionData = new CompletionData(){
        {
            CompletionVariant variant = new CompletionVariant(PsiElement.class, TrueFilter.INSTANCE);
            variant.addCompletionFilter(TrueFilter.INSTANCE, TailTypes.noneType());
            this.registerVariant(variant);
        }
    };
    @NonNls
    public static final String DUMMY_IDENTIFIER = "IntellijIdeaRulezzz ";
    @NonNls
    public static final String DUMMY_IDENTIFIER_TRIMMED = "IntellijIdeaRulezzz ".trim();

    @Nullable
    public static CompletionData getCompletionDataByElement(@Nullable PsiElement position, @NotNull PsiFile originalFile) {
        if (originalFile == null) {
            CompletionUtil.$$$reportNull$$$0(0);
        }
        if (position == null) {
            return null;
        }
        return ourGenericCompletionData;
    }

    public static boolean shouldShowFeature(CompletionParameters parameters, @NonNls String id) {
        return CompletionUtil.shouldShowFeature(parameters.getPosition().getProject(), id);
    }

    public static boolean shouldShowFeature(Project project, @NonNls String id) {
        if (FeatureUsageTracker.getInstance().isToBeAdvertisedInLookup(id, project)) {
            FeatureUsageTracker.getInstance().triggerFeatureShown(id);
            return true;
        }
        return false;
    }

    @NotNull
    public static String findJavaIdentifierPrefix(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            CompletionUtil.$$$reportNull$$$0(1);
        }
        return CompletionUtil.findJavaIdentifierPrefix(parameters.getPosition(), parameters.getOffset());
    }

    @NotNull
    public static String findJavaIdentifierPrefix(@Nullable PsiElement position, int offsetInFile) {
        return CompletionUtil.findIdentifierPrefix(position, offsetInFile, (ElementPattern<Character>)CharPattern.javaIdentifierPartCharacter(), (ElementPattern<Character>)CharPattern.javaIdentifierStartCharacter());
    }

    @NotNull
    public static String findReferenceOrAlphanumericPrefix(@NotNull CompletionParameters parameters) {
        String prefix;
        if (parameters == null) {
            CompletionUtil.$$$reportNull$$$0(2);
        }
        String string = (prefix = CompletionUtil.findReferencePrefix(parameters)) == null ? CompletionUtil.findAlphanumericPrefix(parameters) : prefix;
        if (string == null) {
            CompletionUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static String findAlphanumericPrefix(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            CompletionUtil.$$$reportNull$$$0(4);
        }
        return CompletionUtil.findIdentifierPrefix(parameters.getPosition().getContainingFile(), parameters.getOffset(), (ElementPattern<Character>)CharPattern.letterOrDigitCharacter(), (ElementPattern<Character>)CharPattern.letterOrDigitCharacter());
    }

    @NotNull
    public static String findIdentifierPrefix(@Nullable PsiElement position, int offsetInFile, @NotNull ElementPattern<Character> idPart, @NotNull ElementPattern<Character> idStart) {
        if (idPart == null) {
            CompletionUtil.$$$reportNull$$$0(5);
        }
        if (idStart == null) {
            CompletionUtil.$$$reportNull$$$0(6);
        }
        if (position == null) {
            return "";
        }
        int startOffset = position.getTextRange().getStartOffset();
        return CompletionUtil.findInText(offsetInFile, startOffset, idPart, idStart, position.getNode().getChars());
    }

    public static String findIdentifierPrefix(@NotNull Document document, int offset, ElementPattern<Character> idPart, ElementPattern<Character> idStart) {
        if (document == null) {
            CompletionUtil.$$$reportNull$$$0(7);
        }
        CharSequence text = document.getImmutableCharSequence();
        return CompletionUtil.findInText(offset, 0, idPart, idStart, text);
    }

    @NotNull
    private static String findInText(int offset, int startOffset, ElementPattern<Character> idPart, ElementPattern<Character> idStart, CharSequence text) {
        int start;
        int offsetInElement = offset - startOffset;
        for (start = offsetInElement - 1; start >= 0 && idPart.accepts(Character.valueOf(text.charAt(start))); --start) {
        }
        while (start + 1 < offsetInElement && !idStart.accepts(Character.valueOf(text.charAt(start + 1)))) {
            ++start;
        }
        String string = text.subSequence(start + 1, offsetInElement).toString().trim();
        if (string == null) {
            CompletionUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nullable
    public static String findReferencePrefix(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            CompletionUtil.$$$reportNull$$$0(9);
        }
        return CompletionUtil.findReferencePrefix(parameters.getPosition(), parameters.getOffset());
    }

    @Nullable
    public static String findReferencePrefix(@NotNull PsiElement position, int offsetInFile) {
        if (position == null) {
            CompletionUtil.$$$reportNull$$$0(10);
        }
        try {
            PsiUtilCore.ensureValid(position);
            PsiReference ref = position.getContainingFile().findReferenceAt(offsetInFile);
            if (ref != null) {
                PsiElement element = ref.getElement();
                int offsetInElement = offsetInFile - element.getTextRange().getStartOffset();
                for (TextRange refRange : ReferenceRange.getRanges(ref)) {
                    if (!refRange.contains(offsetInElement)) continue;
                    int beginIndex = refRange.getStartOffset();
                    String text = element.getText();
                    if (beginIndex < 0 || beginIndex > offsetInElement || offsetInElement > text.length()) {
                        throw new AssertionError((Object)("Inconsistent reference range: ref=" + String.valueOf(ref.getClass()) + " element=" + String.valueOf(element.getClass()) + " ref.start=" + refRange.getStartOffset() + " offset=" + offsetInElement + " psi.length=" + text.length()));
                    }
                    return text.substring(beginIndex, offsetInElement);
                }
            }
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
        return null;
    }

    public static InsertionContext emulateInsertion(InsertionContext oldContext, int newStart, LookupElement item) {
        InsertionContext newContext = CompletionUtil.newContext(oldContext, item);
        CompletionUtil.emulateInsertion(item, newStart, newContext);
        return newContext;
    }

    private static InsertionContext newContext(InsertionContext oldContext, LookupElement forElement) {
        Editor editor = oldContext.getEditor();
        return new InsertionContext(new OffsetMap(editor.getDocument()), '\u0000', new LookupElement[]{forElement}, oldContext.getFile(), editor, oldContext.shouldAddCompletionChar());
    }

    public static InsertionContext newContext(InsertionContext oldContext, LookupElement forElement, int startOffset, int tailOffset) {
        InsertionContext context = CompletionUtil.newContext(oldContext, forElement);
        CompletionUtil.setOffsets(context, startOffset, tailOffset);
        return context;
    }

    public static void emulateInsertion(LookupElement item, int offset, InsertionContext context) {
        CompletionUtil.setOffsets(context, offset, offset);
        Editor editor = context.getEditor();
        Document document = editor.getDocument();
        String lookupString = item.getLookupString();
        document.insertString(offset, lookupString);
        editor.getCaretModel().moveToOffset(context.getTailOffset());
        PsiDocumentManager.getInstance(context.getProject()).commitDocument(document);
        item.handleInsert(context);
        PsiDocumentManager.getInstance(context.getProject()).doPostponedOperationsAndUnblockDocument(document);
    }

    private static void setOffsets(InsertionContext context, int offset, int tailOffset) {
        OffsetMap offsetMap = context.getOffsetMap();
        offsetMap.addOffset(CompletionInitializationContext.START_OFFSET, offset);
        offsetMap.addOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET, tailOffset);
        offsetMap.addOffset(CompletionInitializationContext.SELECTION_END_OFFSET, tailOffset);
        context.setTailOffset(tailOffset);
    }

    @Nullable
    public static PsiElement getTargetElement(LookupElement lookupElement) {
        LookupValueWithPsiElement value;
        PsiElement element;
        PsiElement psiElement = lookupElement.getPsiElement();
        if (psiElement != null && psiElement.isValid()) {
            return CompletionUtil.getOriginalElement(psiElement);
        }
        Object object = lookupElement.getObject();
        if (object instanceof LookupValueWithPsiElement && (element = (value = (LookupValueWithPsiElement)object).getElement()) != null && element.isValid()) {
            return CompletionUtil.getOriginalElement(element);
        }
        return null;
    }

    @Nullable
    public static <T extends PsiElement> T getOriginalElement(@NotNull T psi) {
        if (psi == null) {
            CompletionUtil.$$$reportNull$$$0(11);
        }
        return CompletionUtilCoreImpl.getOriginalElement(psi);
    }

    @NotNull
    public static <T extends PsiElement> T getOriginalOrSelf(@NotNull T psi) {
        T element;
        if (psi == null) {
            CompletionUtil.$$$reportNull$$$0(12);
        }
        T t = (element = CompletionUtil.getOriginalElement(psi)) == null ? psi : element;
        if (t == null) {
            CompletionUtil.$$$reportNull$$$0(13);
        }
        return t;
    }

    public static Iterable<String> iterateLookupStrings(final @NotNull LookupElement element) {
        if (element == null) {
            CompletionUtil.$$$reportNull$$$0(14);
        }
        return new Iterable<String>(){

            @Override
            @NotNull
            public Iterator<String> iterator() {
                Iterator<String> original = element.getAllLookupStrings().iterator();
                return new UnmodifiableIterator<String>(original){

                    @Override
                    public boolean hasNext() {
                        try {
                            return super.hasNext();
                        }
                        catch (ConcurrentModificationException e) {
                            throw this.handleCME(e);
                        }
                    }

                    @Override
                    public String next() {
                        try {
                            return (String)super.next();
                        }
                        catch (ConcurrentModificationException e) {
                            throw this.handleCME(e);
                        }
                    }

                    private RuntimeException handleCME(ConcurrentModificationException cme) {
                        RuntimeExceptionWithAttachments ewa = new RuntimeExceptionWithAttachments("Error while traversing lookup strings of " + String.valueOf(element) + " of " + String.valueOf(element.getClass()), new Attachment("threadDump.txt", ThreadDumper.dumpThreadsToString()));
                        ewa.initCause(cme);
                        return ewa;
                    }
                };
            }
        };
    }

    @ApiStatus.Internal
    @NotNull
    public static CompletionAssertions.WatchingInsertionContext createInsertionContext(@Nullable List<LookupElement> lookupItems, LookupElement item, char completionChar, Editor editor, PsiFile psiFile, int caretOffset, int idEndOffset, OffsetMap offsetMap) {
        int initialStartOffset = Math.max(0, caretOffset - item.getLookupString().length());
        return CompletionUtil.createInsertionContext(lookupItems, completionChar, editor, psiFile, initialStartOffset, caretOffset, idEndOffset, offsetMap);
    }

    @ApiStatus.Internal
    @NotNull
    public static CompletionAssertions.WatchingInsertionContext createInsertionContext(@Nullable List<LookupElement> lookupItems, char completionChar, Editor editor, PsiFile psiFile, int startOffset, int caretOffset, int idEndOffset, OffsetMap offsetMap) {
        offsetMap.addOffset(CompletionInitializationContext.START_OFFSET, startOffset);
        offsetMap.addOffset(CompletionInitializationContext.SELECTION_END_OFFSET, caretOffset);
        offsetMap.addOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET, idEndOffset);
        List<LookupElement> items = lookupItems == null ? Collections.emptyList() : lookupItems;
        return new CompletionAssertions.WatchingInsertionContext(offsetMap, psiFile, completionChar, items, editor);
    }

    @ApiStatus.Internal
    public static int calcIdEndOffset(OffsetMap offsetMap, Editor editor, Integer initOffset) {
        return offsetMap.containsOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET) ? offsetMap.getOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET) : CompletionInitializationContext.calcDefaultIdentifierEnd(editor, initOffset);
    }

    @ApiStatus.Internal
    public static int calcIdEndOffset(CompletionProcessEx indicator) {
        return CompletionUtil.calcIdEndOffset(indicator.getOffsetMap(), indicator.getEditor(), indicator.getCaret().getOffset());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 8, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFile";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 3: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/CompletionUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idPart";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idStart";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/CompletionUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferenceOrAlphanumericPrefix";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findInText";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalOrSelf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCompletionDataByElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findJavaIdentifierPrefix";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findReferenceOrAlphanumericPrefix";
                break;
            }
            case 3: 
            case 8: 
            case 13: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findAlphanumericPrefix";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findIdentifierPrefix";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findReferencePrefix";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalElement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalOrSelf";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "iterateLookupStrings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 8, 13 -> new IllegalStateException(string);
        };
    }
}

