/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.LintCliFixPerformerKt;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintFixPerformer;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Severity;
import com.android.utils.PositionXmlParser;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.parsers.ParserConfigurationException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001:\u0002ABBA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0015H\u0014J\u001a\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0014J\u0014\u0010\u0019\u001a\u00020\u00052\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bJ\u001c\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001bJ\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001b2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u001fJ&\u0010#\u001a\u00020\u00112\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020!2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u001bH\u0016J \u0010)\u001a\u00020\u00152\u0006\u0010*\u001a\u00020\u00152\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,H\u0002J,\u0010\u0004\u001a\u00020\u00112\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020,0/2\u0006\u00100\u001a\u00020,2\u0006\u00101\u001a\u00020,H\u0016J4\u0010\u0004\u001a\u00020\u00112\u0006\u00102\u001a\u0002032\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020,0/2\u0006\u00100\u001a\u00020,2\u0006\u00101\u001a\u00020,H\u0014J(\u00104\u001a\u00020\u00152\u0006\u0010$\u001a\u00020%2\u0006\u0010\u000e\u001a\u00020!2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u0015H\u0014J.\u00108\u001a\u00020\u00152\u0006\u00109\u001a\u00020\u00152\u0006\u0010:\u001a\u00020\u00152\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00150<2\u0006\u0010=\u001a\u00020\u0005H\u0002J\u0018\u0010>\u001a\u00020?2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010@\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/android/tools/lint/LintCliFixPerformer;", "Lcom/android/tools/lint/client/api/LintFixPerformer;", "client", "Lcom/android/tools/lint/LintCliClient;", "printStatistics", "", "requireAutoFixable", "includeMarkers", "updateImports", "shortenAll", "<init>", "(Lcom/android/tools/lint/LintCliClient;ZZZZZ)V", "getSourceText", "", "file", "Ljava/io/File;", "log", "", "severity", "Lcom/android/tools/lint/detector/api/Severity;", "message", "", "writeFile", "contents", "", "fix", "incidents", "", "Lcom/android/tools/lint/detector/api/Incident;", "incident", "fixes", "Lcom/android/tools/lint/detector/api/LintFix;", "computeEdits", "Lcom/android/tools/lint/client/api/LintFixPerformer$PendingEditFile;", "lintFix", "applyEdits", "fileProvider", "Lcom/android/tools/lint/client/api/LintFixPerformer$FileProvider;", "fileData", "edits", "Lcom/android/tools/lint/client/api/LintFixPerformer$PendingEdit;", "injectSelection", "fileContents", "selectionStartOffset", "", "selectionEndOffset", "editMap", "", "appliedEditCount", "editedFileCount", "writer", "Ljava/io/PrintWriter;", "customizeReplaceString", "replaceFix", "Lcom/android/tools/lint/detector/api/LintFix$ReplaceString;", "originalReplacement", "removePackage", "source", "prefix", "names", "", "isWildcard", "getExistingImports", "Lcom/android/tools/lint/LintCliFixPerformer$ImportInfo;", "allowCommentNesting", "ImportInfo", "LintCliFileProvider", "lint-cli"})
@SourceDebugExtension(value={"SMAP\nLintCliFixPerformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintCliFixPerformer.kt\ncom/android/tools/lint/LintCliFixPerformer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,677:1\n543#2,6:678\n216#3,2:684\n168#3,3:687\n1#4:686\n*S KotlinDebug\n*F\n+ 1 LintCliFixPerformer.kt\ncom/android/tools/lint/LintCliFixPerformer\n*L\n96#1:678,6\n168#1:684,2\n527#1:687,3\n*E\n"})
public class LintCliFixPerformer
extends LintFixPerformer {
    @NotNull
    private final LintCliClient client;
    private final boolean printStatistics;
    private final boolean includeMarkers;
    private final boolean updateImports;
    private final boolean shortenAll;

    public LintCliFixPerformer(@NotNull LintCliClient client, boolean printStatistics, boolean requireAutoFixable, boolean includeMarkers, boolean updateImports, boolean shortenAll) {
        Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
        super((LintClient)client, requireAutoFixable);
        this.client = client;
        this.printStatistics = printStatistics;
        this.includeMarkers = includeMarkers;
        this.updateImports = updateImports;
        this.shortenAll = shortenAll;
    }

    public /* synthetic */ LintCliFixPerformer(LintCliClient lintCliClient, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        if ((n & 8) != 0) {
            bl3 = false;
        }
        if ((n & 0x10) != 0) {
            bl4 = bl3;
        }
        if ((n & 0x20) != 0) {
            bl5 = bl3;
        }
        this(lintCliClient, bl, bl2, bl3, bl4, bl5);
    }

    @NotNull
    public final CharSequence getSourceText(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.client.getSourceText(file);
    }

    public void log(@NotNull Severity severity, @NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this.client.log(Severity.WARNING, null, message2, new Object[0]);
    }

    protected void writeFile(@NotNull File file, @NotNull String contents2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)contents2, (String)"contents");
        byte[] byArray = contents2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        this.writeFile(file, byArray);
    }

    protected void writeFile(@NotNull File file, @Nullable byte[] contents2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (contents2 == null) {
            file.delete();
        } else {
            File file2 = file.getParentFile();
            if (file2 != null) {
                file2.mkdirs();
            }
            FilesKt.writeBytes((File)file, (byte[])contents2);
        }
    }

    public final boolean fix(@NotNull List<Incident> incidents) {
        Intrinsics.checkNotNullParameter(incidents, (String)"incidents");
        return super.fix(incidents, (LintFixPerformer.FileProvider)new LintCliFileProvider());
    }

    public final boolean fix(@NotNull Incident incident, @NotNull List<? extends LintFix> fixes) {
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Intrinsics.checkNotNullParameter(fixes, (String)"fixes");
        return super.fix(incident, fixes, (LintFixPerformer.FileProvider)new LintCliFileProvider());
    }

    @NotNull
    public final List<LintFixPerformer.PendingEditFile> computeEdits(@NotNull Incident incident, @NotNull LintFix lintFix) {
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Intrinsics.checkNotNullParameter((Object)lintFix, (String)"lintFix");
        return super.computeEdits(incident, lintFix, (LintFixPerformer.FileProvider)new LintCliFileProvider());
    }

    public void applyEdits(@NotNull LintFixPerformer.FileProvider fileProvider, @NotNull LintFixPerformer.PendingEditFile fileData, @NotNull List<LintFixPerformer.PendingEdit> edits) {
        LintFixPerformer.PendingEdit pendingEdit;
        Ref.ObjectRef fileContents;
        block1: {
            Intrinsics.checkNotNullParameter((Object)fileProvider, (String)"fileProvider");
            Intrinsics.checkNotNullParameter((Object)fileData, (String)"fileData");
            Intrinsics.checkNotNullParameter(edits, (String)"edits");
            fileContents = new Ref.ObjectRef();
            fileContents.element = fileProvider.getFileContents(fileData);
            List<LintFixPerformer.PendingEdit> $this$lastOrNull$iv = edits;
            boolean $i$f$lastOrNull = false;
            ListIterator<LintFixPerformer.PendingEdit> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                LintFixPerformer.PendingEdit element$iv;
                LintFixPerformer.PendingEdit it = element$iv = iterator$iv.previous();
                boolean bl = false;
                if (!(it.getSelectStart() != -1)) continue;
                pendingEdit = element$iv;
                break block1;
            }
            pendingEdit = null;
        }
        LintFixPerformer.PendingEdit firstSelection = pendingEdit;
        this.applyEdits(fileData, edits, (Function2)new Function2<LintFixPerformer.PendingEditFile, LintFixPerformer.PendingEdit, Unit>((Ref.ObjectRef<String>)fileContents, this, firstSelection){
            final /* synthetic */ Ref.ObjectRef<String> $fileContents;
            final /* synthetic */ LintCliFixPerformer this$0;
            final /* synthetic */ LintFixPerformer.PendingEdit $firstSelection;
            {
                this.$fileContents = $fileContents;
                this.this$0 = $receiver;
                this.$firstSelection = $firstSelection;
                super(2);
            }

            public final void invoke(LintFixPerformer.PendingEditFile pendingEditFile, LintFixPerformer.PendingEdit edit) {
                Intrinsics.checkNotNullParameter((Object)pendingEditFile, (String)"<unused var>");
                Intrinsics.checkNotNullParameter((Object)edit, (String)"edit");
                this.$fileContents.element = edit.apply((String)this.$fileContents.element);
                if (LintCliFixPerformer.access$getIncludeMarkers$p(this.this$0) && edit.getSelectStart() != -1 && edit.getSelectEnd() != -1 && edit == this.$firstSelection) {
                    this.$fileContents.element = LintCliFixPerformer.access$injectSelection(this.this$0, (String)this.$fileContents.element, edit.getStartOffset() + edit.getSelectStart(), edit.getStartOffset() + edit.getSelectEnd());
                }
            }
        });
        this.writeFile(fileData.getFile(), (String)fileContents.element);
    }

    private final String injectSelection(String fileContents, int selectionStartOffset, int selectionEndOffset) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        boolean bl = this.includeMarkers;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        if (selectionStartOffset == -1) {
            return fileContents;
        }
        StringBuilder $this$injectSelection_u24lambda_u240 = stringBuilder2 = new StringBuilder(fileContents);
        boolean bl2 = false;
        if (selectionEndOffset == selectionStartOffset) {
            stringBuilder = $this$injectSelection_u24lambda_u240.replace(selectionEndOffset, selectionEndOffset, "|");
        } else {
            $this$injectSelection_u24lambda_u240.replace(selectionEndOffset, selectionEndOffset, "]|");
            stringBuilder = $this$injectSelection_u24lambda_u240.replace(selectionStartOffset, selectionStartOffset, "[");
        }
        String string = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public void printStatistics(@NotNull Map<String, Integer> editMap, int appliedEditCount, int editedFileCount) {
        Intrinsics.checkNotNullParameter(editMap, (String)"editMap");
        if (this.printStatistics && editedFileCount > 0) {
            PrintWriter printWriter = new PrintWriter(System.out, true, Charsets.UTF_8);
            this.printStatistics(printWriter, editMap, appliedEditCount, editedFileCount);
        }
    }

    protected void printStatistics(@NotNull PrintWriter writer, @NotNull Map<String, Integer> editMap, int appliedEditCount, int editedFileCount) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter(editMap, (String)"editMap");
        if (editMap.keySet().size() == 1) {
            writer.println("Applied " + appliedEditCount + " edits across " + editedFileCount + " files for this fix: " + CollectionsKt.first((Iterable)editMap.keySet()));
        } else {
            writer.println("Applied " + appliedEditCount + " edits across " + editedFileCount + " files");
            Map<String, Integer> $this$forEach$iv = editMap;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, Integer>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Integer> element$iv;
                Map.Entry<String, Integer> entry = element$iv = iterator.next();
                boolean bl = false;
                String name = entry.getKey();
                int count = ((Number)entry.getValue()).intValue();
                writer.println(count + ": " + name);
            }
        }
    }

    @NotNull
    protected String customizeReplaceString(@NotNull LintFixPerformer.FileProvider fileProvider, @NotNull LintFixPerformer.PendingEditFile file, @NotNull LintFix.ReplaceString replaceFix, @NotNull String originalReplacement) {
        Intrinsics.checkNotNullParameter((Object)fileProvider, (String)"fileProvider");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)replaceFix, (String)"replaceFix");
        Intrinsics.checkNotNullParameter((Object)originalReplacement, (String)"originalReplacement");
        String replacement = originalReplacement;
        String contents2 = fileProvider.getFileContents(file);
        if (this.updateImports || this.shortenAll && replaceFix.getShortenNames()) {
            List addImports = CollectionsKt.toMutableList((Collection)replaceFix.getImports());
            String string = file.getFile().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            boolean isJava = StringsKt.endsWith$default((String)string, (String)".java", (boolean)false, (int)2, null);
            boolean allowCommentNesting = !isJava;
            ImportInfo importInfo = this.getExistingImports(contents2, allowCommentNesting);
            if (replaceFix.getShortenNames()) {
                Set removePrefix = new HashSet();
                Set<String> qualifiedNames = importInfo.qualifiedNames();
                for (String string2 : qualifiedNames) {
                    removePrefix.add(StringsKt.removeSuffix((String)string2, (CharSequence)"*"));
                }
                Set<String> names = importInfo.names();
                if (this.shortenAll) {
                    Object object = importInfo.getPackageStatement();
                    if (object != null && (object = (String)object.getFirst()) != null) {
                        Object it = object;
                        boolean bl = false;
                        removePrefix.add(it + ".");
                    }
                    for (String string2 : LintCliFixPerformerKt.collectNames(replacement, !isJava)) {
                        String importName;
                        String pkg;
                        String name;
                        int dot;
                        if (qualifiedNames.contains(string2) || (dot = LintCliFixPerformerKt.access$indexOfDotUpperCase(string2)) == -1) continue;
                        Intrinsics.checkNotNullExpressionValue((Object)string2.substring(dot + 1), (String)"substring(...)");
                        if (names.contains(name)) continue;
                        Intrinsics.checkNotNullExpressionValue((Object)string2.substring(0, dot + 1), (String)"substring(...)");
                        if (removePrefix.contains(pkg)) continue;
                        int it = StringsKt.indexOf$default((CharSequence)string2, (char)'.', (int)(dot + 1), (boolean)false, (int)4, null);
                        boolean bl = false;
                        int nameEnd = it != -1 ? it : string2.length();
                        Intrinsics.checkNotNullExpressionValue((Object)string2.substring(0, nameEnd), (String)"substring(...)");
                        removePrefix.add(importName);
                        if (addImports.contains(importName) || LintFixPerformer.Companion.implicitlyImported(StringsKt.substringBeforeLast$default((String)importName, (char)'.', null, (int)2, null))) continue;
                        addImports.add(importName);
                    }
                }
                for (String full : removePrefix) {
                    String clz = full;
                    if (!StringsKt.contains$default((CharSequence)replacement, (CharSequence)clz, (boolean)false, (int)2, null)) continue;
                    boolean isWildcard = StringsKt.endsWith$default((String)clz, (String)".", (boolean)false, (int)2, null);
                    if (!isWildcard) {
                        int index = StringsKt.lastIndexOf$default((CharSequence)clz, (char)'.', (int)0, (boolean)false, (int)6, null);
                        if (index == -1) continue;
                        String string3 = clz.substring(0, index + 1);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                        clz = string3;
                    }
                    replacement = this.removePackage(replacement, clz, names, isWildcard);
                }
            }
            if (!((Collection)addImports).isEmpty()) {
                TreeMap<String, Integer> nonstaticImports = importInfo.getNonStaticImports();
                TreeMap<String, Integer> staticImports = importInfo.getStaticImports();
                for (String string4 : CollectionsKt.sortedDescending((Iterable)addImports)) {
                    boolean isStaticImport;
                    boolean isMethod = Character.isLowerCase(string4.charAt(StringsKt.lastIndexOf$default((CharSequence)string4, (char)'.', (int)0, (boolean)false, (int)6, null) + 1));
                    boolean bl = isStaticImport = isJava && isMethod;
                    if (((Map)nonstaticImports).containsKey(string4) || ((Map)staticImports).containsKey(string4)) continue;
                    int insertOffset = -1;
                    TreeMap<String, Integer> imports = isStaticImport && !((Map)staticImports).isEmpty() ? staticImports : nonstaticImports;
                    for (Map.Entry importName : ((Map)imports).entrySet()) {
                        String imported = (String)importName.getKey();
                        int importedOffset = ((Number)importName.getValue()).intValue();
                        if (imported.compareTo(string4) <= 0) continue;
                        insertOffset = importedOffset;
                        break;
                    }
                    if (insertOffset == -1) {
                        if (!((Map)imports).isEmpty()) {
                            Iterator iterator = ((Iterable)((Map)imports).entrySet()).iterator();
                            if (!iterator.hasNext()) {
                                throw new NoSuchElementException();
                            }
                            Map.Entry it232 = (Map.Entry)iterator.next();
                            boolean bl2 = false;
                            int it232 = ((Number)it232.getValue()).intValue();
                            while (iterator.hasNext()) {
                                Map.Entry it332 = (Map.Entry)iterator.next();
                                boolean bl3 = false;
                                int it332 = ((Number)it332.getValue()).intValue();
                                if (it232 >= it332) continue;
                                it232 = it332;
                            }
                            int last = it232;
                            int it = StringsKt.indexOf$default((CharSequence)contents2, (char)'\n', (int)last, (boolean)false, (int)4, null);
                            boolean bl3 = false;
                            int lineEnd = it == -1 ? contents2.length() : it;
                            insertOffset = StringsKt.contains$default((CharSequence)contents2.subSequence(last, lineEnd), (CharSequence)"/*", (boolean)false, (int)2, null) ? last : Math.min(lineEnd + 1, contents2.length());
                        } else {
                            int offset = 0;
                            int length = contents2.length();
                            while (offset < length) {
                                if ((offset = LintFixPerformer.Companion.skipCommentsAndWhitespace$default((LintFixPerformer.Companion)LintFixPerformer.Companion, (CharSequence)contents2, (int)offset, (boolean)allowCommentNesting, (boolean)false, (int)8, null)) == length) {
                                    insertOffset = length;
                                    break;
                                }
                                if (StringsKt.startsWith$default((String)contents2, (String)"package", (int)offset, (boolean)false, (int)4, null)) {
                                    insertOffset = Math.min(LintCliFixPerformerKt.access$lineEnd(contents2, offset) + 1, contents2.length());
                                    break;
                                }
                                if (contents2.charAt(offset) == '@') {
                                    offset = LintFixPerformer.Companion.skipAnnotation((CharSequence)contents2, offset);
                                    continue;
                                }
                                insertOffset = LintCliFixPerformerKt.access$lineBegin(contents2, offset);
                                break;
                            }
                        }
                    }
                    String importStatement = isJava ? "import " + (isStaticImport ? "static " : "") + string4 + ";\n" : "import " + string4 + "\n";
                    file.getEdits().add(new LintFixPerformer.PendingEdit((LintFix)replaceFix, insertOffset, insertOffset, importStatement, 0, 0, 0, 112, null));
                }
            }
        }
        return replacement;
    }

    private final String removePackage(String source, String prefix, Set<String> names, boolean isWildcard) {
        if (((CharSequence)prefix).length() == 0) {
            return source;
        }
        StringBuilder sb = new StringBuilder();
        int index = 0;
        while (true) {
            int next;
            String string = source.substring(index, (next = StringsKt.indexOf$default((CharSequence)source, (String)prefix, (int)index, (boolean)false, (int)4, null)) == -1 ? source.length() : next);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            sb.append(string);
            if (next == -1) break;
            if (next > 0 && source.charAt(next - 1) == '\"') {
                sb.append(prefix);
                index = next + prefix.length();
                continue;
            }
            index = next + prefix.length();
            if (isWildcard) {
                String name;
                int nameEnd;
                for (nameEnd = index; nameEnd < source.length() && Character.isJavaIdentifierPart(source.charAt(nameEnd)); ++nameEnd) {
                }
                Intrinsics.checkNotNullExpressionValue((Object)source.substring(index, nameEnd), (String)"substring(...)");
                if (names.contains(name)) {
                    String string2 = source.substring(next, index);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    sb.append(string2);
                    continue;
                }
            }
            if (index != source.length() && Character.isUpperCase(source.charAt(index)) || LintCliFixPerformer.removePackage$isPackageMatchAt(prefix, source, next)) continue;
            String string3 = source.substring(next, index);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            sb.append(string3);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final ImportInfo getExistingImports(CharSequence contents2, boolean allowCommentNesting) {
        boolean bl;
        TreeMap<String, Integer> staticImports;
        TreeMap<String, Integer> imports;
        ImportInfo info;
        block22: {
            int n;
            info = new ImportInfo();
            imports = info.getNonStaticImports();
            staticImports = info.getStaticImports();
            int index = 0;
            int length = contents2.length();
            while (index < length && (index = LintFixPerformer.Companion.skipCommentsAndWhitespace$default((LintFixPerformer.Companion)LintFixPerformer.Companion, (CharSequence)contents2, (int)index, (boolean)allowCommentNesting, (boolean)false, (int)8, null)) != length) {
                int start;
                char c;
                if (CharsKt.isWhitespace((char)(c = contents2.charAt(index++)))) continue;
                if (c == 'p' && StringsKt.startsWith$default((CharSequence)contents2, (CharSequence)"package", (int)(index - 1), (boolean)false, (int)4, null)) {
                    start = index - 1;
                    for (index = start + 7; index < length && CharsKt.isWhitespace((char)contents2.charAt(index)); ++index) {
                    }
                    int symbolStart = index;
                    while (index < length && contents2.charAt(index) != '\n' && contents2.charAt(index) != ';' && contents2.charAt(index) != '/') {
                        ++index;
                    }
                    while (index > 0 && contents2.charAt(index - 1) == ' ') {
                        --index;
                    }
                    String symbol = ((Object)contents2.subSequence(symbolStart, index)).toString();
                    info.setPackageStatement((Pair<String, Integer>)new Pair((Object)symbol, (Object)start));
                    if ((index = StringsKt.indexOf$default((CharSequence)contents2, (char)'\n', (int)index, (boolean)false, (int)4, null) + 1) != 0) continue;
                    break;
                }
                if (c == 'i' && StringsKt.startsWith$default((CharSequence)contents2, (CharSequence)"import", (int)(index - 1), (boolean)false, (int)4, null)) {
                    start = index - 1;
                    for (index = start + 6; index < length && CharsKt.isWhitespace((char)contents2.charAt(index)); ++index) {
                    }
                    boolean isStatic = false;
                    if (StringsKt.startsWith$default((CharSequence)contents2, (CharSequence)"static", (int)index, (boolean)false, (int)4, null) && index + 6 < length && CharsKt.isWhitespace((char)contents2.charAt(index + 6))) {
                        index += 6;
                        isStatic = true;
                    }
                    while (index < length && CharsKt.isWhitespace((char)contents2.charAt(index))) {
                        ++index;
                    }
                    int symbolStart = index;
                    while (index < length && contents2.charAt(index) != '\n' && contents2.charAt(index) != ';' && contents2.charAt(index) != '/') {
                        ++index;
                    }
                    while (index > 0 && contents2.charAt(index - 1) == ' ') {
                        --index;
                    }
                    String symbol = ((Object)contents2.subSequence(symbolStart, index)).toString();
                    if (isStatic) {
                        ((Map)staticImports).put(symbol, start);
                    } else {
                        ((Map)imports).put(symbol, start);
                    }
                    if ((index = StringsKt.indexOf$default((CharSequence)contents2, (char)'\n', (int)index, (boolean)false, (int)4, null) + 1) != 0) continue;
                    break;
                }
                if (c != '@') break;
                index = LintFixPerformer.Companion.skipAnnotation(contents2, index - 1);
            }
            if (!((Map)imports).isEmpty()) {
                Iterator isStatic = ((Iterable)((Map)imports).entrySet()).iterator();
                if (!isStatic.hasNext()) {
                    throw new NoSuchElementException();
                }
                Map.Entry it22 = (Map.Entry)isStatic.next();
                boolean bl2 = false;
                int it22 = ((Number)it22.getValue()).intValue();
                while (isStatic.hasNext()) {
                    Map.Entry it32 = (Map.Entry)isStatic.next();
                    $i$a$-minOf-LintCliFixPerformer$getExistingImports$classImportsStart$1 = false;
                    int it32 = ((Number)it32.getValue()).intValue();
                    if (it22 <= it32) continue;
                    it22 = it32;
                }
                n = it22;
            } else {
                n = 0;
            }
            int classImportsStart = n;
            Map $this$all$iv = staticImports;
            boolean $i$f$all = false;
            if ($this$all$iv.isEmpty()) {
                bl = true;
            } else {
                Iterator it22 = $this$all$iv.entrySet().iterator();
                while (it22.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry it = element$iv = it22.next();
                    boolean bl3 = false;
                    if (((Number)it.getValue()).intValue() < classImportsStart) continue;
                    bl = false;
                    break block22;
                }
                bl = true;
            }
        }
        if (!bl) {
            for (Map.Entry entry : ((Map)staticImports).entrySet()) {
                String key = (String)entry.getKey();
                int value = ((Number)entry.getValue()).intValue();
                ((Map)imports).put(key, value);
            }
            staticImports.clear();
        }
        return info;
    }

    private static final boolean removePackage$isPackageMatchAt(String $prefix, String $source, int next) {
        int i = next + $prefix.length();
        while (i < $source.length()) {
            char c;
            if ((c = $source.charAt(i++)) == '.') {
                return false;
            }
            if (Character.isJavaIdentifierPart(c)) continue;
            return true;
        }
        return true;
    }

    public static final /* synthetic */ boolean access$getIncludeMarkers$p(LintCliFixPerformer $this) {
        return $this.includeMarkers;
    }

    public static final /* synthetic */ String access$injectSelection(LintCliFixPerformer $this, String fileContents, int selectionStartOffset, int selectionEndOffset) {
        return $this.injectSelection(fileContents, selectionStartOffset, selectionEndOffset);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013R(\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/lint/LintCliFixPerformer$ImportInfo;", "", "<init>", "()V", "packageStatement", "Lkotlin/Pair;", "", "", "getPackageStatement", "()Lkotlin/Pair;", "setPackageStatement", "(Lkotlin/Pair;)V", "staticImports", "Ljava/util/TreeMap;", "getStaticImports", "()Ljava/util/TreeMap;", "nonStaticImports", "getNonStaticImports", "qualifiedNames", "", "names", "lint-cli"})
    @SourceDebugExtension(value={"SMAP\nLintCliFixPerformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintCliFixPerformer.kt\ncom/android/tools/lint/LintCliFixPerformer$ImportInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,677:1\n1563#2:678\n1634#2,3:679\n*S KotlinDebug\n*F\n+ 1 LintCliFixPerformer.kt\ncom/android/tools/lint/LintCliFixPerformer$ImportInfo\n*L\n179#1:678\n179#1:679,3\n*E\n"})
    private static final class ImportInfo {
        @Nullable
        private Pair<String, Integer> packageStatement;
        @NotNull
        private final TreeMap<String, Integer> staticImports = new TreeMap();
        @NotNull
        private final TreeMap<String, Integer> nonStaticImports = new TreeMap();

        @Nullable
        public final Pair<String, Integer> getPackageStatement() {
            return this.packageStatement;
        }

        public final void setPackageStatement(@Nullable Pair<String, Integer> pair) {
            this.packageStatement = pair;
        }

        @NotNull
        public final TreeMap<String, Integer> getStaticImports() {
            return this.staticImports;
        }

        @NotNull
        public final TreeMap<String, Integer> getNonStaticImports() {
            return this.nonStaticImports;
        }

        @NotNull
        public final Set<String> qualifiedNames() {
            Set<String> set = this.staticImports.keySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
            Set<String> set2 = this.nonStaticImports.keySet();
            Intrinsics.checkNotNullExpressionValue(set2, (String)"<get-keys>(...)");
            return SetsKt.plus(set, (Iterable)set2);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Set<String> names() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.qualifiedNames();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(StringsKt.substringAfterLast$default((String)it, (char)'.', null, (int)2, null));
            }
            return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u0018\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\u0006H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/lint/LintCliFixPerformer$LintCliFileProvider;", "Lcom/android/tools/lint/client/api/LintFixPerformer$FileProvider;", "<init>", "(Lcom/android/tools/lint/LintCliFixPerformer;)V", "files", "", "Lcom/android/tools/lint/client/api/LintFixPerformer$PendingEditFile;", "", "documents", "Lorg/w3c/dom/Document;", "getFileContents", "file", "getXmlDocument", "createBinaryFile", "", "fileData", "contents", "", "deleteFile", "createXmlDocument", "handleXmlError", "e", "", "lint-cli"})
    @SourceDebugExtension(value={"SMAP\nLintCliFixPerformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintCliFixPerformer.kt\ncom/android/tools/lint/LintCliFixPerformer$LintCliFileProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,677:1\n1#2:678\n*E\n"})
    public final class LintCliFileProvider
    implements LintFixPerformer.FileProvider {
        @NotNull
        private final Map<LintFixPerformer.PendingEditFile, String> files = new LinkedHashMap();
        @NotNull
        private final Map<LintFixPerformer.PendingEditFile, Document> documents = new LinkedHashMap();

        @NotNull
        public String getFileContents(@NotNull LintFixPerformer.PendingEditFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            String string = this.files.get(file);
            if (string == null) {
                String string2;
                String it = string2 = ((Object)LintCliFixPerformer.this.getSourceText(file.getFile())).toString();
                boolean bl = false;
                this.files.put(file, it);
                string = string2;
            }
            return string;
        }

        @Nullable
        public Document getXmlDocument(@NotNull LintFixPerformer.PendingEditFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Document document = this.documents.get(file);
            if (document == null) {
                Document document2;
                Document it = document2 = this.createXmlDocument(file);
                boolean bl = false;
                if (it != null) {
                    this.documents.put(file, it);
                }
                document = document2;
            }
            return document;
        }

        public void createBinaryFile(@NotNull LintFixPerformer.PendingEditFile fileData, @NotNull byte[] contents2) {
            Intrinsics.checkNotNullParameter((Object)fileData, (String)"fileData");
            Intrinsics.checkNotNullParameter((Object)contents2, (String)"contents");
            LintCliFixPerformer.this.writeFile(fileData.getFile(), contents2);
        }

        public void deleteFile(@NotNull LintFixPerformer.PendingEditFile fileData) {
            Intrinsics.checkNotNullParameter((Object)fileData, (String)"fileData");
            LintCliFixPerformer.this.writeFile(fileData.getFile(), (byte[])null);
        }

        private final Document createXmlDocument(LintFixPerformer.PendingEditFile file) {
            try {
                String contents2 = this.getFileContents(file);
                Document document = LintCliFixPerformer.this.client.getXmlDocument(file.getFile(), contents2);
                if (document != null) {
                    Document it = document;
                    boolean bl = false;
                    return it;
                }
                return PositionXmlParser.parse((String)contents2);
            }
            catch (Exception e) {
                Exception exception = e;
                if (!(exception instanceof ParserConfigurationException || exception instanceof SAXException || exception instanceof IOException)) {
                    throw e;
                }
                this.handleXmlError(e, file);
                return null;
            }
        }

        private final void handleXmlError(Throwable e, LintFixPerformer.PendingEditFile file) {
            LintCliFixPerformer.this.client.log(Severity.WARNING, e, "Ignoring " + file + ": Failed to parse XML: " + e, new Object[0]);
        }
    }
}

