/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.preloading.instrumentation;

import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.kotlin.preloading.instrumentation.FieldData;
import org.jetbrains.kotlin.preloading.instrumentation.MethodData;
import org.jetbrains.kotlin.preloading.instrumentation.MethodInstrumenter;
import org.jetbrains.kotlin.preloading.instrumentation.annotations.AllArgs;
import org.jetbrains.kotlin.preloading.instrumentation.annotations.ClassName;
import org.jetbrains.kotlin.preloading.instrumentation.annotations.MethodDesc;
import org.jetbrains.kotlin.preloading.instrumentation.annotations.MethodInterceptor;
import org.jetbrains.kotlin.preloading.instrumentation.annotations.MethodName;
import org.jetbrains.kotlin.preloading.instrumentation.annotations.This;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.util.Printer;
import org.jetbrains.org.objectweb.asm.util.Textifier;
import org.jetbrains.org.objectweb.asm.util.TraceMethodVisitor;

public class InterceptionInstrumenter {
    private static final Pattern ANYTHING = Pattern.compile(".*");
    private static final Type OBJECT_TYPE = Type.getType(Object.class);
    private final Map<String, ClassMatcher> classPatterns = new LinkedHashMap<String, ClassMatcher>();
    private final Set<String> neverMatchedClassPatterns = new LinkedHashSet<String>();
    private final Set<MethodInstrumenter> neverMatchedInstrumenters = new LinkedHashSet<MethodInstrumenter>();
    private final List<DumpAction> dumpTasks = new ArrayList<DumpAction>();

    public InterceptionInstrumenter(List<Class<?>> handlerClasses) {
        for (Class<?> handlerClass : handlerClasses) {
            this.addHandlerClass(handlerClass);
        }
    }

    private void addHandlerClass(Class<?> handlerClass) {
        for (Field field : handlerClass.getFields()) {
            MethodInterceptor annotation = field.getAnnotation(MethodInterceptor.class);
            if (annotation == null) continue;
            if ((field.getModifiers() & 8) == 0) {
                throw new IllegalArgumentException("Non-static field annotated @MethodInterceptor: " + field);
            }
            Pattern classPattern = InterceptionInstrumenter.compilePattern(annotation.className());
            List<MethodInstrumenter> instrumenters = this.addClassPattern(classPattern);
            try {
                String nameFromAnnotation;
                Object interceptor = field.get(null);
                if (interceptor == null) {
                    throw new IllegalArgumentException("Interceptor is null: " + field);
                }
                Class<?> interceptorClass = interceptor.getClass();
                FieldData fieldData = InterceptionInstrumenter.getFieldData(field, interceptorClass);
                ArrayList<MethodData> enterData = new ArrayList<MethodData>();
                ArrayList<MethodData> normalReturnData = new ArrayList<MethodData>();
                ArrayList<MethodData> exceptionData = new ArrayList<MethodData>();
                ArrayList<Method> dumpMethods = new ArrayList<Method>();
                for (Method method : interceptorClass.getMethods()) {
                    Class<?>[] parameterTypes;
                    String name2 = method.getName();
                    MethodData methodData = InterceptionInstrumenter.getMethodData(fieldData, method);
                    if (name2.startsWith("enter")) {
                        enterData.add(methodData);
                        continue;
                    }
                    if (name2.startsWith("normalReturn")) {
                        normalReturnData.add(methodData);
                        continue;
                    }
                    if (name2.startsWith("exception")) {
                        exceptionData.add(methodData);
                        continue;
                    }
                    if (name2.startsWith("exit")) {
                        normalReturnData.add(methodData);
                        exceptionData.add(methodData);
                        continue;
                    }
                    if (!name2.startsWith("dump") || (parameterTypes = method.getParameterTypes()).length > 1 || parameterTypes.length == 1 && parameterTypes[0] != PrintStream.class) continue;
                    dumpMethods.add(method);
                }
                if (enterData.isEmpty() && normalReturnData.isEmpty() && exceptionData.isEmpty()) {
                    this.dumpTasks.add(out -> out.println("WARNING: No relevant methods found in " + field + " of type " + interceptorClass.getCanonicalName()));
                }
                String methodName = (nameFromAnnotation = annotation.methodName()).isEmpty() ? field.getName() : nameFromAnnotation;
                MethodInstrumenter instrumenter = new MethodInstrumenter(field.getDeclaringClass().getSimpleName() + "." + field.getName(), classPattern, InterceptionInstrumenter.compilePattern(methodName), InterceptionInstrumenter.compilePattern(annotation.methodDesc()), annotation.allowMultipleMatches(), enterData, normalReturnData, exceptionData, annotation.logInterceptions(), annotation.dumpByteCode());
                for (Method dumpMethod : dumpMethods) {
                    this.addDumpTask(interceptor, dumpMethod, instrumenter);
                }
                instrumenters.add(instrumenter);
                this.neverMatchedInstrumenters.add(instrumenter);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    private List<MethodInstrumenter> addClassPattern(Pattern classPattern) {
        ClassMatcher classMatcher = this.classPatterns.get(classPattern.pattern());
        if (classMatcher == null) {
            classMatcher = new ClassMatcher(classPattern);
            this.classPatterns.put(classPattern.pattern(), classMatcher);
            this.neverMatchedClassPatterns.add(classPattern.pattern());
        }
        return classMatcher.instrumenters;
    }

    private static FieldData getFieldData(Field field, Class<?> runtimeType) {
        return new FieldData(Type.getInternalName(field.getDeclaringClass()), field.getName(), Type.getDescriptor(field.getType()), Type.getType(runtimeType));
    }

    private static MethodData getMethodData(FieldData interceptorField, Method method) {
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        int thisParameterIndex = -1;
        int classNameParameterIndex = -1;
        int methodNameParameterIndex = -1;
        int methodDescParameterIndex = -1;
        int allArgsParameterIndex = -1;
        for (int i2 = 0; i2 < parameterAnnotations.length; ++i2) {
            for (Annotation annotation : parameterAnnotations[i2]) {
                if (annotation instanceof This) {
                    if (thisParameterIndex > -1) {
                        throw new IllegalArgumentException("Multiple @This parameters in " + method);
                    }
                    thisParameterIndex = i2;
                    continue;
                }
                if (annotation instanceof ClassName) {
                    if (classNameParameterIndex > -1) {
                        throw new IllegalArgumentException("Multiple @ClassName parameters in " + method);
                    }
                    classNameParameterIndex = i2;
                    continue;
                }
                if (annotation instanceof MethodName) {
                    if (methodNameParameterIndex > -1) {
                        throw new IllegalArgumentException("Multiple @MethodName parameters in " + method);
                    }
                    methodNameParameterIndex = i2;
                    continue;
                }
                if (annotation instanceof MethodDesc) {
                    if (methodDescParameterIndex > -1) {
                        throw new IllegalArgumentException("Multiple @MethodDesc parameters in " + method);
                    }
                    methodDescParameterIndex = i2;
                    continue;
                }
                if (!(annotation instanceof AllArgs)) continue;
                if (allArgsParameterIndex > -1) {
                    throw new IllegalArgumentException("Multiple @AllArgs parameters in " + method);
                }
                allArgsParameterIndex = i2;
            }
        }
        return new MethodData(interceptorField, Type.getInternalName(method.getDeclaringClass()), method.getName(), Type.getMethodDescriptor((Method)method), thisParameterIndex, classNameParameterIndex, methodNameParameterIndex, methodDescParameterIndex, allArgsParameterIndex);
    }

    private void addDumpTask(Object interceptor, Method method, MethodInstrumenter instrumenter) {
        this.dumpTasks.add(out -> {
            out.println("<<< " + instrumenter + ": " + interceptor.getClass().getName() + " says:");
            try {
                if (method.getParameterTypes().length == 0) {
                    method.invoke(interceptor, new Object[0]);
                } else {
                    method.invoke(interceptor, out);
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
            out.println(">>>");
            out.println();
        });
    }

    public byte[] instrument(String resourceName, byte[] data) {
        try {
            String className = InterceptionInstrumenter.stripClassSuffix(resourceName);
            if (className == null) {
                return data;
            }
            ArrayList<MethodInstrumenter> applicableInstrumenters = new ArrayList<MethodInstrumenter>();
            for (Map.Entry<String, ClassMatcher> classPatternEntry : this.classPatterns.entrySet()) {
                String classPattern = classPatternEntry.getKey();
                ClassMatcher classMatcher = classPatternEntry.getValue();
                if (!classMatcher.classPattern.matcher(className).matches()) continue;
                this.neverMatchedClassPatterns.remove(classPattern);
                applicableInstrumenters.addAll(classMatcher.instrumenters);
            }
            if (applicableInstrumenters.isEmpty()) {
                return data;
            }
            return this.instrument(data, applicableInstrumenters);
        }
        catch (Throwable e) {
            throw new IllegalStateException("Exception while instrumenting " + resourceName, e);
        }
    }

    private static String stripClassSuffix(String name2) {
        String suffix = ".class";
        if (!name2.endsWith(suffix)) {
            return null;
        }
        return name2.substring(0, name2.length() - suffix.length());
    }

    private byte[] instrument(byte[] classData, final List<MethodInstrumenter> instrumenters) {
        final ClassReader cr = new ClassReader(classData);
        ClassWriter cw = new ClassWriter(cr, 0);
        cr.accept(new ClassVisitor(589824, (ClassVisitor)cw){
            private final Map<MethodInstrumenter, String> matchedMethods;
            {
                super(x0, x1);
                this.matchedMethods = new HashMap<MethodInstrumenter, String>();
            }

            public MethodVisitor visitMethod(final int access, final String name2, final String desc, String signature, String[] exceptions) {
                MethodVisitor mv2 = super.visitMethod(access, name2, desc, signature, exceptions);
                if ((access & 0x1040) != 0) {
                    return mv2;
                }
                ArrayList<MethodInstrumenter> applicableInstrumenters = new ArrayList<MethodInstrumenter>();
                for (MethodInstrumenter instrumenter : instrumenters) {
                    if (!instrumenter.isApplicable(name2, desc)) continue;
                    applicableInstrumenters.add(instrumenter);
                    instrumenter.reportApplication(cr.getClassName(), name2, desc);
                    this.checkMultipleMatches(instrumenter, name2, desc);
                    InterceptionInstrumenter.this.neverMatchedInstrumenters.remove(instrumenter);
                }
                if (applicableInstrumenters.isEmpty()) {
                    return mv2;
                }
                boolean dumpByteCode = false;
                final ArrayList<MethodData> normalReturnData = new ArrayList<MethodData>();
                final ArrayList<MethodData> enterData = new ArrayList<MethodData>();
                final ArrayList<MethodData> exceptionData = new ArrayList<MethodData>();
                for (MethodInstrumenter instrumenter : applicableInstrumenters) {
                    enterData.addAll(instrumenter.getEnterData());
                    normalReturnData.addAll(instrumenter.getNormalReturnData());
                    exceptionData.addAll(instrumenter.getExceptionData());
                    dumpByteCode |= instrumenter.shouldDumpByteCode();
                }
                if (enterData.isEmpty() && normalReturnData.isEmpty() && exceptionData.isEmpty()) {
                    return mv2;
                }
                if (dumpByteCode) {
                    mv2 = this.getDumpingVisitorWrapper(mv2, name2, desc);
                }
                final int maxStackDepth = this.getMaxStackDepth(name2, desc, normalReturnData, enterData, exceptionData);
                final boolean isConstructor = "<init>".equals(name2);
                return new MethodVisitor(589824, mv2){
                    private InstructionAdapter ia;
                    {
                        super(x0, x1);
                        this.ia = null;
                    }

                    private InstructionAdapter getInstructionAdapter() {
                        if (this.ia == null) {
                            this.ia = new InstructionAdapter((MethodVisitor)this);
                        }
                        return this.ia;
                    }

                    public void visitMaxs(int maxStack, int maxLocals) {
                        super.visitMaxs(Math.max(maxStack, maxStackDepth), maxLocals);
                    }

                    public void visitCode() {
                        for (MethodData methodData : enterData) {
                            InterceptionInstrumenter.invokeMethod(access, cr.getClassName(), name2, desc, this.getInstructionAdapter(), methodData, isConstructor);
                        }
                        super.visitCode();
                    }

                    public void visitInsn(int opcode) {
                        switch (opcode) {
                            case 172: 
                            case 173: 
                            case 174: 
                            case 175: 
                            case 176: 
                            case 177: {
                                for (MethodData methodData : normalReturnData) {
                                    InterceptionInstrumenter.invokeMethod(access, cr.getClassName(), name2, desc, this.getInstructionAdapter(), methodData, false);
                                }
                                break;
                            }
                            case 191: {
                                for (MethodData methodData : exceptionData) {
                                    InterceptionInstrumenter.invokeMethod(access, cr.getClassName(), name2, desc, this.getInstructionAdapter(), methodData, isConstructor);
                                }
                                break;
                            }
                        }
                        super.visitInsn(opcode);
                    }
                };
            }

            private int getMaxStackDepth(String name2, String desc, List<MethodData> normalReturnData, List<MethodData> enterData, List<MethodData> exceptionData) {
                org.jetbrains.org.objectweb.asm.commons.Method methodBeingInstrumented = new org.jetbrains.org.objectweb.asm.commons.Method(name2, desc);
                ArrayList<MethodData> allData = new ArrayList<MethodData>();
                allData.addAll(enterData);
                allData.addAll(exceptionData);
                allData.addAll(normalReturnData);
                int maxStackDepth = 0;
                for (MethodData methodData : allData) {
                    int depth = this.stackDepth(methodData, methodBeingInstrumented);
                    if (maxStackDepth >= depth) continue;
                    maxStackDepth = depth;
                }
                return maxStackDepth;
            }

            private int stackDepth(MethodData methodData, org.jetbrains.org.objectweb.asm.commons.Method methodBeingInstrumented) {
                org.jetbrains.org.objectweb.asm.commons.Method method = InterceptionInstrumenter.getAsmMethod(methodData);
                int allArgsStackDepth = methodData.getAllArgsParameterIndex() >= 0 ? 5 : 0;
                int argsSize = 0;
                for (Type type : method.getArgumentTypes()) {
                    argsSize += type.getSize();
                }
                int receiverSize = 1;
                int exceptionSize = 1;
                int returnValueSize = methodBeingInstrumented.getReturnType().getSize();
                return argsSize + allArgsStackDepth + receiverSize + Math.max(returnValueSize, exceptionSize);
            }

            private void checkMultipleMatches(MethodInstrumenter instrumenter, String name2, String desc) {
                String erasedSignature;
                String alreadyMatched;
                if (!instrumenter.allowsMultipleMatches() && (alreadyMatched = this.matchedMethods.put(instrumenter, erasedSignature = name2 + desc)) != null) {
                    throw new IllegalStateException(instrumenter + " matched two methods in " + cr.getClassName() + ":\n" + alreadyMatched + "\n" + erasedSignature);
                }
            }

            private TraceMethodVisitor getDumpingVisitorWrapper(MethodVisitor mv2, final String methodName, final String methodDesc) {
                return new TraceMethodVisitor(mv2, (Printer)new Textifier(589824){

                    public void visitMethodEnd() {
                        System.out.println(cr.getClassName() + ":" + methodName + methodDesc);
                        for (Object line : this.getText()) {
                            System.out.print(line);
                        }
                        System.out.println();
                        System.out.println();
                        super.visitMethodEnd();
                    }
                });
            }
        }, 0);
        return cw.toByteArray();
    }

    private static org.jetbrains.org.objectweb.asm.commons.Method getAsmMethod(MethodData methodData) {
        return new org.jetbrains.org.objectweb.asm.commons.Method(methodData.getName(), methodData.getDesc());
    }

    private static void invokeMethod(int instrumentedMethodAccess, String instrumentedClassName, String instrumentedMethodName, String instrumentedMethodDesc, InstructionAdapter ia, MethodData methodData, boolean thisUnavailable) {
        FieldData field = methodData.getOwnerField();
        ia.getstatic(field.getDeclaringClass(), field.getName(), field.getDesc());
        ia.checkcast(Type.getObjectType((String)methodData.getDeclaringClass()));
        org.jetbrains.org.objectweb.asm.commons.Method asmMethod = InterceptionInstrumenter.getAsmMethod(methodData);
        Type[] interceptingMethodParameterTypes = asmMethod.getArgumentTypes();
        int parameterCount = interceptingMethodParameterTypes.length;
        if (parameterCount > 0) {
            Type[] instrumentedMethodParameterTypes = Type.getArgumentTypes((String)instrumentedMethodDesc);
            boolean isStatic = (instrumentedMethodAccess & 8) != 0;
            int base = isStatic ? 0 : 1;
            int instrumentedMethodParameterIndex = 0;
            int instrumentedMethodParameterOffset = 0;
            for (int i2 = 0; i2 < parameterCount; ++i2) {
                if (i2 == methodData.getThisParameterIndex()) {
                    if (isStatic || thisUnavailable) {
                        ia.aconst(null);
                        continue;
                    }
                    ia.load(0, OBJECT_TYPE);
                    continue;
                }
                if (i2 == methodData.getClassNameParameterIndex()) {
                    ia.aconst((Object)instrumentedClassName);
                    continue;
                }
                if (i2 == methodData.getMethodNameParameterIndex()) {
                    ia.aconst((Object)instrumentedMethodName);
                    continue;
                }
                if (i2 == methodData.getMethodDescParameterIndex()) {
                    ia.aconst((Object)instrumentedMethodDesc);
                    continue;
                }
                if (i2 == methodData.getAllArgsParameterIndex()) {
                    ia.aconst((Object)instrumentedMethodParameterTypes.length);
                    ia.newarray(OBJECT_TYPE);
                    int offset = 0;
                    for (int parameterIndex = 0; parameterIndex < instrumentedMethodParameterTypes.length; ++parameterIndex) {
                        ia.dup();
                        ia.iconst(parameterIndex);
                        Type type = instrumentedMethodParameterTypes[parameterIndex];
                        ia.load(base + offset, type);
                        offset += type.getSize();
                        InterceptionInstrumenter.boxOrCastIfNeeded(ia, type, OBJECT_TYPE);
                        ia.astore(OBJECT_TYPE);
                    }
                    continue;
                }
                Type type = instrumentedMethodParameterTypes[instrumentedMethodParameterIndex];
                ia.load(base + instrumentedMethodParameterOffset, type);
                InterceptionInstrumenter.boxOrCastIfNeeded(ia, type, interceptingMethodParameterTypes[i2]);
                ++instrumentedMethodParameterIndex;
                instrumentedMethodParameterOffset += type.getSize();
            }
        }
        ia.invokevirtual(methodData.getDeclaringClass(), methodData.getName(), methodData.getDesc(), false);
        Type type = asmMethod.getReturnType();
        if (type.getSort() != 0) {
            if (type.getSize() == 1) {
                ia.pop();
            } else {
                ia.pop2();
            }
        }
    }

    private static void boxOrCastIfNeeded(InstructionAdapter ia, Type from2, Type to) {
        if (InterceptionInstrumenter.isPrimitive(to)) {
            if (!InterceptionInstrumenter.isPrimitive(from2)) {
                throw new IllegalArgumentException("Cannot cast " + from2 + " to " + to);
            }
            ia.cast(from2, to);
            return;
        }
        switch (from2.getSort()) {
            case 1: {
                InterceptionInstrumenter.box(ia, from2, Boolean.class);
                break;
            }
            case 2: {
                InterceptionInstrumenter.box(ia, from2, Character.class);
                break;
            }
            case 3: {
                InterceptionInstrumenter.box(ia, from2, Byte.class);
                break;
            }
            case 4: {
                InterceptionInstrumenter.box(ia, from2, Short.class);
                break;
            }
            case 5: {
                InterceptionInstrumenter.box(ia, from2, Integer.class);
                break;
            }
            case 6: {
                InterceptionInstrumenter.box(ia, from2, Float.class);
                break;
            }
            case 7: {
                InterceptionInstrumenter.box(ia, from2, Long.class);
                break;
            }
            case 8: {
                InterceptionInstrumenter.box(ia, from2, Double.class);
                break;
            }
        }
    }

    private static boolean isPrimitive(Type to) {
        return to.getSort() <= 8;
    }

    private static void box(InstructionAdapter ia, Type from2, Class<?> boxedClass) {
        Type boxedType = Type.getType(boxedClass);
        ia.invokestatic(boxedType.getInternalName(), "valueOf", "(" + from2.getDescriptor() + ")" + boxedType.getDescriptor(), false);
    }

    public void dump(PrintStream out) {
        for (DumpAction task : this.dumpTasks) {
            task.dump(out);
        }
        if (!this.neverMatchedClassPatterns.isEmpty()) {
            out.println("Class patterns never matched:");
            for (String classPattern : this.neverMatchedClassPatterns) {
                out.println("    " + classPattern);
                this.neverMatchedInstrumenters.removeAll(this.classPatterns.get(classPattern).instrumenters);
            }
        }
        if (!this.neverMatchedInstrumenters.isEmpty()) {
            out.println("Instrumenters never matched: ");
            for (MethodInstrumenter instrumenter : this.neverMatchedInstrumenters) {
                out.println("    " + instrumenter);
            }
        }
    }

    private static Pattern compilePattern(String regex) {
        if (regex.isEmpty()) {
            return ANYTHING;
        }
        return Pattern.compile(regex);
    }

    private static class ClassMatcher {
        private final Pattern classPattern;
        private final List<MethodInstrumenter> instrumenters = new ArrayList<MethodInstrumenter>();

        private ClassMatcher(Pattern classPattern) {
            this.classPattern = classPattern;
        }
    }

    static interface DumpAction {
        public void dump(PrintStream var1);
    }
}

