/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.boxing;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.optimization.boxing.BoxingInterpreter;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;
import org.jetbrains.org.objectweb.asm.tree.analysis.Value;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J&\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u00012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/boxing/BoxingFrame;", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "nLocals", "", "nStack", "<init>", "(II)V", "merge", "", "frame", "interpreter", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Interpreter;", "backend"})
public final class BoxingFrame
extends Frame<BasicValue> {
    public BoxingFrame(int nLocals, int nStack) {
        super(nLocals, nStack);
    }

    public boolean merge(@NotNull Frame<? extends BasicValue> frame, @NotNull Interpreter<BasicValue> interpreter2) {
        BasicValue merged;
        int i2;
        Intrinsics.checkNotNullParameter(frame, (String)"frame");
        Intrinsics.checkNotNullParameter(interpreter2, (String)"interpreter");
        if (this.getStackSize() != frame.getStackSize()) {
            throw new AnalyzerException(null, "Incompatible stack heights");
        }
        BoxingInterpreter boxingInterpreter = (BoxingInterpreter)interpreter2;
        boolean changed = false;
        int n = this.getLocals();
        for (i2 = 0; i2 < n; ++i2) {
            BasicValue local = (BasicValue)this.getLocal(i2);
            Intrinsics.checkNotNull((Object)local);
            Value value2 = frame.getLocal(i2);
            Intrinsics.checkNotNullExpressionValue((Object)value2, (String)"getLocal(...)");
            merged = boxingInterpreter.mergeLocalVariableValues(local, (BasicValue)value2);
            if (Intrinsics.areEqual((Object)local, (Object)merged)) continue;
            this.setLocal(i2, (Value)merged);
            changed = true;
        }
        n = this.getStackSize();
        for (i2 = 0; i2 < n; ++i2) {
            BasicValue onStack = (BasicValue)this.getStack(i2);
            Intrinsics.checkNotNull((Object)onStack);
            Value value3 = frame.getStack(i2);
            Intrinsics.checkNotNullExpressionValue((Object)value3, (String)"getStack(...)");
            merged = boxingInterpreter.mergeStackValues(onStack, (BasicValue)value3);
            if (Intrinsics.areEqual((Object)onStack, (Object)merged)) continue;
            this.setStack(i2, (Value)merged);
            changed = true;
        }
        return changed;
    }
}

