/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.actualizer;

import java.io.File;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.actualizer.ClassActualizationInfo;
import org.jetbrains.kotlin.backend.common.actualizer.ExpectActualCollectorKt;
import org.jetbrains.kotlin.backend.common.actualizer.IrActualizerUtilsKt;
import org.jetbrains.kotlin.backend.common.actualizer.IrExpectActualMap;
import org.jetbrains.kotlin.backend.common.actualizer.IrExpectActualMatchingContext;
import org.jetbrains.kotlin.backend.common.actualizer.IrMissingActualDeclarationProvider;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.ir.IrDiagnosticReporter;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContext;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitor;
import org.jetbrains.kotlin.mpp.DeclarationSymbolMarker;
import org.jetbrains.kotlin.mpp.RegularClassSymbolMarker;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.calls.mpp.AbstractExpectActualChecker;
import org.jetbrains.kotlin.resolve.calls.mpp.AbstractExpectActualMatcher;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectActualIncompatibility;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectActualMatchingCompatibility;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0002\n\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/backend/common/actualizer/ExpectActualLinkCollector;", "", "<init>", "()V", "collectAndCheckMapping", "", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "data", "Lorg/jetbrains/kotlin/backend/common/actualizer/ExpectActualLinkCollector$MatchingContext;", "ExpectActualLinkCollectorVisitor", "MatchingContext", "ir.actualization"})
public final class ExpectActualLinkCollector {
    public final void collectAndCheckMapping(@NotNull IrModuleFragment declaration, @NotNull MatchingContext data) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        ExpectActualLinkCollectorVisitor.INSTANCE.visitModuleFragment(declaration, data);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\n\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\f\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u0003H\u0016J \u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\u0018\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\u0003H\u0016J$\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u00192\u0006\u0010\u0012\u001a\u00020\u0003J\u0018\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\u0003H\u0016\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/backend/common/actualizer/ExpectActualLinkCollector$ExpectActualLinkCollectorVisitor;", "Lorg/jetbrains/kotlin/ir/visitors/IrVisitor;", "", "Lorg/jetbrains/kotlin/backend/common/actualizer/ExpectActualLinkCollector$MatchingContext;", "<init>", "()V", "visitFile", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "data", "visitFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "visitProperty", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "matchExpectTopLevelCallable", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "callableId", "Lorg/jetbrains/kotlin/name/CallableId;", "context", "visitClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "matchAndCheckExpectTopLevelDeclaration", "expectSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "actualSymbols", "", "visitElement", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "ir.actualization"})
    private static final class ExpectActualLinkCollectorVisitor
    extends IrVisitor<Unit, MatchingContext> {
        @NotNull
        public static final ExpectActualLinkCollectorVisitor INSTANCE = new ExpectActualLinkCollectorVisitor();

        private ExpectActualLinkCollectorVisitor() {
        }

        @Override
        public void visitFile(@NotNull IrFile declaration, @NotNull MatchingContext data) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            super.visitFile(declaration, data.withNewCurrentFile(declaration));
        }

        @Override
        public void visitFunction(@NotNull IrFunction declaration, @NotNull MatchingContext data) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (declaration.isExpect()) {
                this.matchExpectTopLevelCallable(declaration, AdditionalIrUtilsKt.getCallableId(declaration), data);
            }
        }

        @Override
        public void visitProperty(@NotNull IrProperty declaration, @NotNull MatchingContext data) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (declaration.isExpect()) {
                this.matchExpectTopLevelCallable(declaration, AdditionalIrUtilsKt.getCallableId(declaration), data);
            }
        }

        private final void matchExpectTopLevelCallable(IrDeclarationWithName declaration, CallableId callableId, MatchingContext context2) {
            IrSymbol irSymbol = declaration.getSymbol();
            List list = context2.getClassActualizationInfo().getActualTopLevels().get(callableId);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            this.matchAndCheckExpectTopLevelDeclaration(irSymbol, list, context2);
        }

        @Override
        public void visitClass(@NotNull IrClass declaration, @NotNull MatchingContext data) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (!declaration.isExpect()) {
                return;
            }
            ClassId classId = AdditionalIrUtilsKt.getClassIdOrFail(declaration);
            IrClassSymbol expectClassSymbol = declaration.getSymbol();
            IrSymbol actualClassLikeSymbol = data.getClassActualizationInfo().getActualWithoutExpansion(classId);
            this.matchAndCheckExpectTopLevelDeclaration(expectClassSymbol, CollectionsKt.listOfNotNull((Object)actualClassLikeSymbol), data);
        }

        public final void matchAndCheckExpectTopLevelDeclaration(@NotNull IrSymbol expectSymbol, @NotNull List<? extends IrSymbol> actualSymbols, @NotNull MatchingContext context2) {
            Intrinsics.checkNotNullParameter((Object)expectSymbol, (String)"expectSymbol");
            Intrinsics.checkNotNullParameter(actualSymbols, (String)"actualSymbols");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            DeclarationSymbolMarker matched = AbstractExpectActualMatcher.INSTANCE.matchSingleExpectTopLevelDeclarationAgainstPotentialActuals(expectSymbol, actualSymbols, context2);
            if (matched != null) {
                AbstractExpectActualChecker.INSTANCE.checkSingleExpectTopLevelDeclarationAgainstMatchedActual(expectSymbol, matched, context2, context2.getLanguageVersionSettings());
            }
        }

        @Override
        public void visitElement(@NotNull IrElement element, @NotNull MatchingContext data) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            element.acceptChildren(this, data);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011B5\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\u0010\u0010\u0012J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u000fJ\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&H\u0016J8\u0010(\u001a\u00020$2\u0006\u0010%\u001a\u00020)2\u0006\u0010'\u001a\u00020)2\n\u0010*\u001a\u0006\u0012\u0002\b\u00030+2\b\u0010,\u001a\u0004\u0018\u00010-2\b\u0010.\u001a\u0004\u0018\u00010-H\u0016J>\u0010/\u001a\u00020$2\u0006\u0010%\u001a\u00020)2\u0018\u00100\u001a\u0014\u0012\u0004\u0012\u000202\u0012\n\u0012\b\u0012\u0004\u0012\u00020)03012\b\u0010,\u001a\u0004\u0018\u00010-2\b\u0010.\u001a\u0004\u0018\u00010-H\u0016J\u0014\u00104\u001a\u00020$*\u00020\u00072\u0006\u0010'\u001a\u00020&H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0017\u001a\u0004\u0018\u00010\u00188BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001d\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/backend/common/actualizer/ExpectActualLinkCollector$MatchingContext;", "Lorg/jetbrains/kotlin/backend/common/actualizer/IrExpectActualMatchingContext;", "typeSystemContext", "Lorg/jetbrains/kotlin/ir/types/IrTypeSystemContext;", "diagnosticsReporter", "Lorg/jetbrains/kotlin/ir/IrDiagnosticReporter;", "expectActualTracker", "Lorg/jetbrains/kotlin/incremental/components/ExpectActualTracker;", "classActualizationInfo", "Lorg/jetbrains/kotlin/backend/common/actualizer/ClassActualizationInfo;", "missingActualProvider", "Lorg/jetbrains/kotlin/backend/common/actualizer/IrMissingActualDeclarationProvider;", "expectActualMap", "Lorg/jetbrains/kotlin/backend/common/actualizer/IrExpectActualMap;", "currentExpectFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "<init>", "(Lorg/jetbrains/kotlin/ir/types/IrTypeSystemContext;Lorg/jetbrains/kotlin/ir/IrDiagnosticReporter;Lorg/jetbrains/kotlin/incremental/components/ExpectActualTracker;Lorg/jetbrains/kotlin/backend/common/actualizer/ClassActualizationInfo;Lorg/jetbrains/kotlin/backend/common/actualizer/IrMissingActualDeclarationProvider;Lorg/jetbrains/kotlin/backend/common/actualizer/IrExpectActualMap;Lorg/jetbrains/kotlin/ir/declarations/IrFile;)V", "(Lorg/jetbrains/kotlin/ir/types/IrTypeSystemContext;Lorg/jetbrains/kotlin/ir/IrDiagnosticReporter;Lorg/jetbrains/kotlin/incremental/components/ExpectActualTracker;Lorg/jetbrains/kotlin/backend/common/actualizer/ClassActualizationInfo;Lorg/jetbrains/kotlin/backend/common/actualizer/IrMissingActualDeclarationProvider;)V", "getClassActualizationInfo", "()Lorg/jetbrains/kotlin/backend/common/actualizer/ClassActualizationInfo;", "getExpectActualMap", "()Lorg/jetbrains/kotlin/backend/common/actualizer/IrExpectActualMap;", "currentExpectIoFile", "Ljava/io/File;", "getCurrentExpectIoFile", "()Ljava/io/File;", "currentExpectIoFile$delegate", "Lkotlin/Lazy;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "withNewCurrentFile", "newCurrentFile", "onMatchedDeclarations", "", "expectSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "actualSymbol", "onIncompatibleMembersFromClassScope", "Lorg/jetbrains/kotlin/mpp/DeclarationSymbolMarker;", "incompatibility", "Lorg/jetbrains/kotlin/resolve/multiplatform/ExpectActualIncompatibility;", "containingExpectClassSymbol", "Lorg/jetbrains/kotlin/mpp/RegularClassSymbolMarker;", "containingActualClassSymbol", "onMismatchedMembersFromClassScope", "actualSymbolsByIncompatibility", "", "Lorg/jetbrains/kotlin/resolve/multiplatform/ExpectActualMatchingCompatibility$Mismatch;", "", "reportWithCurrentFile", "ir.actualization"})
    @SourceDebugExtension(value={"SMAP\nExpectActualCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpectActualCollector.kt\norg/jetbrains/kotlin/backend/common/actualizer/ExpectActualLinkCollector$MatchingContext\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,515:1\n1#2:516\n*E\n"})
    public static final class MatchingContext
    extends IrExpectActualMatchingContext {
        @NotNull
        private final IrDiagnosticReporter diagnosticsReporter;
        @Nullable
        private final ExpectActualTracker expectActualTracker;
        @NotNull
        private final ClassActualizationInfo classActualizationInfo;
        @Nullable
        private final IrMissingActualDeclarationProvider missingActualProvider;
        @NotNull
        private final IrExpectActualMap expectActualMap;
        @Nullable
        private final IrFile currentExpectFile;
        @NotNull
        private final Lazy currentExpectIoFile$delegate;

        public MatchingContext(@NotNull IrTypeSystemContext typeSystemContext2, @NotNull IrDiagnosticReporter diagnosticsReporter, @Nullable ExpectActualTracker expectActualTracker, @NotNull ClassActualizationInfo classActualizationInfo, @Nullable IrMissingActualDeclarationProvider missingActualProvider, @NotNull IrExpectActualMap expectActualMap, @Nullable IrFile currentExpectFile) {
            Intrinsics.checkNotNullParameter((Object)typeSystemContext2, (String)"typeSystemContext");
            Intrinsics.checkNotNullParameter((Object)diagnosticsReporter, (String)"diagnosticsReporter");
            Intrinsics.checkNotNullParameter((Object)classActualizationInfo, (String)"classActualizationInfo");
            Intrinsics.checkNotNullParameter((Object)expectActualMap, (String)"expectActualMap");
            super(typeSystemContext2, classActualizationInfo.getActualClasses());
            this.diagnosticsReporter = diagnosticsReporter;
            this.expectActualTracker = expectActualTracker;
            this.classActualizationInfo = classActualizationInfo;
            this.missingActualProvider = missingActualProvider;
            this.expectActualMap = expectActualMap;
            this.currentExpectFile = currentExpectFile;
            this.currentExpectIoFile$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> MatchingContext.currentExpectIoFile_delegate$lambda$0(this));
        }

        @NotNull
        public final ClassActualizationInfo getClassActualizationInfo() {
            return this.classActualizationInfo;
        }

        @NotNull
        public final IrExpectActualMap getExpectActualMap() {
            return this.expectActualMap;
        }

        public MatchingContext(@NotNull IrTypeSystemContext typeSystemContext2, @NotNull IrDiagnosticReporter diagnosticsReporter, @Nullable ExpectActualTracker expectActualTracker, @NotNull ClassActualizationInfo classActualizationInfo, @Nullable IrMissingActualDeclarationProvider missingActualProvider) {
            Intrinsics.checkNotNullParameter((Object)typeSystemContext2, (String)"typeSystemContext");
            Intrinsics.checkNotNullParameter((Object)diagnosticsReporter, (String)"diagnosticsReporter");
            Intrinsics.checkNotNullParameter((Object)classActualizationInfo, (String)"classActualizationInfo");
            this(typeSystemContext2, diagnosticsReporter, expectActualTracker, classActualizationInfo, missingActualProvider, new IrExpectActualMap(), null);
        }

        private final File getCurrentExpectIoFile() {
            Lazy lazy = this.currentExpectIoFile$delegate;
            return (File)lazy.getValue();
        }

        @NotNull
        public final LanguageVersionSettings getLanguageVersionSettings() {
            return this.diagnosticsReporter.getLanguageVersionSettings();
        }

        @NotNull
        public final MatchingContext withNewCurrentFile(@NotNull IrFile newCurrentFile) {
            Intrinsics.checkNotNullParameter((Object)newCurrentFile, (String)"newCurrentFile");
            return new MatchingContext(this.getTypeContext(), this.diagnosticsReporter, this.expectActualTracker, this.classActualizationInfo, this.missingActualProvider, this.expectActualMap, newCurrentFile);
        }

        @Override
        public void onMatchedDeclarations(@NotNull IrSymbol expectSymbol, @NotNull IrSymbol actualSymbol) {
            Intrinsics.checkNotNullParameter((Object)expectSymbol, (String)"expectSymbol");
            Intrinsics.checkNotNullParameter((Object)actualSymbol, (String)"actualSymbol");
            ExpectActualTracker expectActualTracker = this.expectActualTracker;
            if (expectActualTracker != null) {
                this.reportWithCurrentFile(expectActualTracker, actualSymbol);
            }
            IrActualizerUtilsKt.recordActualForExpectDeclaration(expectSymbol, actualSymbol, this.expectActualMap, this.diagnosticsReporter);
        }

        @Override
        public void onIncompatibleMembersFromClassScope(@NotNull DeclarationSymbolMarker expectSymbol, @NotNull DeclarationSymbolMarker actualSymbol, @NotNull ExpectActualIncompatibility<?> incompatibility, @Nullable RegularClassSymbolMarker containingExpectClassSymbol, @Nullable RegularClassSymbolMarker containingActualClassSymbol) {
            Intrinsics.checkNotNullParameter((Object)expectSymbol, (String)"expectSymbol");
            Intrinsics.checkNotNullParameter((Object)actualSymbol, (String)"actualSymbol");
            Intrinsics.checkNotNullParameter(incompatibility, (String)"incompatibility");
            if (!(expectSymbol instanceof IrSymbol)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(actualSymbol instanceof IrSymbol)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            IrActualizerUtilsKt.reportExpectActualIrIncompatibility(this.diagnosticsReporter, (IrSymbol)expectSymbol, (IrSymbol)actualSymbol, incompatibility);
        }

        @Override
        public void onMismatchedMembersFromClassScope(@NotNull DeclarationSymbolMarker expectSymbol, @NotNull Map<ExpectActualMatchingCompatibility.Mismatch, ? extends List<? extends DeclarationSymbolMarker>> actualSymbolsByIncompatibility, @Nullable RegularClassSymbolMarker containingExpectClassSymbol, @Nullable RegularClassSymbolMarker containingActualClassSymbol) {
            boolean isActualMissing;
            Intrinsics.checkNotNullParameter((Object)expectSymbol, (String)"expectSymbol");
            Intrinsics.checkNotNullParameter(actualSymbolsByIncompatibility, (String)"actualSymbolsByIncompatibility");
            if (!(expectSymbol instanceof IrSymbol)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            boolean bl = isActualMissing = actualSymbolsByIncompatibility.isEmpty() && !IrActualizerUtilsKt.containsOptionalExpectation(((IrSymbol)expectSymbol).getOwner());
            if (isActualMissing || !actualSymbolsByIncompatibility.isEmpty()) {
                IrSymbol actualSymbolForMissingActual;
                IrMissingActualDeclarationProvider irMissingActualDeclarationProvider = this.missingActualProvider;
                IrSymbol irSymbol = actualSymbolForMissingActual = irMissingActualDeclarationProvider != null ? irMissingActualDeclarationProvider.provideSymbolForMissingActual((IrSymbol)expectSymbol, (IrClassSymbol)containingExpectClassSymbol, (IrClassSymbol)containingActualClassSymbol) : null;
                if (actualSymbolForMissingActual != null) {
                    this.onMatchedMembers(expectSymbol, actualSymbolForMissingActual, containingActualClassSymbol, containingActualClassSymbol);
                    return;
                }
            }
            if (isActualMissing) {
                IrActualizerUtilsKt.reportMissingActual(this.diagnosticsReporter, (IrSymbol)expectSymbol);
            }
            for (Map.Entry<ExpectActualMatchingCompatibility.Mismatch, ? extends List<? extends DeclarationSymbolMarker>> entry : actualSymbolsByIncompatibility.entrySet()) {
                ExpectActualMatchingCompatibility.Mismatch incompatibility = entry.getKey();
                List<? extends DeclarationSymbolMarker> actualMemberSymbols = entry.getValue();
                for (DeclarationSymbolMarker declarationSymbolMarker : actualMemberSymbols) {
                    if (!(declarationSymbolMarker instanceof IrSymbol)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    IrActualizerUtilsKt.reportExpectActualIrMismatch(this.diagnosticsReporter, (IrSymbol)expectSymbol, (IrSymbol)declarationSymbolMarker, incompatibility);
                }
            }
        }

        private final void reportWithCurrentFile(ExpectActualTracker $this$reportWithCurrentFile, IrSymbol actualSymbol) {
            if (this.currentExpectFile != null) {
                IrSymbolOwner it = actualSymbol.getOwner();
                boolean bl = false;
                boolean bl2 = it instanceof IrDeclaration && Intrinsics.areEqual((Object)((IrDeclaration)it).getOrigin(), (Object)IrDeclarationOrigin.Companion.getSTUB_FOR_LENIENT());
                if (bl2) {
                    File file = this.getCurrentExpectIoFile();
                    Intrinsics.checkNotNull((Object)file);
                    $this$reportWithCurrentFile.reportExpectOfLenientStub(file);
                } else {
                    File actualIoFile;
                    IrFile irFile = this.classActualizationInfo.getActualSymbolsToFile().get(actualSymbol);
                    File file = actualIoFile = irFile != null ? ExpectActualCollectorKt.access$toIoFile(irFile) : null;
                    if (actualIoFile != null) {
                        File file2 = this.getCurrentExpectIoFile();
                        Intrinsics.checkNotNull((Object)file2);
                        $this$reportWithCurrentFile.report(file2, actualIoFile);
                    }
                }
            }
        }

        private static final File currentExpectIoFile_delegate$lambda$0(MatchingContext this$0) {
            IrFile irFile = this$0.currentExpectFile;
            return irFile != null ? ExpectActualCollectorKt.access$toIoFile(irFile) : null;
        }
    }
}

