/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.avd;

import com.android.io.CancellableFileIo;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.PathFileWrapper;
import com.android.sdklib.SystemImageTags;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.repository.IdDisplay;
import com.android.utils.ILogger;
import com.android.utils.StringHelper;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b!\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u0000 U2\u00020\u0001:\u0002TUBm\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b\u0012\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b\u0012\u0014\b\u0002\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fB[\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u0012\u0016\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t\u0018\u00010\b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u0010J\u0006\u0010-\u001a\u00020.J\u0010\u0010;\u001a\u0004\u0018\u00010\t2\u0006\u0010<\u001a\u00020\tJ\u000e\u0010?\u001a\u00020.2\u0006\u0010@\u001a\u00020\u0000J\u000e\u0010A\u001a\u00020\u00002\u0006\u0010B\u001a\u00020\u0000J\u000e\u0010C\u001a\u00020.2\u0006\u0010#\u001a\u00020\tJ\t\u0010H\u001a\u00020\u0003H\u00c6\u0003J\t\u0010I\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010J\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u0015\u0010K\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J\u0015\u0010L\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J\u0015\u0010M\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J\t\u0010N\u001a\u00020\rH\u00c6\u0003Ju\u0010O\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b2\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b2\u0014\b\u0002\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b2\b\b\u0002\u0010\f\u001a\u00020\rH\u00c6\u0001J\u0013\u0010P\u001a\u00020.2\b\u0010B\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010Q\u001a\u00020RH\u00d6\u0001J\t\u0010S\u001a\u00020\tH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001eR\u0011\u0010!\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001eR\u0011\u0010#\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0017\u0010'\u001a\b\u0012\u0004\u0012\u00020$0(8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0011\u0010+\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u001eR\u0011\u0010/\u001a\u0002008F\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u0011\u00103\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b4\u0010\u001eR\u0011\u00105\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b6\u0010\u001eR\u0011\u00107\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b8\u0010\u001eR\u0011\u00109\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b:\u0010\u0012R\u0013\u0010=\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b>\u0010\u001eR\u0011\u0010D\u001a\u00020.8F\u00a2\u0006\u0006\u001a\u0004\bD\u0010ER\u0011\u0010F\u001a\u00020.8F\u00a2\u0006\u0006\u001a\u0004\bF\u0010ER\u0011\u0010G\u001a\u00020.8F\u00a2\u0006\u0006\u001a\u0004\bG\u0010E\u00a8\u0006V"}, d2={"Lcom/android/sdklib/internal/avd/AvdInfo;", "", "iniFile", "Ljava/nio/file/Path;", "dataFolderPath", "systemImage", "Lcom/android/sdklib/ISystemImage;", "properties", "", "", "userSettings", "environment", "status", "Lcom/android/sdklib/internal/avd/AvdInfo$AvdStatus;", "<init>", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Lcom/android/sdklib/ISystemImage;Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;Lcom/android/sdklib/internal/avd/AvdInfo$AvdStatus;)V", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Lcom/android/sdklib/ISystemImage;Ljava/util/Map;Ljava/util/Map;Lcom/android/sdklib/internal/avd/AvdInfo$AvdStatus;)V", "getIniFile", "()Ljava/nio/file/Path;", "getDataFolderPath", "getSystemImage", "()Lcom/android/sdklib/ISystemImage;", "getProperties", "()Ljava/util/Map;", "getUserSettings", "getEnvironment", "getStatus", "()Lcom/android/sdklib/internal/avd/AvdInfo$AvdStatus;", "id", "getId", "()Ljava/lang/String;", "name", "getName", "displayName", "getDisplayName", "tag", "Lcom/android/sdklib/repository/IdDisplay;", "getTag", "()Lcom/android/sdklib/repository/IdDisplay;", "tags", "", "getTags", "()Ljava/util/List;", "abiType", "getAbiType", "hasPlayStore", "", "androidVersion", "Lcom/android/sdklib/AndroidVersion;", "getAndroidVersion", "()Lcom/android/sdklib/AndroidVersion;", "cpuArch", "getCpuArch", "deviceManufacturer", "getDeviceManufacturer", "deviceName", "getDeviceName", "configFile", "getConfigFile", "getProperty", "propertyName", "errorMessage", "getErrorMessage", "isSameMetadata", "avdInfo", "copyMetadata", "other", "hasTag", "isXrHeadsetDevice", "()Z", "isAiGlassesDevice", "isAiGlassesCompatibleDevice", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "hashCode", "", "toString", "AvdStatus", "Companion", "sdklib"})
@SourceDebugExtension(value={"SMAP\nAvdInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AvdInfo.kt\ncom/android/sdklib/internal/avd/AvdInfo\n+ 2 CollectionsUtils.kt\ncom/android/utils/CollectionsUtilsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,275:1\n26#2:276\n463#3:277\n413#3:278\n504#3,7:283\n1252#4,4:279\n1573#4:290\n1604#4,3:291\n1607#4:295\n1#5:294\n*S KotlinDebug\n*F\n+ 1 AvdInfo.kt\ncom/android/sdklib/internal/avd/AvdInfo\n*L\n69#1:276\n69#1:277\n69#1:278\n69#1:283,7\n69#1:279,4\n116#1:290\n116#1:291,3\n116#1:295\n*E\n"})
public final class AvdInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path iniFile;
    @NotNull
    private final Path dataFolderPath;
    @Nullable
    private final ISystemImage systemImage;
    @NotNull
    private final Map<String, String> properties;
    @NotNull
    private final Map<String, String> userSettings;
    @NotNull
    private final Map<String, String> environment;
    @NotNull
    private final AvdStatus status;

    public AvdInfo(@NotNull Path iniFile, @NotNull Path dataFolderPath, @Nullable ISystemImage systemImage, @NotNull Map<String, String> properties, @NotNull Map<String, String> userSettings, @NotNull Map<String, String> environment, @NotNull AvdStatus status2) {
        Intrinsics.checkNotNullParameter((Object)iniFile, (String)"iniFile");
        Intrinsics.checkNotNullParameter((Object)dataFolderPath, (String)"dataFolderPath");
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        Intrinsics.checkNotNullParameter(userSettings, (String)"userSettings");
        Intrinsics.checkNotNullParameter(environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)((Object)status2), (String)"status");
        this.iniFile = iniFile;
        this.dataFolderPath = dataFolderPath;
        this.systemImage = systemImage;
        this.properties = properties;
        this.userSettings = userSettings;
        this.environment = environment;
        this.status = status2;
    }

    public /* synthetic */ AvdInfo(Path path, Path path2, ISystemImage iSystemImage, Map map, Map map2, Map map3, AvdStatus avdStatus, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 0x10) != 0) {
            map2 = MapsKt.emptyMap();
        }
        if ((n & 0x20) != 0) {
            map3 = MapsKt.emptyMap();
        }
        if ((n & 0x40) != 0) {
            avdStatus = AvdStatus.OK;
        }
        this(path, path2, iSystemImage, map, map2, map3, avdStatus);
    }

    @NotNull
    public final Path getIniFile() {
        return this.iniFile;
    }

    @NotNull
    public final Path getDataFolderPath() {
        return this.dataFolderPath;
    }

    @Nullable
    public final ISystemImage getSystemImage() {
        return this.systemImage;
    }

    @NotNull
    public final Map<String, String> getProperties() {
        return this.properties;
    }

    @NotNull
    public final Map<String, String> getUserSettings() {
        return this.userSettings;
    }

    @NotNull
    public final Map<String, String> getEnvironment() {
        return this.environment;
    }

    @NotNull
    public final AvdStatus getStatus() {
        return this.status;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public AvdInfo(@NotNull Path iniFile, @NotNull Path dataFolderPath, @Nullable ISystemImage systemImage, @Nullable Map<String, String> properties, @Nullable Map<String, String> userSettings, @NotNull AvdStatus status2) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)iniFile, (String)"iniFile");
        Intrinsics.checkNotNullParameter((Object)dataFolderPath, (String)"dataFolderPath");
        Intrinsics.checkNotNullParameter((Object)((Object)status2), (String)"status");
        AvdInfo avdInfo = this;
        Path path = iniFile;
        Path path2 = dataFolderPath;
        ISystemImage iSystemImage = systemImage;
        Map map2 = properties;
        if (map2 == null) {
            map2 = MapsKt.emptyMap();
        }
        Map<String, String> map3 = userSettings;
        if (map3 != null) {
            void $this$filterValues$iv$iv;
            Map map4;
            void $this$mapValuesTo$iv$iv$iv;
            void $this$mapValuesNotNull$iv;
            Map<String, String> map5 = map3;
            Map map6 = map2;
            ISystemImage iSystemImage2 = iSystemImage;
            Path path3 = path2;
            Path path4 = path;
            AvdInfo avdInfo2 = avdInfo;
            boolean $i$f$mapValuesNotNull = false;
            Map $this$mapValues$iv$iv = $this$mapValuesNotNull$iv;
            boolean $i$f$mapValues = false;
            void var11_16 = $this$mapValues$iv$iv;
            Map destination$iv$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv$iv = $this$mapValuesTo$iv$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv$iv : $this$associateByTo$iv$iv$iv$iv) {
                String v;
                void it$iv$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv$iv;
                Map map7 = destination$iv$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv$iv;
                Object k = it$iv$iv$iv.getKey();
                map4 = map7;
                boolean bl2 = false;
                String k2 = (String)entry2.getKey();
                String string = v = (String)entry2.getValue();
                map4.put(k, string);
            }
            $this$mapValues$iv$iv = destination$iv$iv$iv;
            boolean $i$f$filterValues = false;
            LinkedHashMap result$iv$iv = new LinkedHashMap();
            for (Map.Entry entry$iv$iv : $this$filterValues$iv$iv.entrySet()) {
                Object it$iv = entry$iv$iv.getValue();
                boolean bl = false;
                if (!(it$iv != null)) continue;
                result$iv$iv.put(entry$iv$iv.getKey(), entry$iv$iv.getValue());
            }
            map4 = result$iv$iv;
            avdInfo = avdInfo2;
            path = path4;
            path2 = path3;
            iSystemImage = iSystemImage2;
            map2 = map6;
            map = map4;
        } else {
            map = MapsKt.emptyMap();
        }
        avdInfo(path, path2, iSystemImage, map2, map, MapsKt.emptyMap(), status2);
    }

    public /* synthetic */ AvdInfo(Path path, Path path2, ISystemImage iSystemImage, Map map, Map map2, AvdStatus avdStatus, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            avdStatus = AvdStatus.OK;
        }
        this(path, path2, iSystemImage, map, map2, avdStatus);
    }

    @NotNull
    public final String getId() {
        return ((Object)this.dataFolderPath).toString();
    }

    @NotNull
    public final String getName() {
        return Companion.getAvdNameFromFile(this.iniFile);
    }

    @NotNull
    public final String getDisplayName() {
        String string = this.properties.get("avd.ini.displayname");
        if (string == null) {
            string = Companion.avdNameToDisplayName(this.getName());
        }
        return string;
    }

    @NotNull
    public final IdDisplay getTag() {
        String string = this.properties.get("tag.id");
        if (string == null) {
            IdDisplay idDisplay = SystemImageTags.DEFAULT_TAG;
            Intrinsics.checkNotNullExpressionValue((Object)idDisplay, (String)"DEFAULT_TAG");
            return idDisplay;
        }
        String id = string;
        String display = this.properties.get("tag.display");
        String string2 = display;
        if (string2 == null) {
            string2 = id;
        }
        IdDisplay idDisplay = IdDisplay.create(id, string2);
        Intrinsics.checkNotNullExpressionValue((Object)idDisplay, (String)"create(...)");
        return idDisplay;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<IdDisplay> getTags() {
        void $this$mapIndexedTo$iv$iv;
        String string = this.properties.get("tag.ids");
        if (string == null) {
            return CollectionsKt.listOf((Object)this.getTag());
        }
        String ids = string;
        String string2 = this.properties.get("tag.displaynames");
        if (string2 == null) {
            string2 = "";
        }
        String displays = string2;
        char[] cArray = new char[]{','};
        List idList = StringsKt.split$default((CharSequence)ids, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        char[] cArray2 = new char[]{','};
        List displayList = StringsKt.split$default((CharSequence)displays, (char[])cArray2, (boolean)false, (int)0, (int)6, null);
        Iterable $this$mapIndexed$iv = idList;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            String string3;
            void v2;
            Collection collection;
            block8: {
                void id;
                block7: {
                    void it;
                    String string4;
                    void i;
                    int n;
                    if ((n = index$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    String string5 = (String)item$iv$iv;
                    int n2 = n;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    v2 = id;
                    string3 = (String)CollectionsKt.getOrNull((List)displayList, (int)i);
                    if (string3 == null) break block7;
                    String string6 = string4 = string3;
                    void var19_19 = v2;
                    boolean bl2 = false;
                    v2 = var19_19;
                    string3 = Boolean.valueOf(((CharSequence)it).length() > 0) != false ? string4 : null;
                    if (string3 != null) break block8;
                }
                string3 = id;
            }
            collection.add(IdDisplay.create((String)v2, string3));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final String getAbiType() {
        String string = this.properties.get("abi.type");
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    public final boolean hasPlayStore() {
        String enabled = this.properties.get("PlayStore.enabled");
        return StringsKt.equals((String)"true", (String)enabled, (boolean)true) || StringsKt.equals((String)"yes", (String)enabled, (boolean)true);
    }

    @NotNull
    public final AndroidVersion getAndroidVersion() {
        String string;
        block3: {
            block2: {
                string = this.getProperty("target");
                if (string == null) break block2;
                String it = string;
                boolean bl = false;
                AndroidVersion androidVersion = AndroidTargetHash.getPlatformVersion(it);
                string = androidVersion;
                if (androidVersion != null) break block3;
            }
            AndroidVersion androidVersion = AndroidVersion.DEFAULT;
            string = androidVersion;
            Intrinsics.checkNotNullExpressionValue((Object)androidVersion, (String)"DEFAULT");
        }
        return string;
    }

    @NotNull
    public final String getCpuArch() {
        String string = this.properties.get("hw.cpu.arch");
        if (string == null) {
            string = "arm";
        }
        return string;
    }

    @NotNull
    public final String getDeviceManufacturer() {
        String string = this.properties.get("hw.device.manufacturer");
        if (string == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public final String getDeviceName() {
        String string = this.properties.get("hw.device.name");
        if (string == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public final Path getConfigFile() {
        return Companion.getConfigFile(this.dataFolderPath);
    }

    @Nullable
    public final String getProperty(@NotNull String propertyName) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        return this.properties.get(propertyName);
    }

    @Nullable
    public final String getErrorMessage() {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[this.status.ordinal()]) {
            case 1: {
                string = "Missing config.ini file in " + this.dataFolderPath;
                break;
            }
            case 2: {
                string = "Failed to parse properties from " + this.getConfigFile();
                break;
            }
            case 3: {
                String tag = Intrinsics.areEqual((Object)SystemImageTags.DEFAULT_TAG, (Object)this.getTag()) ? "" : this.getTag().getDisplay() + " ";
                string = "Missing system image for " + tag + this.getAbiType() + " " + this.getDisplayName() + ".";
                break;
            }
            case 4: {
                string = this.properties.get("hw.device.manufacturer") + " " + this.properties.get("hw.device.name") + " no longer exists as a device";
                break;
            }
            case 5: {
                string = "Corrupted AVD ini file: " + this.iniFile;
                break;
            }
            case 6: {
                string = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    public final boolean isSameMetadata(@NotNull AvdInfo avdInfo) {
        Intrinsics.checkNotNullParameter((Object)avdInfo, (String)"avdInfo");
        return Intrinsics.areEqual(this.userSettings, avdInfo.userSettings);
    }

    @NotNull
    public final AvdInfo copyMetadata(@NotNull AvdInfo other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return AvdInfo.copy$default(this, null, null, null, null, other.userSettings, null, null, 111, null);
    }

    public final boolean hasTag(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        String tags = this.properties.get("tag.ids");
        return tags != null && StringHelper.asSeparatedListContains$default((CharSequence)tags, (CharSequence)tag, null, (int)2, null);
    }

    public final boolean isXrHeadsetDevice() {
        String string = SystemImageTags.XR_HEADSET_TAG.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        return this.hasTag(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isAiGlassesDevice() {
        String string = SystemImageTags.AI_GLASSES_TAG.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        if (this.hasTag(string)) return true;
        String string2 = SystemImageTags.DEPRECATED_AI_GLASSES_TAG.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getId(...)");
        if (!this.hasTag(string2)) return false;
        return true;
    }

    public final boolean isAiGlassesCompatibleDevice() {
        String string = SystemImageTags.AI_GLASSES_COMPATIBLE_TAG.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        return this.hasTag(string);
    }

    @NotNull
    public final Path component1() {
        return this.iniFile;
    }

    @NotNull
    public final Path component2() {
        return this.dataFolderPath;
    }

    @Nullable
    public final ISystemImage component3() {
        return this.systemImage;
    }

    @NotNull
    public final Map<String, String> component4() {
        return this.properties;
    }

    @NotNull
    public final Map<String, String> component5() {
        return this.userSettings;
    }

    @NotNull
    public final Map<String, String> component6() {
        return this.environment;
    }

    @NotNull
    public final AvdStatus component7() {
        return this.status;
    }

    @NotNull
    public final AvdInfo copy(@NotNull Path iniFile, @NotNull Path dataFolderPath, @Nullable ISystemImage systemImage, @NotNull Map<String, String> properties, @NotNull Map<String, String> userSettings, @NotNull Map<String, String> environment, @NotNull AvdStatus status2) {
        Intrinsics.checkNotNullParameter((Object)iniFile, (String)"iniFile");
        Intrinsics.checkNotNullParameter((Object)dataFolderPath, (String)"dataFolderPath");
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        Intrinsics.checkNotNullParameter(userSettings, (String)"userSettings");
        Intrinsics.checkNotNullParameter(environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)((Object)status2), (String)"status");
        return new AvdInfo(iniFile, dataFolderPath, systemImage, properties, userSettings, environment, status2);
    }

    public static /* synthetic */ AvdInfo copy$default(AvdInfo avdInfo, Path path, Path path2, ISystemImage iSystemImage, Map map, Map map2, Map map3, AvdStatus avdStatus, int n, Object object) {
        if ((n & 1) != 0) {
            path = avdInfo.iniFile;
        }
        if ((n & 2) != 0) {
            path2 = avdInfo.dataFolderPath;
        }
        if ((n & 4) != 0) {
            iSystemImage = avdInfo.systemImage;
        }
        if ((n & 8) != 0) {
            map = avdInfo.properties;
        }
        if ((n & 0x10) != 0) {
            map2 = avdInfo.userSettings;
        }
        if ((n & 0x20) != 0) {
            map3 = avdInfo.environment;
        }
        if ((n & 0x40) != 0) {
            avdStatus = avdInfo.status;
        }
        return avdInfo.copy(path, path2, iSystemImage, map, map2, map3, avdStatus);
    }

    @NotNull
    public String toString() {
        return "AvdInfo(iniFile=" + this.iniFile + ", dataFolderPath=" + this.dataFolderPath + ", systemImage=" + this.systemImage + ", properties=" + this.properties + ", userSettings=" + this.userSettings + ", environment=" + this.environment + ", status=" + this.status + ")";
    }

    public int hashCode() {
        int result = ((Object)this.iniFile).hashCode();
        result = result * 31 + ((Object)this.dataFolderPath).hashCode();
        result = result * 31 + (this.systemImage == null ? 0 : this.systemImage.hashCode());
        result = result * 31 + ((Object)this.properties).hashCode();
        result = result * 31 + ((Object)this.userSettings).hashCode();
        result = result * 31 + ((Object)this.environment).hashCode();
        result = result * 31 + this.status.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AvdInfo)) {
            return false;
        }
        AvdInfo avdInfo = (AvdInfo)other;
        if (!Intrinsics.areEqual((Object)this.iniFile, (Object)avdInfo.iniFile)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.dataFolderPath, (Object)avdInfo.dataFolderPath)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.systemImage, (Object)avdInfo.systemImage)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.properties, avdInfo.properties)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.userSettings, avdInfo.userSettings)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.environment, avdInfo.environment)) {
            return false;
        }
        return this.status == avdInfo.status;
    }

    @JvmOverloads
    public AvdInfo(@NotNull Path iniFile, @NotNull Path dataFolderPath, @Nullable ISystemImage systemImage, @Nullable Map<String, String> properties, @Nullable Map<String, String> userSettings) {
        Intrinsics.checkNotNullParameter((Object)iniFile, (String)"iniFile");
        Intrinsics.checkNotNullParameter((Object)dataFolderPath, (String)"dataFolderPath");
        this(iniFile, dataFolderPath, systemImage, properties, userSettings, null, 32, null);
    }

    @JvmStatic
    @NotNull
    public static final String getAvdNameFromFile(@NotNull Path file) {
        return Companion.getAvdNameFromFile(file);
    }

    @JvmStatic
    @NotNull
    public static final String avdNameToDisplayName(@NotNull String avdName) {
        return Companion.avdNameToDisplayName(avdName);
    }

    @JvmStatic
    @NotNull
    public static final Path getDefaultAvdFolder(@NotNull AvdManager manager, @NotNull String avdName, boolean unique) {
        return Companion.getDefaultAvdFolder(manager, avdName, unique);
    }

    @JvmStatic
    @NotNull
    public static final Path getDefaultIniFile(@NotNull AvdManager manager, @NotNull String avdName) {
        return Companion.getDefaultIniFile(manager, avdName);
    }

    @JvmStatic
    @NotNull
    public static final Path getUserSettingsPath(@NotNull Path dataFolder) {
        return Companion.getUserSettingsPath(dataFolder);
    }

    @JvmStatic
    @NotNull
    public static final Map<String, String> parseUserSettingsFile(@NotNull Path dataFolder, @Nullable ILogger logger) {
        return Companion.parseUserSettingsFile(dataFolder, logger);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/android/sdklib/internal/avd/AvdInfo$AvdStatus;", "", "<init>", "(Ljava/lang/String;I)V", "OK", "ERROR_CONFIG", "ERROR_PROPERTIES", "ERROR_DEVICE_MISSING", "ERROR_IMAGE_MISSING", "ERROR_CORRUPTED_INI", "sdklib"})
    public static final class AvdStatus
    extends Enum<AvdStatus> {
        public static final /* enum */ AvdStatus OK = new AvdStatus();
        public static final /* enum */ AvdStatus ERROR_CONFIG = new AvdStatus();
        public static final /* enum */ AvdStatus ERROR_PROPERTIES = new AvdStatus();
        public static final /* enum */ AvdStatus ERROR_DEVICE_MISSING = new AvdStatus();
        public static final /* enum */ AvdStatus ERROR_IMAGE_MISSING = new AvdStatus();
        public static final /* enum */ AvdStatus ERROR_CORRUPTED_INI = new AvdStatus();
        private static final /* synthetic */ AvdStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static AvdStatus[] values() {
            return (AvdStatus[])$VALUES.clone();
        }

        public static AvdStatus valueOf(String value) {
            return Enum.valueOf(AvdStatus.class, value);
        }

        @NotNull
        public static EnumEntries<AvdStatus> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = avdStatusArray = new AvdStatus[]{AvdStatus.OK, AvdStatus.ERROR_CONFIG, AvdStatus.ERROR_PROPERTIES, AvdStatus.ERROR_DEVICE_MISSING, AvdStatus.ERROR_IMAGE_MISSING, AvdStatus.ERROR_CORRUPTED_INI};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0007J \u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0018\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u0005H\u0007J\u000e\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007H\u0007J&\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00152\u0006\u0010\u0013\u001a\u00020\u00072\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007\u00a8\u0006\u0018"}, d2={"Lcom/android/sdklib/internal/avd/AvdInfo$Companion;", "", "<init>", "()V", "getAvdNameFromFile", "", "file", "Ljava/nio/file/Path;", "avdNameToDisplayName", "avdName", "getDefaultAvdFolder", "manager", "Lcom/android/sdklib/internal/avd/AvdManager;", "unique", "", "getDefaultIniFile", "getConfigFile", "path", "getUserSettingsPath", "dataFolder", "parseUserSettingsFile", "", "logger", "Lcom/android/utils/ILogger;", "sdklib"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final String getAvdNameFromFile(@NotNull Path file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            String iniFilename = ((Object)file.getFileName()).toString();
            String string = iniFilename.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            return StringsKt.endsWith$default((String)string, (String)".ini", (boolean)false, (int)2, null) ? StringsKt.dropLast((String)iniFilename, (int)4) : iniFilename;
        }

        @JvmStatic
        @NotNull
        public final String avdNameToDisplayName(@NotNull String avdName) {
            Intrinsics.checkNotNullParameter((Object)avdName, (String)"avdName");
            return StringsKt.replace$default((String)avdName, (char)'_', (char)' ', (boolean)false, (int)4, null);
        }

        @JvmStatic
        @NotNull
        public final Path getDefaultAvdFolder(@NotNull AvdManager manager, @NotNull String avdName, boolean unique) {
            Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
            Intrinsics.checkNotNullParameter((Object)avdName, (String)"avdName");
            Path base = manager.getBaseAvdFolder();
            Path result = base.resolve(avdName + ".avd");
            if (unique) {
                int suffix = 0;
                while (CancellableFileIo.exists((Path)result, (LinkOption[])new LinkOption[0])) {
                    result = base.resolve(avdName + "_" + ++suffix + ".avd");
                }
            }
            Path path = result;
            Intrinsics.checkNotNull((Object)path);
            return path;
        }

        @JvmStatic
        @NotNull
        public final Path getDefaultIniFile(@NotNull AvdManager manager, @NotNull String avdName) {
            Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
            Intrinsics.checkNotNullParameter((Object)avdName, (String)"avdName");
            Path path = manager.getBaseAvdFolder().resolve(avdName + ".ini");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            return path;
        }

        @NotNull
        public final Path getConfigFile(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Path path2 = path.resolve("config.ini");
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
            return path2;
        }

        @JvmStatic
        @NotNull
        public final Path getUserSettingsPath(@NotNull Path dataFolder) {
            Intrinsics.checkNotNullParameter((Object)dataFolder, (String)"dataFolder");
            Path path = dataFolder.resolve("user-settings.ini");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            return path;
        }

        @JvmStatic
        @NotNull
        public final Map<String, String> parseUserSettingsFile(@NotNull Path dataFolder, @Nullable ILogger logger) {
            Intrinsics.checkNotNullParameter((Object)dataFolder, (String)"dataFolder");
            PathFileWrapper settingsPath = new PathFileWrapper(this.getUserSettingsPath(dataFolder));
            if (settingsPath.exists()) {
                Map map = AvdManager.Companion.parseIniFile(settingsPath, logger);
                if (map == null) {
                    map = MapsKt.emptyMap();
                }
                return map;
            }
            return MapsKt.emptyMap();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AvdStatus.values().length];
            try {
                nArray[AvdStatus.ERROR_CONFIG.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AvdStatus.ERROR_PROPERTIES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AvdStatus.ERROR_IMAGE_MISSING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AvdStatus.ERROR_DEVICE_MISSING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AvdStatus.ERROR_CORRUPTED_INI.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AvdStatus.OK.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

