/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiWhiteSpace;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 !2\u00020\u00012\u00020\u0002:\u0001!B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001c\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001a\u0010\r\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00062\u0006\u0010\u0016\u001a\u00020\u0015J\u0018\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u000eH\u0002J\f\u0010\u001a\u001a\u00020\u0015*\u00020\u000eH\u0002J(\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u0013H\u0002\u00a8\u0006\""}, d2={"Lcom/android/tools/lint/checks/TextConcatDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "findString", "Lcom/intellij/psi/PsiElement;", "expression", "biasLeft", "", "Lorg/jetbrains/uast/ULiteralExpression;", "Lorg/jetbrains/uast/UExpression;", "getWords", "", "line", "differentLines", "element1", "element2", "getStringText", "check", "", "node", "Lorg/jetbrains/uast/UPolyadicExpression;", "lhs", "rhs", "Issues", "lint-checks"})
public final class TextConcatDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(TextConcatDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue ISSUE = Issue.Companion.create("TextConcatSpace", "Missing space in text concatenation?", "\n          When splitting strings up across separate lines, it's easy to accidentally \\\n          miss a separating space. This lint check looks for cases of string concatenation \\\n          where a separating space may be missing.\n          ", Category.CORRECTNESS, 6, Severity.WARNING, IMPLEMENTATION);

    @NotNull
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        Object[] objectArray = new Class[]{UBinaryExpression.class, UPolyadicExpression.class};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new UElementHandler(this, context){
            final /* synthetic */ TextConcatDetector this$0;
            final /* synthetic */ JavaContext $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
            }

            public void visitBinaryExpression(UBinaryExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (Intrinsics.areEqual((Object)node.getOperator(), (Object)UastBinaryOperator.PLUS)) {
                    TextConcatDetector.access$check(this.this$0, this.$context, (UPolyadicExpression)node, node.getLeftOperand(), node.getRightOperand());
                }
            }

            public void visitPolyadicExpression(UPolyadicExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (Intrinsics.areEqual((Object)node.getOperator(), (Object)UastBinaryOperator.PLUS)) {
                    List operands = node.getOperands();
                    int n = operands.size() - 1;
                    for (int i = 0; i < n; ++i) {
                        TextConcatDetector.access$check(this.this$0, this.$context, node, (UExpression)operands.get(i), (UExpression)operands.get(i + 1));
                    }
                }
            }
        };
    }

    private final PsiElement findString(PsiElement expression, boolean biasLeft) {
        if (expression == null) {
            return null;
        }
        PsiElement psiElement = expression;
        if (psiElement instanceof KtParenthesizedExpression) {
            return this.findString((PsiElement)((KtParenthesizedExpression)expression).getExpression(), biasLeft);
        }
        if (psiElement instanceof PsiParenthesizedExpression) {
            return this.findString((PsiElement)((PsiParenthesizedExpression)expression).getExpression(), biasLeft);
        }
        if (psiElement instanceof KtLiteralStringTemplateEntry) {
            return expression;
        }
        if (psiElement instanceof PsiLiteralExpression) {
            String stringWithQuotes = ((PsiLiteralExpression)expression).getText();
            Intrinsics.checkNotNull((Object)stringWithQuotes);
            if (StringsKt.startsWith$default((CharSequence)stringWithQuotes, (char)'\"', (boolean)false, (int)2, null) && StringsKt.endsWith$default((CharSequence)stringWithQuotes, (char)'\"', (boolean)false, (int)2, null) && ((PsiLiteralExpression)expression).getValue() instanceof String) {
                PsiElement psiElement2 = ((PsiLiteralExpression)expression).getFirstChild();
                if (psiElement2 == null) {
                    psiElement2 = expression;
                }
                return psiElement2;
            }
        } else if (psiElement instanceof KtBinaryExpression) {
            if (Intrinsics.areEqual((Object)((KtBinaryExpression)expression).getOperationToken(), (Object)KtTokens.PLUS)) {
                KtExpression follow = biasLeft ? ((KtBinaryExpression)expression).getLeft() : ((KtBinaryExpression)expression).getRight();
                return this.findString((PsiElement)follow, biasLeft);
            }
        } else if (psiElement instanceof PsiBinaryExpression) {
            if (Intrinsics.areEqual((Object)((PsiBinaryExpression)expression).getOperationSign().getTokenType(), (Object)JavaTokenType.PLUS)) {
                PsiExpression follow = biasLeft ? ((PsiBinaryExpression)expression).getLOperand() : ((PsiBinaryExpression)expression).getROperand();
                return this.findString((PsiElement)follow, biasLeft);
            }
        } else if (psiElement instanceof PsiPolyadicExpression) {
            if (Intrinsics.areEqual((Object)((PsiPolyadicExpression)expression).getOperationTokenType(), (Object)JavaTokenType.PLUS)) {
                Object[] objectArray = ((PsiPolyadicExpression)expression).getOperands();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getOperands(...)");
                Object[] operands = objectArray;
                if (!(operands.length == 0)) {
                    PsiExpression follow = biasLeft ? (PsiExpression)ArraysKt.first((Object[])operands) : (PsiExpression)ArraysKt.last((Object[])operands);
                    return this.findString((PsiElement)follow, biasLeft);
                }
            }
        } else if (psiElement instanceof KtStringTemplateExpression) {
            Object[] entries = ((KtStringTemplateExpression)expression).getEntries();
            Intrinsics.checkNotNull((Object)entries);
            if (!(entries.length == 0)) {
                KtStringTemplateEntry string2 = biasLeft ? (KtStringTemplateEntry)ArraysKt.first((Object[])entries) : (KtStringTemplateEntry)ArraysKt.last((Object[])entries);
                return (PsiElement)(string2 instanceof KtLiteralStringTemplateEntry ? (KtLiteralStringTemplateEntry)string2 : null);
            }
        }
        return null;
    }

    private final ULiteralExpression findString(UExpression expression, boolean biasLeft) {
        if (expression instanceof ULiteralExpression) {
            return (ULiteralExpression)expression;
        }
        if (expression instanceof UPolyadicExpression && Intrinsics.areEqual((Object)((UPolyadicExpression)expression).getOperator(), (Object)UastBinaryOperator.PLUS)) {
            List operands = ((UPolyadicExpression)expression).getOperands();
            if (!((Collection)operands).isEmpty()) {
                UExpression element;
                UExpression uExpression = element = biasLeft ? UastUtils.skipParenthesizedExprDown((UExpression)((UExpression)CollectionsKt.first((List)operands))) : UastUtils.skipParenthesizedExprDown((UExpression)((UExpression)CollectionsKt.last((List)operands)));
                if (element instanceof ULiteralExpression) {
                    return (ULiteralExpression)element;
                }
            }
        } else if (expression instanceof UParenthesizedExpression) {
            return this.findString(((UParenthesizedExpression)expression).getExpression(), biasLeft);
        }
        return null;
    }

    @NotNull
    public final List<String> getWords(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        String[] stringArray = new String[]{" "};
        return StringsKt.split$default((CharSequence)line, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
    }

    private final boolean differentLines(PsiElement element1, PsiElement element2) {
        PsiElement curr = element1;
        while (curr != null) {
            PsiElement next;
            if (curr == element2) {
                return false;
            }
            if (curr instanceof PsiWhiteSpace) {
                String string2 = ((PsiWhiteSpace)curr).getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"\n", (boolean)false, (int)2, null)) {
                    return true;
                }
            }
            if ((next = curr.getFirstChild()) == null && (next = curr.getNextSibling()) == null) {
                for (PsiElement parent = curr.getParent(); parent != null && (next = parent.getNextSibling()) == null; parent = parent.getParent()) {
                }
            }
            curr = next;
        }
        return false;
    }

    private final String getStringText(PsiElement $this$getStringText) {
        String string2;
        String text = $this$getStringText.getText();
        if ($this$getStringText instanceof PsiJavaToken) {
            Intrinsics.checkNotNull((Object)text);
            string2 = StringsKt.removeSurrounding((String)text, (CharSequence)"\"");
        } else {
            String string3 = text;
            Intrinsics.checkNotNull((Object)string3);
            string2 = string3;
        }
        return string2;
    }

    private final void check(JavaContext context, UPolyadicExpression node, UExpression lhs, UExpression rhs) {
        LintFix lintFix;
        int i;
        PsiElement psiElement = this.findString(lhs.getSourcePsi(), false);
        if (psiElement == null) {
            return;
        }
        PsiElement leftPsi = psiElement;
        String leftString = this.getStringText(leftPsi);
        if (((CharSequence)leftString).length() == 0 || !Character.isLetter(StringsKt.last((CharSequence)leftString))) {
            return;
        }
        for (i = leftString.length(); i > 0 && Character.isLetterOrDigit(leftString.charAt(i - 1)); --i) {
        }
        if (i == 0 || leftString.charAt(i - 1) != ' ') {
            return;
        }
        if (!StringsKt.contains$default((CharSequence)leftString, (CharSequence)" ", (boolean)false, (int)2, null)) {
            return;
        }
        PsiElement psiElement2 = this.findString(rhs.getSourcePsi(), true);
        if (psiElement2 == null) {
            return;
        }
        PsiElement rightPsi = psiElement2;
        String rightString = this.getStringText(rightPsi);
        if (((CharSequence)rightString).length() == 0 || !Character.isLetter(StringsKt.first((CharSequence)rightString))) {
            return;
        }
        List<String> leftWords = this.getWords(leftString);
        if (leftWords.size() < 2) {
            return;
        }
        List<String> rightWords = this.getWords(rightString);
        if (!this.differentLines(leftPsi, rightPsi)) {
            return;
        }
        LintFix.ReplaceStringBuilder fixBuilder = this.fix().name("Insert space").replace().range(context.getLocation(rightPsi));
        PsiElement psiElement3 = rightPsi;
        if (psiElement3 instanceof KtLiteralStringTemplateEntry) {
            lintFix = fixBuilder.beginning().with(" ").build();
        } else if (psiElement3 instanceof PsiJavaToken) {
            LintFix.ReplaceStringBuilder replaceStringBuilder = fixBuilder.text(((PsiJavaToken)rightPsi).getText());
            String string2 = ((PsiJavaToken)rightPsi).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            String string3 = string2;
            int n = 1;
            String string4 = string3.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            lintFix = replaceStringBuilder.with("\" " + string4).build();
        } else {
            lintFix = null;
        }
        LintFix fix2 = lintFix;
        String lastWord = (String)CollectionsKt.last(leftWords);
        String firstWord = (String)CollectionsKt.first(rightWords);
        context.report(ISSUE, (UElement)node, Location.withSecondary$default((Location)context.getLocation(rightPsi), (Location)context.getLocation(leftPsi), (String)"Previous text here", (boolean)false, (int)4, null), "Missing space between \"" + lastWord + "\" on the previous line and \"" + firstWord + "\" here? Resulting string is \"" + lastWord + firstWord + "\".", fix2);
    }

    public static final /* synthetic */ void access$check(TextConcatDetector $this, JavaContext context, UPolyadicExpression node, UExpression lhs, UExpression rhs) {
        $this.check(context, node, lhs, rhs);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/tools/lint/checks/TextConcatDetector$Issues;", "", "<init>", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

