/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.AnalysisApiLintUtilsKt;
import com.android.tools.lint.checks.DataFlowAnalyzer;
import com.android.tools.lint.checks.PendingIntentMutableImplicitDetector;
import com.android.tools.lint.checks.PendingIntentUtils;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.android.tools.lint.detector.api.UastLintUtilsKt;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiVariable;
import com.intellij.util.containers.UtilKt;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.symbols.KaDeclarationSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaDeclarationSymbolKt;
import org.jetbrains.kotlin.analysis.api.symbols.KaFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbolLocation;
import org.jetbrains.kotlin.analysis.api.symbols.KaTypeParameterSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaValueParameterSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.uast.UArrayAccessExpression;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UThisExpression;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u00012\u00020\u0002:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/lint/checks/PendingIntentMutableImplicitDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "getApplicableMethodNames", "", "", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "filterIncident", "", "Lcom/android/tools/lint/detector/api/Context;", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "map", "Lcom/android/tools/lint/detector/api/LintMap;", "Companion", "lint-checks"})
public final class PendingIntentMutableImplicitDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    private static final String CLASS_URI = "android.net.Uri";
    @NotNull
    private static final String METHOD_ARRAY_OF = "arrayOf";
    @NotNull
    private static final String METHOD_ARRAY_OF_NULLS = "arrayOfNulls";
    @NotNull
    private static final String METHOD_INTENT_SET_COMPONENT = "setComponent";
    @NotNull
    private static final String METHOD_INTENT_SET_PACKAGE = "setPackage";
    @NotNull
    private static final String METHOD_INTENT_SET_CLASS = "setClass";
    @NotNull
    private static final String METHOD_INTENT_SET_CLASS_NAME = "setClassName";
    @NotNull
    private static final String METHOD_LIST_OF = "listOf";
    @NotNull
    private static final String TYPE_PARAM = "T";
    @NotNull
    private static final List<String[]> INTENT_EXPLICIT_CONSTRUCTOR_ARGS;

    @NotNull
    public List<String> getApplicableMethodNames() {
        return PendingIntentUtils.INSTANCE.getGET_METHOD_NAMES();
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (!context.getEvaluator().isMemberInClass((PsiMember)method, "android.app.PendingIntent")) {
            return;
        }
        UExpression uExpression = node.getArgumentForParameter(3);
        if (uExpression == null) {
            return;
        }
        UExpression flagsArgument = uExpression;
        Object object = ConstantEvaluator.evaluate((JavaContext)context, (UElement)((UElement)flagsArgument));
        Integer n = object instanceof Integer ? (Integer)object : null;
        if (n == null) {
            return;
        }
        int flags = n;
        if (!PendingIntentMutableImplicitDetector.Companion.isNewMutableNonExemptedPendingIntent(flags)) {
            return;
        }
        UExpression uExpression2 = node.getArgumentForParameter(2);
        if (uExpression2 == null) {
            return;
        }
        UExpression intentArgument = uExpression2;
        if (PendingIntentMutableImplicitDetector.Companion.getIntentTypeForExpression(intentArgument, new Companion.IntentExpressionInfo(context.getEvaluator(), node, intentArgument)).isImplicit()) {
            LintFix[] lintFixArray = new LintFix[]{PendingIntentMutableImplicitDetector.Companion.buildImmutableFixOrNull(context, flagsArgument), PendingIntentMutableImplicitDetector.Companion.buildNoCreateFix(context, flagsArgument)};
            LintFix fixes = this.fix().alternatives(lintFixArray);
            Incident incident = new Incident(ISSUE, (Object)node, context.getLocation((UElement)node), "Mutable implicit `PendingIntent` will throw an exception", fixes);
            context.report(incident, this.map());
        }
    }

    public boolean filterIncident(@NotNull Context context, @NotNull Incident incident, @NotNull LintMap map2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Intrinsics.checkNotNullParameter((Object)map2, (String)"map");
        if (context.getMainProject().getTargetSdk() < 23) {
            return false;
        }
        if (context.getMainProject().getTargetSdk() < 34) {
            incident.overrideSeverity(Severity.WARNING);
            incident.setMessage(incident.getMessage() + " once this app starts targeting Android 14 or above");
        }
        incident.setMessage(incident.getMessage() + ", follow either of these recommendations: for an existing `PendingIntent` use `FLAG_NO_CREATE` and for a new `PendingIntent` either make it immutable or make the `Intent` within explicit");
        return true;
    }

    static {
        String[][] stringArrayArray = Issue.Companion;
        String[] stringArray = Category.SECURITY;
        Severity severity = Severity.ERROR;
        Implementation implementation = new Implementation(PendingIntentMutableImplicitDetector.class, Scope.JAVA_FILE_SCOPE);
        ISSUE = Issue.Companion.create$default((Issue.Companion)stringArrayArray, (String)"MutableImplicitPendingIntent", (String)"Mutable Implicit PendingIntent is disallowed", (String)"\n          Apps targeting Android 14 and above are not allowed to create `PendingIntents` with \\\n          `FLAG_MUTABLE` and an implicit intent within for security reasons.\n\n          To retrieve an existing PendingIntent, use `FLAG_NO_CREATE`. To create a new \\\n          `PendingIntent`, either make the intent explicit, or make it immutable with \\\n          `FLAG_IMMUTABLE`.\n          ", (Implementation)implementation, null, (Category)stringArray, (int)5, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        stringArrayArray = new String[2][];
        stringArray = new String[]{"android.content.Context", "java.lang.Class<?>"};
        stringArrayArray[0] = stringArray;
        stringArray = new String[]{"java.lang.String", CLASS_URI, "android.content.Context", "java.lang.Class<?>"};
        stringArrayArray[1] = stringArray;
        INTENT_EXPLICIT_CONSTRUCTOR_ARGS = CollectionsKt.listOf((Object[])((Object[])stringArrayArray));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0004RSTUB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010 \u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\"\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020#2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u001fH\u0002J(\u0010&\u001a\u0012\u0012\u0004\u0012\u00020\u001a\u0012\u0006\u0012\u0004\u0018\u00010(\u0018\u00010'2\u0006\u0010\u001e\u001a\u00020#2\u0006\u0010)\u001a\u00020\u001fH\u0002J \u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00182\u0006\u0010)\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u000e\u0010-\u001a\u00020\u0014*\u0004\u0018\u00010\u001fH\u0002J\u001a\u0010.\u001a\u00020\u00142\b\u0010)\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010/\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u00100\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u001fH\u0002J\u0018\u00101\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u001f2\u0006\u00102\u001a\u00020\u0007H\u0002J\u001c\u00101\u001a\u00020\u0014*\u0002032\u0006\u00104\u001a\u0002052\u0006\u00102\u001a\u00020\u0007H\u0002J\u0014\u00106\u001a\u00020\u0014*\u0002032\u0006\u00104\u001a\u000205H\u0002J&\u00107\u001a\u00020\u00142\u0006\u00104\u001a\u0002052\u0014\b\u0002\u00108\u001a\u000e\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020\u001409H\u0002J\u0010\u0010;\u001a\u00020\u00142\u0006\u00104\u001a\u000205H\u0002J\u0010\u0010<\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u001fH\u0002J\u0018\u0010=\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010>\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u001fH\u0002J\u0010\u0010?\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u001fH\u0002J\u0010\u0010@\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u001fH\u0002J0\u0010A\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020!2\u0006\u0010B\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020\u00182\u0006\u0010)\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J0\u0010C\u001a\u00020\u00182\u0006\u0010B\u001a\u00020\u001a2\u0006\u0010D\u001a\u00020\u00182\u0006\u0010E\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001aH\u0002J\"\u0010F\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u001f2\b\u0010E\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001a\u0010G\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u00112\b\u0010E\u001a\u0004\u0018\u00010\u001aH\u0002J\u0012\u0010H\u001a\u0004\u0018\u00010\u001a2\u0006\u0010%\u001a\u00020\u001aH\u0002J\u0018\u0010I\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\u001aH\u0002J \u0010J\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001a\u0010K\u001a\u0004\u0018\u00010L2\u0006\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020\u001aH\u0002J\u0018\u0010P\u001a\u00020L2\u0006\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020\u001aH\u0002J\u001a\u0010Q\u001a\u0004\u0018\u00010\u001a2\u0006\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020\u001aH\u0002R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006V"}, d2={"Lcom/android/tools/lint/checks/PendingIntentMutableImplicitDetector$Companion;", "", "<init>", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "CLASS_URI", "", "METHOD_ARRAY_OF", "METHOD_ARRAY_OF_NULLS", "METHOD_INTENT_SET_COMPONENT", "METHOD_INTENT_SET_PACKAGE", "METHOD_INTENT_SET_CLASS", "METHOD_INTENT_SET_CLASS_NAME", "METHOD_LIST_OF", "TYPE_PARAM", "INTENT_EXPLICIT_CONSTRUCTOR_ARGS", "", "", "isNewMutableNonExemptedPendingIntent", "", "flags", "", "getIntentTypeForExpression", "Lcom/android/tools/lint/checks/PendingIntentMutableImplicitDetector$Companion$IntentType;", "intentExp", "Lorg/jetbrains/uast/UExpression;", "intentInfo", "Lcom/android/tools/lint/checks/PendingIntentMutableImplicitDetector$Companion$IntentExpressionInfo;", "getIntentTypeForCall", "intent", "Lorg/jetbrains/uast/UCallExpression;", "getIntentTypeForQualified", "Lorg/jetbrains/uast/UQualifiedReferenceExpression;", "getIntentTypeForSimpleName", "Lorg/jetbrains/uast/USimpleNameReferenceExpression;", "isNewJavaKotlinArrayWithDimensions", "exp", "findLastAssignmentAndItsParentUMethod", "Lkotlin/Pair;", "Lorg/jetbrains/uast/UMethod;", "call", "setIntentTypeAfterCallInPlace", "", "intentType", "isFirstArgNull", "isIntentMethodCall", "isEscapeCall", "isKotlinCollection", "isArrayOfOrArrayOfNulls", "arrayOfMethodName", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "symbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaFunctionSymbol;", "isListOf", "hasSingleTypeParameter", "typeParameterCheck", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaTypeParameterSymbol;", "hasVarargValueParameterOnly", "isWithScopeCall", "getIntentTypeForWithScopeCall", "isSelectorScopeCall", "isApplyAlsoScopeCall", "isLetRunScopeCall", "getIntentTypeForSelectorScopeCall", "intentObject", "getIntentTypeForLambda", "intentObjectType", "lambdaExp", "areAllLambdaExpressionsIntentMethodCalls", "getLambdaExpressionsOrNull", "getRealExpressionOrNull", "isReferencingContextObject", "containsQualifiedIntentMethodCalls", "buildImmutableFixOrNull", "Lcom/android/tools/lint/detector/api/LintFix;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "flagsArgument", "buildNoCreateFix", "findMutableFlagExpression", "IntentExpressionInfo", "IntentType", "IntentSimpleNameAnalyzer", "IntentDataFlowAnalyzer", "lint-checks"})
    @SourceDebugExtension(value={"SMAP\nPendingIntentMutableImplicitDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PendingIntentMutableImplicitDetector.kt\ncom/android/tools/lint/checks/PendingIntentMutableImplicitDetector$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 4 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n*L\n1#1,801:1\n1761#2,3:802\n1761#2,3:805\n1761#2,3:808\n1761#2,3:845\n1761#2,3:848\n1740#2,3:851\n30#3,2:811\n30#3,2:828\n35#4,15:813\n35#4,15:830\n*S KotlinDebug\n*F\n+ 1 PendingIntentMutableImplicitDetector.kt\ncom/android/tools/lint/checks/PendingIntentMutableImplicitDetector$Companion\n*L\n241#1:802,3\n259#1:805,3\n268#1:808,3\n539#1:845,3\n542#1:848,3\n622#1:851,3\n454#1:811,2\n462#1:828,2\n454#1:813,15\n462#1:830,15\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isNewMutableNonExemptedPendingIntent(int flags) {
            boolean isFlagNoCreateSet = (flags & 0x20000000) != 0;
            boolean isFlagMutableSet = (flags & 0x2000000) != 0;
            boolean isFlagAllowUnsafeImplicitIntentSet = (flags & 0x1000000) != 0;
            return isFlagMutableSet && !isFlagNoCreateSet && !isFlagAllowUnsafeImplicitIntentSet;
        }

        private final IntentType getIntentTypeForExpression(UExpression intentExp, IntentExpressionInfo intentInfo) {
            UExpression intent = UastUtils.skipParenthesizedExprDown((UExpression)intentExp);
            return intent instanceof UCallExpression ? this.getIntentTypeForCall((UCallExpression)intent, intentInfo) : (intent instanceof UQualifiedReferenceExpression ? this.getIntentTypeForQualified((UQualifiedReferenceExpression)intent, intentInfo) : (intent instanceof USimpleNameReferenceExpression ? this.getIntentTypeForSimpleName((USimpleNameReferenceExpression)intent, intentInfo) : new IntentType(false)));
        }

        private final IntentType getIntentTypeForCall(UCallExpression intent, IntentExpressionInfo intentInfo) {
            IntentType intentType;
            UastCallKind uastCallKind = intent.getKind();
            if (Intrinsics.areEqual((Object)uastCallKind, (Object)UastCallKind.CONSTRUCTOR_CALL)) {
                boolean bl;
                block20: {
                    Iterable $this$any$iv = INTENT_EXPLICIT_CONSTRUCTOR_ARGS;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String[] constructorArgs = (String[])element$iv;
                            boolean bl2 = false;
                            PsiMethod psiMethod = intent.resolve();
                            if (psiMethod == null) {
                                return new IntentType(false);
                            }
                            if (!intentInfo.getJavaEvaluator().methodMatches(psiMethod, "android.content.Intent", false, Arrays.copyOf(constructorArgs, constructorArgs.length))) continue;
                            bl = true;
                            break block20;
                        }
                        bl = false;
                    }
                }
                intentType = bl ? new IntentType(true, false, false, 4, null) : new IntentType(true);
            } else if (Intrinsics.areEqual((Object)uastCallKind, (Object)UastCallKind.NESTED_ARRAY_INITIALIZER) || Intrinsics.areEqual((Object)uastCallKind, (Object)UastCallKind.NEW_ARRAY_WITH_INITIALIZER)) {
                boolean bl;
                block21: {
                    Iterable $this$any$iv = intent.getValueArguments();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            UExpression it = (UExpression)element$iv;
                            boolean bl3 = false;
                            if (!Companion.getIntentTypeForExpression(it, intentInfo).isImplicit()) continue;
                            bl = true;
                            break block21;
                        }
                        bl = false;
                    }
                }
                boolean bl4 = bl;
                intentType = new IntentType(bl4);
            } else if (Intrinsics.areEqual((Object)uastCallKind, (Object)UastCallKind.METHOD_CALL)) {
                if (this.isWithScopeCall(intent)) {
                    intentType = this.getIntentTypeForWithScopeCall(intent, intentInfo);
                } else if (this.isKotlinCollection(intent)) {
                    boolean bl;
                    block22: {
                        Iterable $this$any$iv = intent.getValueArguments();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                UExpression it = (UExpression)element$iv;
                                boolean bl5 = false;
                                if (!Companion.getIntentTypeForExpression(it, intentInfo).isImplicit()) continue;
                                bl = true;
                                break block22;
                            }
                            bl = false;
                        }
                    }
                    boolean bl6 = bl;
                    intentType = new IntentType(bl6);
                } else {
                    intentType = new IntentType(false);
                }
            } else {
                intentType = new IntentType(false);
            }
            return intentType;
        }

        private final IntentType getIntentTypeForQualified(UQualifiedReferenceExpression intent, IntentExpressionInfo intentInfo) {
            List qualifiedChain = UastUtils.getQualifiedChain((UExpression)((UExpression)intent));
            if (qualifiedChain.isEmpty()) {
                return new IntentType(false);
            }
            if (Lint.isKotlin((Language)intent.getLang()) && qualifiedChain.size() >= 3 && Intrinsics.areEqual((Object)((UExpression)qualifiedChain.get(0)).asSourceString(), (Object)"android") && Intrinsics.areEqual((Object)((UExpression)qualifiedChain.get(1)).asSourceString(), (Object)"content")) {
                qualifiedChain = CollectionsKt.drop((Iterable)qualifiedChain, (int)2);
            }
            Pair pair = UtilKt.headTail((List)qualifiedChain);
            UExpression intentObject = (UExpression)pair.component1();
            List calls = (List)pair.component2();
            IntentType intentType = this.getIntentTypeForExpression(intentObject, intentInfo);
            for (UExpression c2 : calls) {
                if (intentType.isEscaped()) break;
                UCallExpression uCallExpression = c2 instanceof UCallExpression ? (UCallExpression)c2 : null;
                if (uCallExpression == null) continue;
                UCallExpression call2 = uCallExpression;
                if (this.isSelectorScopeCall(call2)) {
                    intentType = this.getIntentTypeForSelectorScopeCall(intent, intentObject, intentType, call2, intentInfo);
                    continue;
                }
                this.setIntentTypeAfterCallInPlace(intentType, call2, intentInfo);
            }
            return intentType;
        }

        private final IntentType getIntentTypeForSimpleName(USimpleNameReferenceExpression intent, IntentExpressionInfo intentInfo) {
            Pair<UExpression, UMethod> pair = this.findLastAssignmentAndItsParentUMethod(intent, intentInfo.getCall());
            if (pair == null) {
                return new IntentType(false);
            }
            Pair<UExpression, UMethod> pair2 = pair;
            UExpression assign = (UExpression)pair2.component1();
            UMethod assignParentUMethod = (UMethod)pair2.component2();
            UMethod uMethod = (UMethod)UastUtils.getParentOfType$default((UElement)((UElement)intent), UMethod.class, (boolean)false, (int)2, null);
            if (uMethod == null) {
                return new IntentType(false);
            }
            UMethod intentParentUMethod = uMethod;
            if (!Intrinsics.areEqual((Object)assignParentUMethod, (Object)intentParentUMethod)) {
                return new IntentType(false);
            }
            int intentArraySize = 0;
            IntentType assignIntentType = new IntentType(false);
            if (assign instanceof UCallExpression && this.isNewJavaKotlinArrayWithDimensions((UCallExpression)assign)) {
                if (((UCallExpression)assign).getValueArguments().size() > 1) {
                    return new IntentType(false);
                }
                Object object = ((UExpression)((UCallExpression)assign).getValueArguments().get(0)).evaluate();
                Integer n = object instanceof Integer ? (Integer)object : null;
                intentArraySize = n != null ? n : 0;
            } else {
                assignIntentType = this.getIntentTypeForExpression(assign, intentInfo);
            }
            if (assignIntentType.isEscaped()) {
                return assignIntentType;
            }
            IntentSimpleNameAnalyzer analyzer2 = new IntentSimpleNameAnalyzer(assign, intent, intentInfo, intentArraySize, assignIntentType);
            intentParentUMethod.accept((UastVisitor)analyzer2);
            return analyzer2.getIntentTypeAfterGivenAssignment();
        }

        private final boolean isNewJavaKotlinArrayWithDimensions(UCallExpression exp) {
            return UastExpressionUtils.isNewArrayWithDimensions((UElement)((UElement)exp)) || UastExpressionUtils.isMethodCall((UElement)((UElement)exp)) && this.isArrayOfOrArrayOfNulls(exp, PendingIntentMutableImplicitDetector.METHOD_ARRAY_OF_NULLS);
        }

        private final Pair<UExpression, UMethod> findLastAssignmentAndItsParentUMethod(USimpleNameReferenceExpression intent, UCallExpression call2) {
            UExpression uExpression;
            PsiElement psiElement = intent.resolve();
            PsiVariable psiVariable = psiElement instanceof PsiVariable ? (PsiVariable)psiElement : null;
            if (psiVariable == null) {
                return null;
            }
            UExpression uExpression2 = UastLintUtils.Companion.findLastAssignment(psiVariable, (UElement)call2);
            if (uExpression2 == null || (uExpression = UastUtils.skipParenthesizedExprDown((UExpression)uExpression2)) == null) {
                return null;
            }
            UExpression assign = uExpression;
            return new Pair((Object)assign, (Object)UastUtils.getParentOfType$default((UElement)((UElement)assign), UMethod.class, (boolean)false, (int)2, null));
        }

        private final void setIntentTypeAfterCallInPlace(IntentType intentType, UCallExpression call2, IntentExpressionInfo intentInfo) {
            block16: {
                String string2 = call2.getMethodName();
                if (string2 == null) break block16;
                int n = -1;
                switch (string2.hashCode()) {
                    case -2128364156: {
                        if (string2.equals(PendingIntentMutableImplicitDetector.METHOD_INTENT_SET_PACKAGE)) {
                            n = 1;
                        }
                        break;
                    }
                    case 1389455926: {
                        if (string2.equals(PendingIntentMutableImplicitDetector.METHOD_INTENT_SET_CLASS)) {
                            n = 2;
                        }
                        break;
                    }
                    case 139480763: {
                        if (string2.equals(PendingIntentMutableImplicitDetector.METHOD_INTENT_SET_COMPONENT)) {
                            n = 3;
                        }
                        break;
                    }
                    case 1529499105: {
                        if (string2.equals(PendingIntentMutableImplicitDetector.METHOD_INTENT_SET_CLASS_NAME)) {
                            n = 2;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 3: {
                        intentType.setHasComponent(!this.isFirstArgNull(call2));
                        break;
                    }
                    case 1: {
                        intentType.setHasPackage(!this.isFirstArgNull(call2));
                        break;
                    }
                    case 2: {
                        intentType.setHasComponent(true);
                    }
                }
            }
            if (!intentType.isEscaped()) {
                intentType.setEscaped(this.isEscapeCall(call2, intentInfo));
            }
        }

        private final boolean isFirstArgNull(UCallExpression $this$isFirstArgNull) {
            Object object = $this$isFirstArgNull;
            UExpression uExpression = object != null && (object = object.getValueArguments()) != null ? (UExpression)CollectionsKt.getOrNull((List)object, (int)0) : null;
            ULiteralExpression uLiteralExpression = uExpression instanceof ULiteralExpression ? (ULiteralExpression)uExpression : null;
            return uLiteralExpression != null ? uLiteralExpression.isNull() : false;
        }

        private final boolean isIntentMethodCall(UCallExpression call2, IntentExpressionInfo intentInfo) {
            UCallExpression uCallExpression = call2;
            return intentInfo.getJavaEvaluator().isMemberInClass((PsiMember)(uCallExpression != null ? uCallExpression.resolve() : null), "android.content.Intent");
        }

        private final boolean isEscapeCall(UCallExpression call2, IntentExpressionInfo intentInfo) {
            return !this.isIntentMethodCall(call2, intentInfo) && !this.isSelectorScopeCall(call2) && !this.isWithScopeCall(call2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final boolean isKotlinCollection(UCallExpression call2) {
            void this_$iv$iv;
            KtElement sourcePsi;
            PsiElement psiElement = call2.getSourcePsi();
            KtElement ktElement = psiElement instanceof KtElement ? (KtElement)psiElement : null;
            if (ktElement == null) {
                return false;
            }
            KtElement useSiteElement$iv = sourcePsi = ktElement;
            boolean $i$f$analyze = false;
            Project project = useSiteElement$iv.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project);
            KtElement useSiteElement$iv$iv = useSiteElement$iv;
            boolean $i$f$analyze2 = false;
            KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(useSiteElement$iv$iv);
            this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
            try {
                Object lock$iv$iv;
                Object object = lock$iv$iv = new Object();
                synchronized (object) {
                    KaFunctionSymbol kaFunctionSymbol;
                    KaSession $this$isKotlinCollection_u24lambda_u240;
                    block12: {
                        try {
                            boolean bl = false;
                            $this$isKotlinCollection_u24lambda_u240 = analysisSession$iv$iv;
                            boolean bl2 = false;
                            if (AnalysisApiLintUtilsKt.getFunctionLikeSymbol($this$isKotlinCollection_u24lambda_u240, sourcePsi) != null) break block12;
                            boolean bl3 = false;
                            // MONITOREXIT @DISABLED, blocks:[0, 1, 6] lbl25 : MonitorExitStatement: MONITOREXIT : var10_11
                            boolean bl4 = bl3;
                            return bl4;
                        }
                        catch (Throwable throwable) {
                            try {
                                throw throwable;
                            }
                            catch (Throwable throwable$iv$iv) {
                                this_$iv$iv.handleAnalysisException(throwable$iv$iv, analysisSession$iv$iv, useSiteElement$iv$iv);
                                throw new KotlinNothingValueException();
                            }
                        }
                    }
                    KaFunctionSymbol symbol = kaFunctionSymbol;
                    boolean bl = Companion.isListOf($this$isKotlinCollection_u24lambda_u240, symbol) || Companion.isArrayOfOrArrayOfNulls($this$isKotlinCollection_u24lambda_u240, symbol, PendingIntentMutableImplicitDetector.METHOD_ARRAY_OF);
                    // MONITOREXIT @DISABLED, blocks:[0, 3, 6] lbl31 : MonitorExitStatement: MONITOREXIT : var10_11
                    boolean bl5 = bl;
                    return bl5;
                }
            }
            finally {
                this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final boolean isArrayOfOrArrayOfNulls(UCallExpression call2, String arrayOfMethodName) {
            void this_$iv$iv;
            KtElement sourcePsi;
            PsiElement psiElement = call2.getSourcePsi();
            KtElement ktElement = psiElement instanceof KtElement ? (KtElement)psiElement : null;
            if (ktElement == null) {
                return false;
            }
            KtElement useSiteElement$iv = sourcePsi = ktElement;
            boolean $i$f$analyze = false;
            Project project = useSiteElement$iv.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project);
            KtElement useSiteElement$iv$iv = useSiteElement$iv;
            boolean $i$f$analyze2 = false;
            KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(useSiteElement$iv$iv);
            this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
            try {
                Object lock$iv$iv;
                Object object = lock$iv$iv = new Object();
                synchronized (object) {
                    KaFunctionSymbol kaFunctionSymbol;
                    KaSession $this$isArrayOfOrArrayOfNulls_u24lambda_u240;
                    block12: {
                        try {
                            boolean bl = false;
                            $this$isArrayOfOrArrayOfNulls_u24lambda_u240 = analysisSession$iv$iv;
                            boolean bl2 = false;
                            if (AnalysisApiLintUtilsKt.getFunctionLikeSymbol($this$isArrayOfOrArrayOfNulls_u24lambda_u240, sourcePsi) != null) break block12;
                            boolean bl3 = false;
                            // MONITOREXIT @DISABLED, blocks:[0, 1, 6] lbl25 : MonitorExitStatement: MONITOREXIT : var11_12
                            boolean bl4 = bl3;
                            return bl4;
                        }
                        catch (Throwable throwable) {
                            try {
                                throw throwable;
                            }
                            catch (Throwable throwable$iv$iv) {
                                this_$iv$iv.handleAnalysisException(throwable$iv$iv, analysisSession$iv$iv, useSiteElement$iv$iv);
                                throw new KotlinNothingValueException();
                            }
                        }
                    }
                    KaFunctionSymbol symbol = kaFunctionSymbol;
                    boolean bl = Companion.isArrayOfOrArrayOfNulls($this$isArrayOfOrArrayOfNulls_u24lambda_u240, symbol, arrayOfMethodName);
                    // MONITOREXIT @DISABLED, blocks:[0, 3, 6] lbl31 : MonitorExitStatement: MONITOREXIT : var11_12
                    boolean bl5 = bl;
                    return bl5;
                }
            }
            finally {
                this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
            }
        }

        private final boolean isArrayOfOrArrayOfNulls(KaSession $this$isArrayOfOrArrayOfNulls, KaFunctionSymbol symbol, String arrayOfMethodName) {
            if (!this.hasSingleTypeParameter(symbol, (Function1<? super KaTypeParameterSymbol, Boolean>)((Function1)isArrayOfOrArrayOfNulls.2.INSTANCE))) {
                return false;
            }
            if (Intrinsics.areEqual((Object)arrayOfMethodName, (Object)PendingIntentMutableImplicitDetector.METHOD_ARRAY_OF) && !this.hasVarargValueParameterOnly(symbol)) {
                return false;
            }
            CallableId callableId = symbol.getCallableId();
            if (callableId == null) {
                return false;
            }
            CallableId callableId2 = callableId;
            FqName packageName = callableId2.getPackageName();
            String string2 = callableId2.getCallableName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
            String methodName = string2;
            KaType returnType = symbol.getReturnType();
            return Intrinsics.areEqual((Object)packageName, (Object)StandardClassIds.INSTANCE.getBASE_KOTLIN_PACKAGE()) && symbol.getLocation() == KaSymbolLocation.TOP_LEVEL && Intrinsics.areEqual((Object)methodName, (Object)arrayOfMethodName) && $this$isArrayOfOrArrayOfNulls.isArrayOrPrimitiveArray(returnType);
        }

        private final boolean isListOf(KaSession $this$isListOf, KaFunctionSymbol symbol) {
            if (!com.android.tools.lint.checks.PendingIntentMutableImplicitDetector$Companion.hasSingleTypeParameter$default(this, symbol, null, 2, null) || !this.hasVarargValueParameterOnly(symbol)) {
                return false;
            }
            CallableId callableId = symbol.getCallableId();
            if (callableId == null) {
                return false;
            }
            CallableId callableId2 = callableId;
            FqName packageName = callableId2.getPackageName();
            String string2 = callableId2.getCallableName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
            String methodName = string2;
            KaType returnType = symbol.getReturnType();
            return Intrinsics.areEqual((Object)packageName, (Object)StandardClassIds.INSTANCE.getBASE_COLLECTIONS_PACKAGE()) && symbol.getLocation() == KaSymbolLocation.TOP_LEVEL && Intrinsics.areEqual((Object)methodName, (Object)PendingIntentMutableImplicitDetector.METHOD_LIST_OF) && $this$isListOf.isClassType(returnType, StandardClassIds.INSTANCE.getList());
        }

        private final boolean hasSingleTypeParameter(KaFunctionSymbol symbol, Function1<? super KaTypeParameterSymbol, Boolean> typeParameterCheck) {
            List typeParameters = KaDeclarationSymbolKt.getTypeParameters((KaDeclarationSymbol)((KaDeclarationSymbol)symbol));
            if (typeParameters.size() != 1) {
                return false;
            }
            KaTypeParameterSymbol typeParam = (KaTypeParameterSymbol)typeParameters.get(0);
            return Intrinsics.areEqual((Object)typeParam.getName().asString(), (Object)PendingIntentMutableImplicitDetector.TYPE_PARAM) && (Boolean)typeParameterCheck.invoke((Object)typeParam) != false;
        }

        static /* synthetic */ boolean hasSingleTypeParameter$default(Companion companion, KaFunctionSymbol kaFunctionSymbol, Function1 function1, int n, Object object) {
            if ((n & 2) != 0) {
                function1 = hasSingleTypeParameter.1.INSTANCE;
            }
            return companion.hasSingleTypeParameter(kaFunctionSymbol, (Function1<? super KaTypeParameterSymbol, Boolean>)function1);
        }

        private final boolean hasVarargValueParameterOnly(KaFunctionSymbol symbol) {
            List valueParameters = symbol.getValueParameters();
            if (valueParameters.size() != 1) {
                return false;
            }
            return ((KaValueParameterSymbol)valueParameters.get(0)).isVararg();
        }

        private final boolean isWithScopeCall(UCallExpression call2) {
            return Intrinsics.areEqual((Object)call2.getMethodName(), (Object)"with") && UastLintUtilsKt.isScopingFunction((UCallExpression)call2);
        }

        private final IntentType getIntentTypeForWithScopeCall(UCallExpression intent, IntentExpressionInfo intentInfo) {
            UExpression uExpression = intent.getArgumentForParameter(0);
            if (uExpression == null || (uExpression = UastUtils.skipParenthesizedExprDown((UExpression)uExpression)) == null) {
                return new IntentType(false);
            }
            UExpression intentObject = uExpression;
            UExpression uExpression2 = intent.getArgumentForParameter(1);
            if (uExpression2 == null) {
                return new IntentType(false);
            }
            UExpression lambdaExp = uExpression2;
            if (!this.areAllLambdaExpressionsIntentMethodCalls(intent, lambdaExp, intentInfo)) {
                return new IntentType(false);
            }
            IntentType intentObjectType = this.getIntentTypeForExpression(intentObject, intentInfo);
            return this.getIntentTypeForLambda(intentObject, intentObjectType, lambdaExp, intentInfo, (UExpression)intent);
        }

        private final boolean isSelectorScopeCall(UCallExpression call2) {
            return this.isApplyAlsoScopeCall(call2) || this.isLetRunScopeCall(call2);
        }

        private final boolean isApplyAlsoScopeCall(UCallExpression call2) {
            boolean bl;
            block3: {
                Object[] objectArray = new String[]{"apply", "also"};
                Iterable $this$any$iv = CollectionsKt.listOf((Object[])objectArray);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it, (Object)call2.getMethodName())) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl && UastLintUtilsKt.isScopingFunction((UCallExpression)call2);
        }

        private final boolean isLetRunScopeCall(UCallExpression call2) {
            boolean bl;
            block3: {
                Object[] objectArray = new String[]{"let", "run"};
                Iterable $this$any$iv = CollectionsKt.listOf((Object[])objectArray);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it, (Object)call2.getMethodName())) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl && UastLintUtilsKt.isScopingFunction((UCallExpression)call2);
        }

        private final IntentType getIntentTypeForSelectorScopeCall(UQualifiedReferenceExpression intent, UExpression intentObject, IntentType intentType, UCallExpression call2, IntentExpressionInfo intentInfo) {
            UExpression uExpression = (UExpression)CollectionsKt.getOrNull((List)call2.getValueArguments(), (int)0);
            if (uExpression == null) {
                return new IntentType(false);
            }
            UExpression lambdaExp = uExpression;
            if (this.isLetRunScopeCall(call2) && !this.areAllLambdaExpressionsIntentMethodCalls(call2, lambdaExp, intentInfo)) {
                return new IntentType(false);
            }
            return this.getIntentTypeForLambda(intentObject, intentType, lambdaExp, intentInfo, (UExpression)intent);
        }

        private final IntentType getIntentTypeForLambda(UExpression intentObject, IntentType intentObjectType, UExpression lambdaExp, IntentExpressionInfo intentInfo, UExpression intent) {
            IntentDataFlowAnalyzer analyzer2;
            block0: {
                analyzer2 = new IntentDataFlowAnalyzer(intentObject, lambdaExp, intentObjectType, intentInfo);
                UMethod uMethod = (UMethod)UastUtils.getParentOfType$default((UElement)((UElement)intent), UMethod.class, (boolean)false, (int)2, null);
                if (uMethod == null) break block0;
                uMethod.accept((UastVisitor)analyzer2);
            }
            return analyzer2.getIntentTypeAfterGivenAssignment();
        }

        private final boolean areAllLambdaExpressionsIntentMethodCalls(UCallExpression call2, UExpression lambdaExp, IntentExpressionInfo intentInfo) {
            List<UExpression> list = this.getLambdaExpressionsOrNull(lambdaExp);
            if (list == null) {
                return false;
            }
            List<UExpression> expressions = list;
            for (UExpression exp : expressions) {
                UExpression realExp;
                if (this.getRealExpressionOrNull(exp) == null) {
                    return false;
                }
                UExpression uExpression = realExp;
                boolean containsOnlyIntentMethodCalls = uExpression instanceof UCallExpression ? this.isIntentMethodCall((UCallExpression)realExp, intentInfo) : (uExpression instanceof UQualifiedReferenceExpression ? this.containsQualifiedIntentMethodCalls(call2, (UQualifiedReferenceExpression)realExp, intentInfo) : false);
                if (containsOnlyIntentMethodCalls) continue;
                return false;
            }
            return true;
        }

        private final List<UExpression> getLambdaExpressionsOrNull(UExpression lambdaExp) {
            ULambdaExpression uLambdaExpression = lambdaExp instanceof ULambdaExpression ? (ULambdaExpression)lambdaExp : null;
            UExpression uExpression = uLambdaExpression != null ? uLambdaExpression.getBody() : null;
            UBlockExpression uBlockExpression = uExpression instanceof UBlockExpression ? (UBlockExpression)uExpression : null;
            return uBlockExpression != null ? uBlockExpression.getExpressions() : null;
        }

        private final UExpression getRealExpressionOrNull(UExpression exp) {
            UExpression realExp;
            UExpression uExpression = realExp = exp instanceof UReturnExpression ? ((UReturnExpression)exp).getReturnExpression() : exp;
            return uExpression != null ? UastUtils.skipParenthesizedExprDown((UExpression)uExpression) : null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isReferencingContextObject(UCallExpression call2, UExpression exp) {
            if (UastLintUtilsKt.isScopingIt((UCallExpression)call2)) {
                USimpleNameReferenceExpression uSimpleNameReferenceExpression = exp instanceof USimpleNameReferenceExpression ? (USimpleNameReferenceExpression)exp : null;
                if (Intrinsics.areEqual((Object)(uSimpleNameReferenceExpression != null ? uSimpleNameReferenceExpression.getIdentifier() : null), (Object)"it")) return true;
            }
            if (!UastLintUtilsKt.isScopingThis((UCallExpression)call2)) return false;
            if (!(exp instanceof UThisExpression)) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean containsQualifiedIntentMethodCalls(UCallExpression call2, UQualifiedReferenceExpression exp, IntentExpressionInfo intentInfo) {
            UExpression it;
            List chain = UastUtils.getQualifiedChain((UExpression)((UExpression)exp));
            if (chain.isEmpty()) {
                return false;
            }
            Pair pair = UtilKt.headTail((List)chain);
            UExpression head = (UExpression)pair.component1();
            List tail = (List)pair.component2();
            if (!this.isReferencingContextObject(call2, head)) return false;
            Iterable $this$all$iv = tail;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                return true;
            }
            Iterator iterator = $this$all$iv.iterator();
            do {
                if (!iterator.hasNext()) return true;
                Object element$iv = iterator.next();
                it = (UExpression)element$iv;
                boolean bl = false;
            } while (Companion.isIntentMethodCall(it instanceof UCallExpression ? (UCallExpression)it : null, intentInfo));
            return false;
        }

        private final LintFix buildImmutableFixOrNull(JavaContext context, UExpression flagsArgument) {
            UExpression uExpression = this.findMutableFlagExpression(context, flagsArgument);
            if (uExpression == null) {
                return null;
            }
            UExpression mutableFlagExpression = uExpression;
            return LintFix.Companion.create().name("Replace FLAG_MUTABLE with FLAG_IMMUTABLE").replace().reformat(true).shortenNames().range(context.getLocation((UElement)mutableFlagExpression)).with("android.app.PendingIntent.FLAG_IMMUTABLE").build();
        }

        private final LintFix buildNoCreateFix(JavaContext context, UExpression flagsArgument) {
            String orSymbol = Lint.isKotlin((Language)flagsArgument.getLang()) ? "or" : "|";
            String fixText = " " + orSymbol + " android.app.PendingIntent.FLAG_NO_CREATE";
            return LintFix.Companion.create().name("Add FLAG_NO_CREATE").replace().end().reformat(true).shortenNames().range(context.getLocation((UElement)flagsArgument)).with(fixText).build();
        }

        private final UExpression findMutableFlagExpression(JavaContext context, UExpression flagsArgument) {
            Ref.ObjectRef mutableFlagExpression = new Ref.ObjectRef();
            flagsArgument.accept(new UastVisitor(context, (Ref.ObjectRef<UExpression>)mutableFlagExpression){
                final /* synthetic */ JavaContext $context;
                final /* synthetic */ Ref.ObjectRef<UExpression> $mutableFlagExpression;
                {
                    this.$context = $context;
                    this.$mutableFlagExpression = $mutableFlagExpression;
                }

                public boolean visitElement(UElement node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    return false;
                }

                public boolean visitExpression(UExpression node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    if (Intrinsics.areEqual((Object)ConstantEvaluator.evaluate((JavaContext)this.$context, (UElement)((UElement)node)), (Object)0x2000000)) {
                        this.$mutableFlagExpression.element = node;
                        return true;
                    }
                    return false;
                }
            });
            return (UExpression)mutableFlagExpression.element;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0012\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0003H\u0016J\u0006\u0010\u001c\u001a\u00020\u0015J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u0006H\u0016J\u0010\u0010$\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010%\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006&"}, d2={"Lcom/android/tools/lint/checks/PendingIntentMutableImplicitDetector$Companion$IntentDataFlowAnalyzer;", "Lcom/android/tools/lint/checks/DataFlowAnalyzer;", "startExp", "Lorg/jetbrains/uast/UExpression;", "endExp", "intentType", "Lcom/android/tools/lint/checks/PendingIntentMutableImplicitDetector$Companion$IntentType;", "intentInfo", "Lcom/android/tools/lint/checks/PendingIntentMutableImplicitDetector$Companion$IntentExpressionInfo;", "<init>", "(Lorg/jetbrains/uast/UExpression;Lorg/jetbrains/uast/UExpression;Lcom/android/tools/lint/checks/PendingIntentMutableImplicitDetector$Companion$IntentType;Lcom/android/tools/lint/checks/PendingIntentMutableImplicitDetector$Companion$IntentExpressionInfo;)V", "getStartExp", "()Lorg/jetbrains/uast/UExpression;", "getEndExp", "getIntentType", "()Lcom/android/tools/lint/checks/PendingIntentMutableImplicitDetector$Companion$IntentType;", "setIntentType", "(Lcom/android/tools/lint/checks/PendingIntentMutableImplicitDetector$Companion$IntentType;)V", "getIntentInfo", "()Lcom/android/tools/lint/checks/PendingIntentMutableImplicitDetector$Companion$IntentExpressionInfo;", "isEndReached", "", "()Z", "setEndReached", "(Z)V", "afterVisitExpression", "", "node", "isIntentAnalyzable", "receiver", "call", "Lorg/jetbrains/uast/UCallExpression;", "argument", "reference", "Lorg/jetbrains/uast/UElement;", "getIntentTypeAfterGivenAssignment", "isPendingIntentGetMethod", "isIgnoredArgument", "lint-checks"})
        private static class IntentDataFlowAnalyzer
        extends DataFlowAnalyzer {
            @NotNull
            private final UExpression startExp;
            @NotNull
            private final UExpression endExp;
            @NotNull
            private IntentType intentType;
            @NotNull
            private final IntentExpressionInfo intentInfo;
            private boolean isEndReached;

            public IntentDataFlowAnalyzer(@NotNull UExpression startExp, @NotNull UExpression endExp, @NotNull IntentType intentType, @NotNull IntentExpressionInfo intentInfo) {
                Intrinsics.checkNotNullParameter((Object)startExp, (String)"startExp");
                Intrinsics.checkNotNullParameter((Object)endExp, (String)"endExp");
                Intrinsics.checkNotNullParameter((Object)intentType, (String)"intentType");
                Intrinsics.checkNotNullParameter((Object)intentInfo, (String)"intentInfo");
                super(SetsKt.setOf((Object)startExp), null, 2, null);
                this.startExp = startExp;
                this.endExp = endExp;
                this.intentType = intentType;
                this.intentInfo = intentInfo;
            }

            @NotNull
            public final UExpression getStartExp() {
                return this.startExp;
            }

            @NotNull
            public final UExpression getEndExp() {
                return this.endExp;
            }

            @NotNull
            public final IntentType getIntentType() {
                return this.intentType;
            }

            public final void setIntentType(@NotNull IntentType intentType) {
                Intrinsics.checkNotNullParameter((Object)intentType, (String)"<set-?>");
                this.intentType = intentType;
            }

            @NotNull
            public final IntentExpressionInfo getIntentInfo() {
                return this.intentInfo;
            }

            public final boolean isEndReached() {
                return this.isEndReached;
            }

            public final void setEndReached(boolean bl) {
                this.isEndReached = bl;
            }

            public void afterVisitExpression(@NotNull UExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (Intrinsics.areEqual((Object)node, (Object)this.endExp)) {
                    this.isEndReached = true;
                }
                if (!this.isEndReached) {
                    super.afterVisitExpression(node);
                }
            }

            public final boolean isIntentAnalyzable() {
                return !this.intentType.isEscaped() && !this.isEndReached;
            }

            @Override
            public void receiver(@NotNull UCallExpression call2) {
                Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
                if (!this.isIntentAnalyzable()) {
                    return;
                }
                Companion.setIntentTypeAfterCallInPlace(this.intentType, call2, this.intentInfo);
            }

            @Override
            public void argument(@NotNull UCallExpression call2, @NotNull UElement reference) {
                Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
                Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
                if (!this.isIntentAnalyzable()) {
                    return;
                }
                if (!this.isIgnoredArgument(call2, reference)) {
                    this.intentType.setEscaped(true);
                }
            }

            @NotNull
            public IntentType getIntentTypeAfterGivenAssignment() {
                return this.intentType;
            }

            private final boolean isPendingIntentGetMethod(UCallExpression call2) {
                return this.intentInfo.getJavaEvaluator().isMemberInClass((PsiMember)call2.resolve(), "android.app.PendingIntent") && CollectionsKt.contains((Iterable)PendingIntentUtils.INSTANCE.getGET_METHOD_NAMES(), (Object)call2.getMethodName());
            }

            private final boolean isIgnoredArgument(UCallExpression call2, UElement reference) {
                return Intrinsics.areEqual((Object)call2, (Object)UastUtils.skipParenthesizedExprDown((UExpression)this.intentInfo.getIntentArgument())) || Intrinsics.areEqual((Object)reference, (Object)this.intentInfo.getIntentArgument()) || UastExpressionUtils.isNewArrayWithInitializer((UElement)((UElement)call2)) || UastExpressionUtils.isArrayInitializer((UElement)((UElement)call2)) || this.isPendingIntentGetMethod(call2) || Companion.isWithScopeCall(call2) || Companion.isKotlinCollection(call2);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/lint/checks/PendingIntentMutableImplicitDetector$Companion$IntentExpressionInfo;", "", "javaEvaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "call", "Lorg/jetbrains/uast/UCallExpression;", "intentArgument", "Lorg/jetbrains/uast/UExpression;", "<init>", "(Lcom/android/tools/lint/client/api/JavaEvaluator;Lorg/jetbrains/uast/UCallExpression;Lorg/jetbrains/uast/UExpression;)V", "getJavaEvaluator", "()Lcom/android/tools/lint/client/api/JavaEvaluator;", "getCall", "()Lorg/jetbrains/uast/UCallExpression;", "getIntentArgument", "()Lorg/jetbrains/uast/UExpression;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "lint-checks"})
        private static final class IntentExpressionInfo {
            @NotNull
            private final JavaEvaluator javaEvaluator;
            @NotNull
            private final UCallExpression call;
            @NotNull
            private final UExpression intentArgument;

            public IntentExpressionInfo(@NotNull JavaEvaluator javaEvaluator, @NotNull UCallExpression call2, @NotNull UExpression intentArgument) {
                Intrinsics.checkNotNullParameter((Object)javaEvaluator, (String)"javaEvaluator");
                Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
                Intrinsics.checkNotNullParameter((Object)intentArgument, (String)"intentArgument");
                this.javaEvaluator = javaEvaluator;
                this.call = call2;
                this.intentArgument = intentArgument;
            }

            @NotNull
            public final JavaEvaluator getJavaEvaluator() {
                return this.javaEvaluator;
            }

            @NotNull
            public final UCallExpression getCall() {
                return this.call;
            }

            @NotNull
            public final UExpression getIntentArgument() {
                return this.intentArgument;
            }

            @NotNull
            public final JavaEvaluator component1() {
                return this.javaEvaluator;
            }

            @NotNull
            public final UCallExpression component2() {
                return this.call;
            }

            @NotNull
            public final UExpression component3() {
                return this.intentArgument;
            }

            @NotNull
            public final IntentExpressionInfo copy(@NotNull JavaEvaluator javaEvaluator, @NotNull UCallExpression call2, @NotNull UExpression intentArgument) {
                Intrinsics.checkNotNullParameter((Object)javaEvaluator, (String)"javaEvaluator");
                Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
                Intrinsics.checkNotNullParameter((Object)intentArgument, (String)"intentArgument");
                return new IntentExpressionInfo(javaEvaluator, call2, intentArgument);
            }

            public static /* synthetic */ IntentExpressionInfo copy$default(IntentExpressionInfo intentExpressionInfo, JavaEvaluator javaEvaluator, UCallExpression uCallExpression, UExpression uExpression, int n, Object object) {
                if ((n & 1) != 0) {
                    javaEvaluator = intentExpressionInfo.javaEvaluator;
                }
                if ((n & 2) != 0) {
                    uCallExpression = intentExpressionInfo.call;
                }
                if ((n & 4) != 0) {
                    uExpression = intentExpressionInfo.intentArgument;
                }
                return intentExpressionInfo.copy(javaEvaluator, uCallExpression, uExpression);
            }

            @NotNull
            public String toString() {
                return "IntentExpressionInfo(javaEvaluator=" + this.javaEvaluator + ", call=" + this.call + ", intentArgument=" + this.intentArgument + ")";
            }

            public int hashCode() {
                int result = this.javaEvaluator.hashCode();
                result = result * 31 + this.call.hashCode();
                result = result * 31 + this.intentArgument.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof IntentExpressionInfo)) {
                    return false;
                }
                IntentExpressionInfo intentExpressionInfo = (IntentExpressionInfo)other;
                if (!Intrinsics.areEqual((Object)this.javaEvaluator, (Object)intentExpressionInfo.javaEvaluator)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.call, (Object)intentExpressionInfo.call)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.intentArgument, (Object)intentExpressionInfo.intentArgument);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0018\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u000bH\u0016J\u0010\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0007H\u00c6\u0003J\t\u0010#\u001a\u00020\tH\u00c6\u0003J\t\u0010$\u001a\u00020\u000bH\u00c6\u0003J;\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010&\u001a\u00020\u001b2\b\u0010'\u001a\u0004\u0018\u00010(H\u00d6\u0003J\t\u0010)\u001a\u00020\tH\u00d6\u0001J\t\u0010*\u001a\u00020+H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/android/tools/lint/checks/PendingIntentMutableImplicitDetector$Companion$IntentSimpleNameAnalyzer;", "Lcom/android/tools/lint/checks/PendingIntentMutableImplicitDetector$Companion$IntentDataFlowAnalyzer;", "lastAssignment", "Lorg/jetbrains/uast/UExpression;", "intentFinalReference", "Lorg/jetbrains/uast/USimpleNameReferenceExpression;", "initialIntentInfo", "Lcom/android/tools/lint/checks/PendingIntentMutableImplicitDetector$Companion$IntentExpressionInfo;", "intentArraySize", "", "assignIntentType", "Lcom/android/tools/lint/checks/PendingIntentMutableImplicitDetector$Companion$IntentType;", "<init>", "(Lorg/jetbrains/uast/UExpression;Lorg/jetbrains/uast/USimpleNameReferenceExpression;Lcom/android/tools/lint/checks/PendingIntentMutableImplicitDetector$Companion$IntentExpressionInfo;ILcom/android/tools/lint/checks/PendingIntentMutableImplicitDetector$Companion$IntentType;)V", "getLastAssignment", "()Lorg/jetbrains/uast/UExpression;", "getIntentFinalReference", "()Lorg/jetbrains/uast/USimpleNameReferenceExpression;", "getInitialIntentInfo", "()Lcom/android/tools/lint/checks/PendingIntentMutableImplicitDetector$Companion$IntentExpressionInfo;", "getIntentArraySize", "()I", "getAssignIntentType", "()Lcom/android/tools/lint/checks/PendingIntentMutableImplicitDetector$Companion$IntentType;", "intentArrayValuesIsImplicit", "", "visitArrayAccessExpression", "", "node", "Lorg/jetbrains/uast/UArrayAccessExpression;", "getIntentTypeAfterGivenAssignment", "isMemberOfIntentArray", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "", "hashCode", "toString", "", "lint-checks"})
        @SourceDebugExtension(value={"SMAP\nPendingIntentMutableImplicitDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PendingIntentMutableImplicitDetector.kt\ncom/android/tools/lint/checks/PendingIntentMutableImplicitDetector$Companion$IntentSimpleNameAnalyzer\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,801:1\n12707#2,2:802\n*S KotlinDebug\n*F\n+ 1 PendingIntentMutableImplicitDetector.kt\ncom/android/tools/lint/checks/PendingIntentMutableImplicitDetector$Companion$IntentSimpleNameAnalyzer\n*L\n674#1:802,2\n*E\n"})
        private static final class IntentSimpleNameAnalyzer
        extends IntentDataFlowAnalyzer {
            @NotNull
            private final UExpression lastAssignment;
            @NotNull
            private final USimpleNameReferenceExpression intentFinalReference;
            @NotNull
            private final IntentExpressionInfo initialIntentInfo;
            private final int intentArraySize;
            @NotNull
            private final IntentType assignIntentType;
            @NotNull
            private final boolean[] intentArrayValuesIsImplicit;

            public IntentSimpleNameAnalyzer(@NotNull UExpression lastAssignment, @NotNull USimpleNameReferenceExpression intentFinalReference, @NotNull IntentExpressionInfo initialIntentInfo, int intentArraySize, @NotNull IntentType assignIntentType) {
                Intrinsics.checkNotNullParameter((Object)lastAssignment, (String)"lastAssignment");
                Intrinsics.checkNotNullParameter((Object)intentFinalReference, (String)"intentFinalReference");
                Intrinsics.checkNotNullParameter((Object)initialIntentInfo, (String)"initialIntentInfo");
                Intrinsics.checkNotNullParameter((Object)assignIntentType, (String)"assignIntentType");
                super(lastAssignment, initialIntentInfo.getIntentArgument(), assignIntentType, initialIntentInfo);
                this.lastAssignment = lastAssignment;
                this.intentFinalReference = intentFinalReference;
                this.initialIntentInfo = initialIntentInfo;
                this.intentArraySize = intentArraySize;
                this.assignIntentType = assignIntentType;
                this.intentArrayValuesIsImplicit = new boolean[this.intentArraySize];
            }

            @NotNull
            public final UExpression getLastAssignment() {
                return this.lastAssignment;
            }

            @NotNull
            public final USimpleNameReferenceExpression getIntentFinalReference() {
                return this.intentFinalReference;
            }

            @NotNull
            public final IntentExpressionInfo getInitialIntentInfo() {
                return this.initialIntentInfo;
            }

            public final int getIntentArraySize() {
                return this.intentArraySize;
            }

            @NotNull
            public final IntentType getAssignIntentType() {
                return this.assignIntentType;
            }

            public boolean visitArrayAccessExpression(@NotNull UArrayAccessExpression node) {
                UElement parent;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (this.isIntentAnalyzable() && this.isMemberOfIntentArray(node) && (parent = node.getUastParent()) instanceof UBinaryExpression && Intrinsics.areEqual((Object)((UBinaryExpression)parent).getOperator(), (Object)UastBinaryOperator.ASSIGN)) {
                    int index2;
                    UExpression uExpression = (UExpression)CollectionsKt.firstOrNull((List)node.getIndices());
                    Object object = uExpression != null ? uExpression.evaluate() : null;
                    Integer n = object instanceof Integer ? (Integer)object : null;
                    int n2 = index2 = n != null ? n : 0;
                    boolean bl = 0 <= index2 ? index2 < this.intentArraySize : false;
                    if (bl) {
                        this.intentArrayValuesIsImplicit[index2] = Companion.getIntentTypeForExpression(((UBinaryExpression)parent).getRightOperand(), this.getIntentInfo()).isImplicit();
                    }
                }
                return super.visitArrayAccessExpression(node);
            }

            @Override
            @NotNull
            public IntentType getIntentTypeAfterGivenAssignment() {
                boolean bl;
                block2: {
                    if (this.intentArraySize == 0) {
                        return this.getIntentType();
                    }
                    boolean[] $this$any$iv = this.intentArrayValuesIsImplicit;
                    boolean $i$f$any = false;
                    int n = $this$any$iv.length;
                    for (int i = 0; i < n; ++i) {
                        boolean element$iv;
                        boolean it = element$iv = $this$any$iv[i];
                        boolean bl2 = false;
                        if (!it) continue;
                        bl = true;
                        break block2;
                    }
                    bl = false;
                }
                boolean bl3 = bl;
                IntentType finalIntentType = new IntentType(bl3);
                finalIntentType.setEscaped(this.getIntentType().isEscaped());
                return finalIntentType;
            }

            private final boolean isMemberOfIntentArray(UArrayAccessExpression node) {
                UExpression uExpression = node.getReceiver();
                USimpleNameReferenceExpression uSimpleNameReferenceExpression = uExpression instanceof USimpleNameReferenceExpression ? (USimpleNameReferenceExpression)uExpression : null;
                return Intrinsics.areEqual((Object)(uSimpleNameReferenceExpression != null ? uSimpleNameReferenceExpression.getIdentifier() : null), (Object)this.intentFinalReference.getIdentifier());
            }

            @NotNull
            public final UExpression component1() {
                return this.lastAssignment;
            }

            @NotNull
            public final USimpleNameReferenceExpression component2() {
                return this.intentFinalReference;
            }

            @NotNull
            public final IntentExpressionInfo component3() {
                return this.initialIntentInfo;
            }

            public final int component4() {
                return this.intentArraySize;
            }

            @NotNull
            public final IntentType component5() {
                return this.assignIntentType;
            }

            @NotNull
            public final IntentSimpleNameAnalyzer copy(@NotNull UExpression lastAssignment, @NotNull USimpleNameReferenceExpression intentFinalReference, @NotNull IntentExpressionInfo initialIntentInfo, int intentArraySize, @NotNull IntentType assignIntentType) {
                Intrinsics.checkNotNullParameter((Object)lastAssignment, (String)"lastAssignment");
                Intrinsics.checkNotNullParameter((Object)intentFinalReference, (String)"intentFinalReference");
                Intrinsics.checkNotNullParameter((Object)initialIntentInfo, (String)"initialIntentInfo");
                Intrinsics.checkNotNullParameter((Object)assignIntentType, (String)"assignIntentType");
                return new IntentSimpleNameAnalyzer(lastAssignment, intentFinalReference, initialIntentInfo, intentArraySize, assignIntentType);
            }

            public static /* synthetic */ IntentSimpleNameAnalyzer copy$default(IntentSimpleNameAnalyzer intentSimpleNameAnalyzer, UExpression uExpression, USimpleNameReferenceExpression uSimpleNameReferenceExpression, IntentExpressionInfo intentExpressionInfo, int n, IntentType intentType, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    uExpression = intentSimpleNameAnalyzer.lastAssignment;
                }
                if ((n2 & 2) != 0) {
                    uSimpleNameReferenceExpression = intentSimpleNameAnalyzer.intentFinalReference;
                }
                if ((n2 & 4) != 0) {
                    intentExpressionInfo = intentSimpleNameAnalyzer.initialIntentInfo;
                }
                if ((n2 & 8) != 0) {
                    n = intentSimpleNameAnalyzer.intentArraySize;
                }
                if ((n2 & 0x10) != 0) {
                    intentType = intentSimpleNameAnalyzer.assignIntentType;
                }
                return intentSimpleNameAnalyzer.copy(uExpression, uSimpleNameReferenceExpression, intentExpressionInfo, n, intentType);
            }

            @Override
            @NotNull
            public String toString() {
                return "IntentSimpleNameAnalyzer(lastAssignment=" + this.lastAssignment + ", intentFinalReference=" + this.intentFinalReference + ", initialIntentInfo=" + this.initialIntentInfo + ", intentArraySize=" + this.intentArraySize + ", assignIntentType=" + this.assignIntentType + ")";
            }

            public int hashCode() {
                int result = this.lastAssignment.hashCode();
                result = result * 31 + this.intentFinalReference.hashCode();
                result = result * 31 + this.initialIntentInfo.hashCode();
                result = result * 31 + Integer.hashCode(this.intentArraySize);
                result = result * 31 + this.assignIntentType.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof IntentSimpleNameAnalyzer)) {
                    return false;
                }
                IntentSimpleNameAnalyzer intentSimpleNameAnalyzer = (IntentSimpleNameAnalyzer)((Object)other);
                if (!Intrinsics.areEqual((Object)this.lastAssignment, (Object)intentSimpleNameAnalyzer.lastAssignment)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.intentFinalReference, (Object)intentSimpleNameAnalyzer.intentFinalReference)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.initialIntentInfo, (Object)intentSimpleNameAnalyzer.initialIntentInfo)) {
                    return false;
                }
                if (this.intentArraySize != intentSimpleNameAnalyzer.intentArraySize) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.assignIntentType, (Object)intentSimpleNameAnalyzer.assignIntentType);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\tJ\u0006\u0010\b\u001a\u00020\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00032\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\tR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000b\"\u0004\b\u000e\u0010\tR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u000b\"\u0004\b\u000f\u0010\t\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/lint/checks/PendingIntentMutableImplicitDetector$Companion$IntentType;", "", "hasComponent", "", "hasPackage", "isEscaped", "<init>", "(ZZZ)V", "isImplicit", "(Z)V", "getHasComponent", "()Z", "setHasComponent", "getHasPackage", "setHasPackage", "setEscaped", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "lint-checks"})
        private static final class IntentType {
            private boolean hasComponent;
            private boolean hasPackage;
            private boolean isEscaped;

            public IntentType(boolean hasComponent, boolean hasPackage, boolean isEscaped) {
                this.hasComponent = hasComponent;
                this.hasPackage = hasPackage;
                this.isEscaped = isEscaped;
            }

            public /* synthetic */ IntentType(boolean bl, boolean bl2, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 4) != 0) {
                    bl3 = false;
                }
                this(bl, bl2, bl3);
            }

            public final boolean getHasComponent() {
                return this.hasComponent;
            }

            public final void setHasComponent(boolean bl) {
                this.hasComponent = bl;
            }

            public final boolean getHasPackage() {
                return this.hasPackage;
            }

            public final void setHasPackage(boolean bl) {
                this.hasPackage = bl;
            }

            public final boolean isEscaped() {
                return this.isEscaped;
            }

            public final void setEscaped(boolean bl) {
                this.isEscaped = bl;
            }

            public IntentType(boolean isImplicit) {
                this(!isImplicit, !isImplicit, false, 4, null);
            }

            public final boolean isImplicit() {
                return !this.isEscaped && !this.hasComponent && !this.hasPackage;
            }

            public final boolean component1() {
                return this.hasComponent;
            }

            public final boolean component2() {
                return this.hasPackage;
            }

            public final boolean component3() {
                return this.isEscaped;
            }

            @NotNull
            public final IntentType copy(boolean hasComponent, boolean hasPackage, boolean isEscaped) {
                return new IntentType(hasComponent, hasPackage, isEscaped);
            }

            public static /* synthetic */ IntentType copy$default(IntentType intentType, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
                if ((n & 1) != 0) {
                    bl = intentType.hasComponent;
                }
                if ((n & 2) != 0) {
                    bl2 = intentType.hasPackage;
                }
                if ((n & 4) != 0) {
                    bl3 = intentType.isEscaped;
                }
                return intentType.copy(bl, bl2, bl3);
            }

            @NotNull
            public String toString() {
                return "IntentType(hasComponent=" + this.hasComponent + ", hasPackage=" + this.hasPackage + ", isEscaped=" + this.isEscaped + ")";
            }

            public int hashCode() {
                int result = Boolean.hashCode(this.hasComponent);
                result = result * 31 + Boolean.hashCode(this.hasPackage);
                result = result * 31 + Boolean.hashCode(this.isEscaped);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof IntentType)) {
                    return false;
                }
                IntentType intentType = (IntentType)other;
                if (this.hasComponent != intentType.hasComponent) {
                    return false;
                }
                if (this.hasPackage != intentType.hasPackage) {
                    return false;
                }
                return this.isEscaped == intentType.isEscaped;
            }
        }
    }
}

