/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.AnnotationDetectorKt;
import com.android.tools.lint.checks.InferredThreadDetector;
import com.android.tools.lint.checks.ThreadConstraintDetector;
import com.android.tools.lint.checks.WrongThreadInterproceduralDetector;
import com.android.tools.lint.checks.fx.result.ClassId;
import com.android.tools.lint.checks.fx.result.MethodId;
import com.android.tools.lint.checks.fx.result.ResultTemplate;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.collections.immutable.PersistentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u000f\u0010B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014R\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/lint/checks/InferredThreadDetector;", "Lcom/android/tools/lint/checks/ThreadConstraintDetector;", "Lcom/android/tools/lint/checks/InferredThreadDetector$Thread;", "<init>", "()V", "violationIssue", "Lcom/android/tools/lint/detector/api/Issue;", "getViolationIssue", "()Lcom/android/tools/lint/detector/api/Issue;", "unsatisfiableConstraintIssue", "getUnsatisfiableConstraintIssue", "parse", "Lcom/android/tools/lint/checks/ThreadConstraintDetector$ThreadConstraint;", "ann", "Lorg/jetbrains/uast/UAnnotation;", "Thread", "Companion", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nInferredThreadDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InferredThreadDetector.kt\ncom/android/tools/lint/checks/InferredThreadDetector\n+ 2 ThreadConstraintDetector.kt\ncom/android/tools/lint/checks/ThreadConstraintDetector$ThreadConstraintLattice$Companion\n*L\n1#1,103:1\n423#2:104\n*S KotlinDebug\n*F\n+ 1 InferredThreadDetector.kt\ncom/android/tools/lint/checks/InferredThreadDetector\n*L\n97#1:104\n*E\n"})
public final class InferredThreadDetector
extends ThreadConstraintDetector<Thread> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Issue violationIssue = THREAD;
    @NotNull
    private final Issue unsatisfiableConstraintIssue = THREAD;
    @NotNull
    private static final Implementation Impl = new Implementation(InferredThreadDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue THREAD;
    @NotNull
    private static final ThreadConstraintDetector.ThreadConstraintLattice<Thread> lattice;
    @NotNull
    private static final Lazy<PersistentMap<ClassId, PersistentMap<MethodId, ResultTemplate<ThreadConstraintDetector.ThreadConstraint<Thread>>>>> assumptions$delegate;

    public InferredThreadDetector() {
        super(lattice, Companion.getAssumptions());
    }

    @Override
    @NotNull
    protected Issue getViolationIssue() {
        return this.violationIssue;
    }

    @Override
    @NotNull
    protected Issue getUnsatisfiableConstraintIssue() {
        return this.unsatisfiableConstraintIssue;
    }

    @Override
    @Nullable
    protected ThreadConstraintDetector.ThreadConstraint<Thread> parse(@NotNull UAnnotation ann) {
        ThreadConstraintDetector.ThreadConstraint threadConstraint;
        Intrinsics.checkNotNullParameter((Object)ann, (String)"ann");
        String string2 = ann.getQualifiedName();
        if (Intrinsics.areEqual((Object)string2, (Object)AnnotationDetectorKt.ANY_THREAD_ANNOTATION.newName()) || Intrinsics.areEqual((Object)string2, (Object)AnnotationDetectorKt.ANY_THREAD_ANNOTATION.oldName())) {
            threadConstraint = this.getLattice().getAnyThread();
        } else if (Intrinsics.areEqual((Object)string2, (Object)AnnotationDetectorKt.UI_THREAD_ANNOTATION.oldName()) || Intrinsics.areEqual((Object)string2, (Object)AnnotationDetectorKt.UI_THREAD_ANNOTATION.newName()) || Intrinsics.areEqual((Object)string2, (Object)AnnotationDetectorKt.MAIN_THREAD_ANNOTATION.oldName()) || Intrinsics.areEqual((Object)string2, (Object)AnnotationDetectorKt.MAIN_THREAD_ANNOTATION.newName())) {
            Thread[] threadArray = new Thread[]{Thread.MainOrUi};
            threadConstraint = this.getLattice().of(threadArray);
        } else if (Intrinsics.areEqual((Object)string2, (Object)AnnotationDetectorKt.WORKER_THREAD_ANNOTATION.oldName()) || Intrinsics.areEqual((Object)string2, (Object)AnnotationDetectorKt.WORKER_THREAD_ANNOTATION.newName())) {
            Thread[] threadArray = new Thread[]{Thread.Worker};
            threadConstraint = this.getLattice().of(threadArray);
        } else if (Intrinsics.areEqual((Object)string2, (Object)AnnotationDetectorKt.BINDER_THREAD_ANNOTATION.oldName()) || Intrinsics.areEqual((Object)string2, (Object)AnnotationDetectorKt.BINDER_THREAD_ANNOTATION.newName())) {
            Thread[] threadArray = new Thread[]{Thread.Binder};
            threadConstraint = this.getLattice().of(threadArray);
        } else {
            threadConstraint = null;
        }
        return threadConstraint;
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = Impl;
        THREAD = Issue.Companion.create$default((Issue.Companion)companion, (String)"ThreadConstraint", (String)"Wrong Thread (with inference)", (String)"\n                Ensures that a method which expects to be called on a specific thread, is \\\n                actually called from that thread. For example, calls on methods in widgets \\\n                should always be made on the UI thread. This new issue subsumes \\\n                `WrongThreadInterprocedural`, accompanied by a check aiming to be more reliable \\\n                and scalable.\n                ", (Implementation)implementation, (String)"https://developer.android.com/guide/components/processes-and-threads.html#Threads", (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3072, null).setAliases(CollectionsKt.listOf((Object)WrongThreadInterproceduralDetector.ISSUE.getId()));
        ThreadConstraintDetector.ThreadConstraintLattice.Companion this_$iv = ThreadConstraintDetector.ThreadConstraintLattice.Companion;
        boolean $i$f$of = false;
        lattice = new ThreadConstraintDetector.ThreadConstraintLattice<Thread>(Thread.class);
        assumptions$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)Companion.assumptions.2.INSTANCE);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fRO\u0010\r\u001a6\u0012\u0004\u0012\u00020\u000f\u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\u0010\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00120\u00110\u000e0\u000ej\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u0012`\u00138FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/lint/checks/InferredThreadDetector$Companion;", "", "<init>", "()V", "Impl", "Lcom/android/tools/lint/detector/api/Implementation;", "THREAD", "Lcom/android/tools/lint/detector/api/Issue;", "lattice", "Lcom/android/tools/lint/checks/ThreadConstraintDetector$ThreadConstraintLattice;", "Lcom/android/tools/lint/checks/InferredThreadDetector$Thread;", "getLattice", "()Lcom/android/tools/lint/checks/ThreadConstraintDetector$ThreadConstraintLattice;", "assumptions", "Lkotlinx/collections/immutable/PersistentMap;", "Lcom/android/tools/lint/checks/fx/result/ClassId;", "Lcom/android/tools/lint/checks/fx/result/MethodId;", "Lcom/android/tools/lint/checks/fx/result/ResultTemplate;", "Lcom/android/tools/lint/checks/ThreadConstraintDetector$ThreadConstraint;", "Lcom/android/tools/lint/checks/fx/result/AssumptionTable;", "getAssumptions", "()Lkotlinx/collections/immutable/PersistentMap;", "assumptions$delegate", "Lkotlin/Lazy;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ThreadConstraintDetector.ThreadConstraintLattice<Thread> getLattice() {
            return lattice;
        }

        @NotNull
        public final PersistentMap<ClassId, PersistentMap<MethodId, ResultTemplate<ThreadConstraintDetector.ThreadConstraint<Thread>>>> getAssumptions() {
            Lazy lazy = assumptions$delegate;
            return (PersistentMap)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\bH\u0016j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\t"}, d2={"Lcom/android/tools/lint/checks/InferredThreadDetector$Thread;", "", "<init>", "(Ljava/lang/String;I)V", "MainOrUi", "Worker", "Binder", "toString", "", "lint-checks"})
    public static final class Thread
    extends Enum<Thread> {
        public static final /* enum */ Thread MainOrUi = new Thread();
        public static final /* enum */ Thread Worker = new Thread();
        public static final /* enum */ Thread Binder = new Thread();
        private static final /* synthetic */ Thread[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        @NotNull
        public String toString() {
            String string2;
            switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                case 1: {
                    string2 = "`@{Main,Ui}Thread`";
                    break;
                }
                case 2: {
                    string2 = "`@WorkerThread`";
                    break;
                }
                case 3: {
                    string2 = "`@BinderThread`";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return string2;
        }

        public static Thread[] values() {
            return (Thread[])$VALUES.clone();
        }

        public static Thread valueOf(String value) {
            return Enum.valueOf(Thread.class, value);
        }

        @NotNull
        public static EnumEntries<Thread> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = threadArray = new Thread[]{Thread.MainOrUi, Thread.Worker, Thread.Binder};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Thread.values().length];
                try {
                    nArray[Thread.MainOrUi.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Thread.Worker.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Thread.Binder.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

