/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.runtime.components;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.builtins.jvm.JavaToKotlinClassMap;
import org.jetbrains.kotlin.descriptors.runtime.components.ReflectAnnotationSource;
import org.jetbrains.kotlin.descriptors.runtime.components.ReflectKotlinClassKt;
import org.jetbrains.kotlin.descriptors.runtime.components.SignatureSerializer;
import org.jetbrains.kotlin.descriptors.runtime.structure.ReflectClassUtilKt;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.resolve.constants.ClassLiteralValue;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\tJ\u001a\u0010\n\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\r\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001c\u0010\u000e\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001c\u0010\u000f\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J$\u0010\u0013\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0002J\u0010\u0010\u0016\u001a\u00020\u0017*\u0006\u0012\u0002\b\u00030\u0007H\u0002J \u0010\u0018\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0001H\u0002\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/descriptors/runtime/components/ReflectClassStructure;", "", "<init>", "()V", "loadClassAnnotations", "", "klass", "Ljava/lang/Class;", "visitor", "Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass$AnnotationVisitor;", "visitMembers", "memberVisitor", "Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass$MemberVisitor;", "loadMethodAnnotations", "loadConstructorAnnotations", "loadFieldAnnotations", "processAnnotation", "annotation", "", "processAnnotationArguments", "Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass$AnnotationArgumentVisitor;", "annotationType", "classLiteralValue", "Lorg/jetbrains/kotlin/resolve/constants/ClassLiteralValue;", "processAnnotationArgumentValue", "name", "Lorg/jetbrains/kotlin/name/Name;", "value", "descriptors.runtime"})
final class ReflectClassStructure {
    @NotNull
    public static final ReflectClassStructure INSTANCE = new ReflectClassStructure();

    private ReflectClassStructure() {
    }

    public final void loadClassAnnotations(@NotNull Class<?> klass, @NotNull KotlinJvmBinaryClass.AnnotationVisitor visitor2) {
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        Annotation[] annotationArray = klass.getDeclaredAnnotations();
        Intrinsics.checkNotNullExpressionValue((Object)annotationArray, (String)"getDeclaredAnnotations(...)");
        for (Annotation annotation : annotationArray) {
            Intrinsics.checkNotNull((Object)annotation);
            this.processAnnotation(visitor2, annotation);
        }
        visitor2.visitEnd();
    }

    public final void visitMembers(@NotNull Class<?> klass, @NotNull KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)memberVisitor, (String)"memberVisitor");
        this.loadMethodAnnotations(klass, memberVisitor);
        this.loadConstructorAnnotations(klass, memberVisitor);
        this.loadFieldAnnotations(klass, memberVisitor);
    }

    private final void loadMethodAnnotations(Class<?> klass, KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Method[] methodArray = klass.getDeclaredMethods();
        Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getDeclaredMethods(...)");
        for (Method method : methodArray) {
            KotlinJvmBinaryClass.MethodAnnotationVisitor visitor2;
            Name name2 = Name.identifier(method.getName());
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
            Intrinsics.checkNotNull((Object)method);
            if (memberVisitor.visitMethod(name2, SignatureSerializer.INSTANCE.methodDesc(method)) == null) continue;
            Annotation[] annotationArray = method.getDeclaredAnnotations();
            Intrinsics.checkNotNullExpressionValue((Object)annotationArray, (String)"getDeclaredAnnotations(...)");
            for (Annotation annotation : annotationArray) {
                KotlinJvmBinaryClass.AnnotationVisitor annotationVisitor = visitor2;
                Intrinsics.checkNotNull((Object)annotation);
                this.processAnnotation(annotationVisitor, annotation);
            }
            Annotation[][] annotationArray2 = method.getParameterAnnotations();
            Intrinsics.checkNotNullExpressionValue((Object)annotationArray2, (String)"getParameterAnnotations(...)");
            Annotation[] annotationArray3 = annotationArray2;
            int n = ((Object[])annotationArray3).length;
            for (int j = 0; j < n; ++j) {
                int parameterIndex = j;
                Annotation annotations2 = annotationArray3[j];
                Intrinsics.checkNotNull((Object)annotations2);
                for (Annotation annotation : annotations2) {
                    KotlinJvmBinaryClass.AnnotationArgumentVisitor it;
                    Class annotationType = JvmClassMappingKt.getJavaClass((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)annotation));
                    ClassId classId = ReflectClassUtilKt.getClassId(annotationType);
                    Intrinsics.checkNotNull((Object)annotation);
                    if (visitor2.visitParameterAnnotation(parameterIndex, classId, new ReflectAnnotationSource(annotation)) == null) continue;
                    boolean bl = false;
                    INSTANCE.processAnnotationArguments(it, annotation, annotationType);
                }
            }
            visitor2.visitEnd();
        }
    }

    private final void loadConstructorAnnotations(Class<?> klass, KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Constructor<?>[] constructorArray = klass.getDeclaredConstructors();
        Intrinsics.checkNotNullExpressionValue(constructorArray, (String)"getDeclaredConstructors(...)");
        for (Constructor<?> constructor : constructorArray) {
            KotlinJvmBinaryClass.MethodAnnotationVisitor visitor2;
            Annotation[] annotationArray;
            Intrinsics.checkNotNull(constructor);
            if (memberVisitor.visitMethod(SpecialNames.INIT, SignatureSerializer.INSTANCE.constructorDesc(constructor)) == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)constructor.getDeclaredAnnotations(), (String)"getDeclaredAnnotations(...)");
            for (Annotation annotation : annotationArray) {
                KotlinJvmBinaryClass.AnnotationVisitor annotationVisitor = visitor2;
                Intrinsics.checkNotNull((Object)annotation);
                this.processAnnotation(annotationVisitor, annotation);
            }
            Annotation[][] parameterAnnotations = constructor.getParameterAnnotations();
            Intrinsics.checkNotNull((Object)parameterAnnotations);
            if (!(((Object[])parameterAnnotations).length == 0)) {
                int shift = constructor.getParameterTypes().length - ((Object[])parameterAnnotations).length;
                Annotation[][] annotationArray2 = parameterAnnotations;
                int n = ((Object[])annotationArray2).length;
                for (int j = 0; j < n; ++j) {
                    int parameterIndex = j;
                    Annotation[] annotations2 = annotationArray2[j];
                    Intrinsics.checkNotNull((Object)annotations2);
                    for (Annotation annotation : annotations2) {
                        Class annotationType = JvmClassMappingKt.getJavaClass((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)annotation));
                        ClassId classId = ReflectClassUtilKt.getClassId(annotationType);
                        Intrinsics.checkNotNull((Object)annotation);
                        KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = visitor2.visitParameterAnnotation(parameterIndex + shift, classId, new ReflectAnnotationSource(annotation));
                        if (annotationArgumentVisitor == null) continue;
                        KotlinJvmBinaryClass.AnnotationArgumentVisitor it = annotationArgumentVisitor;
                        boolean bl = false;
                        INSTANCE.processAnnotationArguments(it, annotation, annotationType);
                    }
                }
            }
            visitor2.visitEnd();
        }
    }

    private final void loadFieldAnnotations(Class<?> klass, KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Field[] fieldArray = klass.getDeclaredFields();
        Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"getDeclaredFields(...)");
        for (Field field : fieldArray) {
            KotlinJvmBinaryClass.AnnotationVisitor visitor2;
            Annotation[] annotationArray;
            Name name2 = Name.identifier(field.getName());
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
            Intrinsics.checkNotNull((Object)field);
            if (memberVisitor.visitField(name2, SignatureSerializer.INSTANCE.fieldDesc(field), null) == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)field.getDeclaredAnnotations(), (String)"getDeclaredAnnotations(...)");
            for (Annotation annotation : annotationArray) {
                Intrinsics.checkNotNull((Object)annotation);
                this.processAnnotation(visitor2, annotation);
            }
            visitor2.visitEnd();
        }
    }

    private final void processAnnotation(KotlinJvmBinaryClass.AnnotationVisitor visitor2, Annotation annotation) {
        block0: {
            Class annotationType = JvmClassMappingKt.getJavaClass((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)annotation));
            KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = visitor2.visitAnnotation(ReflectClassUtilKt.getClassId(annotationType), new ReflectAnnotationSource(annotation));
            if (annotationArgumentVisitor == null) break block0;
            KotlinJvmBinaryClass.AnnotationArgumentVisitor it = annotationArgumentVisitor;
            boolean bl = false;
            INSTANCE.processAnnotationArguments(it, annotation, annotationType);
        }
    }

    private final void processAnnotationArguments(KotlinJvmBinaryClass.AnnotationArgumentVisitor visitor2, Annotation annotation, Class<?> annotationType) {
        Method[] methodArray = annotationType.getDeclaredMethods();
        Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getDeclaredMethods(...)");
        for (Method method : methodArray) {
            Object object;
            try {
                Intrinsics.checkNotNull((Object)method.invoke((Object)annotation, new Object[0]));
            }
            catch (IllegalAccessException e) {
                continue;
            }
            Object value2 = object;
            Name name2 = Name.identifier(method.getName());
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
            this.processAnnotationArgumentValue(visitor2, name2, value2);
        }
        visitor2.visitEnd();
    }

    private final ClassLiteralValue classLiteralValue(Class<?> $this$classLiteralValue) {
        Class<?> currentClass = $this$classLiteralValue;
        int dimensions = 0;
        while (currentClass.isArray()) {
            ++dimensions;
            Intrinsics.checkNotNullExpressionValue(currentClass.getComponentType(), (String)"getComponentType(...)");
        }
        if (currentClass.isPrimitive()) {
            if (Intrinsics.areEqual(currentClass, Void.TYPE)) {
                return new ClassLiteralValue(ClassId.Companion.topLevel(StandardNames.FqNames.unit.toSafe()), dimensions);
            }
            PrimitiveType primitiveType = JvmPrimitiveType.get(currentClass.getName()).getPrimitiveType();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)primitiveType), (String)"getPrimitiveType(...)");
            PrimitiveType primitiveType2 = primitiveType;
            if (dimensions > 0) {
                return new ClassLiteralValue(ClassId.Companion.topLevel(primitiveType2.getArrayTypeFqName()), dimensions - 1);
            }
            return new ClassLiteralValue(ClassId.Companion.topLevel(primitiveType2.getTypeFqName()), dimensions);
        }
        ClassId javaClassId = ReflectClassUtilKt.getClassId(currentClass);
        ClassId classId = JavaToKotlinClassMap.INSTANCE.mapJavaToKotlin(javaClassId.asSingleFqName());
        if (classId == null) {
            classId = javaClassId;
        }
        ClassId kotlinClassId = classId;
        return new ClassLiteralValue(kotlinClassId, dimensions);
    }

    private final void processAnnotationArgumentValue(KotlinJvmBinaryClass.AnnotationArgumentVisitor visitor2, Name name2, Object value2) {
        Class<?> clazz = value2.getClass();
        if (Intrinsics.areEqual(clazz, Class.class)) {
            Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type java.lang.Class<*>");
            visitor2.visitClassLiteral(name2, this.classLiteralValue((Class)value2));
        } else if (ReflectKotlinClassKt.access$getTYPES_ELIGIBLE_FOR_SIMPLE_VISIT$p().contains(clazz)) {
            visitor2.visit(name2, value2);
        } else if (ReflectClassUtilKt.isEnumClassOrSpecializedEnumEntryClass(clazz)) {
            Class<?> clazz2 = clazz.isEnum() ? clazz : clazz.getEnclosingClass();
            Intrinsics.checkNotNull(clazz2);
            ClassId classId = ReflectClassUtilKt.getClassId(clazz2);
            Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type kotlin.Enum<*>");
            Name name3 = Name.identifier(((Enum)value2).name());
            Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
            visitor2.visitEnum(name2, classId, name3);
        } else if (Annotation.class.isAssignableFrom(clazz)) {
            Class<?>[] classArray = clazz.getInterfaces();
            Intrinsics.checkNotNullExpressionValue(classArray, (String)"getInterfaces(...)");
            Class annotationClass = (Class)ArraysKt.single((Object[])classArray);
            Intrinsics.checkNotNull((Object)annotationClass);
            KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = visitor2.visitAnnotation(name2, ReflectClassUtilKt.getClassId(annotationClass));
            if (annotationArgumentVisitor == null) {
                return;
            }
            KotlinJvmBinaryClass.AnnotationArgumentVisitor v = annotationArgumentVisitor;
            Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type kotlin.Annotation");
            this.processAnnotationArguments(v, (Annotation)value2, annotationClass);
        } else if (clazz.isArray()) {
            KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor annotationArrayArgumentVisitor = visitor2.visitArray(name2);
            if (annotationArrayArgumentVisitor == null) {
                return;
            }
            KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor v = annotationArrayArgumentVisitor;
            Class<?> componentType = clazz.getComponentType();
            if (componentType.isEnum()) {
                Intrinsics.checkNotNull(componentType);
                ClassId enumClassId = ReflectClassUtilKt.getClassId(componentType);
                Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type kotlin.Array<*>");
                for (Object element : (Object[])value2) {
                    Intrinsics.checkNotNull((Object)element, (String)"null cannot be cast to non-null type kotlin.Enum<*>");
                    Name name4 = Name.identifier(((Enum)element).name());
                    Intrinsics.checkNotNullExpressionValue((Object)name4, (String)"identifier(...)");
                    v.visitEnum(enumClassId, name4);
                }
            } else if (Intrinsics.areEqual(componentType, Class.class)) {
                Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type kotlin.Array<*>");
                for (Object element : (Object[])value2) {
                    Intrinsics.checkNotNull((Object)element, (String)"null cannot be cast to non-null type java.lang.Class<*>");
                    v.visitClassLiteral(this.classLiteralValue((Class)element));
                }
            } else if (Annotation.class.isAssignableFrom(componentType)) {
                Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type kotlin.Array<*>");
                for (Object element : (Object[])value2) {
                    KotlinJvmBinaryClass.AnnotationArgumentVisitor vv;
                    Intrinsics.checkNotNull(componentType);
                    if (v.visitAnnotation(ReflectClassUtilKt.getClassId(componentType)) == null) continue;
                    Intrinsics.checkNotNull((Object)element, (String)"null cannot be cast to non-null type kotlin.Annotation");
                    this.processAnnotationArguments(vv, (Annotation)element, componentType);
                }
            } else {
                Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type kotlin.Array<*>");
                for (Object element : (Object[])value2) {
                    v.visit(element);
                }
            }
            v.visitEnd();
        } else {
            throw new UnsupportedOperationException("Unsupported annotation argument value (" + clazz + "): " + value2);
        }
    }
}

